/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.PreferencesListener;
import mpi.eudico.client.annotator.ShutdownListener;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.gui.ChangedTranscriptionsPane;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.FrameInfo;
import mpi.eudico.client.annotator.util.MonitoringLogger;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.lock.FileLockInfo;
import mpi.eudico.util.lock.FileLockUtil;
import nl.mpi.util.FileUtility;

public class FrameManager
implements PreferencesListener {
    private static final FrameManager manager = new FrameManager();
    private boolean exitAllowed = false;
    private Map<String, String> recentFilesMap;
    private List<String> recentFilesList;
    private List<FrameInfo> openFrameList;
    private Map<JFrame, FileLockInfo> fileLockMap;
    private boolean fileLockingEnabled = false;
    private final int maxFilePathLength = 40;
    private int frameCounter = 0;
    private final String FR_NAME = "Frame-";
    private final String RECENTS_PREF = "FrameManager.RecentFiles";
    private final String EXIT_PREF = "FrameManager.ExitMes";
    private List<String> completeRecentItems;
    private int nrRecentItemsPreference = 5;
    private static List<ShutdownListener> listenerList;
    private final ReentrantLock exitLock = new ReentrantLock();

    private FrameManager() {
        Boolean lockFilePref;
        Integer recentItems = Preferences.getInt("UI.RecentItems", null);
        if (recentItems != null) {
            this.nrRecentItemsPreference = recentItems;
        }
        if ((lockFilePref = Preferences.getBool("CreateLockFiles", null)) != null) {
            this.fileLockingEnabled = lockFilePref;
        }
        this.recentFilesMap = new HashMap<String, String>(this.nrRecentItemsPreference);
        this.recentFilesList = new ArrayList<String>(this.nrRecentItemsPreference);
        this.openFrameList = new ArrayList<FrameInfo>(10);
        this.fileLockMap = new HashMap<JFrame, FileLockInfo>();
        listenerList = new ArrayList<ShutdownListener>(1);
        this.completeRecentItems = Preferences.getListOfString("FrameManager.RecentFiles", null);
        if (this.completeRecentItems != null) {
            for (int i = 0; i < this.completeRecentItems.size() && i < this.nrRecentItemsPreference; ++i) {
                String url = this.completeRecentItems.get(i);
                if (url == null) continue;
                this.recentFilesList.add(url);
                String shUrl = this.fullPathToDisplayPath(url);
                if (shUrl == null) continue;
                this.recentFilesMap.put(url, shUrl);
            }
        } else {
            this.completeRecentItems = new ArrayList<String>();
        }
        Preferences.addPreferencesListener(null, this);
    }

    private void updateRecentFileMenu() {
        Integer recentItems = Preferences.getInt("UI.RecentItems", null);
        if (recentItems != null) {
            this.nrRecentItemsPreference = recentItems;
        }
        ArrayList<String> old_recentFilesList = new ArrayList<String>(this.recentFilesList.subList(0, this.recentFilesList.size()));
        int nrTotalRecentFiles = this.completeRecentItems.size();
        if (this.nrRecentItemsPreference <= nrTotalRecentFiles) {
            this.recentFilesList.clear();
            this.recentFilesList.addAll(this.completeRecentItems.subList(0, this.nrRecentItemsPreference));
        } else {
            this.recentFilesList.clear();
            this.recentFilesList.addAll(this.completeRecentItems);
        }
        this.updateRecentFilesMap();
        for (FrameInfo frame_info : this.openFrameList) {
            if (!(frame_info.getFrame() instanceof ElanFrame2)) continue;
            ElanFrame2 elan_frame = (ElanFrame2)frame_info.getFrame();
            for (String url : old_recentFilesList) {
                elan_frame.removeActionFromMenu(url, 11);
            }
            for (int i = 0; i < this.recentFilesList.size(); ++i) {
                String lon = this.recentFilesList.get(i);
                String sho = this.recentFilesMap.get(lon);
                elan_frame.addActionToMenu(new RecentAction(elan_frame, sho, lon), 11, i);
            }
        }
    }

    public static FrameManager getInstance() {
        return manager;
    }

    public void closeFrame(String frameId) {
        if (frameId == null) {
            return;
        }
        FrameInfo fin = null;
        for (int i = 0; i < this.openFrameList.size() && !(fin = this.openFrameList.get(i)).getFrameId().equals(frameId); ++i) {
            fin = null;
        }
        if (fin != null) {
            this.closeFrame(fin.getFrame());
        }
    }

    public void closeFrame(JFrame frame) {
        if (frame == null) {
            return;
        }
        FileLockInfo fli = this.fileLockMap.remove(frame);
        if (fli != null) {
            this.releaseLocks(fli);
        }
        FrameInfo fin = null;
        for (int i = 0; i < this.openFrameList.size() && (fin = this.openFrameList.get(i)).getFrame() != frame; ++i) {
            fin = null;
        }
        if (fin == null) {
            return;
        }
        String id = fin.getFrameId();
        this.openFrameList.remove(fin);
        if (id != null) {
            for (int i = 0; i < this.openFrameList.size(); ++i) {
                FrameInfo info = this.openFrameList.get(i);
                if (!(info.getFrame() instanceof ElanFrame2)) continue;
                ((ElanFrame2)info.getFrame()).removeActionFromMenu(id, 800);
            }
        }
        FrameInfo actInfo = null;
        for (int i = 0; i < this.openFrameList.size() && !(actInfo = this.openFrameList.get(i)).getFrame().isActive(); ++i) {
            actInfo = null;
        }
        if (actInfo != null) {
            for (int i = 0; i < this.openFrameList.size(); ++i) {
                FrameInfo other = this.openFrameList.get(i);
                if (!(other.getFrame() instanceof ElanFrame2)) continue;
                ((ElanFrame2)other.getFrame()).setMenuSelected(actInfo.getFrameId(), 800);
            }
        }
        if (this.openFrameList.size() == 0) {
            if (frame instanceof ElanFrame2) {
                if (((ElanFrame2)frame).getViewerManager() != null) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FrameManager.getInstance().createEmptyFrame();
                        }
                    });
                } else {
                    this.exit();
                }
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FrameManager.getInstance().createEmptyFrame();
                    }
                });
            }
        }
    }

    public void setToFront(String frameId) {
        for (int i = 0; i < this.openFrameList.size(); ++i) {
            FrameInfo fin = this.openFrameList.get(i);
            if (!fin.getFrameId().equals(frameId)) continue;
            fin.getFrame().toFront();
            break;
        }
    }

    public void activateNextFrame(boolean forward) {
        FrameInfo loopInfo;
        if (this.openFrameList.size() <= 1) {
            return;
        }
        int current = -1;
        for (int i = 0; i < this.openFrameList.size(); ++i) {
            ElanFrame2 ef2;
            loopInfo = this.openFrameList.get(i);
            if (!(loopInfo.getFrame() instanceof ElanFrame2) || !(ef2 = (ElanFrame2)loopInfo.getFrame()).isActive()) continue;
            current = i;
            break;
        }
        int next = -1;
        next = current == this.openFrameList.size() - 1 ? (forward ? 0 : current - 1) : (current == 0 ? (forward ? 1 : this.openFrameList.size() - 1) : (forward ? current + 1 : current - 1));
        if (next > -1 && next < this.openFrameList.size()) {
            loopInfo = this.openFrameList.get(next);
            loopInfo.getFrame().toFront();
        }
    }

    public void frameActivated(JFrame frame) {
        if (frame == null) {
            return;
        }
        for (int i = 0; i < this.openFrameList.size(); ++i) {
            FrameInfo fin = this.openFrameList.get(i);
            if (fin.getFrame() != frame) continue;
            this.frameActivated(fin.getFrameId());
            break;
        }
    }

    public void updateShortcuts() {
        for (int i = 0; i < this.openFrameList.size(); ++i) {
            ElanFrame2 frame;
            ElanLayoutManager layoutManager;
            FrameInfo fin = this.openFrameList.get(i);
            if (!(fin.getFrame() instanceof ElanFrame2) || (layoutManager = (frame = (ElanFrame2)fin.getFrame()).getLayoutManager()) == null) continue;
            layoutManager.shortcutsChanged();
        }
    }

    public void frameActivated(String frameId) {
        if (frameId != null) {
            for (int i = 0; i < this.openFrameList.size(); ++i) {
                FrameInfo fin = this.openFrameList.get(i);
                if (!(fin.getFrame() instanceof ElanFrame2)) continue;
                ((ElanFrame2)fin.getFrame()).setMenuSelected(frameId, 800);
            }
        }
    }

    public JFrame getActiveFrame() {
        if (this.openFrameList.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.openFrameList.size(); ++i) {
            ElanFrame2 ef2;
            FrameInfo loopInfo = this.openFrameList.get(i);
            if (!(loopInfo.getFrame() instanceof ElanFrame2) || !(ef2 = (ElanFrame2)loopInfo.getFrame()).isActive()) continue;
            return ef2;
        }
        return null;
    }

    public ElanFrame2 getFrameFor(String filePath) {
        return this.getFrameFor(filePath, true);
    }

    public ElanFrame2 getFrameFor(String filePath, boolean createNewFrame) {
        if (filePath == null) {
            return null;
        }
        for (int i = 0; i < this.openFrameList.size(); ++i) {
            FrameInfo fin = this.openFrameList.get(i);
            if (fin.getFilePath() == null || !fin.getFilePath().equals(filePath) || !(fin.getFrame() instanceof ElanFrame2)) continue;
            return (ElanFrame2)fin.getFrame();
        }
        if (createNewFrame) {
            return this.createFrame(filePath);
        }
        return null;
    }

    public ElanFrame2 getFrameFor(Transcription transcription) {
        if (transcription == null) {
            return null;
        }
        for (int i = 0; i < this.openFrameList.size(); ++i) {
            Transcription t;
            ElanFrame2 frame;
            ViewerManager2 vm;
            FrameInfo fin = this.openFrameList.get(i);
            if (!(fin.getFrame() instanceof ElanFrame2) || (vm = (frame = (ElanFrame2)fin.getFrame()).getViewerManager()) == null || (t = vm.getTranscription()) != transcription) continue;
            return frame;
        }
        return null;
    }

    public void updateFrameTitle(JFrame frame, String newPath) {
        if (frame == null || newPath == null) {
            return;
        }
        newPath = FileUtility.urlToAbsPath(newPath);
        FrameInfo fin = null;
        for (int i = 0; i < this.openFrameList.size() && (fin = this.openFrameList.get(i)).getFrame() != frame; ++i) {
            fin = null;
        }
        if (fin == null) {
            return;
        }
        String nextName = FileUtility.fileNameFromPath(newPath);
        for (int i = 0; i < this.openFrameList.size(); ++i) {
            FrameInfo loopInfo = this.openFrameList.get(i);
            if (!(loopInfo.getFrame() instanceof ElanFrame2)) continue;
            ElanFrame2 ef2 = (ElanFrame2)loopInfo.getFrame();
            ef2.removeActionFromMenu(fin.getFrameId(), 800);
            ef2.addActionToMenu(new ActiveWindowAction(fin.getFrameId(), nextName), 800, -1);
            if (!frame.isActive()) continue;
            ef2.setMenuSelected(fin.getFrameId(), 800);
        }
        fin.setFilePath(newPath);
        fin.setFrameName(nextName);
        this.addToRecentFiles(newPath);
    }

    public void updateFileLock(JFrame frame, String oldPath, String newPath) {
        if (frame == null) {
            return;
        }
        String newPathName = FileUtility.urlToAbsPath(newPath);
        FileLockInfo fli = this.fileLockMap.get(frame);
        if (fli != null && (fli.getFileString().equals(oldPath) || oldPath == null)) {
            this.releaseLocks(fli);
            this.fileLockMap.remove(frame);
        }
        if (this.fileLockingEnabled && newPathName != null) {
            FileLockInfo nextFli = new FileLockInfo(newPathName);
            this.acquireAppLock(nextFli);
            if (nextFli.getAppLock() != null) {
                this.fileLockMap.put(frame, nextFli);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        if (this.exitLock.isHeldByCurrentThread()) {
            return;
        }
        this.exitLock.lock();
        try {
            FrameInfo loopInfo;
            int i;
            this.fireWindowClosing(this, 3);
            ArrayList<String> changedTrans = new ArrayList<String>(this.openFrameList.size());
            for (int i2 = 0; i2 < this.openFrameList.size(); ++i2) {
                FrameInfo loopInfo2 = this.openFrameList.get(i2);
                if (!(loopInfo2.getFrame() instanceof ElanFrame2)) continue;
                ElanFrame2 ef2 = (ElanFrame2)loopInfo2.getFrame();
                if (ef2.getViewerManager() != null) {
                    ViewerManager2 vm = ef2.getViewerManager();
                    Transcription transcription = vm.getTranscription();
                    if (!transcription.isChanged()) continue;
                    changedTrans.add(loopInfo2.getFrameName());
                    continue;
                }
                ef2.doClose(false);
            }
            List<String> vals = null;
            if (changedTrans.size() > 0) {
                ChangedTranscriptionsPane pane = new ChangedTranscriptionsPane(changedTrans);
                int option = JOptionPane.showConfirmDialog(this.getActiveFrame(), pane, ElanLocale.getString("Menu.File.Save"), 2, 3);
                if (option != 0) {
                    return;
                }
                vals = pane.getSelectedValues();
            }
            for (int j = 0; j < this.openFrameList.size(); ++j) {
                ElanFrame2 ef2;
                FrameInfo loopInfo3 = this.openFrameList.get(j);
                if (vals != null && vals.contains(loopInfo3.getFrameName())) {
                    if (!(loopInfo3.getFrame() instanceof ElanFrame2)) continue;
                    ef2 = (ElanFrame2)loopInfo3.getFrame();
                    ef2.saveAndClose(false);
                    continue;
                }
                if (!(loopInfo3.getFrame() instanceof ElanFrame2)) continue;
                ef2 = (ElanFrame2)loopInfo3.getFrame();
                ef2.doClose(false);
            }
            Preferences.set("FrameManager.RecentFiles", this.completeRecentItems, null);
            ArrayList<FrameInfo> closed = new ArrayList<FrameInfo>(this.openFrameList.size());
            for (i = this.openFrameList.size() - 1; i >= 0; --i) {
                ElanFrame2 ef2;
                loopInfo = this.openFrameList.get(i);
                if (!(loopInfo.getFrame() instanceof ElanFrame2) || (ef2 = (ElanFrame2)loopInfo.getFrame()).isShowing()) continue;
                closed.add(loopInfo);
                this.openFrameList.remove(loopInfo);
            }
            if (this.openFrameList.size() > 0) {
                for (i = 0; i < closed.size(); ++i) {
                    loopInfo = (FrameInfo)closed.get(i);
                    for (int j = 0; j < this.openFrameList.size(); ++j) {
                        FrameInfo ofi = this.openFrameList.get(j);
                        if (!(ofi.getFrame() instanceof ElanFrame2)) continue;
                        ElanFrame2 ef2 = (ElanFrame2)ofi.getFrame();
                        ef2.removeActionFromMenu(loopInfo.getFrameId(), 800);
                    }
                }
                return;
            }
            if (this.exitAllowed) {
                this.fireWindowClosing(this, 4);
                MonitoringLogger.exitElan();
                ClientLogger.LOG.info("ELAN stopped.");
                System.exit(0);
            }
        }
        finally {
            this.exitLock.unlock();
        }
    }

    ElanFrame2 createEmptyFrame() {
        ElanFrame2 ef2 = new ElanFrame2();
        this.addFrame(ef2);
        return ef2;
    }

    public ElanFrame2 createFrame(String eafPath) {
        if (eafPath == null) {
            return null;
        }
        return this.createFrame(eafPath, null);
    }

    public ElanFrame2 createFrame(String eafPath, List<String> files) {
        if (eafPath == null) {
            return null;
        }
        FileLockInfo lockInfo = null;
        if (!FileUtility.isRemoteFile(eafPath)) {
            lockInfo = new FileLockInfo(eafPath);
            this.checkLockedStatus(lockInfo);
            if (lockInfo.isAppLocked()) {
                this.showLockMessage(lockInfo);
                return null;
            }
            if (this.fileLockingEnabled) {
                this.acquireAppLock(lockInfo);
            } else {
                this.releaseLocks(lockInfo);
                lockInfo = null;
            }
        }
        ElanFrame2 ef2 = null;
        if (this.openFrameList.size() == 1) {
            FrameInfo fin = this.openFrameList.get(0);
            if (fin.getFrame() instanceof ElanFrame2) {
                ef2 = (ElanFrame2)fin.getFrame();
                if (ef2.getViewerManager() == null) {
                    ef2.openEAF(eafPath, files);
                    this.updateFrameTitle(ef2, eafPath);
                } else {
                    ef2 = new ElanFrame2(eafPath, files);
                    this.addFrame(ef2);
                }
            }
        } else {
            ef2 = new ElanFrame2(eafPath, files);
            this.addFrame(ef2);
        }
        if (lockInfo != null && lockInfo.getAppLock() != null) {
            this.fileLockMap.put(ef2, lockInfo);
        }
        return ef2;
    }

    public ElanFrame2 createFrame(Transcription transcription) {
        if (transcription == null) {
            return null;
        }
        ElanFrame2 ef2 = null;
        if (this.openFrameList.size() == 1) {
            FrameInfo fin = this.openFrameList.get(0);
            if (fin.getFrame() instanceof ElanFrame2) {
                ef2 = (ElanFrame2)fin.getFrame();
                if (ef2.getViewerManager() == null) {
                    ef2.setTranscription(transcription);
                    String fullPath = transcription.getName();
                    if (!transcription.getName().equals("aishug294879ryshfda9763afo8947a5gf")) {
                        fullPath = transcription.getFullPath();
                        if (fullPath.startsWith("file")) {
                            fullPath = fullPath.substring(5);
                        }
                        this.updateFrameTitle(ef2, fullPath);
                    }
                } else {
                    ef2 = new ElanFrame2(transcription);
                    this.addFrame(ef2);
                }
            }
        } else {
            ef2 = new ElanFrame2(transcription);
            this.addFrame(ef2);
        }
        return ef2;
    }

    public void addFrame(JFrame frame) {
        if (frame == null) {
            return;
        }
        String id = "Frame-" + this.frameCounter++;
        String fullPath = null;
        Object fileName = ElanLocale.getString("Frame.ElanFrame.Untitled") + "-" + this.frameCounter;
        FrameInfo frInfo = new FrameInfo(frame, id);
        frInfo.setFrameName((String)fileName);
        this.openFrameList.add(frInfo);
        if (frame instanceof ElanFrame2) {
            TranscriptionImpl tr;
            ElanFrame2 ef2 = (ElanFrame2)frame;
            if (ef2.getViewerManager() != null && !(tr = (TranscriptionImpl)ef2.getViewerManager().getTranscription()).getName().equals("aishug294879ryshfda9763afo8947a5gf")) {
                fullPath = tr.getFullPath();
                fullPath = FileUtility.urlToAbsPath(fullPath);
                fileName = tr.getName();
                frInfo.setFilePath(fullPath);
                frInfo.setFrameName((String)fileName);
            }
            for (int i = 0; i < this.recentFilesList.size(); ++i) {
                String lon = this.recentFilesList.get(i);
                String sho = this.recentFilesMap.get(lon);
                ef2.addActionToMenu(new RecentAction(ef2, sho, lon), 11, i);
            }
        }
        for (int i = 0; i < this.openFrameList.size(); ++i) {
            ActiveWindowAction ac;
            ElanFrame2 ef2;
            FrameInfo fin = this.openFrameList.get(i);
            if (fin.getFrame() instanceof ElanFrame2) {
                ef2 = (ElanFrame2)fin.getFrame();
                ac = new ActiveWindowAction(id, (String)fileName);
                ef2.addActionToMenu(ac, 800, -1);
                ef2.setMenuSelected(id, 800);
            }
            if (fin == frInfo || !(frInfo.getFrame() instanceof ElanFrame2)) continue;
            ef2 = (ElanFrame2)frInfo.getFrame();
            ac = new ActiveWindowAction(fin.getFrameId(), fin.getFrameName());
            ef2.addActionToMenu(ac, 800, i);
        }
        if (fullPath != null) {
            this.addToRecentFiles(fullPath);
        }
    }

    private void addToRecentFiles(String fullPath) {
        if (fullPath == null) {
            return;
        }
        if (!fullPath.toLowerCase().endsWith(".eaf")) {
            return;
        }
        String shortUrl = this.fullPathToDisplayPath(fullPath);
        boolean move = false;
        if (this.completeRecentItems.contains(fullPath)) {
            if (this.completeRecentItems.indexOf(fullPath) == 0) {
                return;
            }
            move = true;
            this.completeRecentItems.remove(fullPath);
            this.completeRecentItems.add(0, fullPath);
        } else {
            this.completeRecentItems.add(0, fullPath);
            if (this.completeRecentItems.size() > 30) {
                this.completeRecentItems.remove(this.completeRecentItems.size() - 1);
            }
            if (shortUrl != null) {
                this.recentFilesMap.put(fullPath, shortUrl);
            }
        }
        this.recentFilesList.clear();
        if (this.completeRecentItems.size() > this.nrRecentItemsPreference) {
            this.recentFilesList.addAll(this.completeRecentItems.subList(0, this.nrRecentItemsPreference));
        } else {
            this.recentFilesList.addAll(this.completeRecentItems);
        }
        this.updateRecentFilesMap();
        for (int i = 0; i < this.openFrameList.size(); ++i) {
            Action ac;
            FrameInfo fin = this.openFrameList.get(i);
            if (!(fin.getFrame() instanceof ElanFrame2)) continue;
            ElanFrame2 ef2 = (ElanFrame2)fin.getFrame();
            if (move) {
                ac = ef2.removeActionFromMenu(fullPath, 11);
                if (ac == null) {
                    ac = new RecentAction(ef2, shortUrl, fullPath);
                }
                ef2.addActionToMenu(ac, 11, 0);
                continue;
            }
            ac = new RecentAction(ef2, shortUrl, fullPath);
            ef2.addActionToMenu(ac, 11, 0);
        }
        Preferences.set("FrameManager.RecentFiles", this.completeRecentItems, null);
    }

    private void updateRecentFilesMap() {
        this.recentFilesMap.clear();
        for (int i = 0; i < this.recentFilesList.size(); ++i) {
            String shUrl;
            String url = this.completeRecentItems.get(i);
            if (url == null || (shUrl = this.fullPathToDisplayPath(url)) == null) continue;
            this.recentFilesMap.put(url, shUrl);
        }
    }

    private void removeFromRecentFiles(String fullPath) {
        if (fullPath == null) {
            return;
        }
        if (this.completeRecentItems.contains(fullPath)) {
            this.completeRecentItems.remove(fullPath);
            this.recentFilesList.remove(fullPath);
            this.recentFilesMap.remove(fullPath);
            for (int i = 0; i < this.openFrameList.size(); ++i) {
                FrameInfo fin = this.openFrameList.get(i);
                if (!(fin.getFrame() instanceof ElanFrame2)) continue;
                ElanFrame2 ef2 = (ElanFrame2)fin.getFrame();
                ef2.removeActionFromMenu(fullPath, 11);
            }
            Preferences.set("FrameManager.RecentFiles", this.completeRecentItems, null);
        }
    }

    public String fullPathToDisplayPath(String fullPath) {
        int colon;
        if (fullPath == null) {
            return "";
        }
        int start = 0;
        int lastSep = fullPath.lastIndexOf(File.separatorChar);
        if (lastSep < 0) {
            if (fullPath.length() <= 40) {
                return fullPath;
            }
            return fullPath.substring(0, 37) + "...";
        }
        if (fullPath.startsWith("file:")) {
            start = 5;
        }
        if ((colon = fullPath.indexOf(58, start)) - start > 0 && colon - start < 5) {
            start = colon - 1;
        } else {
            int ad = 0;
            for (int i = 0; i < 3; ++i) {
                if (fullPath.charAt(start + i) != File.separatorChar) continue;
                ++ad;
            }
            if (ad == 3) {
                start += 2;
            }
        }
        if (fullPath.length() - start < 40) {
            return fullPath.substring(start);
        }
        int fl = fullPath.length() - lastSep;
        if (fl > 40) {
            return fullPath.substring(lastSep, lastSep + 40);
        }
        int fd = fullPath.indexOf(File.separatorChar, start + 3);
        if (fd == lastSep) {
            if (fl + fd - start <= 40) {
                return fullPath.substring(start);
            }
            return fullPath.substring(start, start + 40 - fl - 3) + "..." + fullPath.substring(lastSep);
        }
        if (fd >= 0 && fl + (fd - start) < 37) {
            int nextSep = fd;
            while ((nextSep = fullPath.indexOf(File.separatorChar, fd + 1)) > 0 && nextSep != lastSep && fl + (nextSep - start) < 37) {
                fd = nextSep;
            }
            return fullPath.substring(start, fd + 1) + "..." + fullPath.substring(lastSep);
        }
        if (fd >= 0) {
            int rm = Math.max(40 - fl - 4, 1);
            if (fd - start > rm) {
                fd = start + rm;
                return fullPath.substring(start, fd) + "." + File.separator + "..." + fullPath.substring(lastSep);
            }
            return fullPath.substring(start, fd + 1) + "..." + fullPath.substring(lastSep);
        }
        return fullPath.substring(start);
    }

    public boolean isExitAllowed() {
        return this.exitAllowed;
    }

    public void setExitAllowed(boolean exitAllowed) {
        this.exitAllowed = exitAllowed;
    }

    @Override
    public void preferencesChanged() {
        Boolean lockFilePref;
        Integer recentItems = Preferences.getInt("UI.RecentItems", null);
        if (recentItems != null) {
            this.nrRecentItemsPreference = recentItems;
        }
        if (this.nrRecentItemsPreference != this.recentFilesList.size()) {
            this.updateRecentFileMenu();
        }
        if ((lockFilePref = Preferences.getBool("CreateLockFiles", null)) != null) {
            this.fileLockingEnabled = lockFilePref;
        }
    }

    public List<Transcription> getOpenTranscriptions() {
        ArrayList<Transcription> res = new ArrayList<Transcription>();
        for (FrameInfo frame_info : this.openFrameList) {
            ElanFrame2 elan_frame;
            ViewerManager2 vm;
            if (!(frame_info.getFrame() instanceof ElanFrame2) || (vm = (elan_frame = (ElanFrame2)frame_info.getFrame()).getViewerManager()) == null) continue;
            Transcription t = vm.getTranscription();
            res.add(t);
        }
        return res;
    }

    public List<String> getRecentFiles() {
        return Collections.unmodifiableList(this.recentFilesList);
    }

    public void addWindowCloseListener(ShutdownListener l) {
        listenerList.add(l);
    }

    public void removeWindowCloseListener(ShutdownListener l) {
        listenerList.remove(l);
    }

    protected void fireWindowClosing(Object source, int type) {
        ShutdownListener.Event e = null;
        for (ShutdownListener l : listenerList) {
            if (e == null) {
                e = new ShutdownListener.Event(source, type);
            }
            l.somethingIsClosing(e);
        }
    }

    private void checkLockedStatus(FileLockInfo lockInfo) {
        try {
            lockInfo.setAppLocked(FileLockUtil.isAppLocked(lockInfo.getFileString()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void acquireAppLock(FileLockInfo lockInfo) {
        try {
            lockInfo.setAppLock(FileLockUtil.acquireAppLockFile(lockInfo.getFileString()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void releaseLocks(FileLockInfo lockInfo) {
        if (lockInfo.getAppLock() != null) {
            FileLockUtil.releaseAppLockFile(lockInfo.getAppLock());
        }
    }

    private void showLockMessage(FileLockInfo lockInfo) {
        List<String> lines = FileLockUtil.getAppLockContent(lockInfo.getFileString());
        if (lines != null) {
            StringBuilder sb = null;
            if (lines.size() >= 3) {
                sb = new StringBuilder(String.format("<html><table><tr><td colspan=\"2\">%s</td></tr>", ElanLocale.getString("FileLock.Message0")));
                sb.append(String.format("<tr><td>%s</td><td>%s</td></tr>", ElanLocale.getString("FileLock.Message1"), lines.get(0)));
                sb.append(String.format("<tr><td>%s</td><td>%s</td></tr>", ElanLocale.getString("FileLock.Message2"), lines.get(1)));
                sb.append(String.format("<tr><td>%s</td><td>%s</td></tr>", ElanLocale.getString("FileLock.Message3"), lines.get(2)));
                sb.append("</table></html>");
            } else {
                sb = new StringBuilder(ElanLocale.getString("FileLock.Message0"));
                for (String s : lines) {
                    sb.append(String.format("  \"%s\", ", s));
                }
            }
            JOptionPane.showMessageDialog(this.getActiveFrame(), sb.toString(), ElanLocale.getString("FileLock.Error"), 2);
        }
    }

    class RecentAction
    extends AbstractAction {
        private JFrame fr;

        RecentAction(JFrame fr, String shortUrl, String fullUrl) {
            this.fr = fr;
            this.putValue("Name", shortUrl);
            this.putValue("LongDescription", fullUrl);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String path = (String)this.getValue("LongDescription");
                boolean fileExists = true;
                if (FileUtility.isRemoteFile(path)) {
                    fileExists = FileUtility.remoteFileExists(path);
                } else {
                    File fileTemp = new File(path);
                    boolean bl = fileExists = fileTemp.exists() && !fileTemp.isDirectory();
                }
                if (!fileExists) {
                    Object strMessage = ElanLocale.getString("Menu.Dialog.Message1");
                    strMessage = (String)strMessage + path;
                    strMessage = (String)strMessage + ElanLocale.getString("Menu.Dialog.Message2");
                    String strError = ElanLocale.getString("Message.Error");
                    JOptionPane.showMessageDialog(this.fr, strMessage, strError, 0);
                    FrameManager.this.removeFromRecentFiles(path);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            FrameManager.getInstance().createFrame((String)this.getValue("LongDescription"));
        }
    }

    class ActiveWindowAction
    extends AbstractAction {
        ActiveWindowAction(String frameId, String fileName) {
            this.putValue("Name", fileName);
            this.putValue("LongDescription", frameId);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FrameManager.getInstance().setToFront((String)this.getValue("LongDescription"));
        }
    }
}

