/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.linkedmedia.MediaDescriptorUtil;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.EmptyMediaPlayer;
import mpi.eudico.client.annotator.player.PlayerFactory;
import mpi.eudico.client.util.SelectableObject;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.util.MediaDescriptorUtility;
import nl.mpi.util.FileUtility;

public class PlayerViewerMenuManager {
    private ElanFrame2 frame;
    private Transcription transcription;
    private List<SelectableObject<MediaDescriptor>> menuPlayers;
    private final String HIDDEN_PLAYERS_KEY = "HiddenPlayers";

    public PlayerViewerMenuManager(ElanFrame2 frame, Transcription transcription) {
        this.frame = frame;
        this.transcription = transcription;
        this.menuPlayers = new ArrayList<SelectableObject<MediaDescriptor>>();
    }

    public List<MediaDescriptor> getStoredVisiblePlayers() {
        List<String> tempList = Preferences.getListOfString("HiddenPlayers", this.transcription);
        List<MediaDescriptor> mediaDescriptors = this.transcription.getMediaDescriptors();
        if (tempList == null) {
            return mediaDescriptors;
        }
        int size = mediaDescriptors.size();
        ArrayList<MediaDescriptor> visList = new ArrayList<MediaDescriptor>(size);
        for (MediaDescriptor md : mediaDescriptors) {
            if (md.mediaURL == null || tempList.contains(md.mediaURL)) continue;
            visList.add(md);
        }
        return visList;
    }

    public void initPlayerMenu() {
        List<MediaDescriptor> visuals = this.frame.getLayoutManager().getVisualPlayers();
        List<MediaDescriptor> descriptors = this.transcription.getMediaDescriptors();
        int visibles = 0;
        for (MediaDescriptor md : descriptors) {
            if (md.mimeType != null && md.mimeType.equals("audio/x-wav") || md.mimeType.equals("audio/*")) continue;
            boolean curVisual = visuals.contains(md);
            boolean curValid = MediaDescriptorUtility.checkLinkStatus(md);
            if (!curVisual && md.mimeType != null && md.mimeType.equals("unknown") && curValid && !this.isVideo(md)) continue;
            String fileName = FileUtility.fileNameFromPath(md.mediaURL);
            PlayerAction action = new PlayerAction(md.mediaURL, fileName);
            if (!curValid) {
                action.setEnabled(false);
            }
            this.frame.addActionToMenu(action, 610, -1);
            if (curVisual && visibles < 4) {
                this.frame.setMenuSelected(md.mediaURL, 610);
                this.menuPlayers.add(new SelectableObject<MediaDescriptor>(md, true));
                ++visibles;
                continue;
            }
            this.menuPlayers.add(new SelectableObject<MediaDescriptor>(md, false));
        }
    }

    public void reinitializePlayerMenu() {
        ArrayList<String> hidden = new ArrayList<String>(6);
        for (SelectableObject<MediaDescriptor> sob : this.menuPlayers) {
            MediaDescriptor md = sob.getValue();
            if (!sob.isSelected()) {
                hidden.add(md.mediaURL);
            }
            this.frame.removeActionFromMenu(md.mediaURL, 610);
        }
        if (hidden.size() > 0) {
            this.removeHiddenPlayers(hidden);
        }
        this.menuPlayers.clear();
        this.initPlayerMenu();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isVideo(MediaDescriptor md) {
        if (md == null) {
            return false;
        }
        ElanMediaPlayer player = null;
        try {
            player = PlayerFactory.createElanMediaPlayer(md);
            if (player.getVisualComponent() == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (player != null) {
                player.cleanUpOnClose();
                player = null;
            }
        }
    }

    private void savePreferences() {
        ArrayList<String> hidden = new ArrayList<String>();
        for (SelectableObject<MediaDescriptor> sob : this.menuPlayers) {
            MediaDescriptor md = sob.getValue();
            if (sob.isSelected()) continue;
            hidden.add(md.mediaURL);
        }
        Preferences.set("HiddenPlayers", hidden, this.transcription);
    }

    void playerActionPerformed(AbstractAction action, ActionEvent e) {
        if (e.getSource() instanceof AbstractButton) {
            boolean selected = ((AbstractButton)e.getSource()).isSelected();
            List<MediaDescriptor> visuals = this.frame.getLayoutManager().getVisualPlayers();
            if (!selected) {
                String url = (String)action.getValue("LongDescription");
                MediaDescriptor md = null;
                SelectableObject<MediaDescriptor> sob = null;
                for (int i = 0; i < this.menuPlayers.size(); ++i) {
                    sob = this.menuPlayers.get(i);
                    md = sob.getValue();
                    if (md.mediaURL.equals(url)) {
                        sob.setSelected(false);
                        break;
                    }
                    if (i != this.menuPlayers.size() - 1) continue;
                    md = null;
                }
                if (md != null) {
                    this.removePlayer(md);
                }
            } else {
                String url = (String)action.getValue("LongDescription");
                MediaDescriptor md = null;
                SelectableObject<MediaDescriptor> sob = null;
                for (int i = 0; i < this.menuPlayers.size(); ++i) {
                    sob = this.menuPlayers.get(i);
                    md = sob.getValue();
                    if (md.mediaURL.equals(url)) {
                        sob.setSelected(true);
                        break;
                    }
                    if (i != this.menuPlayers.size() - 1) continue;
                    md = null;
                }
                long mediaTime = this.frame.getViewerManager().getMasterMediaPlayer().getMediaTime();
                if (visuals.size() < 4) {
                    ElanMediaPlayer pl;
                    if (md != null && (pl = MediaDescriptorUtil.createMediaPlayer((TranscriptionImpl)this.transcription, md)) != null) {
                        if (this.frame.getViewerManager().getMasterMediaPlayer() instanceof EmptyMediaPlayer) {
                            this.frame.getViewerManager().setMasterMediaPlayer(pl);
                        } else if (this.transcription.getMediaDescriptors().size() > 0 && this.transcription.getMediaDescriptors().get(0).equals(md)) {
                            this.frame.getViewerManager().setMasterMediaPlayer(pl);
                        }
                        this.frame.getLayoutManager().add(pl);
                        pl.setMediaTime(mediaTime);
                    }
                } else {
                    JOptionPane.showMessageDialog(this.frame, ElanLocale.getString("Player.MaxNumber") + " 4", ElanLocale.getString("Message.Warning"), 2);
                    ((AbstractButton)e.getSource()).setSelected(false);
                }
            }
            this.savePreferences();
        }
    }

    private void removeHiddenPlayers(List<String> hidden) {
        if (hidden == null || hidden.size() == 0) {
            return;
        }
        List<MediaDescriptor> visuals = this.frame.getLayoutManager().getVisualPlayers();
        for (MediaDescriptor md : visuals) {
            if (!hidden.contains(md.mediaURL)) continue;
            this.removePlayer(md);
        }
    }

    private void removePlayer(MediaDescriptor md) {
        if (md == null || md.mediaURL == null) {
            return;
        }
        ElanMediaPlayer player = null;
        List<MediaDescriptor> visuals = this.frame.getLayoutManager().getVisualPlayers();
        MediaDescriptor otherMd = this.frame.getViewerManager().getMasterMediaPlayer().getMediaDescriptor();
        if (otherMd != null && md.mediaURL.equals(otherMd.mediaURL)) {
            player = this.frame.getViewerManager().getMasterMediaPlayer();
            long mediaTime = player.getMediaTime();
            List<ElanMediaPlayer> connectPlayers = this.frame.getViewerManager().getConnectedMediaPlayers();
            if (connectPlayers.size() == 0) {
                this.frame.getViewerManager().setMasterMediaPlayer(new EmptyMediaPlayer(Integer.MAX_VALUE));
                this.frame.getViewerManager().destroyMediaPlayer(player);
                this.frame.getLayoutManager().remove(player);
                this.frame.getViewerManager().getMasterMediaPlayer().setMediaTime(mediaTime);
            } else if (connectPlayers.size() == 1) {
                if (connectPlayers.get(0) instanceof EmptyMediaPlayer) {
                    long minTime;
                    long time = this.frame.getViewerManager().getTranscription().getLatestTime();
                    if (time < (minTime = 60000L)) {
                        time = minTime;
                    }
                    ((EmptyMediaPlayer)connectPlayers.get(0)).setMediaDuration(time);
                }
                this.frame.getViewerManager().setMasterMediaPlayer(connectPlayers.get(0));
                this.frame.getViewerManager().destroyMediaPlayer(player);
                this.frame.getLayoutManager().remove(player);
                this.frame.getViewerManager().getMasterMediaPlayer().setMediaTime(mediaTime);
            } else {
                ElanMediaPlayer connPl = connectPlayers.get(0);
                if (connPl instanceof EmptyMediaPlayer || !visuals.contains(connPl.getMediaDescriptor())) {
                    block0: for (int i = 1; i < connectPlayers.size(); ++i) {
                        if (connectPlayers.get(i) instanceof EmptyMediaPlayer) continue;
                        ElanMediaPlayer nextPl = connectPlayers.get(i);
                        for (int j = 0; j < visuals.size(); ++j) {
                            if (!visuals.get(j).equals(nextPl.getMediaDescriptor())) continue;
                            connPl = nextPl;
                            break block0;
                        }
                    }
                }
                this.frame.getViewerManager().setMasterMediaPlayer(connPl);
                this.frame.getViewerManager().destroyMediaPlayer(player);
                this.frame.getLayoutManager().remove(player);
                this.frame.getViewerManager().getMasterMediaPlayer().setMediaTime(mediaTime);
            }
        } else {
            List<ElanMediaPlayer> connectPlayers = this.frame.getViewerManager().getConnectedMediaPlayers();
            ElanMediaPlayer connPl = null;
            for (int i = 0; i < connectPlayers.size(); ++i) {
                connPl = connectPlayers.get(i);
                if (!md.equals(connPl.getMediaDescriptor())) continue;
                this.frame.getViewerManager().destroyMediaPlayer(connPl);
                this.frame.getLayoutManager().remove(connPl);
            }
        }
    }

    class PlayerAction
    extends AbstractAction {
        PlayerAction(String fileUrl, String fileName) {
            this.putValue("Name", fileName);
            this.putValue("LongDescription", fileUrl);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlayerViewerMenuManager.this.playerActionPerformed(this, e);
        }
    }
}

