/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.PreferencesListener;
import mpi.eudico.client.annotator.SaveAs27Preferences;
import mpi.eudico.client.annotator.prefs.PrefKeyMapper;
import mpi.eudico.client.annotator.prefs.PreferencesReader;
import mpi.eudico.client.annotator.prefs.PreferencesWriter;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import nl.mpi.util.FileUtility;

public class Preferences {
    public static final String CV_PREFS = "CV.ML.Prefs";
    public static final String CV_PREFS_OLD_2_7 = "CV.Prefs";
    public static final String PREF_ML_LANGUAGE = "DefaultControlledVocabularyLanguage";
    private static final String GLOBAL_PREFS_KEY = "elan global prefs key";
    private static final String GLOBAL_PREFS_FILE_NAME = "elan.pfs";
    private static final String GLOBAL_PREFS_XML_FILE_NAME = "elan.pfsx";
    private static final String XML_EXT = "pfsx";
    public static final String REMOTE_PREF_CACHE = "RemotePrefCache";
    private static Map<Object, Map<String, Object>> preferences;
    private static Map<Transcription, List<PreferencesListener>> listenerGroups;
    private static PreferencesReader xmlPrefsReader;
    private static PreferencesWriter xmlPrefsWriter;
    private static Map<Transcription, String> prefLocations;

    public static Object get(String key, Transcription document) {
        if (key == null) {
            return null;
        }
        Preferences.initPreferencesFor(document);
        Object result = preferences.get(Preferences.documentKeyFor(document)).get(key);
        if (result != null) {
            return result;
        }
        return preferences.get(GLOBAL_PREFS_KEY).get(key);
    }

    public static Boolean getBool(String key, Transcription document) {
        Object o = Preferences.get(key, document);
        if (!(o instanceof Boolean)) {
            return null;
        }
        return (Boolean)o;
    }

    public static Integer getInt(String key, Transcription document) {
        Object o = Preferences.get(key, document);
        if (!(o instanceof Integer)) {
            return null;
        }
        return (Integer)o;
    }

    public static Long getLong(String key, Transcription document) {
        Object o = Preferences.get(key, document);
        if (o == null || !(o instanceof Long)) {
            return null;
        }
        return (Long)o;
    }

    public static Float getFloat(String key, Transcription document) {
        Object o = Preferences.get(key, document);
        if (!(o instanceof Float)) {
            return null;
        }
        return (Float)o;
    }

    public static Double getDouble(String key, Transcription document) {
        Object o = Preferences.get(key, document);
        if (!(o instanceof Double)) {
            return null;
        }
        return (Double)o;
    }

    public static String getString(String key, Transcription document) {
        Object o = Preferences.get(key, document);
        if (!(o instanceof String)) {
            return null;
        }
        return (String)o;
    }

    public static Dimension getDimension(String key, Transcription document) {
        Object o = Preferences.get(key, document);
        if (!(o instanceof Dimension)) {
            return null;
        }
        return (Dimension)o;
    }

    public static Point getPoint(String key, Transcription document) {
        Object o = Preferences.get(key, document);
        if (!(o instanceof Point)) {
            return null;
        }
        return (Point)o;
    }

    public static Rectangle getRect(String key, Transcription document) {
        Object o = Preferences.get(key, document);
        if (!(o instanceof Rectangle)) {
            return null;
        }
        return (Rectangle)o;
    }

    public static Color getColor(String key, Transcription document) {
        Object o = Preferences.get(key, document);
        if (!(o instanceof Color)) {
            return null;
        }
        return (Color)o;
    }

    public static List<?> getList(String key, Transcription document) {
        Object o = Preferences.get(key, document);
        if (!(o instanceof List)) {
            return null;
        }
        return (List)o;
    }

    public static List<String> getListOfString(String key, Transcription document) {
        Object lo;
        List<String> o = Preferences.getList(key, document);
        if (o == null) {
            return null;
        }
        if (!o.isEmpty() && !((lo = o.get(0)) instanceof String)) {
            return null;
        }
        List<String> l = o;
        return l;
    }

    public static Map<String, ?> getMap(String key, Transcription document) {
        Object o = Preferences.get(key, document);
        if (!(o instanceof Map)) {
            return null;
        }
        Map m = (Map)o;
        return m;
    }

    public static Map<String, String> getMapOfString(String key, Transcription document) {
        Iterator<?> it;
        Object mo;
        Map<String, String> m = Preferences.getMap(key, document);
        if (m == null) {
            return null;
        }
        if (!m.isEmpty() && !((mo = (it = m.values().iterator()).next()) instanceof String)) {
            return null;
        }
        return m;
    }

    public static Map<String, Color> getMapOfColor(String key, Transcription document) {
        Iterator<?> it;
        Object mo;
        Map<String, Color> m = Preferences.getMap(key, document);
        if (m == null) {
            return null;
        }
        if (!m.isEmpty() && !((mo = (it = m.values().iterator()).next()) instanceof Color)) {
            return null;
        }
        return m;
    }

    public static Map<String, Integer> getMapOfInt(String key, Transcription document) {
        Iterator<?> it;
        Object mo;
        Map<String, Integer> m = Preferences.getMap(key, document);
        if (m == null) {
            return null;
        }
        if (!m.isEmpty() && !((mo = (it = m.values().iterator()).next()) instanceof Integer)) {
            return null;
        }
        return m;
    }

    public static Map<String, Font> getMapOfFont(String key, Transcription document) {
        Iterator<?> it;
        Object mo;
        Map<String, Font> m = Preferences.getMap(key, document);
        if (m == null) {
            return null;
        }
        if (!m.isEmpty() && !((mo = (it = m.values().iterator()).next()) instanceof Font)) {
            return null;
        }
        return m;
    }

    public static Map<String, Object> getPreferencesFor(Transcription document) {
        Map<String, Object> result = preferences.get(Preferences.documentKeyFor(document));
        if (result == null && document != null) {
            result = Preferences.loadPreferencesForFile(document.getFullPath());
        }
        return result;
    }

    public static void set(String key, Object value, Transcription document, boolean notify, boolean savePrefs) {
        if (key == null) {
            return;
        }
        Preferences.initPreferencesFor(document);
        preferences.get(Preferences.documentKeyFor(document)).put(key, value);
        if (savePrefs) {
            Preferences.writePreferencesFor(document);
        }
        if (notify) {
            if (document != null) {
                Preferences.notifyListeners(document);
            } else {
                Preferences.notifyAllListeners();
            }
        }
    }

    public static void set(String key, Object value, Transcription document, boolean notify) {
        Preferences.set(key, value, document, notify, true);
    }

    public static void set(String key, Object value, Transcription document) {
        Preferences.set(key, value, document, false);
    }

    public static void set(String key, int value, Transcription document) {
        Preferences.set(key, (Object)value, document);
    }

    public static void set(String key, long value, Transcription document) {
        Preferences.set(key, (Object)value, document);
    }

    public static void set(String key, float value, Transcription document) {
        Preferences.set(key, Float.valueOf(value), document);
    }

    public static void set(String key, double value, Transcription document) {
        Preferences.set(key, (Object)value, document);
    }

    public static void removeDocument(Transcription document) {
        if (preferences != null) {
            preferences.remove(document);
        }
        prefLocations.remove(document);
        listenerGroups.remove(document);
    }

    public static void addPreferencesListener(Transcription document, PreferencesListener listener) {
        if (listenerGroups.containsKey(document)) {
            List<PreferencesListener> listeners = listenerGroups.get(document);
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        } else {
            ArrayList<PreferencesListener> list = new ArrayList<PreferencesListener>();
            list.add(listener);
            listenerGroups.put(document, list);
        }
    }

    public static void removePreferencesListener(Transcription document, PreferencesListener listener) {
        if (listenerGroups.containsKey(document)) {
            listenerGroups.get(document).remove(listener);
        }
    }

    public static void exportPreferences(Transcription document, String filePath) {
        if (document == null || filePath == null) {
            return;
        }
        xmlPrefsWriter.encodeAndSave(preferences.get(Preferences.documentKeyFor(document)), filePath);
    }

    public static void importPreferences(Transcription document, String filePath) {
        if (document == null) {
            return;
        }
        Map loadedPrefs = xmlPrefsReader.parse(filePath);
        if (loadedPrefs.size() == 0) {
            return;
        }
        if (preferences == null) {
            preferences = new HashMap<Object, Map<String, Object>>();
        }
        if (preferences.get(Preferences.documentKeyFor(document)) == null) {
            preferences.put(Preferences.documentKeyFor(document), loadedPrefs);
        } else {
            preferences.get(Preferences.documentKeyFor(document)).putAll(loadedPrefs);
        }
        Preferences.writePreferencesFor(document);
        Preferences.notifyListeners(document);
    }

    public static void importPreferences(Transcription document, Map<String, Object> loadedPrefs) {
        if (document == null) {
            return;
        }
        if (loadedPrefs == null || loadedPrefs.size() == 0) {
            return;
        }
        if (preferences == null) {
            preferences = new HashMap<Object, Map<String, Object>>();
        }
        if (preferences.get(Preferences.documentKeyFor(document)) == null) {
            preferences.put(Preferences.documentKeyFor(document), loadedPrefs);
        } else {
            preferences.get(Preferences.documentKeyFor(document)).putAll(loadedPrefs);
        }
        Preferences.writePreferencesFor(document);
        Preferences.notifyListeners(document);
    }

    public static Map<String, Object> loadPreferencesForFile(String filePath) {
        Object val;
        if (filePath == null) {
            return null;
        }
        Object prefFileName = filePath.replace('\\', '/');
        if (((String)prefFileName).length() > 3) {
            prefFileName = ((String)prefFileName).substring(0, ((String)prefFileName).length() - 3) + XML_EXT;
        }
        if ((val = Preferences.get("DefaultPreferencesLocation", null)) instanceof String) {
            String genPrefsLocation = ((String)val).replace('\\', '/');
            Object fileName = prefFileName;
            int lastSep = ((String)fileName).lastIndexOf(47);
            if (lastSep > -1) {
                fileName = ((String)fileName).substring(lastSep);
            }
            prefFileName = genPrefsLocation + (String)fileName;
        }
        if (((String)prefFileName).startsWith("file:")) {
            prefFileName = ((String)prefFileName).substring(5);
        }
        try {
            if (new File((String)prefFileName).exists()) {
                return xmlPrefsReader.parse((String)prefFileName);
            }
        }
        catch (Exception ex) {
            ClientLogger.LOG.warning("Could not load preferences file: " + ex.getMessage());
        }
        return null;
    }

    public static void notifyListeners(Transcription document) {
        List<PreferencesListener> listeners = listenerGroups.get(document);
        if (listeners != null) {
            for (int i = 0; i < listeners.size(); ++i) {
                listeners.get(i).preferencesChanged();
            }
        }
    }

    private static void notifyAllListeners() {
        List<PreferencesListener> listeners2 = null;
        for (List<PreferencesListener> listeners2 : listenerGroups.values()) {
            if (listeners2 == null) continue;
            for (int i = 0; i < listeners2.size(); ++i) {
                listeners2.get(i).preferencesChanged();
            }
        }
    }

    private static void initPreferencesFor(Transcription document) {
        if (preferences == null) {
            preferences = new HashMap<Object, Map<String, Object>>();
        }
        if (!preferences.containsKey(Preferences.documentKeyFor(document))) {
            Map<String, Object> documentPreferences = Preferences.readPreferencesFor(document);
            preferences.put(Preferences.documentKeyFor(document), documentPreferences);
        }
    }

    private static Map<String, Object> readPreferencesFor(Transcription document) {
        Map<String, Object> preferencesHashtable = null;
        String xmlPath = "";
        try {
            xmlPath = Preferences.preferenceXmlFilePathFor(document);
            if (xmlPath == null) {
                return new HashMap<String, Object>();
            }
            if (new File(xmlPath).exists()) {
                preferencesHashtable = xmlPrefsReader.parse(xmlPath);
            } else if (new File(Preferences.preferenceFilePathFor(document)).exists()) {
                FileInputStream fileIn = new FileInputStream(Preferences.preferenceFilePathFor(document));
                ObjectInputStream objectIn = new ObjectInputStream(fileIn);
                preferencesHashtable = (Hashtable)objectIn.readObject();
                preferencesHashtable = Preferences.convertPreferencesTable(preferencesHashtable);
                objectIn.close();
                fileIn.close();
            } else if (document != null && FileUtility.isRemoteFile(document.getFullPath())) {
                xmlPath = document.getFullPath().replaceFirst("eaf$", XML_EXT);
                preferencesHashtable = xmlPrefsReader.parse(xmlPath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (preferencesHashtable != null) {
            return preferencesHashtable;
        }
        return new HashMap<String, Object>();
    }

    private static void writePreferencesFor(Transcription document) {
        try {
            if (document != null && document.getName().equals("aishug294879ryshfda9763afo8947a5gf")) {
                return;
            }
            String prefPath = Preferences.preferenceXmlFilePathFor(document);
            if (prefPath != null) {
                int format = SaveAs27Preferences.saveAsType(document);
                Object orig = SaveAs27Preferences.adjustPreferencesForSavingFormat(document, format);
                xmlPrefsWriter.encodeAndSave(preferences.get(Preferences.documentKeyFor(document)), prefPath);
                SaveAs27Preferences.restoreAdjustedPreferences(document, orig);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Object documentKeyFor(Transcription document) {
        if (document == null) {
            return GLOBAL_PREFS_KEY;
        }
        return document;
    }

    private static String preferenceFilePathFor(Transcription document) throws Exception {
        if (document == null) {
            return Constants.ELAN_DATA_DIR + System.getProperty("file.separator") + GLOBAL_PREFS_FILE_NAME;
        }
        Object prefFileName = "";
        if (document instanceof TranscriptionImpl) {
            prefFileName = ((TranscriptionImpl)document).getPathName();
        }
        if (((String)prefFileName).length() > 3) {
            prefFileName = ((String)prefFileName).substring(0, ((String)prefFileName).length() - 3) + "pfs";
        }
        return prefFileName;
    }

    private static String preferenceXmlFilePathFor(Transcription document) throws Exception {
        Object val;
        if (document == null) {
            return Constants.ELAN_DATA_DIR + System.getProperty("file.separator") + GLOBAL_PREFS_XML_FILE_NAME;
        }
        if (prefLocations.containsKey(document)) {
            return prefLocations.get(document);
        }
        Object prefFileName = "";
        if (document instanceof TranscriptionImpl) {
            prefFileName = ((TranscriptionImpl)document).getPathName();
        }
        if (!((String)prefFileName).toLowerCase().endsWith("eaf")) {
            return null;
        }
        if (((String)prefFileName).length() > 3) {
            prefFileName = ((String)prefFileName).substring(0, ((String)prefFileName).length() - 3) + XML_EXT;
        }
        if ((val = Preferences.get("DefaultPreferencesLocation", null)) instanceof String) {
            Object genPrefsLocation = ((String)val).replace('\\', '/');
            String fileName = ((String)prefFileName).replace('\\', '/');
            int lastSep = fileName.lastIndexOf(47);
            if (lastSep > -1) {
                fileName = fileName.substring(lastSep);
            }
            if (((String)(genPrefsLocation = (String)genPrefsLocation + fileName)).startsWith("file:")) {
                genPrefsLocation = ((String)genPrefsLocation).substring(5);
            }
            try {
                if (new File((String)genPrefsLocation).exists()) {
                    prefFileName = genPrefsLocation;
                    prefLocations.put(document, (String)prefFileName);
                }
            }
            catch (Exception exception) {}
        } else if (FileUtility.isRemoteFile((String)prefFileName)) {
            File cacheDir = new File(Constants.ELAN_DATA_DIR + Constants.FILESEPARATOR + REMOTE_PREF_CACHE);
            if (!cacheDir.exists()) {
                cacheDir.mkdir();
            }
            prefFileName = Constants.ELAN_DATA_DIR + Constants.FILESEPARATOR + REMOTE_PREF_CACHE + Constants.FILESEPARATOR + FileUtility.fileNameFromPath((String)prefFileName);
            prefLocations.put(document, (String)prefFileName);
        }
        return prefFileName;
    }

    private static Map<String, Object> convertPreferencesTable(Map<String, Object> oldPrefs) {
        Map viewersState;
        Object to;
        if (oldPrefs == null) {
            return null;
        }
        HashMap<String, Object> nextMap = new HashMap<String, Object>();
        oldPrefs.remove("LastUsedShoeboxMarkers");
        Object tierOrder = oldPrefs.remove("TierOrder");
        if (tierOrder instanceof Vector) {
            ArrayList al = new ArrayList((Vector)tierOrder);
            nextMap.put("MultiTierViewer.TierOrder", al);
        }
        if ((to = oldPrefs.remove("Interlinear.VisibleTiers")) instanceof String[]) {
            String[] visb = (String[])to;
            ArrayList<String> vtList = new ArrayList<String>(visb.length);
            for (String element : visb) {
                vtList.add(element);
            }
            nextMap.put("Interlinear.VisibleTiers", vtList);
        }
        if ((viewersState = (Map)oldPrefs.remove("LayoutManagerState")) != null) {
            for (String key : viewersState.keySet()) {
                if (key.equals("TimeSeriesPanelMap")) {
                    Map tsMap = (Map)viewersState.get(key);
                    if (tsMap == null) continue;
                    for (Object tsKey : tsMap.keySet()) {
                        if (!(tsKey instanceof Integer)) continue;
                        Object tsVal = tsMap.get(tsKey);
                        String newKey = "TimeSeriesViewer.Panel-" + (Integer)tsKey;
                        if (!(tsVal instanceof String[])) continue;
                        String[] names = (String[])tsVal;
                        ArrayList<String> namesList = new ArrayList<String>(names.length);
                        for (String name : names) {
                            namesList.add(name);
                        }
                        nextMap.put(newKey, namesList);
                    }
                    continue;
                }
                Object newKey = PrefKeyMapper.keyMapper.get(key);
                if (newKey != null) {
                    if (key.startsWith("SubTitleTierName") && key.length() > 16) {
                        newKey = (String)newKey + key.substring(16);
                    } else if (key.startsWith("SubTitleFontSize") && key.length() > 16) {
                        newKey = (String)newKey + key.substring(16);
                    }
                    nextMap.put((String)newKey, viewersState.get(key));
                    continue;
                }
                nextMap.put(key, viewersState.get(key));
            }
        }
        nextMap.putAll(oldPrefs);
        return nextMap;
    }

    private static void printPrefs(Object prefs) {
        if (prefs == null || !(prefs instanceof Map)) {
            return;
        }
        Map prf = (Map)prefs;
        for (Object ke : prf.keySet()) {
            Object val = prf.get(ke);
            if (ke == null) {
                System.out.println("Entry: key is null...");
                continue;
            }
            System.out.println("K: " + ke + " (" + ke.getClass() + ")");
            if (val == null) {
                System.out.println("Entry: value is null...");
                continue;
            }
            System.out.println("V: " + val + " (" + val.getClass() + ")");
            if (val instanceof Object[]) {
                val = Arrays.asList((Object[])val);
            }
            if (val instanceof List) {
                List li = (List)val;
                for (int i = 0; i < li.size(); ++i) {
                    Object vv = li.get(i);
                    if (vv == null) continue;
                    System.out.println("\tentry: " + vv.toString());
                }
                continue;
            }
            if (!(val instanceof Map)) continue;
            Map mm = (Map)val;
            for (Object kk : mm.keySet()) {
                Object vv = mm.get(kk);
                if (kk != null) {
                    System.out.println("\tK: " + kk + " (" + kk.getClass() + ")");
                    if (vv != null) {
                        System.out.println("\tV: " + vv + " (" + vv.getClass() + ")");
                        continue;
                    }
                    System.out.println("\tvalue is null");
                    continue;
                }
                System.out.println("\tkey is null");
            }
        }
    }

    public static void updateAllCVLanguages(String newLanguageValue, boolean force) {
        for (Transcription t : FrameManager.getInstance().getOpenTranscriptions()) {
            ((TranscriptionImpl)t).updateCVLanguage(newLanguageValue, force);
        }
    }

    static {
        listenerGroups = new HashMap<Transcription, List<PreferencesListener>>();
        xmlPrefsReader = new PreferencesReader();
        xmlPrefsWriter = new PreferencesWriter();
        prefLocations = new HashMap<Transcription, String>();
    }
}

