/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.util.ArrayList;
import java.util.List;
import mpi.eudico.client.annotator.TierOrderListener;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;

public class TierOrder
implements ACMEditListener {
    private List<TierOrderListener> listeners = new ArrayList<TierOrderListener>();
    private List<String> tierOrder = null;
    private Transcription transcripton;

    public TierOrder(Transcription trans) {
        this.transcripton = trans;
    }

    public void setTierOrder(List<String> tierOrderList) {
        this.tierOrder = tierOrderList;
        this.notifyListeners();
    }

    public List<String> getTierOrder() {
        return this.tierOrder;
    }

    public void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).updateTierOrder(this.tierOrder);
        }
    }

    public void addTierOrderListener(TierOrderListener listener) {
        this.listeners.add(listener);
        listener.updateTierOrder(this.tierOrder);
    }

    public void removeTierorderListener(TierOrderListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
        switch (e.getOperation()) {
            case 1: {
                String tierName;
                Object obj = e.getModification();
                if (!(obj instanceof TierImpl) || !this.tierOrder.contains(tierName = ((Tier)obj).getName())) break;
                this.tierOrder.remove(tierName);
                break;
            }
            case 0: {
                String tierName;
                Object obj = e.getModification();
                if (!(obj instanceof TierImpl) || this.tierOrder.contains(tierName = ((Tier)obj).getName())) break;
                this.tierOrder.add(tierName);
                break;
            }
            case 2: {
                int i;
                Object obj = e.getSource();
                if (!(obj instanceof TierImpl)) break;
                String tierName = ((Tier)obj).getName();
                List<? extends Tier> tiers = this.transcripton.getTiers();
                ArrayList<String> tierNames = new ArrayList<String>();
                for (i = 0; i < tiers.size(); ++i) {
                    String name = tiers.get(i).getName();
                    tierNames.add(name);
                }
                for (i = 0; i < this.tierOrder.size(); ++i) {
                    if (tierNames.contains(this.tierOrder.get(i))) continue;
                    this.tierOrder.remove(i);
                    this.tierOrder.add(i, tierName);
                }
                break;
            }
        }
    }
}

