/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.util.ArrayList;
import java.util.List;
import mpi.eudico.client.annotator.TimeScaleListener;

public class TimeScale {
    private List<TimeScaleListener> listeners = new ArrayList<TimeScaleListener>();
    private long timeScaleBeginTime = 0L;
    private long timeScaleEndTime = 0L;
    private float timeScaleMsPerPixel = 10.0f;

    public long getBeginTime() {
        return this.timeScaleBeginTime;
    }

    public void setBeginTime(long beginTime) {
        if (this.timeScaleBeginTime != beginTime) {
            this.timeScaleBeginTime = beginTime;
            this.notifyListeners();
        }
    }

    public long getEndTime() {
        return this.timeScaleEndTime;
    }

    public void setEndTime(long endTime) {
        if (this.timeScaleEndTime != endTime) {
            this.timeScaleEndTime = endTime;
            this.notifyListeners();
        }
    }

    public long getIntervalDuration() {
        return this.timeScaleEndTime - this.timeScaleBeginTime;
    }

    public float getMsPerPixel() {
        return this.timeScaleMsPerPixel;
    }

    public void setMsPerPixel(float msPerPixel) {
        if (this.timeScaleMsPerPixel != msPerPixel) {
            this.timeScaleMsPerPixel = msPerPixel;
            this.notifyListeners();
        }
    }

    public void addTimeScaleListener(TimeScaleListener listener) {
        this.listeners.add(listener);
        listener.updateTimeScale();
    }

    public void removeTimeScaleListener(TimeScaleListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).updateTimeScale();
        }
    }
}

