/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;

public class VolumeManager {
    private float masterVolume = 1.0f;
    private ViewerManager2 vm;

    public VolumeManager(ViewerManager2 vm) {
        this.vm = vm;
        this.masterVolume = vm.getMediaPlayerController().getVolume();
        this.setSimpleVolumes();
    }

    public void setMasterVolume(float masterVolume) {
        this.masterVolume = masterVolume;
        this.setEffectiveVolume(this.vm.getMasterMediaPlayer());
        for (ElanMediaPlayer player : this.vm.getConnectedMediaPlayers()) {
            this.setEffectiveVolume(player);
        }
    }

    public float getMasterVolume() {
        return this.masterVolume;
    }

    public void setSubVolume(ElanMediaPlayer player, float volume) {
        player.setSubVolume(volume);
        this.setEffectiveVolume(player);
    }

    public float getSubVolume(ElanMediaPlayer player) {
        return player.getSubVolume();
    }

    private void setEffectiveVolume(ElanMediaPlayer player) {
        if (player.getMute()) {
            player.setVolume(0.0f);
        } else {
            float sv = player.getSubVolume();
            player.setVolume(sv * this.masterVolume);
        }
    }

    public void setSimpleVolumes() {
        for (ElanMediaPlayer player : this.vm.getConnectedMediaPlayers()) {
            player.setSubVolume(0.0f);
            player.setMute(false);
        }
        ElanMediaPlayer master = this.vm.getMasterMediaPlayer();
        master.setSubVolume(1.0f);
        master.setMute(false);
        this.setMasterVolume(this.masterVolume);
    }

    public void setMute(ElanMediaPlayer toMute, boolean mute) {
        toMute.setMute(mute);
        this.setEffectiveVolume(toMute);
    }
}

