/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.comments.CommentEnvelope;
import mpi.eudico.client.annotator.comments.CommentManager;

public class AddCommentCommand
implements UndoableCommand {
    private String commandName;
    private CommentManager commentManager;
    private CommentEnvelope newComment;
    private int insertPosition;

    public AddCommentCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        if (receiver instanceof CommentManager && arguments != null && arguments.length >= 1 && arguments[0] instanceof CommentEnvelope) {
            this.commentManager = (CommentManager)receiver;
            this.newComment = (CommentEnvelope)arguments[0];
            this.redo();
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    @Override
    public void undo() {
        if (this.newComment != null) {
            int index = this.commentManager.findCommentById(this.newComment.getMessageID());
            this.commentManager.remove(index);
        }
    }

    @Override
    public void redo() {
        if (this.newComment != null) {
            this.insertPosition = this.commentManager.insert(this.newComment);
        }
    }

    public int getInsertPosition() {
        return this.insertPosition;
    }
}

