/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.lexicon.LexiconQueryBundle2;

public class AddTypeCommand
implements UndoableCommand {
    private String commandName;
    private Transcription transcription;
    private String typeName;
    private Constraint constraint;
    private String cvName;
    private String dcId;
    private boolean timeAlignable;
    private LexiconQueryBundle2 queryBundle;
    private LinguisticType newLT;

    public AddTypeCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        if (this.newLT != null) {
            this.transcription.removeLinguisticType(this.newLT);
        }
    }

    @Override
    public void redo() {
        if (this.newLT != null) {
            this.transcription.addLinguisticType(this.newLT);
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (Transcription)receiver;
        this.typeName = (String)arguments[0];
        this.constraint = (Constraint)arguments[1];
        this.cvName = (String)arguments[2];
        this.timeAlignable = (Boolean)arguments[3];
        if (arguments.length >= 6) {
            this.dcId = (String)arguments[5];
        }
        if (arguments.length >= 7) {
            this.queryBundle = (LexiconQueryBundle2)arguments[6];
        }
        this.newLT = new LinguisticType(this.typeName);
        this.newLT.setControlledVocabularyName(this.cvName);
        this.newLT.setTimeAlignable(this.timeAlignable);
        if (this.constraint != null) {
            this.newLT.addConstraint(this.constraint);
        }
        if (this.dcId != null) {
            this.newLT.setDataCategory(this.dcId);
        }
        if (this.queryBundle != null) {
            this.newLT.setLexiconQueryBundle(this.queryBundle);
        }
        this.transcription.addLinguisticType(this.newLT);
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

