/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.CommandAction;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class AnnotationDownCA
extends CommandAction {
    private Icon icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/GoToLowerAnnotation.gif"));

    public AnnotationDownCA(ViewerManager2 theVM) {
        super(theVM, "CommandActions.AnnotationDown");
        this.putValue("SmallIcon", this.icon);
        this.putValue("Name", "");
    }

    @Override
    protected void newCommand() {
        this.command = ELANCommandFactory.createCommand(this.vm.getTranscription(), "Commands.ActiveAnnotation");
    }

    @Override
    protected Object getReceiver() {
        return this.vm;
    }

    @Override
    protected Object[] getArguments() {
        Annotation currentActiveAnnot = this.vm.getActiveAnnotation().getAnnotation();
        Annotation newActiveAnnot = null;
        List<TierImpl> visibleTiers = null;
        if (this.vm.getMultiTierControlPanel() != null) {
            visibleTiers = this.vm.getMultiTierControlPanel().getVisibleTiers();
        }
        if (visibleTiers == null || visibleTiers.size() == 0) {
            return new Object[]{currentActiveAnnot};
        }
        if (currentActiveAnnot != null) {
            long mediaTime = this.vm.getMasterMediaPlayer().getMediaTime();
            long refTime = mediaTime >= currentActiveAnnot.getBeginTimeBoundary() && mediaTime <= currentActiveAnnot.getEndTimeBoundary() ? (mediaTime == currentActiveAnnot.getBeginTimeBoundary() ? mediaTime + 1L : mediaTime) : currentActiveAnnot.getBeginTimeBoundary() + 1L;
            TierImpl currentTier = (TierImpl)currentActiveAnnot.getTier();
            int index = visibleTiers.indexOf(currentTier);
            if (index > -1 && index < visibleTiers.size() - 1) {
                for (int i = index; i < visibleTiers.size() - 1; ++i) {
                    TierImpl downTier = this.getNextNonEmptyTier(i + 1);
                    newActiveAnnot = downTier == null ? currentActiveAnnot : this.getClosestAnnotation(downTier, currentActiveAnnot);
                    if (newActiveAnnot == null) continue;
                    long newBeginTime = newActiveAnnot.getBeginTimeBoundary();
                    long newEndTime = newActiveAnnot.getEndTimeBoundary();
                    long beginTime = currentActiveAnnot.getBeginTimeBoundary();
                    long endTime = currentActiveAnnot.getEndTimeBoundary();
                    if (!(newBeginTime >= beginTime && newBeginTime <= endTime || newBeginTime <= beginTime && newBeginTime >= beginTime - 1000L || newBeginTime >= endTime && newBeginTime <= endTime + 1000L || newBeginTime <= beginTime && newEndTime >= endTime && (beginTime - 5000L > newBeginTime || endTime + 5000L > newEndTime) && newEndTime - newBeginTime < 10000L)) {
                        continue;
                    }
                    break;
                }
            } else if (index < 0) {
                TierImpl firstTier = this.getNextNonEmptyTier(0);
                newActiveAnnot = firstTier == null ? currentActiveAnnot : this.getAnnotationAtOrBefore(firstTier, refTime);
            } else if (index == visibleTiers.size() - 1) {
                newActiveAnnot = currentActiveAnnot;
            }
        } else {
            TierImpl firstTier;
            Tier activeTier = this.vm.getMultiTierControlPanel().getActiveTier();
            newActiveAnnot = activeTier != null ? this.getAnnotationAtOrBefore((TierImpl)activeTier, this.vm.getMasterMediaPlayer().getMediaTime()) : ((firstTier = this.getNextNonEmptyTier(0)) == null ? currentActiveAnnot : this.getAnnotationAtOrBefore(firstTier, this.vm.getMasterMediaPlayer().getMediaTime()));
        }
        Object[] args = new Object[]{newActiveAnnot};
        return args;
    }

    private TierImpl getNextNonEmptyTier(int fromIndex) {
        List<TierImpl> vis = null;
        if (this.vm.getMultiTierControlPanel() != null) {
            vis = this.vm.getMultiTierControlPanel().getVisibleTiers();
        }
        if (vis == null || vis.size() == 0) {
            return null;
        }
        if (fromIndex < 0 || fromIndex >= vis.size()) {
            return null;
        }
        for (int i = fromIndex; i < vis.size(); ++i) {
            if (vis.get(i).getNumberOfAnnotations() <= 0) continue;
            return vis.get(i);
        }
        return null;
    }

    private Annotation getAnnotationAtOrBefore(TierImpl tier, long time) {
        if (tier.getAnnotationAtTime(time) != null) {
            return tier.getAnnotationAtTime(time);
        }
        return tier.getAnnotationBefore(time);
    }

    private Annotation getClosestAnnotation(TierImpl tier, Annotation ann) {
        long beginTime = ann.getBeginTimeBoundary();
        long endTime = ann.getEndTimeBoundary();
        Annotation annBefore = tier.getAnnotationBefore(beginTime);
        Annotation annAfter = tier.getAnnotationAfter(beginTime);
        if (annAfter != null && annBefore != null) {
            if (annBefore.getEndTimeBoundary() > beginTime && annBefore.getEndTimeBoundary() < endTime) {
                return annBefore;
            }
            if (annAfter.getBeginTimeBoundary() > beginTime && annAfter.getBeginTimeBoundary() < endTime) {
                return annAfter;
            }
            if (beginTime - annBefore.getEndTimeBoundary() > annAfter.getBeginTimeBoundary() - endTime) {
                return annAfter;
            }
            return annBefore;
        }
        if (annAfter != null) {
            return annAfter;
        }
        if (annBefore != null) {
            return annBefore;
        }
        return null;
    }
}

