/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.util.TimeFormatter;

public class AnnotationsFromOverlapsClasCommand
implements UndoableCommand {
    private ArrayList<ProgressListener> listeners;
    private String commandName;
    private TranscriptionImpl transcription;
    private TierImpl sourceTier1;
    private TierImpl sourceTier2;
    private TierImpl destTier;
    private boolean addContent = false;
    private int timeFormat = 0;
    private boolean matchingValuesOnly = false;
    private boolean specificValueOnly = false;
    private String specificValue;
    private ArrayList<long[]> overlaps;
    private ArrayList<String> overlapValues;
    private ArrayList<AnnotationDataRecord> annRecords;

    public AnnotationsFromOverlapsClasCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        LinguisticType type;
        Integer tf;
        this.transcription = (TranscriptionImpl)receiver;
        String sourceName1 = (String)arguments[0];
        String sourceName2 = (String)arguments[1];
        Object destName = (String)arguments[2];
        String typeName = (String)arguments[3];
        Boolean ac = (Boolean)arguments[4];
        if (ac != null) {
            this.addContent = ac;
        }
        if ((tf = (Integer)arguments[5]) != null) {
            this.timeFormat = tf;
        }
        if (arguments.length > 5 && arguments[6] instanceof Boolean) {
            this.matchingValuesOnly = (Boolean)arguments[6];
            if (this.matchingValuesOnly && arguments.length > 7) {
                this.specificValueOnly = (Boolean)arguments[7];
                this.specificValue = (String)arguments[8];
                if (this.specificValue == null) {
                    this.specificValue = "";
                }
            }
        }
        this.sourceTier1 = this.transcription.getTierWithId(sourceName1);
        this.sourceTier2 = this.transcription.getTierWithId(sourceName2);
        if (this.sourceTier1 == null || this.sourceTier2 == null) {
            this.progressInterrupt("One of the sourcetiers could not be found");
            return;
        }
        if (destName == null) {
            destName = "Overlap";
            ClientLogger.LOG.warning("Name of destination tier is null, changed to Overlap");
        }
        this.destTier = this.transcription.getTierWithId((String)destName);
        if (this.destTier != null) {
            int count = 1;
            String cName = (String)destName + "-";
            while (this.destTier != null) {
                cName = cName + count;
                this.destTier = this.transcription.getTierWithId(cName);
                ++count;
            }
            ClientLogger.LOG.warning("Tier " + (String)destName + " already exists, changed name to " + cName);
            destName = cName;
        }
        if ((type = this.transcription.getLinguisticTypeByName(typeName)) == null) {
            for (int i = 0; i < this.transcription.getLinguisticTypes().size(); ++i) {
                LinguisticType countType = this.transcription.getLinguisticTypes().get(i);
                if (countType.getConstraints() != null) continue;
                ClientLogger.LOG.warning("LinguisticType " + typeName + " could not be found, using " + countType.getLinguisticTypeName() + " instead.");
                type = countType;
                typeName = type.getLinguisticTypeName();
                break;
            }
        }
        this.destTier = new TierImpl(null, (String)destName, null, this.transcription, type);
        this.transcription.addTier(this.destTier);
        this.overlaps = new ArrayList();
        this.overlapValues = new ArrayList();
        this.progressUpdate(8, "Created tier: " + (String)destName);
        CalcOverLapsThread calcThread = new CalcOverLapsThread(AnnotationsFromOverlapsClasCommand.class.getName());
        try {
            calcThread.start();
        }
        catch (Exception exc) {
            this.transcription.setNotifying(true);
            ClientLogger.LOG.severe("Exception in calculation of overlaps: " + exc.getMessage());
            this.progressInterrupt("An exception occurred: " + exc.getMessage());
        }
    }

    @Override
    public void undo() {
        if (this.transcription != null && this.destTier != null) {
            this.setWaitCursor(true);
            this.transcription.removeTier(this.destTier);
            this.setWaitCursor(false);
        }
    }

    @Override
    public void redo() {
        if (this.transcription != null && this.destTier != null) {
            int curPropMode = 0;
            curPropMode = this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                this.transcription.setTimeChangePropagationMode(0);
            }
            this.setWaitCursor(true);
            if (this.transcription.getTierWithId(this.destTier.getName()) == null) {
                this.transcription.addTier(this.destTier);
            }
            if (this.annRecords != null && this.annRecords.size() > 0) {
                this.transcription.setNotifying(false);
                for (int i = 0; i < this.annRecords.size(); ++i) {
                    AnnotationDataRecord record = this.annRecords.get(i);
                    Annotation ann = this.destTier.createAnnotation(record.getBeginTime(), record.getEndTime());
                    if (ann == null || record.getValue() == null) continue;
                    ann.setValue(record.getValue());
                }
                this.transcription.setNotifying(true);
            }
            this.setWaitCursor(false);
            this.transcription.setTimeChangePropagationMode(curPropMode);
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    public synchronized void addProgressListener(ProgressListener pl) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(pl);
    }

    public synchronized void removeProgressListener(ProgressListener pl) {
        if (pl != null && this.listeners != null) {
            this.listeners.remove(pl);
        }
    }

    private void progressUpdate(int percent, String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressUpdated(this, percent, message);
            }
        }
    }

    private void progressComplete(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressCompleted(this, message);
            }
        }
    }

    private void progressInterrupt(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressInterrupted(this, message);
            }
        }
    }

    private class CalcOverLapsThread
    extends Thread {
        public CalcOverLapsThread() {
        }

        public CalcOverLapsThread(String name) {
            super(name);
        }

        @Override
        public void interrupt() {
            super.interrupt();
            AnnotationsFromOverlapsClasCommand.this.progressInterrupt("Operation interrupted...");
        }

        @Override
        public void run() {
            AnnotationsFromOverlapsClasCommand.this.transcription.setNotifying(false);
            int curPropMode = 0;
            curPropMode = AnnotationsFromOverlapsClasCommand.this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                AnnotationsFromOverlapsClasCommand.this.transcription.setTimeChangePropagationMode(0);
            }
            int annCount = AnnotationsFromOverlapsClasCommand.this.sourceTier1.getNumberOfAnnotations();
            float perAnn = 60.0f;
            if (annCount > 0) {
                perAnn = 60.0f / (float)annCount;
            }
            int j = 0;
            ArrayList<AbstractAnnotation> sourceAnns1 = new ArrayList<AbstractAnnotation>(AnnotationsFromOverlapsClasCommand.this.sourceTier1.getAnnotations());
            int numAnns1 = sourceAnns1.size();
            ArrayList<AbstractAnnotation> sourceAnns2 = new ArrayList<AbstractAnnotation>(AnnotationsFromOverlapsClasCommand.this.sourceTier2.getAnnotations());
            int numAnns2 = sourceAnns2.size();
            AbstractAnnotation ann1 = null;
            AbstractAnnotation ann2 = null;
            AnnotationsFromOverlapsClasCommand.this.progressUpdate(10, "Calculating overlaps...");
            for (int i = 0; i < numAnns1; ++i) {
                ann1 = sourceAnns1.get(i);
                long bt1 = ann1.getBeginTimeBoundary();
                long et1 = ann1.getEndTimeBoundary();
                while (j < numAnns2) {
                    ann2 = sourceAnns2.get(j);
                    long bt2 = ann2.getBeginTimeBoundary();
                    long et2 = ann2.getEndTimeBoundary();
                    if (et2 > bt1) {
                        if (bt2 >= et1) {
                            if (j <= 0) break;
                            --j;
                            break;
                        }
                        long obt = bt1 <= bt2 ? bt2 : bt1;
                        long oet = et1 <= et2 ? et1 : et2;
                        if (AnnotationsFromOverlapsClasCommand.this.matchingValuesOnly) {
                            if (!AnnotationsFromOverlapsClasCommand.this.specificValueOnly) {
                                if (ann1.getValue() == null && ann2.getValue() == null || ann1.getValue() != null && ann2.getValue() != null && ann1.getValue().length() == 0 && ann2.getValue().length() == 0 || ann1.getValue().equals(ann2.getValue())) {
                                    AnnotationsFromOverlapsClasCommand.this.overlaps.add(new long[]{obt, oet});
                                    if (!AnnotationsFromOverlapsClasCommand.this.addContent) {
                                        AnnotationsFromOverlapsClasCommand.this.overlapValues.add(ann1.getValue());
                                    }
                                }
                            } else if (ann1.getValue() != null && ann2.getValue() != null && ann1.getValue().equals(AnnotationsFromOverlapsClasCommand.this.specificValue) && ann2.getValue().equals(AnnotationsFromOverlapsClasCommand.this.specificValue)) {
                                AnnotationsFromOverlapsClasCommand.this.overlaps.add(new long[]{obt, oet});
                                if (!AnnotationsFromOverlapsClasCommand.this.addContent) {
                                    AnnotationsFromOverlapsClasCommand.this.overlapValues.add(AnnotationsFromOverlapsClasCommand.this.specificValue);
                                }
                            }
                        } else {
                            AnnotationsFromOverlapsClasCommand.this.overlaps.add(new long[]{obt, oet});
                            if (!AnnotationsFromOverlapsClasCommand.this.addContent) {
                                AnnotationsFromOverlapsClasCommand.this.overlapValues.add(ann1.getValue() + " " + ann2.getValue());
                            }
                        }
                    }
                    ++j;
                }
                AnnotationsFromOverlapsClasCommand.this.progressUpdate((int)(10.0f + (float)i * perAnn), null);
            }
            perAnn = 25.0f;
            if (AnnotationsFromOverlapsClasCommand.this.overlaps.size() > 0) {
                perAnn = 25.0f / (float)AnnotationsFromOverlapsClasCommand.this.overlaps.size();
            }
            AnnotationsFromOverlapsClasCommand.this.annRecords = new ArrayList(AnnotationsFromOverlapsClasCommand.this.overlaps.size());
            AnnotationsFromOverlapsClasCommand.this.progressUpdate(70, "Creating annotations...");
            for (int i = 0; i < AnnotationsFromOverlapsClasCommand.this.overlaps.size(); ++i) {
                long[] ol = (long[])AnnotationsFromOverlapsClasCommand.this.overlaps.get(i);
                Annotation ann = AnnotationsFromOverlapsClasCommand.this.destTier.createAnnotation(ol[0], ol[1]);
                if (ann != null && AnnotationsFromOverlapsClasCommand.this.addContent) {
                    switch (AnnotationsFromOverlapsClasCommand.this.timeFormat) {
                        case 102: {
                            ann.setValue(String.valueOf(ol[1] - ol[0]));
                            break;
                        }
                        case 101: {
                            ann.setValue(TimeFormatter.toSSMSString(ol[1] - ol[0]));
                            break;
                        }
                        case 100: {
                            ann.setValue(TimeFormatter.toString(ol[1] - ol[0]));
                        }
                    }
                } else if (ann != null && !AnnotationsFromOverlapsClasCommand.this.addContent && i < AnnotationsFromOverlapsClasCommand.this.overlapValues.size()) {
                    ann.setValue((String)AnnotationsFromOverlapsClasCommand.this.overlapValues.get(i));
                }
                if (ann != null) {
                    AnnotationsFromOverlapsClasCommand.this.annRecords.add(new AnnotationDataRecord(ann));
                }
                AnnotationsFromOverlapsClasCommand.this.progressUpdate((int)(70.0f + (float)i * perAnn), null);
            }
            AnnotationsFromOverlapsClasCommand.this.transcription.setTimeChangePropagationMode(curPropMode);
            AnnotationsFromOverlapsClasCommand.this.transcription.setNotifying(true);
            AnnotationsFromOverlapsClasCommand.this.progressComplete("Operation complete...");
        }
    }
}

