/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.util.Pair;
import nl.mpi.lexan.analyzers.helpers.Position;
import nl.mpi.lexan.analyzers.helpers.Suggestion;
import nl.mpi.lexan.analyzers.helpers.SuggestionSet;

public class AnnotationsFromSuggestionSetCommand
implements UndoableCommand {
    private String name;
    private TranscriptionImpl transcription;
    private Object[] arguments;
    private List<DefaultMutableTreeNode> deletedForUndo;
    private List<DefaultMutableTreeNode> modifiedForUndo;
    private List<Annotation> createdForUndo;
    private List<Annotation> createdForRecursion;

    public AnnotationsFromSuggestionSetCommand(String name) {
        this.name = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        Suggestion first;
        Position pos;
        TierImpl topChTier;
        this.transcription = (TranscriptionImpl)receiver;
        this.arguments = arguments;
        SuggestionSet sugSet = (SuggestionSet)arguments[0];
        boolean recursive = arguments.length >= 2 ? (Boolean)arguments[1] : false;
        List topSugs = sugSet.getSuggestions();
        if (topSugs != null && !topSugs.isEmpty() && (topChTier = this.transcription.getTierWithId((pos = (first = (Suggestion)topSugs.get(0)).getPosition()).getTierId())) != null) {
            TierImpl topParent = topChTier.getParentTier();
            if (topParent != null) {
                List<Annotation> children;
                AbstractAnnotation aaPar = (AbstractAnnotation)topParent.getAnnotationAtTime((pos.getBeginTime() + pos.getEndTime()) / 2L);
                if (aaPar != null && (children = aaPar.getChildrenOnTier(topChTier)).size() > 0) {
                    this.deletedForUndo = new ArrayList<DefaultMutableTreeNode>();
                    for (int i = 0; i < children.size(); ++i) {
                        Annotation aa = children.get(i);
                        this.deletedForUndo.add(AnnotationRecreator.createTreeForAnnotation((AbstractAnnotation)aa));
                        topChTier.removeAnnotation(aa);
                    }
                }
            } else {
                List<Annotation> overlapAnnList = topChTier.getOverlappingAnnotations(pos.getBeginTime(), pos.getEndTime());
                if (!overlapAnnList.isEmpty()) {
                    this.deletedForUndo = new ArrayList<DefaultMutableTreeNode>();
                    this.modifiedForUndo = new ArrayList<DefaultMutableTreeNode>();
                    for (int i = 0; i < overlapAnnList.size(); ++i) {
                        AbstractAnnotation aa = (AbstractAnnotation)overlapAnnList.get(i);
                        if (aa.getBeginTimeBoundary() < pos.getBeginTime()) {
                            this.modifiedForUndo.add(AnnotationRecreator.createTreeForAnnotation(aa));
                            continue;
                        }
                        if (aa.getEndTimeBoundary() > pos.getEndTime()) {
                            this.modifiedForUndo.add(AnnotationRecreator.createTreeForAnnotation(aa));
                            continue;
                        }
                        this.deletedForUndo.add(AnnotationRecreator.createTreeForAnnotation(aa));
                        topChTier.removeAnnotation(aa);
                    }
                }
            }
            Suggestion topSug = new Suggestion(sugSet.getSuggestions());
            ArrayList<Pair<Suggestion, AbstractAnnotation>> list = new ArrayList<Pair<Suggestion, AbstractAnnotation>>(1);
            list.add(Pair.makePair(topSug, null));
            this.createdForUndo = new ArrayList<Annotation>();
            if (recursive) {
                this.createdForRecursion = new ArrayList<Annotation>();
            }
            this.createAnnotationsForSuggestions(list);
        }
    }

    private void createAnnotationsForSuggestions(List<Pair<Suggestion, AbstractAnnotation>> sugAnnList) {
        if (sugAnnList.isEmpty()) {
            return;
        }
        for (Pair<Suggestion, AbstractAnnotation> entry : sugAnnList) {
            Map<String, List<Suggestion>> groupedChildren;
            Suggestion nextSuggestion = entry.getFirst();
            List children = nextSuggestion.getChildren();
            if (children == null || children.isEmpty() || (groupedChildren = this.groupPerTier(children)) == null) continue;
            AbstractAnnotation parAnn = entry.getSecond();
            for (Map.Entry<String, List<Suggestion>> childEntry : groupedChildren.entrySet()) {
                String tierName = childEntry.getKey();
                List<Suggestion> sugsPerTier = childEntry.getValue();
                TierImpl t = this.transcription.getTierWithId(tierName);
                if (t == null) continue;
                LinguisticType lt = t.getLinguisticType();
                Constraint con = lt.getConstraints();
                int numSugs = sugsPerTier.size();
                long bt = -1L;
                long et = -1L;
                if (parAnn != null) {
                    bt = parAnn.getBeginTimeBoundary();
                    et = parAnn.getEndTimeBoundary();
                } else {
                    bt = sugsPerTier.get(0).getPosition().getBeginTime();
                    et = sugsPerTier.get(numSugs - 1).getPosition().getEndTime();
                }
                long perAnn = (et - bt) / (long)numSugs;
                AbstractAnnotation prevAnn = null;
                ArrayList<Pair<Suggestion, AbstractAnnotation>> createdAnns = new ArrayList<Pair<Suggestion, AbstractAnnotation>>(3);
                for (int i = 0; i < numSugs; ++i) {
                    long mid;
                    boolean rememberForUndo;
                    Suggestion curSug = sugsPerTier.get(i);
                    AbstractAnnotation curAnn = null;
                    boolean bl = rememberForUndo = parAnn == null;
                    if (con == null || con.getStereoType() == 1) {
                        curAnn = (AbstractAnnotation)t.createAnnotation(bt + (long)i * perAnn, bt + (long)(i + 1) * perAnn);
                    } else if (con.getStereoType() == 0) {
                        curAnn = prevAnn != null ? (AbstractAnnotation)t.createAnnotationAfter(prevAnn) : (AbstractAnnotation)t.createAnnotation(bt + (long)i * perAnn, bt + (long)(i + 1) * perAnn);
                    } else if (con.getStereoType() == 3) {
                        if (prevAnn != null) {
                            curAnn = (AbstractAnnotation)t.createAnnotationAfter(prevAnn);
                        } else {
                            mid = (bt + et) / 2L;
                            curAnn = (AbstractAnnotation)t.createAnnotation(mid, mid);
                            if (curAnn == null) {
                                AbstractAnnotation existing = (AbstractAnnotation)t.getAnnotationAtTime(bt);
                                boolean removeForUndo = true;
                                if (existing != null) {
                                    List<Annotation> overlap = t.getOverlappingAnnotations(bt, et);
                                    for (Annotation toRemove : overlap) {
                                        this.deletedForUndo.add(AnnotationRecreator.createTreeForAnnotation((AbstractAnnotation)toRemove));
                                        t.removeAnnotation(toRemove);
                                    }
                                    curAnn = (AbstractAnnotation)t.createAnnotation(mid, mid);
                                    rememberForUndo = curAnn != null;
                                }
                            }
                        }
                    } else if (con.getStereoType() == 4 && prevAnn == null) {
                        mid = (bt + et) / 2L;
                        curAnn = (AbstractAnnotation)t.createAnnotation(mid, mid);
                    }
                    if (curAnn != null) {
                        curAnn.setValue(curSug.getContent());
                        if (curSug.getChildren() != null && !curSug.getChildren().isEmpty()) {
                            createdAnns.add(Pair.makePair(curSug, curAnn));
                        }
                        if (rememberForUndo) {
                            this.createdForUndo.add(curAnn);
                        }
                        if (this.createdForRecursion != null) {
                            this.createdForRecursion.add(curAnn);
                        }
                    }
                    prevAnn = curAnn;
                }
                this.createAnnotationsForSuggestions(createdAnns);
            }
        }
    }

    private Map<String, List<Suggestion>> groupPerTier(List<Suggestion> suggestions) {
        if (suggestions == null || suggestions.size() == 0) {
            return null;
        }
        HashMap<String, List<Suggestion>> groupedSugs = new HashMap<String, List<Suggestion>>(6);
        for (Suggestion sug : suggestions) {
            String tierId = sug.getPosition().getTierId();
            if (groupedSugs.containsKey(tierId)) {
                ((List)groupedSugs.get(tierId)).add(sug);
                continue;
            }
            ArrayList<Suggestion> sugGroup = new ArrayList<Suggestion>(6);
            sugGroup.add(sug);
            groupedSugs.put(tierId, sugGroup);
        }
        return groupedSugs;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void undo() {
        if (this.createdForUndo != null) {
            for (Annotation ann : this.createdForUndo) {
                Tier tier = ann.getTier();
                tier.removeAnnotation(ann);
            }
        }
        int mode = this.transcription.getTimeChangePropagationMode();
        this.transcription.setTimeChangePropagationMode(0);
        if (this.deletedForUndo != null && this.deletedForUndo.size() > 0) {
            DefaultMutableTreeNode node = this.deletedForUndo.get(0);
            AnnotationDataRecord adr = (AnnotationDataRecord)node.getUserObject();
            TierImpl t = this.transcription.getTierWithId(adr.getTierName());
            LinguisticType lt = t.getLinguisticType();
            if (lt.getConstraints().getStereoType() == 3) {
                for (int i = this.deletedForUndo.size() - 1; i >= 0; --i) {
                    AnnotationRecreator.createAnnotationFromTree(this.transcription, this.deletedForUndo.get(i), true);
                }
            } else {
                for (DefaultMutableTreeNode tree : this.deletedForUndo) {
                    AnnotationRecreator.createAnnotationFromTree(this.transcription, tree, true);
                }
            }
        }
        if (this.modifiedForUndo != null && !this.modifiedForUndo.isEmpty()) {
            for (DefaultMutableTreeNode tree : this.modifiedForUndo) {
                AnnotationRecreator.createAnnotationFromTree(this.transcription, tree, true);
            }
        }
        this.transcription.setTimeChangePropagationMode(mode);
    }

    @Override
    public void redo() {
        this.execute(this.transcription, this.arguments);
    }

    public List<? extends Annotation> getCreatedAnnotations() {
        return this.createdForRecursion;
    }
}

