/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class ChangeTierAttributesCommand
implements UndoableCommand {
    private String commandName;
    private String oldTierName;
    private String oldParticipant;
    private String oldAnnotator;
    private Locale oldLocale;
    private LinguisticType oldLingType;
    private TierImpl oldParentTier;
    private String oldLangRef;
    private String tierName;
    private TierImpl parentTier;
    private String lingTypeName;
    private LinguisticType lingType;
    private String participant;
    private String annotator;
    private Locale locale;
    private String langRef;
    private TierImpl tier;
    private TranscriptionImpl transcription;

    public ChangeTierAttributesCommand(String theName) {
        this.commandName = theName;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.tier = (TierImpl)receiver;
        this.transcription = this.tier.getTranscription();
        this.tierName = (String)arguments[0];
        this.parentTier = (TierImpl)arguments[1];
        this.lingTypeName = (String)arguments[2];
        this.participant = (String)arguments[3];
        this.annotator = (String)arguments[4];
        this.locale = (Locale)arguments[5];
        this.langRef = (String)arguments[6];
        if (this.tier != null) {
            this.setWaitCursor(true);
            try {
                this.oldTierName = this.tier.getName();
                this.oldParticipant = this.tier.getParticipant();
                this.oldLocale = this.tier.getDefaultLocale();
                this.oldLingType = this.tier.getLinguisticType();
                this.oldParentTier = this.tier.getParentTier();
                this.oldAnnotator = this.tier.getAnnotator();
                this.oldLangRef = this.tier.getLangRef();
                if (!this.tierName.equals(this.oldTierName)) {
                    this.tier.setName(this.tierName);
                }
                if (this.parentTier != this.oldParentTier) {
                    this.tier.setParentTier(this.parentTier);
                }
                if (!this.participant.equals(this.oldParticipant)) {
                    this.tier.setParticipant(this.participant);
                }
                if (!this.annotator.equals(this.oldAnnotator)) {
                    this.tier.setAnnotator(this.annotator);
                }
                if (this.locale == null || this.locale != this.oldLocale) {
                    this.tier.setDefaultLocale(this.locale);
                }
                if (this.oldLingType == null || this.lingTypeName != this.oldLingType.getLinguisticTypeName()) {
                    List<LinguisticType> types = this.tier.getTranscription().getLinguisticTypes();
                    LinguisticType t2 = null;
                    for (LinguisticType t2 : types) {
                        if (t2.getLinguisticTypeName().equals(this.lingTypeName)) break;
                    }
                    if (t2 != null) {
                        this.lingType = t2;
                        this.tier.setLinguisticType(this.lingType);
                    }
                }
                if (!this.tierName.equals(this.oldTierName)) {
                    this.updatePreferences(this.oldTierName, this.tierName);
                }
                if (this.langRef != null && !this.langRef.equals(this.oldLangRef)) {
                    this.tier.setLangRef(this.langRef);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.setWaitCursor(false);
            }
            this.setWaitCursor(false);
        }
    }

    @Override
    public void undo() {
        if (this.tier != null) {
            try {
                if (this.tierName != null && !this.tierName.equals(this.oldTierName)) {
                    this.tier.setName(this.oldTierName);
                }
                if (this.parentTier != this.oldParentTier) {
                    this.tier.setParentTier(this.oldParentTier);
                }
                this.tier.setLinguisticType(this.oldLingType);
                if (this.participant != null && !this.participant.equals(this.oldParticipant)) {
                    this.tier.setParticipant(this.oldParticipant);
                }
                if (this.annotator != null && !this.annotator.equals(this.oldAnnotator)) {
                    this.tier.setAnnotator(this.oldAnnotator);
                }
                if (this.locale != this.oldLocale) {
                    this.tier.setDefaultLocale(this.oldLocale);
                }
                if (!this.tierName.equals(this.oldTierName)) {
                    this.updatePreferences(this.tierName, this.oldTierName);
                }
                if (this.langRef != null && !this.langRef.equals(this.oldLangRef)) {
                    this.tier.setLangRef(this.oldLangRef);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.setWaitCursor(false);
            }
        }
    }

    @Override
    public void redo() {
        if (this.tier != null) {
            this.setWaitCursor(true);
            try {
                if (this.tierName != null && !this.tierName.equals(this.oldTierName)) {
                    this.tier.setName(this.tierName);
                }
                if (this.parentTier != this.oldParentTier) {
                    this.tier.setParentTier(this.parentTier);
                }
                if (this.lingType != null) {
                    this.tier.setLinguisticType(this.lingType);
                }
                if (this.participant != null && !this.participant.equals(this.oldParticipant)) {
                    this.tier.setParticipant(this.participant);
                }
                if (!this.annotator.equals(this.oldAnnotator)) {
                    this.tier.setAnnotator(this.annotator);
                }
                if (this.locale != this.oldLocale) {
                    this.tier.setDefaultLocale(this.locale);
                }
                if (!this.tierName.equals(this.oldTierName)) {
                    this.updatePreferences(this.oldTierName, this.tierName);
                }
                if (this.langRef != null && !this.langRef.equals(this.oldLangRef)) {
                    this.tier.setLangRef(this.langRef);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.setWaitCursor(false);
            }
            this.setWaitCursor(false);
        }
    }

    private void updatePreferences(String oldTierName, String tierName) {
        Map<String, Font> fontsMap;
        Map<String, Color> colorMap = Preferences.getMapOfColor("TierColors", this.transcription);
        if (colorMap != null && colorMap.containsKey(oldTierName)) {
            Color col = colorMap.remove(oldTierName);
            colorMap.put(tierName, col);
            Preferences.set("TierColors", colorMap, this.transcription, true);
        }
        if ((fontsMap = Preferences.getMapOfFont("TierFonts", this.transcription)) != null && fontsMap.containsKey(oldTierName)) {
            Font font = fontsMap.remove(oldTierName);
            fontsMap.put(tierName, font);
            Preferences.set("TierFonts", fontsMap, this.transcription, true);
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }
}

