/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.UnsupportedCharsetException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import mpi.eudico.client.annotator.commands.AbstractCompareCommand;
import mpi.eudico.client.annotator.interannotator.AnnotatorCompareUtil2;
import mpi.eudico.client.annotator.interannotator.CompareCombi;
import mpi.eudico.client.annotator.interannotator.CompareConstants;
import mpi.eudico.client.annotator.interannotator.modkappa.AgreementTable;
import mpi.eudico.client.annotator.interannotator.modkappa.CKappa;
import mpi.eudico.client.annotator.interannotator.modkappa.GlobalCKappa;
import mpi.eudico.client.annotator.interannotator.modkappa.KappaCompareCombi;
import mpi.eudico.client.annotator.interannotator.modkappa.TwoSquareTable;
import mpi.eudico.server.corpora.clom.AnnotationCore;

public class CompareAnnotationModKappaCommand
extends AbstractCompareCommand {
    List<KappaCompareCombi> modCompareCombis;
    private Map<String, KappaCompareCombi> tierCombisGlobal;
    private KappaCompareCombi globalCombi;
    private double minimalOverlapPercentage = 0.6;
    private boolean perTierPairOutput;
    private final String NAN = "NaN";
    private final String EMPTY = "\"empty\"";
    private final String ZERO = "0";
    private final String NL = "\n";
    private final String NL2 = "\n\n";
    private final String TAB = "\t";
    private final DecimalFormat decFormat = new DecimalFormat("#0.0000", new DecimalFormatSymbols(Locale.US));

    public CompareAnnotationModKappaCommand(String theName) {
        super(theName);
    }

    @Override
    public List<CompareCombi> getCompareSegments() {
        if (this.modCompareCombis != null) {
            return new ArrayList<CompareCombi>(this.modCompareCombis);
        }
        return super.getCompareSegments();
    }

    @Override
    protected void calculateAgreement() {
        if (this.compareSegments.size() == 0) {
            this.logErrorAndInterrupt("There are no tier pairs, nothing to calculate.");
            return;
        }
        Object prefOPObject = this.compareProperties.get("Compare.OverlapPercentage");
        if (prefOPObject instanceof Double) {
            this.minimalOverlapPercentage = (Double)prefOPObject;
        } else if (prefOPObject instanceof Integer) {
            this.minimalOverlapPercentage = (double)((Integer)prefOPObject).intValue() / 100.0;
        }
        this.perTierPairOutput = false;
        Object prefPerTPObject = this.compareProperties.get("Compare.Output.PerTierPair");
        if (prefPerTPObject instanceof Boolean) {
            this.perTierPairOutput = (Boolean)prefPerTPObject;
        }
        this.modCompareCombis = new ArrayList<KappaCompareCombi>();
        float perCombi = 50.0f / (float)this.compareSegments.size();
        AnnotatorCompareUtil2 compareUtil = new AnnotatorCompareUtil2();
        this.progressUpdate((int)this.curProgress, "Building agreement tables, per file...");
        for (CompareCombi cc : this.compareSegments) {
            Map<AnnotationCore, AnnotationCore> curMatchedAnnotations = compareUtil.matchAnnotations(cc, this.minimalOverlapPercentage);
            KappaCompareCombi curKappaCC = this.calculateOverallMatrix(cc, curMatchedAnnotations);
            curKappaCC.doubleMatchedValues();
            this.calculatePerValueAgreementTables(curKappaCC);
            this.modCompareCombis.add(curKappaCC);
            this.curProgress += perCombi;
            this.progressUpdate((int)this.curProgress, null);
        }
        this.progressUpdate((int)this.curProgress, "Starting global agreement calculations...");
        TreeSet<String> allValuesGlobal = new TreeSet<String>();
        TreeMap<Object, TreeSet<String>> perTierCombiValuesGlobal = new TreeMap<Object, TreeSet<String>>();
        for (KappaCompareCombi kcc : this.modCompareCombis) {
            allValuesGlobal.addAll(kcc.getAllValues());
            String tierCombi = kcc.getFirstUnit().tierName + ":" + kcc.getSecondUnit().tierName;
            TreeSet<String> combiValues = (TreeSet<String>)perTierCombiValuesGlobal.get(tierCombi);
            if (combiValues == null) {
                combiValues = new TreeSet<String>();
                perTierCombiValuesGlobal.put(tierCombi, combiValues);
            }
            combiValues.addAll(kcc.getAllValues());
        }
        ArrayList<String> globalValuesList = new ArrayList<String>(allValuesGlobal);
        if (globalValuesList.remove("Unmatched")) {
            globalValuesList.add("Unmatched");
        }
        AgreementTable globalTable = new AgreementTable("Multi file global", globalValuesList);
        for (KappaCompareCombi kcc : this.modCompareCombis) {
            this.mergeGlobalAgreementTables(globalTable, kcc.getOverallTable());
        }
        CKappa ckappa = new CKappa();
        this.globalCombi = new KappaCompareCombi(null, null);
        this.globalCombi.setAllValues(globalValuesList);
        this.globalCombi.setOverallTable(globalTable);
        this.calculatePerValueAgreementTables(this.globalCombi);
        Map<String, TwoSquareTable> globalPerValueTables = this.globalCombi.getPerValueTables();
        for (String keyIter : globalPerValueTables.keySet()) {
            TwoSquareTable iterTable = globalPerValueTables.get(keyIter);
            this.globalCombi.getPerValueAgreement().put(keyIter, ckappa.calcKappa(iterTable.getTable()));
        }
        if (this.perTierPairOutput) {
            this.tierCombisGlobal = new TreeMap<String, KappaCompareCombi>();
            TreeMap<Object, AgreementTable> perTierAgreeTableGlobal = new TreeMap<Object, AgreementTable>();
            for (Object key : perTierCombiValuesGlobal.keySet()) {
                ArrayList<String> valList = new ArrayList<String>((Collection)perTierCombiValuesGlobal.get(key));
                if (valList.remove("Unmatched")) {
                    valList.add("Unmatched");
                }
                perTierAgreeTableGlobal.put(key, new AgreementTable((String)key, valList));
            }
            for (KappaCompareCombi kcc : this.modCompareCombis) {
                String tierCombi = kcc.getFirstUnit().tierName + ":" + kcc.getSecondUnit().tierName;
                AgreementTable at = (AgreementTable)perTierAgreeTableGlobal.get(tierCombi);
                this.mergeGlobalAgreementTables(at, kcc.getOverallTable());
            }
            for (String key : perTierAgreeTableGlobal.keySet()) {
                AgreementTable at = (AgreementTable)perTierAgreeTableGlobal.get(key);
                KappaCompareCombi perTierKCCombi = new KappaCompareCombi(null, null);
                perTierKCCombi.setAllValues(at.getLabels());
                perTierKCCombi.setOverallTable(at);
                this.calculatePerValueAgreementTables(perTierKCCombi);
                Map<String, TwoSquareTable> perTierPerValueTables = perTierKCCombi.getPerValueTables();
                for (String keyIter : perTierPerValueTables.keySet()) {
                    TwoSquareTable iterTable = perTierPerValueTables.get(keyIter);
                    perTierKCCombi.getPerValueAgreement().put(keyIter, ckappa.calcKappa(iterTable.getTable()));
                }
                this.tierCombisGlobal.put(key, perTierKCCombi);
            }
        }
        this.progressComplete(String.format("Completed calculations of %d pairs of tiers.", this.modCompareCombis.size()));
    }

    @Override
    public void writeResultsAsText(File toFile, String encoding) throws IOException {
        if (this.globalCombi == null || this.globalCombi.getAllValues().isEmpty()) {
            throw new IOException("There are no results to save.");
        }
        if (toFile == null) {
            throw new IOException("There is no file location specified.");
        }
        BufferedWriter writer = null;
        try {
            FileOutputStream out = new FileOutputStream(toFile);
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter((OutputStream)out, encoding);
            }
            catch (UnsupportedCharsetException uce) {
                osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
            }
            writer = new BufferedWriter(osw);
            writer.write(String.format("Output created: %tD %<tT", Calendar.getInstance()));
            writer.write("\n\n");
            writer.write(String.format("%s\t: a kappa value of \"%s\" usually indicates a division by zero", "NaN", "NaN"));
            writer.write("\n");
            writer.write("0\t: a kappa value of \"0\" replaces a value < 0 (negative kappa), as opposed to the value \"0.000\"");
            writer.write("\n\n");
            writer.write("Number of files involved: ");
            if (this.transcription != null && this.compareProperties.get("Compare.TierSource") == CompareConstants.FILE_MATCHING.CURRENT_DOC) {
                writer.write("1 (current transcription)");
            } else {
                writer.write(String.valueOf(this.numFiles));
            }
            writer.write("\n");
            writer.write("Number of selected tiers: " + this.numSelTiers);
            writer.write("\n");
            writer.write("Number of pairs of tiers in the comparison: " + this.modCompareCombis.size());
            writer.write("\n");
            writer.write("Required minimal overlap percentage: " + String.valueOf(Math.round(this.minimalOverlapPercentage * 100.0)) + "%");
            writer.write("\n\n");
            writer.write("Global results of all files and all tiers:");
            writer.write("\n");
            this.writeValuesTable(writer, this.globalCombi);
            writer.write("\n");
            writer.write("Global kappa values and agreement matrix:");
            writer.write("\n");
            this.writeAgreementMatrix(writer, this.globalCombi.getOverallTable());
            writer.write("\n\n");
            writer.flush();
            writer.write("Global per value agreement table:");
            writer.write("\n");
            for (String value : this.globalCombi.getAllValues()) {
                if (value.equals("Unmatched")) continue;
                writer.write(value.isEmpty() ? "\"empty\"" : value);
                writer.write("\n");
                TwoSquareTable tst = this.globalCombi.getAgreementTable(value);
                if (tst != null) {
                    writer.write(String.valueOf(tst.getTable()[0][0]));
                    writer.write("\t");
                    writer.write(String.valueOf(tst.getTable()[0][1]));
                    writer.write("\n");
                    writer.write(String.valueOf(tst.getTable()[1][0]));
                    writer.write("\t");
                    writer.write(String.valueOf(tst.getTable()[1][1]));
                    writer.write("\n");
                } else {
                    writer.write("-");
                }
                writer.write("\n");
                writer.flush();
            }
            if (this.perTierPairOutput) {
                this.writeGlobalPerTier(writer);
            }
            writer.write("End of global results.");
            writer.write("\n");
            writer.write("################################################");
            if (this.perTierPairOutput) {
                writer.write("\n\n");
                writer.write("Results per individual tier combination: kappa,\tkappa_max,\traw agreement");
                writer.write("\n");
                CKappa cKappa = new CKappa();
                for (KappaCompareCombi kcc : this.modCompareCombis) {
                    writer.write("File 1: " + kcc.getFirstUnit().fileName + " Tier 1: " + kcc.getFirstUnit().tierName);
                    writer.write("\n");
                    writer.write("File 2: " + kcc.getSecondUnit().fileName + " Tier 2: " + kcc.getSecondUnit().tierName);
                    writer.write("\n");
                    List<String> locLabels = kcc.getAllValues();
                    for (String value : locLabels) {
                        if (value.equals("Unmatched")) continue;
                        TwoSquareTable curTable = kcc.getAgreementTable(value);
                        writer.write(value.isEmpty() ? "\"empty\"" : value);
                        writer.write("\t");
                        double ck = cKappa.calcKappa(curTable.getTable());
                        writer.write(Double.isNaN(ck) ? "NaN" : (ck < 0.0 ? "0" : this.decFormat.format(ck)));
                        writer.write("\t");
                        double mk = cKappa.calcMaxKappa(curTable.getTable());
                        writer.write(Double.isNaN(mk) ? "NaN" : (mk < 0.0 ? "0" : this.decFormat.format(mk)));
                        writer.write("\t");
                        double ra = cKappa.calcRawAgreement(curTable.getTable());
                        writer.write(Double.isNaN(ra) ? "NaN" : (ra < 0.0 ? "0" : this.decFormat.format(ra)));
                        writer.write("\n");
                    }
                    writer.write("\n");
                }
            }
            writer.flush();
        }
        catch (Throwable tr) {
            throw new IOException("Cannot write to file: " + tr.getMessage());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable out) {}
            }
        }
    }

    private void writeGlobalPerTier(Writer writer) throws IOException {
        writer.write("======================================================");
        writer.write("\n");
        writer.write("Overall results per tier combination");
        writer.write("\n\n");
        for (String tierCombiName : this.tierCombisGlobal.keySet()) {
            KappaCompareCombi kcc = this.tierCombisGlobal.get(tierCombiName);
            writer.write("Tier combination: " + tierCombiName);
            writer.write("\n");
            writer.write("Per value:");
            writer.write("\n");
            this.writeValuesTable(writer, kcc);
            writer.write("\n");
            writer.write("Overall kappa values and agreement matrix:");
            writer.write("\n");
            this.writeAgreementMatrix(writer, kcc.getOverallTable());
            writer.write("------------------------------------------------------");
            writer.write("\n\n");
        }
        writer.flush();
    }

    private void writeValuesTable(Writer writer, KappaCompareCombi kcc) throws IOException {
        List<String> allValues = kcc.getAllValues();
        CKappa cKappa = new CKappa();
        writer.write("value");
        writer.write("\t");
        writer.write("kappa");
        writer.write("\t");
        writer.write("kappa_max");
        writer.write("\t");
        writer.write("raw agreement");
        writer.write("\n");
        for (String value : allValues) {
            if (value.equals("Unmatched")) continue;
            writer.write(value.isEmpty() ? "\"empty\"" : value);
            writer.write("\t");
            double ck = kcc.getAgreementForValue(value);
            writer.write(Double.isNaN(ck) ? "NaN" : (ck < 0.0 ? "0" : this.decFormat.format(ck)));
            TwoSquareTable curTst = kcc.getAgreementTable(value);
            writer.write("\t");
            double mk = cKappa.calcMaxKappa(curTst.getTable());
            writer.write(Double.isNaN(mk) ? "NaN" : (mk < 0.0 ? "0" : this.decFormat.format(mk)));
            writer.write("\t");
            double ra = cKappa.calcRawAgreement(curTst.getTable());
            writer.write(Double.isNaN(ra) ? "NaN" : (ra < 0.0 ? "0" : this.decFormat.format(ra)));
            writer.write("\n");
        }
    }

    private void writeAgreementMatrix(Writer writer, AgreementTable overallTable) throws IOException {
        String label;
        int i;
        GlobalCKappa gcKappa = new GlobalCKappa(overallTable.getTable(), true);
        writer.write("Overall results (incl. unlinked/unmatched annotations):");
        writer.write("\n");
        writer.write("kappa_ipf");
        writer.write("\t");
        writer.write("kappa_max");
        writer.write("\t");
        writer.write("raw agreement");
        writer.write("\n");
        writer.write(Double.isNaN(gcKappa.kappaAllIPF) ? "NaN" : (gcKappa.kappaAllIPF < 0.0 ? "0" : this.decFormat.format(gcKappa.kappaAllIPF)));
        writer.write("\t");
        writer.write(Double.isNaN(gcKappa.maxKappaAll) ? "NaN" : (gcKappa.maxKappaAll < 0.0 ? "0" : this.decFormat.format(gcKappa.maxKappaAll)));
        writer.write("\t");
        writer.write(Double.isNaN(gcKappa.rawAgreementAll) ? "NaN" : (gcKappa.rawAgreementAll < 0.0 ? "0" : this.decFormat.format(gcKappa.rawAgreementAll)));
        writer.write("\n\n");
        writer.write("Overall results (excl. unlinked/unmatched annotations):");
        writer.write("\n");
        if (overallTable.getLabels().size() > 2) {
            writer.write("kappa (excl.)");
            writer.write("\t");
            writer.write("kappa_max (excl.)");
            writer.write("\t");
            writer.write("raw agreement (excl.)");
            writer.write("\n");
            writer.write(Double.isNaN(gcKappa.kappaMatched) ? "NaN" : (gcKappa.kappaMatched < 0.0 ? "0" : this.decFormat.format(gcKappa.kappaMatched)));
            writer.write("\t");
            writer.write(Double.isNaN(gcKappa.maxKappaMatched) ? "NaN" : (gcKappa.maxKappaMatched < 0.0 ? "0" : this.decFormat.format(gcKappa.maxKappaMatched)));
            writer.write("\t");
            writer.write(Double.isNaN(gcKappa.rawAgreementMatched) ? "NaN" : (gcKappa.rawAgreementMatched < 0.0 ? "0" : this.decFormat.format(gcKappa.rawAgreementMatched)));
        } else {
            writer.write("\tNot available because there is only one value in the matrix apart from the Unmatched category");
        }
        writer.write("\n\n");
        writer.write("Overall Agreement Matrix:");
        writer.write("\n");
        writer.write("First annotator in the rows, second annotator in the columns");
        writer.write("\n\n");
        List<String> labels = overallTable.getLabels();
        writer.write("\t");
        for (i = 0; i < labels.size(); ++i) {
            label = labels.get(i);
            writer.write(label.isEmpty() ? "\"empty\"" : label);
            writer.write("\t");
        }
        writer.write("\n");
        for (i = 0; i < labels.size(); ++i) {
            label = labels.get(i);
            writer.write(label.isEmpty() ? "\"empty\"" : label);
            writer.write("\t");
            for (int j = 0; j < overallTable.getTable()[i].length; ++j) {
                writer.write(String.valueOf(overallTable.getTable()[i][j]));
                writer.write("\t");
            }
            writer.write("\n");
        }
    }

    private KappaCompareCombi calculateOverallMatrix(CompareCombi cc, Map<AnnotationCore, AnnotationCore> matchedAnnotations) {
        String s2;
        String s1;
        KappaCompareCombi curKappaCC = new KappaCompareCombi(cc.getFirstUnit(), cc.getSecondUnit());
        TreeSet<String> allValues = new TreeSet<String>();
        List<AnnotationCore> ac1List = cc.getFirstUnit().annotations;
        for (AnnotationCore annotationCore : ac1List) {
            allValues.add(annotationCore.getValue());
        }
        List<AnnotationCore> ac2List = cc.getSecondUnit().annotations;
        for (AnnotationCore ac : ac2List) {
            allValues.add(ac.getValue());
        }
        ArrayList<String> arrayList = new ArrayList<String>(allValues);
        arrayList.add("Unmatched");
        curKappaCC.setAllValues(arrayList);
        AgreementTable globalTable = new AgreementTable("File global", arrayList);
        if (matchedAnnotations != null) {
            for (AnnotationCore ac1 : matchedAnnotations.keySet()) {
                AnnotationCore ac2 = matchedAnnotations.get(ac1);
                s1 = ac1.getValue();
                if (s1.equals(s2 = ac2.getValue())) {
                    globalTable.increment(s1);
                    continue;
                }
                globalTable.increment(s1, s2);
            }
        }
        for (AnnotationCore aco : ac1List) {
            if (matchedAnnotations.containsKey(aco)) continue;
            s1 = aco.getValue();
            globalTable.increment(s1, "Unmatched");
        }
        for (AnnotationCore aco : ac2List) {
            if (matchedAnnotations.containsValue(aco)) continue;
            s2 = aco.getValue();
            globalTable.increment("Unmatched", s2);
        }
        curKappaCC.setOverallTable(globalTable);
        return curKappaCC;
    }

    private void calculatePerValueAgreementTables(KappaCompareCombi kcc) {
        String code;
        int i;
        List<String> allValuesList = kcc.getAllValues();
        AgreementTable globalTable = kcc.getOverallTable();
        int totalSum = globalTable.getTotalSum();
        HashMap<String, TwoSquareTable> perValueTable = new HashMap<String, TwoSquareTable>();
        kcc.setPerValueTables(perValueTable);
        for (i = 0; i < allValuesList.size() - 1; ++i) {
            code = allValuesList.get(i);
            perValueTable.put(code, new TwoSquareTable(code));
        }
        for (i = 0; i < allValuesList.size(); ++i) {
            int j;
            code = allValuesList.get(i);
            TwoSquareTable tst = (TwoSquareTable)perValueTable.get(code);
            int cell1 = globalTable.getTable()[i][i];
            int cell2 = 0;
            int cell3 = 0;
            int[] row = globalTable.getTable()[i];
            for (j = 0; j < row.length; ++j) {
                if (j == i) continue;
                cell2 += row[j];
            }
            for (j = 0; j < globalTable.getTable().length; ++j) {
                if (j == i) continue;
                cell3 += globalTable.getTable()[j][i];
            }
            if (tst == null) continue;
            tst.addToCell(0, 0, cell1);
            tst.addToCell(1, 0, cell2);
            tst.addToCell(0, 1, cell3);
            tst.addToCell(1, 1, totalSum - cell1 - cell2 - cell3);
        }
    }

    private void mergeGlobalAgreementTables(AgreementTable intoTable, AgreementTable fromTable) {
        int numRows = fromTable.getLabels().size();
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numRows; ++j) {
                intoTable.addCount(fromTable.getLabels().get(i), fromTable.getLabels().get(j), fromTable.getTable()[i][j]);
            }
        }
    }
}

