/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.UnsupportedCharsetException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import mpi.eudico.client.annotator.commands.AbstractCompareCommand;
import mpi.eudico.client.annotator.interannotator.AnnotatorCompareUtil2;
import mpi.eudico.client.annotator.interannotator.CompareCombi;

public class CompareAnnotationRatioMultiCommand
extends AbstractCompareCommand {
    public CompareAnnotationRatioMultiCommand(String theName) {
        super(theName);
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        super.execute(receiver, arguments);
    }

    @Override
    protected void calculateAgreement() {
        if (this.compareSegments.size() == 0) {
            this.logErrorAndInterrupt("There are no tier pairs, nothing to calculate.");
            return;
        }
        int combiCount = 0;
        float perCombi = 60.0f / (float)this.compareSegments.size();
        AnnotatorCompareUtil2 compareUtil = new AnnotatorCompareUtil2();
        this.progressUpdate((int)this.curProgress, "Starting calculations...");
        for (CompareCombi cc : this.compareSegments) {
            double average = compareUtil.getAverageRatio(cc);
            cc.setOverallAgreement(average);
            ++combiCount;
            this.curProgress += perCombi;
            this.progressUpdate((int)this.curProgress, null);
        }
        this.progressComplete(String.format("Completed calculations of %d pairs of tiers.", combiCount));
    }

    @Override
    public void writeResultsAsText(File toFile, String encoding) throws IOException {
        if (this.compareSegments == null) {
            throw new NullPointerException("There are no results to save.");
        }
        if (toFile == null) {
            throw new IOException("There is no file location specified.");
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        BufferedWriter writer = null;
        try {
            FileOutputStream out = new FileOutputStream(toFile);
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter((OutputStream)out, encoding);
            }
            catch (UnsupportedCharsetException uce) {
                osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
            }
            writer = new BufferedWriter(osw);
            String NL = "\n";
            String NL2 = "\n\n";
            DecimalFormat decFormat = new DecimalFormat("#0.0000", new DecimalFormatSymbols(Locale.US));
            writer.write(String.format("Output created: %tD %<tT", Calendar.getInstance()));
            writer.write("The overlap/extent value is the amount of overlap of two matching annotations divided by the total extent of those two annotations.");
            writer.write("\n");
            writer.write("Unmatched annotations (annotations without a counterpart on the other tier) add 1 to the number of comparisons, but 0 to the value.");
            writer.write("\n\n");
            writer.write("Number of pairs of tiers in the comparison: " + this.compareSegments.size());
            writer.write("\n\n");
            int totalCount = 0;
            double totalAgr = 0.0;
            for (CompareCombi cc : this.compareSegments) {
                writer.write("File 1: " + cc.getFirstUnit().fileName + " Tier 1: " + cc.getFirstUnit().tierName);
                writer.write("\n");
                writer.write("Number of annotations 1: " + cc.getFirstUnit().annotations.size());
                writer.write("\n");
                writer.write("File 2: " + cc.getSecondUnit().fileName + " Tier 2: " + cc.getSecondUnit().tierName);
                writer.write("\n");
                writer.write("Number of annotations 2: " + cc.getSecondUnit().annotations.size());
                writer.write("\n");
                writer.write("Average overlap/extent ratio: " + decFormat.format(cc.getOverallAgreement()));
                writer.write("\n\n");
                ++totalCount;
                totalAgr += cc.getOverallAgreement();
            }
            if (totalCount > 0) {
                writer.write("Overall average overlap/extent ratio: " + decFormat.format(totalAgr / (double)totalCount));
            } else {
                writer.write("There is no overall average overlap/extent ratio avaialable: no tier combinations found.");
            }
        }
        catch (Exception ex) {
            throw new IOException("Cannot write to file: " + ex.getMessage());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

