/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.AWTPermission;
import java.awt.Toolkit;
import java.util.List;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.TransferableAnnotation;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class CopyAnnotationCommand
implements Command {
    private String commandName;

    public CopyAnnotationCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        if (arguments[0] instanceof Annotation) {
            String mediaFile;
            AnnotationDataRecord record = new AnnotationDataRecord((Annotation)arguments[0]);
            TransferableAnnotation ta = new TransferableAnnotation(record);
            String copyOption = Preferences.getString("EditingPanel.CopyOption", null);
            if (copyOption != null && copyOption.equals("filename + tiername + begintime + endtime") && (mediaFile = this.getFirstMedia((Annotation)arguments[0])) != null) {
                record.setFilePath(mediaFile);
            }
            if (this.canAccessSystemClipboard()) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ta, ta);
            }
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    protected boolean canAccessSystemClipboard() {
        if (System.getSecurityManager() != null) {
            try {
                System.getSecurityManager().checkPermission(new AWTPermission("accessClipboard"));
                return true;
            }
            catch (SecurityException se) {
                ClientLogger.LOG.warning("Cannot copy, cannot access the clipboard.");
                return false;
            }
        }
        return true;
    }

    private String getFirstMedia(Annotation anno) {
        List<MediaDescriptor> md = ((TierImpl)anno.getTier()).getTranscription().getMediaDescriptors();
        if (md != null && md.size() > 0) {
            return md.get((int)0).mediaURL;
        }
        return null;
    }
}

