/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.commands.AbstractProgressCommand;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.util.TimeRelation;

public class CopyAnnotationsOfTierCommand
extends AbstractProgressCommand
implements UndoableCommand {
    private TranscriptionImpl transcription;
    private String sourceTierName;
    private String sourceCVName = "";
    private String destinationTierName;
    private String destinationCVName = "";
    private boolean copyAllAnnotations;
    private String queryValue;
    private Boolean isRegexObj;
    private boolean isRegex = false;
    private Pattern pattern;
    private Boolean overwriteObj;
    private boolean overwrite = false;
    private List<String> filesToProcess;
    private List<DefaultMutableTreeNode> deletedAnnotations;
    private List<List<DefaultMutableTreeNode>> deletedChildAnnotations;
    private List<DefaultMutableTreeNode> modifiedAnnotations;
    private List<AnnotationDataRecord> copyAnnotations;

    public CopyAnnotationsOfTierCommand(String name) {
        super(name);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void execute(Object receiver, Object[] arguments) {
        block18: {
            if (receiver instanceof TranscriptionImpl) {
                this.transcription = (TranscriptionImpl)receiver;
            }
            if (arguments != null && arguments.length >= 6) {
                try {
                    this.sourceTierName = (String)arguments[0];
                    this.destinationTierName = (String)arguments[1];
                    cpMode = (String)arguments[2];
                    this.copyAllAnnotations = "WithValue".equals(cpMode) == false;
                    this.queryValue = (String)arguments[3];
                    if (this.queryValue == null) {
                        this.copyAllAnnotations = true;
                    }
                    this.isRegexObj = (Boolean)arguments[4];
                    if (this.isRegexObj != null) {
                        this.isRegex = this.isRegexObj;
                    }
                    if (this.isRegex) {
                        try {
                            this.pattern = Pattern.compile(this.queryValue);
                        }
                        catch (PatternSyntaxException pse) {
                            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                                ClientLogger.LOG.warning(String.format("Cannot execute the Copy Annotations command, invalid regular expression: %s", new Object[]{pse.getMessage()}));
                            }
                            this.progressInterrupt(String.format("Cannot execute the Copy Annotations command because of an invalid regular expression: %s", new Object[]{pse.getMessage()}));
                            return;
                        }
                    }
                    this.overwriteObj = (Boolean)arguments[5];
                    if (this.overwriteObj == null) ** GOTO lbl37
                    this.overwrite = this.overwriteObj;
                }
                catch (Throwable t) {
                    if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                        ClientLogger.LOG.warning(String.format("Cannot execute the Copy Annotations command: %s", new Object[]{t.getMessage()}));
                    }
                    this.progressInterrupt(String.format("Cannot execute the Copy Annotations command because of a problem with the arguments: %s", new Object[]{t.getMessage()}));
                    return;
                }
            } else {
                if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                    ClientLogger.LOG.warning(String.format("Cannot execute the Copy Annotations command: %d arguments (<6)", new Object[]{arguments == null ? 0 : arguments.length}));
                }
                this.progressInterrupt("No or too few arguments passed to the Copy Annotations command");
                return;
            }
lbl37:
            // 2 sources

            if (arguments.length >= 7) {
                try {
                    this.filesToProcess = (List)arguments[6];
                }
                catch (Throwable t) {
                    if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block18;
                    ClientLogger.LOG.warning("Copy Annotations command, unexpected argument: the last argument is not a list of file names");
                }
            }
        }
        if (this.transcription == null && (this.filesToProcess == null || this.filesToProcess.isEmpty())) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.warning("Cannot execute the Copy Annotations command: no transcription and no list of files to process");
            }
            this.progressInterrupt("Cannot execute the Copy Annotations command: no transcription and no list of files to process specified");
            return;
        }
        new CopyThread().start();
    }

    @Override
    public void undo() {
        if (this.transcription != null && this.copyAnnotations != null && !this.copyAnnotations.isEmpty()) {
            TierImpl t2 = this.transcription.getTierWithId(this.destinationTierName);
            if (t2 == null) {
                if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                    ClientLogger.LOG.warning("Cannot undo the Copy Annotations command: the destination tier cannot be found anymore");
                }
                return;
            }
            int curMode = this.transcription.getTimeChangePropagationMode();
            if (curMode != 0) {
                this.transcription.setTimeChangePropagationMode(0);
            }
            this.transcription.setNotifying(false);
            for (AnnotationDataRecord annotationDataRecord : this.copyAnnotations) {
                long mid = (annotationDataRecord.getBeginTime() + annotationDataRecord.getEndTime()) / 2L;
                Annotation a = t2.getAnnotationAtTime(mid);
                if (a == null) continue;
                t2.removeAnnotation(a);
            }
            if (this.deletedChildAnnotations != null && !this.deletedChildAnnotations.isEmpty()) {
                for (List list : this.deletedChildAnnotations) {
                    AnnotationRecreator.createAnnotationsSequentially(this.transcription, list, true);
                }
            } else if (this.deletedAnnotations != null && !this.deletedAnnotations.isEmpty() || this.modifiedAnnotations != null && !this.modifiedAnnotations.isEmpty()) {
                for (DefaultMutableTreeNode defaultMutableTreeNode : this.deletedAnnotations) {
                    AnnotationRecreator.createAnnotationFromTree(this.transcription, defaultMutableTreeNode, true);
                }
                for (DefaultMutableTreeNode defaultMutableTreeNode : this.modifiedAnnotations) {
                    AnnotationRecreator.createAnnotationFromTree(this.transcription, defaultMutableTreeNode, true);
                }
            }
            this.transcription.setTimeChangePropagationMode(curMode);
            this.transcription.setNotifying(true);
        }
    }

    @Override
    public void redo() {
        if (this.transcription != null && this.copyAnnotations != null && !this.copyAnnotations.isEmpty()) {
            TierImpl t2 = this.transcription.getTierWithId(this.destinationTierName);
            if (t2 == null) {
                if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                    ClientLogger.LOG.warning("Cannot redo the Copy Annotations command: the destination tier cannot be found anymore");
                }
                return;
            }
            int curMode = this.transcription.getTimeChangePropagationMode();
            if (curMode != 0) {
                this.transcription.setTimeChangePropagationMode(0);
            }
            this.transcription.setNotifying(false);
            if (this.deletedChildAnnotations != null && !this.deletedChildAnnotations.isEmpty()) {
                for (List<DefaultMutableTreeNode> chList : this.deletedChildAnnotations) {
                    if (chList.isEmpty()) continue;
                    AnnotationDataRecord r1 = (AnnotationDataRecord)chList.get(0).getUserObject();
                    AnnotationDataRecord r2 = (AnnotationDataRecord)chList.get(chList.size() - 1).getUserObject();
                    long bt = r1.getBeginTime();
                    long et = r2.getEndTime();
                    List<Annotation> overAnns = t2.getOverlappingAnnotations(bt, et);
                    for (Annotation a : overAnns) {
                        t2.removeAnnotation(a);
                    }
                }
            }
            this.createCopiesOfAnnotations(t2, this.copyAnnotations);
            this.transcription.setTimeChangePropagationMode(curMode);
            this.transcription.setNotifying(true);
        }
    }

    private List<AbstractAnnotation> collectCandidateAnnotations(TierImpl t1, TierImpl t2) {
        ArrayList<AbstractAnnotation> copyAnnList = new ArrayList<AbstractAnnotation>();
        List<AbstractAnnotation> srcAnns = t1.getAnnotations();
        for (AbstractAnnotation aa : srcAnns) {
            if (!this.overwrite && !t2.getOverlappingAnnotations(aa.getBeginTimeBoundary(), aa.getEndTimeBoundary()).isEmpty()) continue;
            if (this.copyAllAnnotations) {
                copyAnnList.add(aa);
                continue;
            }
            if (this.isRegex) {
                Matcher m = this.pattern.matcher(aa.getValue());
                if (!m.matches()) continue;
                copyAnnList.add(aa);
                continue;
            }
            if (!this.queryValue.equals(aa.getValue())) continue;
            copyAnnList.add(aa);
        }
        return copyAnnList;
    }

    private void processCollectedAnnotation(TierImpl t1, TierImpl t2, List<AbstractAnnotation> collectedAnnotations) {
        boolean isChildTier = t2.hasAncestor(t1);
        for (AbstractAnnotation aa : collectedAnnotations) {
            long et;
            long bt = aa.getBeginTimeBoundary();
            List<Annotation> overlappingAnn = t2.getOverlappingAnnotations(bt, et = aa.getEndTimeBoundary());
            if (overlappingAnn.isEmpty()) continue;
            if (isChildTier) {
                ArrayList<DefaultMutableTreeNode> chGroup = new ArrayList<DefaultMutableTreeNode>(overlappingAnn.size());
                for (Annotation a : overlappingAnn) {
                    chGroup.add(AnnotationRecreator.createTreeForAnnotation((AbstractAnnotation)a));
                }
                this.deletedChildAnnotations.add(chGroup);
                for (Annotation a : overlappingAnn) {
                    t2.removeAnnotation(a);
                }
                continue;
            }
            for (Annotation a : overlappingAnn) {
                AbstractAnnotation ovAnn = (AbstractAnnotation)a;
                if (TimeRelation.isInside(ovAnn, bt, et)) {
                    this.deletedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(ovAnn));
                    continue;
                }
                if (!TimeRelation.overlapsOnLeftSide(ovAnn, bt, et) && !TimeRelation.overlapsOnRightSide(ovAnn, bt, et) && !TimeRelation.surrounds(ovAnn, bt, et)) continue;
                this.modifiedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(ovAnn));
            }
        }
    }

    private void updateAnnotationRecords(List<AnnotationDataRecord> copyAnnotations, String sourceCVName, String destinationCVName) {
        if (sourceCVName != null && !sourceCVName.equals(destinationCVName)) {
            for (AnnotationDataRecord adr : copyAnnotations) {
                adr.setCvEntryId(null);
            }
        }
    }

    private void createCopiesOfAnnotations(TierImpl t2, List<AnnotationDataRecord> copyAnnotations) {
        boolean symbolicTier = false;
        Constraint c = t2.getLinguisticType().getConstraints();
        if (c != null && (c.getStereoType() == 4 || c.getStereoType() == 3)) {
            symbolicTier = true;
        }
        for (AnnotationDataRecord record : copyAnnotations) {
            AbstractAnnotation na;
            long bt = record.getBeginTime();
            long et = record.getEndTime();
            if (symbolicTier) {
                et = bt = (bt + et) / 2L;
            }
            if ((na = (AbstractAnnotation)t2.createAnnotation(bt, et)) == null) continue;
            AnnotationRecreator.restoreValueEtc(na, record, false);
        }
    }

    private class CopyThread
    extends Thread {
        private CopyThread() {
        }

        @Override
        public void run() {
            if (CopyAnnotationsOfTierCommand.this.transcription != null) {
                CopyAnnotationsOfTierCommand.this.progressUpdate(5, "Starting to copy annotations");
                TierImpl sourceTier = CopyAnnotationsOfTierCommand.this.transcription.getTierWithId(CopyAnnotationsOfTierCommand.this.sourceTierName);
                if (sourceTier == null) {
                    CopyAnnotationsOfTierCommand.this.progressInterrupt("The source tier is not specified or not found");
                    return;
                }
                TierImpl destinationTier = CopyAnnotationsOfTierCommand.this.transcription.getTierWithId(CopyAnnotationsOfTierCommand.this.destinationTierName);
                if (destinationTier == null) {
                    CopyAnnotationsOfTierCommand.this.progressInterrupt("The destination tier is not specified or not found");
                    return;
                }
                if (sourceTier.getLinguisticType().getControlledVocabularyName() != null) {
                    CopyAnnotationsOfTierCommand.this.sourceCVName = sourceTier.getLinguisticType().getControlledVocabularyName();
                }
                if (destinationTier.getLinguisticType().getControlledVocabularyName() != null) {
                    CopyAnnotationsOfTierCommand.this.destinationCVName = destinationTier.getLinguisticType().getControlledVocabularyName();
                }
                CopyAnnotationsOfTierCommand.this.progressUpdate(10, "Collecting annotations to copy");
                List collectedAnnotations = CopyAnnotationsOfTierCommand.this.collectCandidateAnnotations(sourceTier, destinationTier);
                if (collectedAnnotations.isEmpty()) {
                    CopyAnnotationsOfTierCommand.this.progressInterrupt("There are no matching annotations to be copied");
                }
                CopyAnnotationsOfTierCommand.this.deletedAnnotations = new ArrayList();
                CopyAnnotationsOfTierCommand.this.deletedChildAnnotations = new ArrayList();
                CopyAnnotationsOfTierCommand.this.modifiedAnnotations = new ArrayList();
                CopyAnnotationsOfTierCommand.this.copyAnnotations = new ArrayList();
                for (AbstractAnnotation aa : collectedAnnotations) {
                    CopyAnnotationsOfTierCommand.this.copyAnnotations.add(new AnnotationDataRecord(aa));
                }
                CopyAnnotationsOfTierCommand.this.progressUpdate(20, String.format("Collected annotation information, %d annotations to copy", collectedAnnotations.size()));
                int curMode = CopyAnnotationsOfTierCommand.this.transcription.getTimeChangePropagationMode();
                if (curMode != 0) {
                    CopyAnnotationsOfTierCommand.this.transcription.setTimeChangePropagationMode(0);
                }
                CopyAnnotationsOfTierCommand.this.transcription.setNotifying(false);
                CopyAnnotationsOfTierCommand.this.processCollectedAnnotation(sourceTier, destinationTier, collectedAnnotations);
                CopyAnnotationsOfTierCommand.this.progressUpdate(40, "Stored annotations to be deleted or modified");
                CopyAnnotationsOfTierCommand.this.updateAnnotationRecords(CopyAnnotationsOfTierCommand.this.copyAnnotations, CopyAnnotationsOfTierCommand.this.sourceCVName, CopyAnnotationsOfTierCommand.this.destinationCVName);
                CopyAnnotationsOfTierCommand.this.progressUpdate(50, "Checked CV entry references of the source annotations");
                CopyAnnotationsOfTierCommand.this.createCopiesOfAnnotations(destinationTier, CopyAnnotationsOfTierCommand.this.copyAnnotations);
                CopyAnnotationsOfTierCommand.this.progressUpdate(90, "Created the new annotations");
                CopyAnnotationsOfTierCommand.this.transcription.setTimeChangePropagationMode(curMode);
                CopyAnnotationsOfTierCommand.this.transcription.setNotifying(true);
                CopyAnnotationsOfTierCommand.this.progressComplete("Finished copying annotations");
            }
        }
    }
}

