/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.util.TimeFormatter;

public class CopyCurrentTimeToPasteBoardCommand
implements Command {
    private String commandName;
    private static String HH_MM_SS_MS = ElanLocale.getString("TimeCodeFormat.Hours");
    private static String SS_MS = ElanLocale.getString("TimeCodeFormat.Seconds");
    private static String MS = ElanLocale.getString("TimeCodeFormat.MilliSec");
    private static String NTSC = ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.NTSC");
    private static String PAL = ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL");
    private static String PAL_50 = ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL50");

    public CopyCurrentTimeToPasteBoardCommand(String theName) {
        this.commandName = theName;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        ElanMediaPlayer player = (ElanMediaPlayer)arguments[0];
        if (player == null) {
            return;
        }
        if (player.isPlaying()) {
            return;
        }
        String currentTime = null;
        String timeFormat = Preferences.getString("CurrentTime.Copy.TimeFormat", null);
        if (timeFormat != null) {
            currentTime = this.checkTimeFormatConstants(timeFormat, player.getMediaTime());
            if (currentTime == null) {
                currentTime = timeFormat.equals(HH_MM_SS_MS) ? TimeFormatter.toString(player.getMediaTime()) : (timeFormat.equals(SS_MS) ? TimeFormatter.toSSMSString(player.getMediaTime()) : (timeFormat.equals(NTSC) ? TimeFormatter.toTimecodeNTSC(player.getMediaTime()) : (timeFormat.equals(PAL) ? TimeFormatter.toTimecodePAL(player.getMediaTime()) : (timeFormat.equals(PAL_50) ? TimeFormatter.toTimecodePAL50(player.getMediaTime()) : Long.toString(player.getMediaTime())))));
            }
        } else {
            currentTime = Long.toString(player.getMediaTime());
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        StringSelection strSel = new StringSelection(currentTime);
        clipboard.setContents(strSel, null);
    }

    private String checkTimeFormatConstants(String timeFormatPref, long time) {
        if (timeFormatPref != null) {
            if (timeFormatPref.equals("hh:mm:ss.ms")) {
                return TimeFormatter.toString(time);
            }
            if (timeFormatPref.equals("ss.ms")) {
                return TimeFormatter.toSSMSString(time);
            }
            if (timeFormatPref.equals("NTSC")) {
                return TimeFormatter.toTimecodeNTSC(time);
            }
            if (timeFormatPref.equals("PAL")) {
                return TimeFormatter.toTimecodePAL(time);
            }
            if (timeFormatPref.equals("PAL-50fps")) {
                return TimeFormatter.toTimecodePAL50(time);
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

