/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Dimension;
import javax.swing.JDialog;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.export.ExportFlexStep1;
import mpi.eudico.client.annotator.export.ExportFlexStep2;
import mpi.eudico.client.annotator.export.ExportFlexStep3;
import mpi.eudico.client.annotator.export.ExportFlexStep4;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ExportFlexDlgCommand
implements Command {
    private String commandName;

    public ExportFlexDlgCommand(String theName) {
        this.commandName = theName;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        if (arguments[0] instanceof TranscriptionImpl) {
            TranscriptionImpl transcription = (TranscriptionImpl)arguments[0];
            MultiStepPane multipane = new MultiStepPane();
            multipane.addStep(new ExportFlexStep1(multipane, transcription));
            multipane.addStep(new ExportFlexStep2(multipane, transcription));
            multipane.addStep(new ExportFlexStep3(multipane, transcription));
            multipane.addStep(new ExportFlexStep4(multipane, transcription));
            JDialog dialog = multipane.createDialog(ELANCommandFactory.getRootFrame(transcription), ElanLocale.getString("ExportFlexDialog.Title"), true);
            dialog.setPreferredSize(new Dimension(600, 600));
            dialog.pack();
            dialog.setVisible(true);
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

