/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.File;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.server.corpora.clom.Transcription;
import nl.mpi.util.FileExtension;

public class ExportPrefsCommand
implements Command {
    private String commandName;
    private Transcription transcription;

    public ExportPrefsCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (Transcription)receiver;
        if (this.transcription == null) {
            return;
        }
        String filePath = this.promptForExportFile();
        if (filePath == null) {
            return;
        }
        Preferences.exportPreferences(this.transcription, filePath);
    }

    private String promptForExportFile() {
        FileChooser chooser = new FileChooser(ELANCommandFactory.getRootFrame(this.transcription));
        chooser.createAndShowFileDialog(ElanLocale.getString("ExportDialog.ExportToFile"), 1, FileExtension.ELAN_XML_PREFS_EXT, "LastUsedExportDir");
        File prefFile = chooser.getSelectedFile();
        if (prefFile != null) {
            return prefFile.getAbsolutePath();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

