/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.turnsandscenemode.TaSSpecialMarkers;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicAssociation;
import nl.mpi.util.FileExtension;
import nl.mpi.util.FileUtility;

public class ExportRegularMultitierEafCommand
implements Command {
    private String name;
    private String translationTypeName = "translation";
    private String transSuffix = "trans";
    private String unknownSpeakerName = "unknown";

    public ExportRegularMultitierEafCommand(String name) {
        this.name = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        TranscriptionImpl transcription = (TranscriptionImpl)receiver;
        if (transcription == null) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.warning("Cannot export the transcription: null");
            }
            return;
        }
        FileChooser chooser = new FileChooser(ELANCommandFactory.getRootFrame(transcription));
        File origFile = null;
        Object fileName = transcription.getName();
        if (!((String)fileName).equals("aishug294879ryshfda9763afo8947a5gf")) {
            String filePath = FileUtility.urlToAbsPath(transcription.getFullPath());
            origFile = new File(filePath);
            chooser.setCurrentDirectory(filePath.substring(0, filePath.indexOf((String)fileName)));
            fileName = ((String)fileName).substring(0, ((String)fileName).lastIndexOf(46)) + ".eaf";
            chooser.createAndShowFileDialog(ElanLocale.getString("SaveDialog.Title"), 1, null, FileExtension.EAF_EXT, null, (String)fileName);
        } else {
            chooser.createAndShowFileDialog(ElanLocale.getString("SaveDialog.Title"), 1, FileExtension.EAF_EXT, "LastUsedEAFDir");
        }
        File f = chooser.getSelectedFile();
        if (f != null) {
            if (origFile != null && f.compareTo(origFile) == 0) {
                if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                    ClientLogger.LOG.warning("Cannot overwrite the original file");
                }
                JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(transcription), ElanLocale.getString("ExportRegularEAF.Message.OverwriteOriginal"), ElanLocale.getString("Message.Warning"), 2);
                return;
            }
            String nextAbsPath = f.getAbsolutePath();
            TranscriptionImpl nextTranscription = null;
            try {
                ACMTranscriptionStore.getCurrentTranscriptionStore().storeTranscriptionIn(transcription, null, null, nextAbsPath, ACMTranscriptionStore.getCurrentEAFParser().getFileFormat());
                nextTranscription = new TranscriptionImpl(nextAbsPath);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(transcription), ElanLocale.getString("Message.Error.Save"), ElanLocale.getString("Message.Warning"), 2);
                return;
            }
            if (nextTranscription != null) {
                if (nextTranscription.isChanged()) {
                    nextTranscription.setUnchanged();
                }
                this.splitTiers(nextTranscription);
                if (nextTranscription.isChanged()) {
                    try {
                        ACMTranscriptionStore.getCurrentTranscriptionStore().storeTranscriptionIn(nextTranscription, null, null, nextAbsPath, ACMTranscriptionStore.getCurrentEAFParser().getFileFormat());
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(transcription), ElanLocale.getString("Message.Error.Save"), ElanLocale.getString("Message.Warning"), 2);
                    }
                }
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void splitTiers(TranscriptionImpl tr) {
        List<TierImpl> topTiers = tr.getTopTiers();
        ArrayList<TierImpl> tiersWithTrans = new ArrayList<TierImpl>();
        ArrayList<TierImpl> tiersWithSpeakers = new ArrayList<TierImpl>();
        block0: for (TierImpl t : topTiers) {
            boolean transDetect = false;
            boolean speakDetect = false;
            for (Annotation annotation : t.getAnnotations()) {
                if (!speakDetect && TaSSpecialMarkers.hasSpeakerMarker(annotation.getValue())) {
                    tiersWithSpeakers.add(t);
                    speakDetect = true;
                }
                if (!transDetect && TaSSpecialMarkers.hasTranslationMarker(annotation.getValue())) {
                    tiersWithTrans.add(t);
                    transDetect = true;
                }
                if (!transDetect || !speakDetect) continue;
                continue block0;
            }
        }
        if (tiersWithSpeakers.isEmpty() && tiersWithTrans.isEmpty()) {
            if (ClientLogger.LOG.isLoggable(Level.INFO)) {
                ClientLogger.LOG.info("No tiers to process, no tiers with translation or speaker markings.");
            }
            return;
        }
        Map<TierImpl, List<TierImpl>> speakerTierMap = null;
        Map<TierImpl, TierImpl> transTierMap = null;
        if (!tiersWithSpeakers.isEmpty()) {
            speakerTierMap = this.createSpeakerTiers(tr, tiersWithSpeakers);
        }
        if (!tiersWithTrans.isEmpty()) {
            transTierMap = this.createNewTranslationTiers(tr, tiersWithTrans, speakerTierMap);
        }
        this.splitAnnotations(tr, speakerTierMap, transTierMap);
    }

    private void splitAnnotations(TranscriptionImpl tr, Map<TierImpl, List<TierImpl>> speakerTierMap, Map<TierImpl, TierImpl> transTierMap) {
        ArrayList<TierImpl> tiersToProcess = new ArrayList<TierImpl>();
        if (speakerTierMap != null) {
            tiersToProcess.addAll(speakerTierMap.keySet());
        }
        if (transTierMap != null) {
            tiersToProcess.addAll(transTierMap.keySet());
        }
        ArrayList<TierImpl> processedTiers = new ArrayList<TierImpl>();
        for (TierImpl t : tiersToProcess) {
            if (processedTiers.contains(t)) continue;
            boolean multiSpeak = speakerTierMap != null && speakerTierMap.containsKey(t);
            boolean hasTranslation = transTierMap != null && transTierMap.containsKey(t);
            HashMap<Object, String> perSpeakerText = new HashMap<Object, String>(multiSpeak ? 10 : 1);
            HashMap<String, String> perSpeakerTrans = new HashMap<String, String>(hasTranslation ? 10 : 0);
            String unknownSpeakerTierName = t.getName() + "@" + this.unknownSpeakerName;
            for (AbstractAnnotation aa : t.getAnnotations()) {
                String value;
                perSpeakerText.clear();
                perSpeakerTrans.clear();
                int[][] spIndices = TaSSpecialMarkers.getSpeakerIndices(aa.getValue());
                int valLength = aa.getValue().length();
                if (spIndices != null) {
                    String s;
                    if (spIndices[0][0] != 0 && (s = aa.getValue().substring(0, spIndices[0][0]).trim()).length() > 0) {
                        perSpeakerText.put(unknownSpeakerTierName, s);
                    }
                    for (int i = 0; i < spIndices.length; ++i) {
                        String sp = aa.getValue().substring(spIndices[i][0], spIndices[i][1]);
                        String val = "";
                        if (i < spIndices.length - 1) {
                            val = aa.getValue().substring(spIndices[i][1], spIndices[i + 1][0]).trim();
                        } else if (spIndices[i][1] < valLength - 1) {
                            val = aa.getValue().substring(spIndices[i][1]).trim();
                        }
                        perSpeakerText.put(sp, val);
                    }
                } else if (multiSpeak) {
                    perSpeakerText.put(unknownSpeakerTierName, aa.getValue());
                } else {
                    perSpeakerText.put(t.getName(), aa.getValue());
                }
                if (hasTranslation) {
                    for (String key : perSpeakerText.keySet()) {
                        value = (String)perSpeakerText.get(key);
                        int valLen = value.length();
                        int[] transIndices = TaSSpecialMarkers.getTranslationIndices(value);
                        if (transIndices == null) continue;
                        String txt = "";
                        String trans = "";
                        if (transIndices[0] > 0) {
                            txt = value.substring(0, transIndices[0]).trim();
                        }
                        if (transIndices[0] + "//".length() < valLen - 1) {
                            trans = value.substring(transIndices[0] + "//".length()).trim();
                        }
                        perSpeakerText.put(key, txt);
                        perSpeakerTrans.put(key, trans);
                    }
                }
                block4: for (String key : perSpeakerText.keySet()) {
                    value = (String)perSpeakerText.get(key);
                    String trans = (String)perSpeakerTrans.get(key);
                    if (!multiSpeak) {
                        long time;
                        aa.setValue(value);
                        TierImpl tri = transTierMap.get(t);
                        Annotation ta = tri.createAnnotation(time = (aa.getBeginTimeBoundary() + aa.getEndTimeBoundary()) / 2L, time);
                        if (ta == null || trans == null) continue;
                        ta.setValue(trans);
                        continue;
                    }
                    List<TierImpl> tispList = speakerTierMap.get(t);
                    if (tispList == null) continue;
                    Object tname = this.cleanTierName(key);
                    if (((String)tname).startsWith("@")) {
                        tname = t.getLinguisticType().getLinguisticTypeName() + (String)tname;
                    }
                    for (TierImpl tt : tispList) {
                        long time;
                        TierImpl tri;
                        Annotation tta;
                        if (!tt.getName().equals(tname)) continue;
                        Annotation ta = tt.createAnnotation(aa.getBeginTimeBoundary(), aa.getEndTimeBoundary());
                        if (ta != null && value != null) {
                            ta.setValue(value);
                        }
                        if (!hasTranslation || (tta = (tri = transTierMap.get(tt)).createAnnotation(time = (aa.getBeginTimeBoundary() + aa.getEndTimeBoundary()) / 2L, time)) == null || trans == null) continue block4;
                        tta.setValue(trans);
                        continue block4;
                    }
                }
            }
            processedTiers.add(t);
        }
    }

    private Map<TierImpl, List<TierImpl>> createSpeakerTiers(TranscriptionImpl tr, List<TierImpl> tiersWithSpeakers) {
        HashMap<TierImpl, List<TierImpl>> sptMap = new HashMap<TierImpl, List<TierImpl>>();
        for (TierImpl t : tiersWithSpeakers) {
            ArrayList<TierImpl> allRelSpeakTiers = new ArrayList<TierImpl>(5);
            sptMap.put(t, allRelSpeakTiers);
            ArrayList<Object> uniqNames = new ArrayList<Object>();
            uniqNames.add(t.getName() + "@" + this.unknownSpeakerName);
            for (AbstractAnnotation aa : t.getAnnotations()) {
                int[][] speakerIndices = TaSSpecialMarkers.getSpeakerIndices(aa.getValue());
                if (speakerIndices == null) continue;
                for (int[] indices : speakerIndices) {
                    String tierName = aa.getValue().substring(indices[0], indices[1]);
                    if (uniqNames.contains(tierName)) continue;
                    uniqNames.add(tierName);
                }
            }
            for (Object tierName : uniqNames) {
                TierImpl spTier;
                LinguisticType lt;
                tierName = this.cleanTierName((String)tierName);
                int atIndex = ((String)tierName).indexOf(64);
                String tierTypeName = ((String)tierName).substring(0, atIndex);
                String participant = ((String)tierName).substring(atIndex + 1);
                if (tierTypeName == null || tierTypeName.isEmpty()) {
                    tierTypeName = t.getName();
                }
                if (atIndex == 0) {
                    tierName = tierTypeName + (String)tierName;
                }
                if ((lt = tr.getLinguisticTypeByName(tierTypeName)) == null) {
                    lt = new LinguisticType(tierTypeName, t.getLinguisticType());
                    tr.addLinguisticType(lt);
                }
                if ((spTier = tr.getTierWithId((String)tierName)) == null) {
                    spTier = new TierImpl((String)tierName, participant, tr, lt);
                    spTier.setAnnotator(t.getAnnotator());
                    tr.addTier(spTier);
                }
                if (allRelSpeakTiers.contains(spTier)) continue;
                allRelSpeakTiers.add(spTier);
            }
        }
        return sptMap;
    }

    private Map<TierImpl, TierImpl> createNewTranslationTiers(TranscriptionImpl tr, List<TierImpl> tiersWithTrans, Map<TierImpl, List<TierImpl>> speakerTierMap) {
        LinguisticType translationType = tr.getLinguisticTypeByName(this.translationTypeName);
        if (translationType == null) {
            translationType = new LinguisticType(this.translationTypeName);
            translationType.addConstraint(new SymbolicAssociation());
            translationType.setTimeAlignable(false);
            tr.addLinguisticType(translationType);
        } else if (translationType.getConstraints().getStereoType() != 4) {
            LinguisticType nextTransType = null;
            for (int count = 1; count < 20; ++count) {
                String nextName = this.translationTypeName + "-" + count;
                nextTransType = tr.getLinguisticTypeByName(nextName);
                if (nextTransType != null) {
                    if (nextTransType.getConstraints().getStereoType() != 4) continue;
                    break;
                }
                nextTransType = new LinguisticType(nextName);
                nextTransType.addConstraint(new SymbolicAssociation());
                nextTransType.setTimeAlignable(false);
                tr.addLinguisticType(nextTransType);
                break;
            }
            translationType = nextTransType;
        }
        if (translationType == null) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.warning("Could not find or create a tier type for translation tiers.");
            }
            return null;
        }
        HashMap<TierImpl, TierImpl> tierTransMap = new HashMap<TierImpl, TierImpl>();
        for (TierImpl t : tiersWithTrans) {
            boolean derivedTiersExist;
            List<TierImpl> derivedSpeakTiers = null;
            if (speakerTierMap != null) {
                derivedSpeakTiers = speakerTierMap.get(t);
            }
            boolean bl = derivedTiersExist = derivedSpeakTiers != null && !derivedSpeakTiers.isEmpty();
            if (derivedTiersExist) {
                tierTransMap.put(t, null);
                for (TierImpl derTier : derivedSpeakTiers) {
                    String derTierName = this.getUniqueTierName(tr, derTier.getName(), this.transSuffix);
                    TierImpl derTransTier = new TierImpl(derTier, derTierName, derTier.getParticipant(), tr, translationType);
                    derTransTier.setAnnotator(derTier.getAnnotator());
                    tr.addTier(derTransTier);
                    tierTransMap.put(derTier, derTransTier);
                }
                continue;
            }
            String tierName = this.getUniqueTierName(tr, t.getName(), this.transSuffix);
            TierImpl transTier = new TierImpl(t, tierName, t.getParticipant(), tr, translationType);
            transTier.setAnnotator(t.getAnnotator());
            tr.addTier(transTier);
            tierTransMap.put(t, transTier);
        }
        return tierTransMap;
    }

    private String getUniqueTierName(TranscriptionImpl transcription, String name, String affix) {
        String nName = affix + "-" + name;
        if (transcription.getTierWithId(nName) != null) {
            for (int i = 1; i < 50; ++i) {
                String nextName = nName + "-" + i;
                if (transcription.getTierWithId(nextName) != null) continue;
                return nextName;
            }
        }
        return nName;
    }

    private String cleanTierName(String tierName) {
        if (tierName.endsWith(":") && tierName.length() > 1) {
            return tierName.substring(0, tierName.length() - 1);
        }
        return tierName;
    }
}

