/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.timeseries.AbstractTSTrack;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ExtractTrackDataCommand
implements UndoableCommand {
    private String commandName;
    private ArrayList<ProgressListener> listeners;
    private TranscriptionImpl transcription;
    private String sourceTierName;
    private String destTierName;
    private ArrayList<AnnotationDataRecord> newAnnos;
    private ArrayList<ValueRecord> changedAnnos;

    public ExtractTrackDataCommand(String commandName) {
        this.commandName = commandName;
    }

    @Override
    public void undo() {
        if (this.transcription != null) {
            RefAnnotation ref;
            TierImpl tier = this.transcription.getTierWithId(this.destTierName);
            if (tier == null) {
                ClientLogger.LOG.severe("Tier " + this.destTierName + " does no longer exist");
                return;
            }
            this.setWaitCursor(true);
            if (this.newAnnos != null) {
                for (int i = 0; i < this.newAnnos.size(); ++i) {
                    AnnotationDataRecord record = this.newAnnos.get(i);
                    ref = (RefAnnotation)tier.getAnnotationAtTime(record.getBeginTime());
                    if (ref != null) {
                        tier.removeAnnotation(ref);
                        continue;
                    }
                    ClientLogger.LOG.warning("Could not delete annotation: " + record.getValue() + "bt: " + record.getBeginTime());
                }
            }
            if (this.changedAnnos != null) {
                for (int i = 0; i < this.changedAnnos.size(); ++i) {
                    ValueRecord valRec = this.changedAnnos.get(i);
                    ref = (RefAnnotation)tier.getAnnotationAtTime(valRec.beginTime);
                    if (ref != null) {
                        ref.setValue(valRec.oldValue);
                        continue;
                    }
                    ClientLogger.LOG.warning("Could not find annotation: " + valRec.oldValue + "bt: " + valRec.beginTime);
                }
            }
            this.setWaitCursor(false);
        }
    }

    @Override
    public void redo() {
        if (this.transcription != null) {
            RefAnnotation ref;
            TierImpl tier = this.transcription.getTierWithId(this.destTierName);
            if (tier == null) {
                ClientLogger.LOG.severe("Tier " + this.destTierName + " does no longer exist");
                return;
            }
            this.setWaitCursor(true);
            if (this.newAnnos != null) {
                for (int i = 0; i < this.newAnnos.size(); ++i) {
                    AnnotationDataRecord record = this.newAnnos.get(i);
                    ref = (RefAnnotation)tier.getAnnotationAtTime(record.getBeginTime());
                    if (ref == null) {
                        long mid = (record.getBeginTime() + record.getEndTime()) / 2L;
                        ref = (RefAnnotation)tier.createAnnotation(mid, mid);
                        if (ref != null) {
                            ref.setValue(record.getValue());
                            continue;
                        }
                        ClientLogger.LOG.warning("Could not create a reference annotation at time: " + mid);
                        continue;
                    }
                    ClientLogger.LOG.warning("Annotation was not deleted in undo: " + record.getValue() + "bt: " + record.getBeginTime());
                }
            }
            if (this.changedAnnos != null) {
                for (int i = 0; i < this.changedAnnos.size(); ++i) {
                    ValueRecord valRec = this.changedAnnos.get(i);
                    ref = (RefAnnotation)tier.getAnnotationAtTime(valRec.beginTime);
                    if (ref != null) {
                        ref.setValue(valRec.newValue);
                        continue;
                    }
                    ClientLogger.LOG.warning("Could not find annotation: " + valRec.newValue + "bt: " + valRec.beginTime);
                }
            }
            this.setWaitCursor(false);
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.sourceTierName = (String)arguments[0];
        this.destTierName = (String)arguments[1];
        AbstractTSTrack track = (AbstractTSTrack)arguments[2];
        String method = (String)arguments[3];
        boolean overwrite = (Boolean)arguments[4];
        TierImpl sourceTier = this.transcription.getTierWithId(this.sourceTierName);
        if (sourceTier == null) {
            this.progressInterrupt(ElanLocale.getString("TimeSeriesViewer.Extract.NotFound") + " " + this.sourceTierName);
            return;
        }
        TierImpl destTier = this.transcription.getTierWithId(this.destTierName);
        if (destTier == null) {
            this.progressInterrupt(ElanLocale.getString("TimeSeriesViewer.Extract.NotFound") + " " + this.destTierName);
            return;
        }
        if (track == null) {
            this.progressInterrupt(ElanLocale.getString("TimeSeriesViewer.Extract.NotFound") + " track");
            return;
        }
        if (method == null) {
            this.progressInterrupt(ElanLocale.getString("TimeSeriesViewer.Extract.NoMethod"));
            return;
        }
        this.newAnnos = new ArrayList();
        this.changedAnnos = new ArrayList();
        ExtractThread thread = new ExtractThread(sourceTier, destTier, track, method, overwrite);
        try {
            thread.start();
        }
        catch (Exception e) {
            ClientLogger.LOG.warning("Error in extraction progress: " + e.getMessage());
            this.progressInterrupt("Extraction progress interrupted");
            this.transcription.setNotifying(true);
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    public synchronized void addProgressListener(ProgressListener pl) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(pl);
    }

    public synchronized void removeProgressListener(ProgressListener pl) {
        if (pl != null && this.listeners != null) {
            this.listeners.remove(pl);
        }
    }

    private void progressUpdate(int percent, String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressUpdated(this, percent, message);
            }
        }
    }

    private void progressComplete(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressCompleted(this, message);
            }
        }
    }

    private void progressInterrupt(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressInterrupted(this, message);
            }
        }
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    private class ValueRecord {
        public final long beginTime;
        public final String oldValue;
        public final String newValue;

        ValueRecord(long beginTime, String oldValue, String newValue) {
            this.beginTime = beginTime;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }
    }

    private class ExtractThread
    extends Thread {
        private TierImpl sourceTier;
        private TierImpl destTier;
        private AbstractTSTrack track;
        private String method;
        private boolean overwrite;
        private final char[] modes;
        private char mode;

        ExtractThread(TierImpl sourceTier, TierImpl destTier, AbstractTSTrack track, String method, boolean overwrite) {
            super(ExtractThread.class.getName());
            this.overwrite = false;
            this.modes = new char[]{'<', '>', '=', '+', 'b', 'e', 'm', 'r'};
            this.mode = this.modes[0];
            this.sourceTier = sourceTier;
            this.destTier = destTier;
            this.track = track;
            this.method = method;
            String lMethod = method.toLowerCase();
            if ("max".equals(lMethod)) {
                this.mode = this.modes[1];
            } else if ("ave".equals(lMethod)) {
                this.mode = this.modes[2];
            } else if ("sum".equals(lMethod)) {
                this.mode = this.modes[3];
            } else if ("atbegin".equals(lMethod)) {
                this.mode = this.modes[4];
            } else if ("atend".equals(lMethod)) {
                this.mode = this.modes[5];
            } else if ("median".equals(lMethod)) {
                this.mode = this.modes[6];
            } else if ("range".equals(lMethod)) {
                this.mode = this.modes[7];
            }
            this.overwrite = overwrite;
        }

        @Override
        public void run() {
            ExtractTrackDataCommand.this.transcription.setNotifying(false);
            ArrayList<AbstractAnnotation> annos = new ArrayList<AbstractAnnotation>(this.sourceTier.getAnnotations());
            float perAnn = 100.0f / (float)Math.max(annos.size(), 1);
            DecimalFormat format = new DecimalFormat("#0.####", new DecimalFormatSymbols(Locale.US));
            for (int i = 0; i < annos.size(); ++i) {
                AlignableAnnotation aa = (AlignableAnnotation)annos.get(i);
                long begin = aa.getBeginTimeBoundary();
                long end = aa.getEndTimeBoundary();
                float value = 0.0f;
                try {
                    switch (this.mode) {
                        case '<': {
                            value = this.track.getMinimum(begin, end);
                            break;
                        }
                        case '>': {
                            value = this.track.getMaximum(begin, end);
                            break;
                        }
                        case '=': {
                            value = this.track.getAverage(begin, end);
                            break;
                        }
                        case '+': {
                            value = this.track.getSum(begin, end);
                            break;
                        }
                        case 'b': {
                            value = this.track.getValueAtBegin(begin, end);
                            break;
                        }
                        case 'e': {
                            value = this.track.getValueAtEnd(begin, end);
                            break;
                        }
                        case 'm': {
                            value = this.track.getMedian(begin, end);
                            break;
                        }
                        case 'r': {
                            value = this.track.getRange(begin, end);
                        }
                    }
                }
                catch (Exception ex) {
                    ExtractTrackDataCommand.this.transcription.setNotifying(true);
                    ClientLogger.LOG.warning("Exception occured during calculation: " + ex.getMessage());
                    ExtractTrackDataCommand.this.progressInterrupt("Exception occured during calculation: " + ex.getMessage());
                    return;
                }
                RefAnnotation ref = (RefAnnotation)this.destTier.getAnnotationAtTime(begin);
                if (ref == null) {
                    long mid = (begin + end) / 2L;
                    ref = (RefAnnotation)this.destTier.createAnnotation(mid, mid);
                    if (ref != null) {
                        if (value != Float.NaN) {
                            ref.setValue(format.format(value));
                        }
                        ExtractTrackDataCommand.this.newAnnos.add(new AnnotationDataRecord(ref));
                    } else {
                        ClientLogger.LOG.warning("Could not create a reference annotation at time: " + mid);
                    }
                } else if (this.overwrite) {
                    String valString = value != Float.NaN ? format.format(value) : "";
                    ExtractTrackDataCommand.this.changedAnnos.add(new ValueRecord(begin, ref.getValue(), valString));
                    ref.setValue(valString);
                }
                ExtractTrackDataCommand.this.progressUpdate((int)((float)(i + 1) * perAnn), null);
            }
            ExtractTrackDataCommand.this.transcription.setNotifying(true);
            ExtractTrackDataCommand.this.progressComplete("Operation complete...");
        }

        @Override
        public void interrupt() {
            ExtractTrackDataCommand.this.progressInterrupt("Operation interrupted...");
            super.interrupt();
        }
    }
}

