/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationValuesRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class LabelAndNumberCommand
implements UndoableCommand {
    private String commandName;
    private TranscriptionImpl transcription;
    private List<String> tierNames;
    private String prefix;
    private int numDigits;
    private int startIntValue = -1;
    private int intIncr = 0;
    private double startDoubleVal = -1.0;
    private double doubleIncr = 0.0;
    private int numDecimals = 0;
    private boolean numberCountPart = true;
    private ArrayList<AnnotationValuesRecord> records;

    public LabelAndNumberCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        this.setWaitCursor(true);
        this.transcription.setNotifying(false);
        String name = null;
        TierImpl tier = null;
        if (this.tierNames != null) {
            if (this.records != null) {
                Annotation ann = null;
                AnnotationValuesRecord record = null;
                for (int i = 0; i < this.records.size(); ++i) {
                    record = this.records.get(i);
                    name = record.getTierName();
                    if (tier == null || !tier.getName().equals(name)) {
                        tier = this.transcription.getTierWithId(name);
                    }
                    if (tier != null) {
                        ann = tier.getAnnotationAtTime(record.getBeginTime());
                        if (ann != null && ann.getEndTimeBoundary() == record.getEndTime()) {
                            ann.setValue(record.getValue());
                            continue;
                        }
                        ClientLogger.LOG.warning("The annotation could not be found for undo");
                        continue;
                    }
                    ClientLogger.LOG.warning("The tier could not be found: " + name);
                }
            } else {
                ClientLogger.LOG.info("No annotation records have been stored for undo.");
            }
        } else {
            ClientLogger.LOG.warning("No tier names have been stored.");
        }
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
    }

    @Override
    public void redo() {
        this.setWaitCursor(true);
        this.transcription.setNotifying(false);
        String name = null;
        TierImpl tier = null;
        if (this.tierNames != null) {
            if (this.records != null) {
                Annotation ann = null;
                AnnotationValuesRecord record = null;
                for (int i = 0; i < this.records.size(); ++i) {
                    record = this.records.get(i);
                    name = record.getTierName();
                    if (tier == null || !tier.getName().equals(name)) {
                        tier = this.transcription.getTierWithId(name);
                    }
                    if (tier != null) {
                        ann = tier.getAnnotationAtTime(record.getBeginTime());
                        if (ann != null && ann.getEndTimeBoundary() == record.getEndTime()) {
                            ann.setValue(record.getNewLabelValue());
                            continue;
                        }
                        ClientLogger.LOG.warning("The annotation could not be found for redo");
                        continue;
                    }
                    ClientLogger.LOG.warning("Could not find tier for redo: " + name);
                }
            } else {
                ClientLogger.LOG.info("No annotation records have been stored for undo.");
            }
        } else {
            ClientLogger.LOG.warning("No tier names have been stored.");
        }
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.tierNames = (List)arguments[0];
        this.prefix = (String)arguments[1];
        Object format = arguments[2];
        if (arguments[3] != null) {
            this.numDigits = (Integer)arguments[3];
        }
        Object startVal = arguments[4];
        Object incrementVal = arguments[5];
        if (this.prefix == null) {
            this.prefix = "";
        }
        if (format == null) {
            this.numberCountPart = false;
        } else {
            if (startVal instanceof Integer) {
                this.startIntValue = (Integer)startVal;
            } else {
                this.startDoubleVal = (Double)startVal;
            }
            if (incrementVal instanceof Integer) {
                this.intIncr = (Integer)incrementVal;
            } else {
                this.doubleIncr = (Double)incrementVal;
                String dv = String.valueOf(this.doubleIncr);
                this.numDecimals = dv.length() - dv.indexOf(".") - 1;
            }
        }
        this.changeAnnotationValues();
    }

    private void changeAnnotationValues() {
        this.setWaitCursor(true);
        this.transcription.setNotifying(false);
        TierImpl tier = null;
        List<Object> anns = null;
        if (this.tierNames == null || this.tierNames.size() == 0) {
            ClientLogger.LOG.warning("No tier selected.");
            this.transcription.setNotifying(true);
            this.setWaitCursor(false);
            return;
        }
        if (this.tierNames.size() == 1) {
            tier = this.transcription.getTierWithId(this.tierNames.get(0));
            if (tier == null) {
                ClientLogger.LOG.warning("The tier " + this.tierNames.get(0) + " does not exist.");
                this.transcription.setNotifying(true);
                this.setWaitCursor(false);
                return;
            }
            anns = tier.getAnnotations();
        } else {
            anns = new ArrayList();
            for (int i = 0; i < this.tierNames.size(); ++i) {
                String name = this.tierNames.get(i);
                tier = this.transcription.getTierWithId(name);
                if (tier != null) {
                    anns.addAll(tier.getAnnotations());
                    continue;
                }
                ClientLogger.LOG.warning("The tier " + name + " does not exist.");
            }
            Collections.sort(anns);
        }
        this.records = new ArrayList(anns.size());
        Annotation ann = null;
        String nextLabel = null;
        AnnotationValuesRecord record = null;
        for (int i = 0; i < anns.size(); ++i) {
            ann = (Annotation)anns.get(i);
            nextLabel = this.getNextLabel(i);
            record = new AnnotationValuesRecord(ann);
            record.setNewLabelValue(nextLabel);
            this.records.add(record);
            ann.setValue(nextLabel);
        }
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
    }

    private String getNextLabel(int count) {
        if (this.numberCountPart) {
            if (this.startIntValue > -1) {
                if (this.numDigits == 1) {
                    return this.prefix + String.valueOf(this.startIntValue + count * this.intIncr);
                }
                StringBuilder sb = new StringBuilder(String.valueOf(this.startIntValue + count * this.intIncr));
                while (sb.length() < this.numDigits) {
                    sb.insert(0, 0);
                }
                return this.prefix + sb.toString();
            }
            if (this.startDoubleVal > -1.0) {
                double nd = this.startDoubleVal + (double)count * this.doubleIncr;
                if (this.numDigits == 1) {
                    String sv = String.valueOf(this.startDoubleVal + (double)count * this.doubleIncr);
                    if (sv.length() - sv.indexOf(".") - 1 > this.numDecimals) {
                        sv = sv.substring(0, sv.indexOf(".") + this.numDecimals);
                    }
                    return this.prefix + sv;
                }
                StringBuilder sb = new StringBuilder(String.valueOf(nd));
                while (sb.indexOf(".") < this.numDigits) {
                    sb.insert(0, 0);
                }
                if (sb.length() - sb.indexOf(".") - 1 > this.numDecimals) {
                    return this.prefix + sb.substring(0, sb.indexOf(".") + 1 + this.numDecimals);
                }
                return this.prefix + sb.toString();
            }
            return this.prefix;
        }
        return this.prefix;
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

