/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import java.util.List;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.imports.MergeUtil;
import mpi.eudico.client.annotator.imports.UndoableTranscriptionMerger;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class MergeTranscriptionsByAddingCommand
implements UndoableCommand {
    private String name;
    private TranscriptionImpl firstTrans;
    private TranscriptionImpl secondTrans;
    private UndoableTranscriptionMerger merger;
    private List<String> tierNames;
    private boolean processSameNameTiers = false;
    private boolean overwrite = false;
    private boolean addLinkedFiles = false;
    private boolean checkTierCompatibility = true;

    public MergeTranscriptionsByAddingCommand(String name) {
        this.name = name;
    }

    @Override
    public void redo() {
        if (this.merger != null) {
            this.merger.redo();
        }
    }

    @Override
    public void undo() {
        if (this.merger != null) {
            this.merger.undo();
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.firstTrans = (TranscriptionImpl)receiver;
        this.secondTrans = (TranscriptionImpl)arguments[0];
        this.tierNames = (List)arguments[1];
        if (arguments.length > 2) {
            this.processSameNameTiers = (Boolean)arguments[2];
        }
        if (arguments.length > 3) {
            this.overwrite = (Boolean)arguments[3];
        }
        if (arguments.length > 4) {
            this.addLinkedFiles = (Boolean)arguments[4];
        }
        if (arguments.length > 5) {
            this.checkTierCompatibility = (Boolean)arguments[5];
        }
        this.startMerge();
    }

    private void startMerge() {
        if (this.checkTierCompatibility) {
            MergeUtil mergeUtil = new MergeUtil();
            List<TierImpl> addableTiers = mergeUtil.getAddableTiers(this.secondTrans, this.firstTrans, this.tierNames);
            ArrayList<String> addableTierNames = new ArrayList<String>(addableTiers.size());
            for (int i = 0; i < addableTiers.size(); ++i) {
                Tier t = addableTiers.get(i);
                addableTierNames.add(t.getName());
            }
            this.merger = new UndoableTranscriptionMerger();
            this.merger.mergeWith(this.firstTrans, this.secondTrans, this.overwrite, addableTierNames);
        } else {
            this.merger = new UndoableTranscriptionMerger();
            this.merger.mergeWith(this.firstTrans, this.secondTrans, this.overwrite, this.tierNames);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }
}

