/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.SaveAs27Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.imports.MergeUtil;
import mpi.eudico.client.annotator.prefs.PreferencesWriter;
import mpi.eudico.client.annotator.timeseries.config.SamplePosition;
import mpi.eudico.client.annotator.timeseries.config.TSSourceConfiguration;
import mpi.eudico.client.annotator.timeseries.config.TSTrackConfiguration;
import mpi.eudico.client.annotator.timeseries.io.TSConfigurationEncoder;
import mpi.eudico.client.annotator.timeseries.io.TSConfigurationParser;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.util.IoUtil;
import nl.mpi.util.FileUtility;
import org.w3c.dom.Element;

public class MergeTranscriptionsCommand
implements Command {
    private String commandName;
    private List<ProgressListener> listeners;
    private TranscriptionImpl destTrans;
    private TranscriptionImpl srcTrans;
    private String fileName;
    private List<String> selTiers;
    private boolean overwrite;
    private boolean addLinkedFiles;
    private boolean copyAndRenameTiers = false;

    public MergeTranscriptionsCommand(String theName) {
        this.commandName = theName;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.destTrans = (TranscriptionImpl)receiver;
        this.srcTrans = (TranscriptionImpl)arguments[0];
        this.fileName = (String)arguments[1];
        this.selTiers = (List)arguments[2];
        this.overwrite = (Boolean)arguments[3];
        this.addLinkedFiles = (Boolean)arguments[4];
        if (arguments.length >= 6) {
            this.copyAndRenameTiers = (Boolean)arguments[5];
        }
        if (this.destTrans == null) {
            this.progressInterrupt("No first transcription (destination) specified.");
            return;
        }
        this.destTrans.setNotifying(false);
        if (this.srcTrans == null) {
            this.progressInterrupt("No second transcription (source) specified");
            return;
        }
        if (this.fileName == null) {
            this.progressInterrupt("No filename specified");
            return;
        }
        if (this.selTiers == null) {
            this.progressInterrupt("No tiers specifed");
            return;
        }
        new MergeThread().start();
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    public synchronized void addProgressListener(ProgressListener pl) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ProgressListener>(2);
        }
        this.listeners.add(pl);
    }

    public synchronized void removeProgressListener(ProgressListener pl) {
        if (pl != null && this.listeners != null) {
            this.listeners.remove(pl);
        }
    }

    private void progressUpdate(int percent, String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressUpdated(this, percent, message);
            }
        }
    }

    private void progressComplete(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressCompleted(this, message);
            }
        }
    }

    private void progressInterrupt(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressInterrupted(this, message);
            }
        }
    }

    class MergeThread
    extends Thread {
        MergeThread() {
        }

        MergeThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            try {
                TierImpl t;
                MergeTranscriptionsCommand.this.progressUpdate(5, "Checking tiers to add...");
                MergeUtil mergeUtil = new MergeUtil();
                Map<String, String> tierNameMap = null;
                if (MergeTranscriptionsCommand.this.copyAndRenameTiers) {
                    tierNameMap = mergeUtil.getRenamingTierMap(MergeTranscriptionsCommand.this.srcTrans, MergeTranscriptionsCommand.this.destTrans, MergeTranscriptionsCommand.this.selTiers);
                    for (Map.Entry<String, String> entry : tierNameMap.entrySet()) {
                        if (entry.getKey().equals(entry.getValue())) continue;
                        MergeTranscriptionsCommand.this.srcTrans.getTierWithId(entry.getKey()).setName(entry.getValue());
                        MergeTranscriptionsCommand.this.selTiers.set(MergeTranscriptionsCommand.this.selTiers.indexOf(entry.getKey()), entry.getValue());
                    }
                }
                List<TierImpl> tiersToAdd = mergeUtil.getAddableTiers(MergeTranscriptionsCommand.this.srcTrans, MergeTranscriptionsCommand.this.destTrans, MergeTranscriptionsCommand.this.selTiers);
                MergeTranscriptionsCommand.this.progressUpdate(10, "Sorting the tiers to add...");
                tiersToAdd = mergeUtil.sortTiers(tiersToAdd);
                MergeTranscriptionsCommand.this.progressUpdate(20, "Creating the tiers. linguistic types, cv's...");
                mergeUtil.addTiersTypesAndCVs(MergeTranscriptionsCommand.this.srcTrans, MergeTranscriptionsCommand.this.destTrans, tiersToAdd);
                MergeTranscriptionsCommand.this.progressUpdate(30, "Adding annotations...");
                int numIndivTiers = 0;
                for (int i = 0; i < tiersToAdd.size(); ++i) {
                    t = tiersToAdd.get(i);
                    if (t.hasParentTier() && tiersToAdd.contains(t.getParentTier())) continue;
                    ++numIndivTiers;
                }
                if (numIndivTiers > 0) {
                    int progPerTier = 60 / numIndivTiers;
                    int count = 1;
                    for (int i = 0; i < tiersToAdd.size(); ++i) {
                        t = tiersToAdd.get(i);
                        if (t.hasParentTier() && tiersToAdd.contains(t.getParentTier())) continue;
                        this.addAnnotations(t);
                        MergeTranscriptionsCommand.this.progressUpdate(30 + count * progPerTier, "Merging of tier " + t.getName() + " done.");
                    }
                }
                List<TSSourceConfiguration> confList = null;
                if (MergeTranscriptionsCommand.this.addLinkedFiles) {
                    List<MediaDescriptor> mediadescriptors = MergeTranscriptionsCommand.this.srcTrans.getMediaDescriptors();
                    List<MediaDescriptor> destmediaDescriptors = MergeTranscriptionsCommand.this.destTrans.getMediaDescriptors();
                    for (int i = 0; i < mediadescriptors.size(); ++i) {
                        if (destmediaDescriptors.contains(mediadescriptors.get(i))) continue;
                        destmediaDescriptors.add(mediadescriptors.get(i));
                    }
                    List<LinkedFileDescriptor> descriptors = MergeTranscriptionsCommand.this.srcTrans.getLinkedFileDescriptors();
                    List<LinkedFileDescriptor> destDescriptors = MergeTranscriptionsCommand.this.destTrans.getLinkedFileDescriptors();
                    confList = this.getTSConfigList(destDescriptors, descriptors);
                    for (int i = 0; i < descriptors.size(); ++i) {
                        if (destDescriptors.contains(descriptors.get(i))) continue;
                        destDescriptors.add(descriptors.get(i));
                    }
                }
                if (confList != null && confList.size() > 0) {
                    TSConfigEncoder encoder = new TSConfigEncoder();
                    encoder.encodeAndSave((Collection<TSSourceConfiguration>)confList);
                }
                MergeTranscriptionsCommand.this.progressUpdate(92, "Saving transcription...");
                int saveAsType = SaveAs27Preferences.saveAsTypeWithCheck(MergeTranscriptionsCommand.this.destTrans);
                TranscriptionStore transcriptionStore = ACMTranscriptionStore.getCurrentTranscriptionStore();
                transcriptionStore.storeTranscription(MergeTranscriptionsCommand.this.destTrans, null, new ArrayList<TierImpl>(0), MergeTranscriptionsCommand.this.fileName, saveAsType);
                ClientLogger.LOG.info("Transcription saved to " + MergeTranscriptionsCommand.this.fileName);
                PreferencesWriter xmlPrefsWriter = new PreferencesWriter();
                Object prefName = MergeTranscriptionsCommand.this.fileName.substring(0, MergeTranscriptionsCommand.this.fileName.lastIndexOf(46));
                prefName = (String)prefName + ".pfsx";
                Map<String, Object> destPrefs = Preferences.loadPreferencesForFile(MergeTranscriptionsCommand.this.destTrans.getFullPath());
                Map<String, Object> srcPrefs = Preferences.loadPreferencesForFile(MergeTranscriptionsCommand.this.srcTrans.getFullPath());
                this.mergePrefs(destPrefs, srcPrefs);
                xmlPrefsWriter.encodeAndSave(destPrefs, (String)prefName);
                if (MergeTranscriptionsCommand.this.copyAndRenameTiers && tierNameMap != null) {
                    for (Map.Entry<String, String> entry : tierNameMap.entrySet()) {
                        if (entry.getKey().equals(entry.getValue())) continue;
                        MergeTranscriptionsCommand.this.srcTrans.getTierWithId(entry.getValue()).setName(entry.getKey());
                        MergeTranscriptionsCommand.this.selTiers.set(MergeTranscriptionsCommand.this.selTiers.indexOf(entry.getValue()), entry.getKey());
                    }
                }
                MergeTranscriptionsCommand.this.progressComplete("Merging complete");
            }
            catch (Exception ex) {
                ClientLogger.LOG.severe("Error while merging: " + ex.getMessage());
                ex.printStackTrace();
                MergeTranscriptionsCommand.this.progressInterrupt("Error while merging: " + ex.getMessage());
            }
        }

        private List<TSSourceConfiguration> getTSConfigList(List<LinkedFileDescriptor> firstSrcDescriptors, List<LinkedFileDescriptor> secondSrcDescriptors) {
            ArrayList<TSSourceConfiguration> confList = new ArrayList<TSSourceConfiguration>();
            ArrayList<String> trackNamesList = new ArrayList<String>();
            this.addConfs(firstSrcDescriptors, trackNamesList, confList);
            this.addConfs(secondSrcDescriptors, trackNamesList, confList);
            return confList;
        }

        private void addConfs(List<LinkedFileDescriptor> descriptors, List<String> trackNamesList, List<TSSourceConfiguration> confList) {
            int i = 0;
            TSSourceConfiguration srcConf = null;
            TSConfigurationParser parser = new TSConfigurationParser();
            while (i < descriptors.size()) {
                String path = descriptors.get((int)i).linkURL;
                if (path.endsWith("_tsconf.xml")) {
                    List<TSSourceConfiguration> confs;
                    if ((path = FileUtility.urlToAbsPath(path)).startsWith("file:")) {
                        path = path.substring(5);
                    }
                    if ((confs = parser.parseSourceConfigs(path)) == null || confs.size() <= 0) continue;
                    for (int c = 0; c < confs.size(); ++c) {
                        if (!(confs.get(c) instanceof TSSourceConfiguration)) continue;
                        srcConf = confs.get(c);
                        Iterator<Object> it = srcConf.objectKeySet().iterator();
                        Object newTrackName = null;
                        while (it.hasNext()) {
                            String trackName = (String)it.next();
                            TSTrackConfiguration tracConf = (TSTrackConfiguration)srcConf.getObject(trackName);
                            int n = 0;
                            int index = trackName.lastIndexOf(45);
                            newTrackName = trackName;
                            if (trackNamesList.contains(newTrackName)) {
                                if (index > 0 && index < trackName.length() - 1) {
                                    String num = trackName.substring(index + 1);
                                    try {
                                        n = Integer.parseInt(num);
                                        ++n;
                                    }
                                    catch (NumberFormatException ne) {
                                        n = 0;
                                    }
                                }
                                newTrackName = trackName.substring(0, index) + "-" + n;
                                while (trackNamesList.contains(newTrackName)) {
                                    newTrackName = ((String)newTrackName).substring(0, index) + "-" + ++n;
                                }
                            }
                            trackNamesList.add((String)newTrackName);
                            tracConf.setTrackName((String)newTrackName);
                            srcConf.removeObject(trackName);
                            srcConf.putObject(newTrackName, tracConf);
                        }
                        confList.add(srcConf);
                    }
                    descriptors.remove(i);
                    continue;
                }
                ++i;
            }
        }

        private void addAnnotations(TierImpl tier) {
            TierImpl parent = tier.getParentTier();
            TierImpl destTier = MergeTranscriptionsCommand.this.destTrans.getTierWithId(tier.getName());
            if (destTier == null) {
                ClientLogger.LOG.warning("Destination tier " + tier.getName() + " not found in destination description");
                return;
            }
            DefaultMutableTreeNode recordNode = null;
            if (parent != null) {
                LinguisticType lt = tier.getLinguisticType();
                if (lt.getConstraints() == null) {
                    ClientLogger.LOG.warning("Error: illegal type for tier: " + tier.getName());
                    return;
                }
                if (lt.getConstraints().getStereoType() == 4) {
                    List<AbstractAnnotation> annotations = tier.getAnnotations();
                    for (AbstractAnnotation ann : annotations) {
                        List<Annotation> overlapAnn = destTier.getOverlappingAnnotations(ann.getBeginTimeBoundary(), ann.getEndTimeBoundary());
                        if (overlapAnn.size() > 0) {
                            if (!MergeTranscriptionsCommand.this.overwrite) continue;
                            recordNode = AnnotationRecreator.createTreeForAnnotation(ann);
                            for (Annotation a : overlapAnn) {
                                destTier.removeAnnotation(a);
                            }
                            AnnotationRecreator.createAnnotationFromTree(MergeTranscriptionsCommand.this.destTrans, recordNode);
                            continue;
                        }
                        recordNode = AnnotationRecreator.createTreeForAnnotation(ann);
                        AnnotationRecreator.createAnnotationFromTree(MergeTranscriptionsCommand.this.destTrans, recordNode);
                    }
                } else {
                    ArrayList<DefaultMutableTreeNode> group = new ArrayList<DefaultMutableTreeNode>();
                    TierImpl rootTier = tier.getRootTier();
                    Annotation curParent = null;
                    List<AbstractAnnotation> annotations = tier.getAnnotations();
                    TreeSet<Annotation> existingAnnos = new TreeSet<Annotation>();
                    for (AbstractAnnotation ann : annotations) {
                        List<Annotation> overlapAnn = destTier.getOverlappingAnnotations(ann.getBeginTimeBoundary(), ann.getEndTimeBoundary());
                        int numOverlap = overlapAnn.size();
                        if (curParent == null) {
                            existingAnnos.addAll(overlapAnn);
                            if (MergeTranscriptionsCommand.this.overwrite || numOverlap == 0) {
                                group.add(AnnotationRecreator.createTreeForAnnotation(ann));
                            }
                            curParent = rootTier.getAnnotationAtTime(ann.getBeginTimeBoundary());
                            continue;
                        }
                        if (rootTier.getAnnotationAtTime(ann.getBeginTimeBoundary()) == curParent) {
                            existingAnnos.addAll(overlapAnn);
                            if (!MergeTranscriptionsCommand.this.overwrite && numOverlap != 0) continue;
                            group.add(AnnotationRecreator.createTreeForAnnotation(ann));
                            continue;
                        }
                        if (group.size() > 0) {
                            if (MergeTranscriptionsCommand.this.overwrite && lt.getConstraints().getStereoType() == 3 && !existingAnnos.isEmpty()) {
                                for (Annotation a : existingAnnos) {
                                    destTier.removeAnnotation(a);
                                }
                            }
                            AnnotationRecreator.createAnnotationsSequentially(MergeTranscriptionsCommand.this.destTrans, group);
                        }
                        existingAnnos.clear();
                        group = new ArrayList();
                        curParent = rootTier.getAnnotationAtTime(ann.getBeginTimeBoundary());
                        existingAnnos.addAll(overlapAnn);
                        if (!MergeTranscriptionsCommand.this.overwrite && numOverlap != 0) continue;
                        group.add(AnnotationRecreator.createTreeForAnnotation(ann));
                    }
                    if (group.size() > 0) {
                        if (MergeTranscriptionsCommand.this.overwrite && lt.getConstraints().getStereoType() == 3 && !existingAnnos.isEmpty()) {
                            for (Annotation a : existingAnnos) {
                                destTier.removeAnnotation(a);
                            }
                            existingAnnos.clear();
                        }
                        AnnotationRecreator.createAnnotationsSequentially(MergeTranscriptionsCommand.this.destTrans, group);
                    }
                }
            } else {
                List<AbstractAnnotation> annotations = tier.getAnnotations();
                for (AbstractAnnotation ann : annotations) {
                    if (!MergeTranscriptionsCommand.this.overwrite && destTier.getOverlappingAnnotations(ann.getBeginTimeBoundary(), ann.getEndTimeBoundary()).size() != 0) continue;
                    recordNode = AnnotationRecreator.createTreeForAnnotation(ann);
                    AnnotationRecreator.createAnnotationFromTree(MergeTranscriptionsCommand.this.destTrans, recordNode);
                }
            }
            ClientLogger.LOG.info("Merging of tier " + tier.getName() + " done.");
        }

        private void mergePrefs(Map<String, Map> destPrefs, Map srcPrefs) {
            if (destPrefs == null) {
                return;
            }
            if (srcPrefs == null) {
                return;
            }
            String TIER_FONTS = "TierFonts";
            Object srcPrefMap = srcPrefs.get("TierFonts");
            Map destPrefMap = destPrefs.get("TierFonts");
            if (srcPrefMap instanceof Map) {
                Map srcFontsMap = (Map)srcPrefMap;
                HashMap destFontMap = null;
                if (destPrefMap instanceof Map) {
                    destFontMap = destPrefMap;
                } else {
                    destFontMap = new HashMap();
                    destPrefs.put("TierFonts", destFontMap);
                }
                for (Object key : srcFontsMap.keySet()) {
                    if (MergeTranscriptionsCommand.this.selTiers != null && !MergeTranscriptionsCommand.this.selTiers.contains(key) || destFontMap.containsKey(key)) continue;
                    destFontMap.put(key, srcFontsMap.get(key));
                }
            }
            String TIER_COLORS = "TierColors";
            srcPrefMap = srcPrefs.get("TierColors");
            destPrefMap = destPrefs.get("TierColors");
            if (srcPrefMap instanceof Map) {
                Map srcColMap = (Map)srcPrefMap;
                HashMap destColMap = null;
                if (destPrefMap instanceof Map) {
                    destColMap = destPrefMap;
                } else {
                    destColMap = new HashMap();
                    destPrefs.put("TierColors", destColMap);
                }
                for (Object key : srcColMap.keySet()) {
                    if (MergeTranscriptionsCommand.this.selTiers != null && !MergeTranscriptionsCommand.this.selTiers.contains(key) || destColMap.containsKey(key)) continue;
                    destColMap.put(key, srcColMap.get(key));
                }
            }
            String TIER_HIGH = "TierHighlightColors";
            srcPrefMap = srcPrefs.get("TierHighlightColors");
            destPrefMap = destPrefs.get("TierHighlightColors");
            if (srcPrefMap instanceof Map) {
                Map srcHighMap = (Map)srcPrefMap;
                HashMap destHighMap = null;
                if (destPrefMap instanceof Map) {
                    destHighMap = (HashMap)destPrefMap;
                } else {
                    destHighMap = new HashMap();
                    destPrefs.put("TierHighlightColors", destHighMap);
                }
                for (String key : srcHighMap.keySet()) {
                    if (MergeTranscriptionsCommand.this.selTiers != null && !MergeTranscriptionsCommand.this.selTiers.contains(key) || destHighMap.containsKey(key)) continue;
                    destHighMap.put(key, srcHighMap.get(key));
                }
            }
            String CV_PREFS = "CV.ML.Prefs";
            srcPrefMap = srcPrefs.get("CV.ML.Prefs");
            destPrefMap = destPrefs.get("CV.ML.Prefs");
            if (srcPrefMap instanceof Map) {
                Map srcCVMap = (Map)srcPrefMap;
                HashMap destCVMap = null;
                if (destPrefMap instanceof Map) {
                    destCVMap = (HashMap)destPrefMap;
                } else {
                    destCVMap = new HashMap();
                    destPrefs.put("CV.ML.Prefs", destCVMap);
                }
                for (String key : srcCVMap.keySet()) {
                    if (MergeTranscriptionsCommand.this.destTrans.getControlledVocabulary(key) == null) continue;
                    if (!destCVMap.containsKey(key)) {
                        destCVMap.put(key, srcCVMap.get(key));
                        continue;
                    }
                    Object curDestCVObject = destCVMap.get(key);
                    Object curSrcCVObject = srcCVMap.get(key);
                    if (!(curDestCVObject instanceof Map) || !(curSrcCVObject instanceof Map)) continue;
                    Map curSrcCV = (Map)curSrcCVObject;
                    Map curDestCV = (Map)curDestCVObject;
                    for (String entryKey : curSrcCV.keySet()) {
                        if (curDestCV.containsKey(entryKey)) continue;
                        curDestCV.put(entryKey, curSrcCV.get(entryKey));
                    }
                }
            }
        }
    }

    private class TSConfigEncoder
    extends TSConfigurationEncoder {
        public void encodeAndSave(Collection<TSSourceConfiguration> tsConfigs) {
            this.configFile = this.createPath(MergeTranscriptionsCommand.this.fileName);
            this.doc = this.createNewDocument();
            if (this.doc != null) {
                Element docElement = this.createDOM(tsConfigs);
                try {
                    LinkedFileDescriptor lfd;
                    IoUtil.writeEncodedFile("UTF-8", this.configFile.substring(5), docElement);
                    ClientLogger.LOG.info("Configuration file saved: " + this.configFile);
                    for (int i = 0; i < MergeTranscriptionsCommand.this.destTrans.getLinkedFileDescriptors().size(); ++i) {
                        lfd = MergeTranscriptionsCommand.this.destTrans.getLinkedFileDescriptors().get(i);
                        if (!lfd.linkURL.toLowerCase().endsWith("_tsconf.xml")) continue;
                        return;
                    }
                    lfd = new LinkedFileDescriptor(this.configFile, "text/xml");
                    MergeTranscriptionsCommand.this.destTrans.getLinkedFileDescriptors().add(lfd);
                }
                catch (Exception e) {
                    ClientLogger.LOG.warning("Could not save configuration file: " + e.getMessage());
                }
            }
        }

        @Override
        protected Element createTrackElement(TSTrackConfiguration trConfig) {
            SamplePosition spos;
            if (trConfig == null || trConfig.getTrackName() == null) {
                return null;
            }
            Element trackElem = this.doc.createElement("track");
            trackElem.setAttribute("name", trConfig.getTrackName());
            Enumeration<?> propEnum = trConfig.propertyNames();
            String minVal = null;
            String maxVal = null;
            while (propEnum.hasMoreElements()) {
                String prop = (String)propEnum.nextElement();
                String val = trConfig.getProperty(prop);
                if (prop.equals("derivative")) {
                    trackElem.setAttribute("derivative", val);
                    continue;
                }
                if (prop.equals("description")) {
                    Element descElem = this.doc.createElement("description");
                    descElem.appendChild(this.doc.createTextNode(val));
                    trackElem.appendChild(descElem);
                    continue;
                }
                if (prop.equals("units")) {
                    Element unitElem = this.doc.createElement("units");
                    unitElem.appendChild(this.doc.createTextNode(val));
                    trackElem.appendChild(unitElem);
                    continue;
                }
                if (prop.equals("min")) {
                    minVal = val;
                    continue;
                }
                if (prop.equals("max")) {
                    maxVal = val;
                    continue;
                }
                if (prop.equals("color")) {
                    Element colElem = this.doc.createElement("color");
                    colElem.appendChild(this.doc.createTextNode(val));
                    trackElem.appendChild(colElem);
                    continue;
                }
                Element propElem = this.createPropertyElement(prop, val);
                if (propElem == null) continue;
                trackElem.appendChild(propElem);
            }
            if (minVal != null && maxVal != null) {
                Element rangeElem = this.doc.createElement("range");
                rangeElem.setAttribute("min", minVal);
                rangeElem.setAttribute("max", maxVal);
                trackElem.appendChild(rangeElem);
            }
            if ((spos = trConfig.getSamplePos()) != null) {
                Element spElem = this.doc.createElement("sample-position");
                if (spos.getDescription() != null) {
                    Element ds = this.doc.createElement("description");
                    ds.appendChild(this.doc.createTextNode(spos.getDescription()));
                    spElem.appendChild(ds);
                }
                for (int i = 0; i < spos.getRows().length; ++i) {
                    Element pos = this.doc.createElement("pos");
                    pos.setAttribute("row", String.valueOf(spos.getRows()[i]));
                    pos.setAttribute("col", String.valueOf(spos.getColumns()[i]));
                    spElem.appendChild(pos);
                }
                trackElem.appendChild(spElem);
            }
            return trackElem;
        }
    }
}

