/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.MonitoringLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceGroup;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class ModifyAnnotationCommand
implements UndoableCommand {
    private String commandName;
    private Transcription transcription;
    private AnnotationDataRecord annotationRecord;
    private String oldValue;
    private String newValue;
    private ExternalReference oldExtRef;
    private ExternalReference newExtRef;
    private String newCveId;

    public ModifyAnnotationCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        TierImpl tier;
        Annotation annotation;
        if (this.annotationRecord != null && this.transcription != null && (annotation = (tier = (TierImpl)this.transcription.getTierWithId(this.annotationRecord.getTierName())).getAnnotationAtTime(this.annotationRecord.getBeginTime())) != null && annotation.getEndTimeBoundary() == this.annotationRecord.getEndTime()) {
            annotation.setCVEntryId(this.annotationRecord.getCvEntryId());
            ((AbstractAnnotation)annotation).setExtRef(this.oldExtRef);
            annotation.setValue(this.oldValue);
            if (MonitoringLogger.isInitiated()) {
                MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.UNDO, MonitoringLogger.CHANGE_ANNOTATION_VALUE);
            }
        }
    }

    @Override
    public void redo() {
        TierImpl tier;
        Annotation annotation;
        if (this.annotationRecord != null && this.transcription != null && (annotation = (tier = (TierImpl)this.transcription.getTierWithId(this.annotationRecord.getTierName())).getAnnotationAtTime(this.annotationRecord.getBeginTime())) != null && annotation.getEndTimeBoundary() == this.annotationRecord.getEndTime()) {
            annotation.setCVEntryId(this.newCveId);
            ModifyAnnotationCommand.replaceExternalReference((AbstractAnnotation)annotation, this.newExtRef);
            annotation.setValue(this.newValue);
            if (MonitoringLogger.isInitiated()) {
                MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.REDO, MonitoringLogger.CHANGE_ANNOTATION_VALUE);
            }
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        AbstractAnnotation annotation = (AbstractAnnotation)receiver;
        if (annotation != null) {
            this.transcription = annotation.getTier().getTranscription();
        }
        this.annotationRecord = new AnnotationDataRecord(annotation);
        this.oldValue = (String)arguments[0];
        this.newValue = (String)arguments[1];
        if (arguments.length >= 3) {
            ExternalReferenceImpl eri = (ExternalReferenceImpl)arguments[2];
            try {
                if (annotation.getExtRef() instanceof ExternalReference) {
                    this.oldExtRef = annotation.getExtRef().clone();
                }
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            this.newExtRef = eri;
            ModifyAnnotationCommand.replaceExternalReference(annotation, eri);
        }
        this.newCveId = arguments.length >= 3 ? (String)arguments[3] : null;
        annotation.setCVEntryId(this.newCveId);
        annotation.setValue(this.newValue);
        if (MonitoringLogger.isInitiated()) {
            MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.CHANGE_ANNOTATION_VALUE, new String[0]);
        }
    }

    public static void replaceExternalReference(AbstractAnnotation annotation, ExternalReference eri) {
        ArrayList<ExternalReference> eriList = new ArrayList<ExternalReference>();
        int listIndex = 0;
        if (eri != null) {
            eriList.add(eri);
        }
        while (listIndex < eriList.size()) {
            ExternalReference externalReference = (ExternalReference)eriList.get(listIndex);
            if (externalReference instanceof ExternalReferenceGroup) {
                eriList.addAll(((ExternalReferenceGroup)externalReference).getAllReferences());
            }
            ++listIndex;
        }
        for (ExternalReference er : eriList) {
            if (er == null || er instanceof ExternalReferenceGroup) continue;
            String value = annotation.getExtRefValue(er.getReferenceType());
            annotation.removeExtRef(new ExternalReferenceImpl(value, er.getReferenceType()));
            if (er.getValue() == null) continue;
            annotation.addExtRef(er);
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

