/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.MonitoringLogger;
import mpi.eudico.client.annotator.util.TimeShiftRecord;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ModifyAnnotationTimeCommand
implements UndoableCommand {
    private String commandName;
    private AlignableAnnotation annotation;
    private DefaultMutableTreeNode rootNode;
    private TranscriptionImpl transcription;
    private TierImpl tier;
    private TierImpl rootTier;
    private int timePropMode;
    private int leftOffset;
    private int rightOffset;
    private long oldBeginTime;
    private long oldEndTime;
    private long newBeginTime;
    private long newEndTime;
    private ArrayList<DefaultMutableTreeNode> removedAnnotations;
    private ArrayList<Object> changedAnnotations;

    public ModifyAnnotationTimeCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        if (!(receiver instanceof AlignableAnnotation)) {
            return;
        }
        this.annotation = (AlignableAnnotation)receiver;
        this.oldBeginTime = this.annotation.getBeginTimeBoundary();
        this.oldEndTime = this.annotation.getEndTimeBoundary();
        this.newBeginTime = (Long)arguments[0];
        if (this.newBeginTime < 0L) {
            if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                ClientLogger.LOG.fine("New begin time < 0, changing to 0");
            }
            this.newBeginTime = 0L;
        }
        this.newEndTime = (Long)arguments[1];
        if (this.newEndTime <= this.newBeginTime) {
            if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                ClientLogger.LOG.fine("Cannot modify annotation times: end time <= begin time");
            }
            return;
        }
        this.leftOffset = (int)(this.newBeginTime - this.oldBeginTime);
        this.rightOffset = (int)(this.newEndTime - this.oldEndTime);
        if (this.oldBeginTime == this.newBeginTime && this.oldEndTime == this.newEndTime) {
            if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                ClientLogger.LOG.fine("Cannot modify annotation times: no changes in begin or end time");
            }
            return;
        }
        this.tier = (TierImpl)this.annotation.getTier();
        if (this.tier.hasParentTier()) {
            this.rootTier = this.tier.getRootTier();
        }
        this.transcription = this.tier.getTranscription();
        this.setWaitCursor(true);
        boolean snapAnnotations = false;
        boolean stickToVideoFrames = false;
        Boolean boolPref = Preferences.getBool("SnapAnnotations", null);
        if (boolPref != null) {
            snapAnnotations = boolPref;
        }
        if ((boolPref = Preferences.getBool("StickAnnotationsWithVideoFrames", null)) != null) {
            stickToVideoFrames = boolPref;
        }
        if (stickToVideoFrames && this.tier.isTimeAlignable() && (!this.tier.hasParentTier() || this.tier.getLinguisticType().getConstraints().getStereoType() == 1)) {
            this.newBeginTime = this.getStartPointOfFrame(this.newBeginTime);
            this.newEndTime = this.getEndPointOfFrame(this.newEndTime);
        }
        if (snapAnnotations) {
            long snapValue = 0L;
            Long longPref = Preferences.getLong("SnapAnnotationsValue", null);
            if (longPref != null) {
                snapValue = longPref;
            }
            if (snapValue > 0L) {
                AbstractAnnotation annAfter;
                long firstDiff;
                long secDiff = firstDiff = Long.MAX_VALUE;
                boolean durationChanged = this.oldEndTime - this.oldBeginTime != this.newEndTime - this.newBeginTime;
                boolean changeLeft = false;
                boolean changeRight = false;
                AbstractAnnotation annBefore = (AbstractAnnotation)this.tier.getAnnotationAtTime(this.newBeginTime);
                if (annBefore == null || annBefore == this.annotation) {
                    annBefore = (AbstractAnnotation)this.tier.getAnnotationBefore(this.newBeginTime);
                }
                if ((annAfter = (AbstractAnnotation)this.tier.getAnnotationAtTime(this.newEndTime)) == null || annAfter == this.annotation) {
                    annAfter = (AbstractAnnotation)this.tier.getAnnotationAfter(this.newEndTime);
                }
                if (annBefore != null && (firstDiff = this.newBeginTime - annBefore.getEndTimeBoundary()) != 0L && firstDiff >= -snapValue && firstDiff <= snapValue) {
                    changeLeft = true;
                }
                if (annAfter != null && (secDiff = annAfter.getBeginTimeBoundary() - this.newEndTime) != 0L && secDiff >= -snapValue && secDiff <= snapValue) {
                    changeRight = true;
                }
                if (changeLeft && changeRight && !durationChanged) {
                    if (Math.abs(firstDiff) <= Math.abs(secDiff)) {
                        changeRight = false;
                    } else {
                        changeLeft = false;
                    }
                }
                if (changeLeft) {
                    this.newBeginTime -= firstDiff;
                    if (!durationChanged) {
                        this.newEndTime -= firstDiff;
                    }
                }
                if (changeRight) {
                    this.newEndTime += secDiff;
                    if (!durationChanged) {
                        this.newBeginTime += secDiff;
                    }
                }
            }
        }
        this.changedAnnotations = new ArrayList();
        this.removedAnnotations = new ArrayList();
        this.timePropMode = this.transcription.getTimeChangePropagationMode();
        switch (this.timePropMode) {
            case 0: {
                this.storeNormal();
                break;
            }
            case 1: {
                this.storeBulldozer();
                break;
            }
            case 2: {
                this.storeShift();
            }
        }
        if (MonitoringLogger.isInitiated()) {
            MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.CHANGE_ANNOTATION_TIME, new String[0]);
        }
        this.annotation.updateTimeInterval(this.newBeginTime, this.newEndTime);
        boolPref = Preferences.getBool("ClearSelectionAfterCreation", null);
        ViewerManager2 vm = ELANCommandFactory.getViewerManager(this.transcription);
        if (boolPref != null) {
            if (boolPref.booleanValue()) {
                if (vm.getMediaPlayerController().getSelectionMode()) {
                    vm.getSelection().setSelection(vm.getMediaPlayerController().getMediaTime(), vm.getMediaPlayerController().getMediaTime());
                } else {
                    vm.getSelection().setSelection(0L, 0L);
                }
            }
        } else {
            vm.getSelection().setSelection(this.newBeginTime, this.newEndTime);
        }
        this.setWaitCursor(false);
    }

    public long getStartPointOfFrame(long time) {
        ViewerManager2 vm = ELANCommandFactory.getViewerManager(this.transcription);
        double milliSecondsPerSample = vm.getMasterMediaPlayer().getMilliSecondsPerSample();
        long curFrame = (long)((double)time / milliSecondsPerSample);
        curFrame = curFrame > 0L ? (long)((double)curFrame * milliSecondsPerSample) : 0L;
        return curFrame;
    }

    public long getEndPointOfFrame(long time) {
        ViewerManager2 vm = ELANCommandFactory.getViewerManager(this.transcription);
        double milliSecondsPerSample = vm.getMasterMediaPlayer().getMilliSecondsPerSample();
        long curFrame = (long)((double)time / milliSecondsPerSample);
        long newEnd = (long)((double)curFrame * milliSecondsPerSample);
        curFrame = newEnd != time ? (long)((double)(curFrame + 1L) * milliSecondsPerSample) : newEnd;
        return curFrame;
    }

    @Override
    public void undo() {
        if (this.oldBeginTime == this.newBeginTime && this.oldEndTime == this.newEndTime) {
            return;
        }
        if (this.newEndTime <= this.newBeginTime) {
            return;
        }
        this.transcription.setNotifying(false);
        this.setWaitCursor(true);
        switch (this.timePropMode) {
            case 0: {
                this.restoreNormal();
                break;
            }
            case 1: {
                this.restoreBulldozer();
                break;
            }
            case 2: {
                this.restoreShift();
            }
        }
        if (MonitoringLogger.isInitiated()) {
            MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.UNDO, MonitoringLogger.CHANGE_ANNOTATION_TIME);
        }
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
    }

    @Override
    public void redo() {
        if (this.oldBeginTime == this.newBeginTime && this.oldEndTime == this.newEndTime) {
            return;
        }
        if (this.newEndTime <= this.newBeginTime) {
            return;
        }
        this.setWaitCursor(true);
        AlignableAnnotation annotation = (AlignableAnnotation)this.tier.getAnnotationAtTime(this.oldBeginTime);
        if (annotation != null) {
            annotation.updateTimeInterval(this.newBeginTime, this.newEndTime);
            if (MonitoringLogger.isInitiated()) {
                MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.REDO, MonitoringLogger.CHANGE_ANNOTATION_TIME);
            }
        }
        this.setWaitCursor(false);
    }

    private void storeNormal() {
        List<Annotation> v;
        if (this.rootTier != null) {
            AbstractAnnotation aa = (AbstractAnnotation)this.rootTier.getAnnotationAtTime(this.oldBeginTime);
            if (aa != null) {
                this.rootNode = AnnotationRecreator.createTreeForAnnotation(aa);
            }
            return;
        }
        if (this.leftOffset > 0 || this.rightOffset < 0) {
            this.rootNode = AnnotationRecreator.createTreeForAnnotation(this.annotation);
        }
        if (this.leftOffset < 0 && (v = this.tier.getOverlappingAnnotations(this.newBeginTime, this.oldBeginTime)).size() > 0) {
            AbstractAnnotation ann = (AbstractAnnotation)v.get(0);
            if (ann.getBeginTimeBoundary() < this.newBeginTime) {
                this.changedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(ann));
            } else {
                this.removedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(ann));
            }
            for (int i = 1; i < v.size(); ++i) {
                this.removedAnnotations.add(AnnotationRecreator.createTreeForAnnotation((AbstractAnnotation)v.get(i)));
            }
        }
        if (this.rightOffset > 0 && (v = this.tier.getOverlappingAnnotations(this.oldEndTime, this.newEndTime)).size() > 0) {
            for (int i = 0; i < v.size(); ++i) {
                if (i != v.size() - 1) {
                    this.removedAnnotations.add(AnnotationRecreator.createTreeForAnnotation((AbstractAnnotation)v.get(i)));
                    continue;
                }
                AbstractAnnotation ann = (AbstractAnnotation)v.get(i);
                if (ann.getEndTimeBoundary() > this.newEndTime) {
                    this.changedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(ann));
                    continue;
                }
                this.removedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(ann));
            }
        }
    }

    private void restoreNormal() {
        if (this.tier == null) {
            return;
        }
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        if (this.rootTier != null) {
            AbstractAnnotation aa = (AbstractAnnotation)this.rootTier.getAnnotationAtTime(this.newBeginTime);
            if (aa != null) {
                this.rootTier.removeAnnotation(aa);
                AnnotationRecreator.createAnnotationFromTree(this.transcription, this.rootNode, true);
            }
        } else {
            DefaultMutableTreeNode node;
            int i;
            AlignableAnnotation actAnnotation = (AlignableAnnotation)this.tier.getAnnotationAtTime(this.newBeginTime);
            if (this.changedAnnotations.size() > 0) {
                for (i = 0; i < this.changedAnnotations.size(); ++i) {
                    node = (DefaultMutableTreeNode)this.changedAnnotations.get(i);
                    AnnotationDataRecord dataRecord = (AnnotationDataRecord)node.getUserObject();
                    AbstractAnnotation aa = dataRecord.getBeginTime() < this.oldBeginTime ? (AbstractAnnotation)this.tier.getAnnotationAtTime(dataRecord.getBeginTime()) : (AbstractAnnotation)this.tier.getAnnotationAtTime(dataRecord.getEndTime() - 1L);
                    if (aa == null) continue;
                    this.tier.removeAnnotation(aa);
                }
            }
            if (this.leftOffset > 0 || this.rightOffset < 0) {
                if (actAnnotation != null) {
                    this.tier.removeAnnotation(actAnnotation);
                }
                AnnotationRecreator.createAnnotationFromTree(this.transcription, this.rootNode, true);
            } else if (actAnnotation != null) {
                actAnnotation.updateTimeInterval(this.oldBeginTime, this.oldEndTime);
            }
            if (this.changedAnnotations.size() > 0) {
                for (i = 0; i < this.changedAnnotations.size(); ++i) {
                    node = (DefaultMutableTreeNode)this.changedAnnotations.get(i);
                    AnnotationRecreator.createAnnotationFromTree(this.transcription, node, true);
                }
            }
            if (this.removedAnnotations.size() > 0) {
                for (i = 0; i < this.removedAnnotations.size(); ++i) {
                    node = this.removedAnnotations.get(i);
                    AnnotationRecreator.createAnnotationFromTree(this.transcription, node, true);
                }
            }
        }
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    private void storeBulldozer() {
        int dist;
        int i;
        int gapBridged;
        int gapToBridge;
        int index;
        AbstractAnnotation cur;
        List<AbstractAnnotation> annos;
        if (this.rootTier != null) {
            this.storeNormal();
            return;
        }
        if (this.leftOffset > 0 || this.rightOffset < 0) {
            this.rootNode = AnnotationRecreator.createTreeForAnnotation(this.annotation);
        }
        if ((annos = this.tier.getAnnotations()) == null) {
            return;
        }
        if (this.leftOffset < 0) {
            cur = this.annotation;
            index = annos.indexOf(this.annotation);
            gapToBridge = -this.leftOffset;
            gapBridged = 0;
            for (i = index - 1; i >= 0; --i) {
                AbstractAnnotation prev = annos.get(i);
                dist = (int)(((AbstractAnnotation)cur).getBeginTimeBoundary() - prev.getEndTimeBoundary());
                if ((gapBridged += dist) >= gapToBridge) break;
                this.removedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(prev));
                this.changedAnnotations.add(new TimeShiftRecord(prev.getBeginTimeBoundary(), prev.getEndTimeBoundary(), -(gapToBridge - gapBridged)));
                cur = prev;
            }
        }
        if (this.rightOffset > 0) {
            AbstractAnnotation next;
            cur = this.annotation;
            index = annos.indexOf(this.annotation);
            gapToBridge = this.rightOffset;
            gapBridged = 0;
            for (i = index + 1; i < annos.size() && (gapBridged += (dist = (int)((next = annos.get(i)).getBeginTimeBoundary() - ((AbstractAnnotation)cur).getEndTimeBoundary()))) < gapToBridge; ++i) {
                this.changedAnnotations.add(new TimeShiftRecord(next.getBeginTimeBoundary(), next.getEndTimeBoundary(), gapToBridge - gapBridged));
                this.removedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(next));
                cur = next;
            }
        }
    }

    private void restoreBulldozer() {
        if (this.tier == null) {
            return;
        }
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        if (this.rootTier != null) {
            this.restoreNormal();
        } else {
            AlignableAnnotation actAnnotation = (AlignableAnnotation)this.tier.getAnnotationAtTime(this.newBeginTime);
            if (this.leftOffset > 0 || this.rightOffset < 0) {
                if (actAnnotation != null) {
                    this.tier.removeAnnotation(actAnnotation);
                    AnnotationRecreator.createAnnotationFromTree(this.transcription, this.rootNode, true);
                }
            } else if (actAnnotation != null) {
                actAnnotation.updateTimeInterval(this.oldBeginTime, this.oldEndTime);
            }
            if (this.changedAnnotations.size() > 0) {
                for (int i = 0; i < this.changedAnnotations.size(); ++i) {
                    TimeShiftRecord tsRecord = (TimeShiftRecord)this.changedAnnotations.get(i);
                    AlignableAnnotation aa = (AlignableAnnotation)this.tier.getAnnotationAtTime(tsRecord.newBegin);
                    DefaultMutableTreeNode node = this.removedAnnotations.get(i);
                    if (aa != null) {
                        this.tier.removeAnnotation(aa);
                    }
                    AnnotationRecreator.createAnnotationFromTree(this.transcription, node, true);
                }
            }
        }
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    private void storeShift() {
        List<Annotation> v;
        if (this.rootTier != null) {
            this.storeNormal();
            return;
        }
        if (this.leftOffset > 0 || this.rightOffset < 0) {
            this.rootNode = AnnotationRecreator.createTreeForAnnotation(this.annotation);
        }
        if (this.leftOffset < 0 && (v = this.tier.getOverlappingAnnotations(this.newBeginTime, this.oldBeginTime)).size() > 0) {
            AbstractAnnotation ann = (AbstractAnnotation)v.get(0);
            if (ann.getBeginTimeBoundary() < this.newBeginTime) {
                this.changedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(ann));
            } else {
                this.removedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(ann));
            }
            for (int i = 1; i < v.size(); ++i) {
                this.removedAnnotations.add(AnnotationRecreator.createTreeForAnnotation((AbstractAnnotation)v.get(i)));
            }
        }
    }

    private void restoreShift() {
        if (this.tier == null) {
            return;
        }
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        if (this.rootTier != null) {
            this.restoreNormal();
        } else {
            DefaultMutableTreeNode node;
            int i;
            AlignableAnnotation actAnnotation = (AlignableAnnotation)this.tier.getAnnotationAtTime(this.newBeginTime);
            if (this.changedAnnotations.size() > 0) {
                for (i = 0; i < this.changedAnnotations.size(); ++i) {
                    node = (DefaultMutableTreeNode)this.changedAnnotations.get(i);
                    AnnotationDataRecord dataRecord = (AnnotationDataRecord)node.getUserObject();
                    AbstractAnnotation aa = (AbstractAnnotation)this.tier.getAnnotationAtTime(dataRecord.getBeginTime());
                    if (aa == null) continue;
                    this.tier.removeAnnotation(aa);
                }
            }
            if ((this.leftOffset > 0 || this.rightOffset < 0) && actAnnotation != null) {
                this.tier.removeAnnotation(actAnnotation);
            }
            if (this.rightOffset > 0) {
                this.transcription.shiftBackward(this.oldBeginTime, -this.rightOffset);
            }
            if (this.leftOffset > 0 || this.rightOffset < 0) {
                AnnotationRecreator.createAnnotationFromTree(this.transcription, this.rootNode, true);
            } else if (actAnnotation != null) {
                actAnnotation.updateTimeInterval(this.oldBeginTime, this.oldEndTime);
            }
            if (this.changedAnnotations.size() > 0) {
                for (i = 0; i < this.changedAnnotations.size(); ++i) {
                    node = (DefaultMutableTreeNode)this.changedAnnotations.get(i);
                    AnnotationRecreator.createAnnotationFromTree(this.transcription, node, true);
                }
            }
            if (this.removedAnnotations.size() > 0) {
                for (i = 0; i < this.removedAnnotations.size(); ++i) {
                    node = this.removedAnnotations.get(i);
                    AnnotationRecreator.createAnnotationFromTree(this.transcription, node, true);
                }
            }
        }
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }
}

