/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Frame;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.TimeIntervalEditDialog;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;

public class ModifyAnnotationTimeDlgCommand
implements Command {
    private String commandName;

    public ModifyAnnotationTimeDlgCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        ViewerManager2 vm = (ViewerManager2)receiver;
        Annotation ann = (Annotation)arguments[0];
        if (ann instanceof AlignableAnnotation) {
            TimeIntervalEditDialog dialog = new TimeIntervalEditDialog((Frame)ELANCommandFactory.getRootFrame(vm.getTranscription()), true);
            dialog.setInterval(ann.getBeginTimeBoundary(), ann.getEndTimeBoundary());
            if (ann.hasParentAnnotation()) {
                Annotation parAnn = ann.getParentAnnotation();
                dialog.setLimits(parAnn.getBeginTimeBoundary(), parAnn.getEndTimeBoundary());
            } else {
                dialog.setLimits(0L, vm.getMasterMediaPlayer().getMediaDuration());
            }
            dialog.setVisible(true);
            long nextBT = dialog.getBeginTime();
            long nextET = dialog.getEndTime();
            if (nextBT > -1L && nextET > nextBT && (nextBT != ann.getBeginTimeBoundary() || nextET != ann.getEndTimeBoundary())) {
                Command com = ELANCommandFactory.createCommand(ann.getTier().getTranscription(), "CommandActions.ModifyAnnotationTime");
                com.execute(ann, new Object[]{nextBT, nextET});
            }
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

