/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import java.util.List;
import mpi.eudico.client.annotator.commands.ModifyAnnotationCommand;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ModifyOrAddDependentAnnotationsCommand
implements UndoableCommand {
    private String commandName;
    private TranscriptionImpl transcription;
    private long begin;
    private long end;
    private Object[] arguments;
    private List<String> prevTexts;
    private List<ExternalReference> prevExtRefs;
    private List<String> prevCveIds;

    public ModifyOrAddDependentAnnotationsCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        Annotation ann = (Annotation)receiver;
        this.begin = ann.getBeginTimeBoundary();
        this.end = ann.getEndTimeBoundary();
        this.arguments = arguments;
        TierImpl tier = (TierImpl)ann.getTier();
        this.transcription = tier.getTranscription();
        this.redo();
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    @Override
    public void undo() {
        int t = 0;
        this.transcription.setNotifying(false);
        for (int x = 0; x < this.arguments.length; x += 4) {
            Annotation ann;
            String tiername = (String)this.arguments[x];
            String oldAnnotationText = this.prevTexts.get(t);
            ExternalReference oldExtRef = this.prevExtRefs.get(t);
            String oldCveId = this.prevCveIds.get(t);
            ++t;
            TierImpl tier = this.transcription.getTierWithId(tiername);
            if (tier.isTimeAlignable()) {
                ann = tier.getAnnotationAtTime(this.begin);
            } else {
                long time = (this.begin + this.end) / 2L;
                ann = tier.getAnnotationAtTime(time);
            }
            if (ann == null) continue;
            if (oldAnnotationText == null) {
                tier.removeAnnotation(ann);
                continue;
            }
            ((AbstractAnnotation)ann).setExtRef(oldExtRef);
            ann.setCVEntryId(oldCveId);
            ann.setValue(oldAnnotationText);
        }
        this.transcription.setNotifying(true);
    }

    @Override
    public void redo() {
        this.prevTexts = new ArrayList<String>();
        this.prevExtRefs = new ArrayList<ExternalReference>();
        this.prevCveIds = new ArrayList<String>();
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        TierImpl firstTier = null;
        for (int x = 0; x < this.arguments.length; x += 4) {
            String tiername = (String)this.arguments[x];
            String newAnnotationText = (String)this.arguments[x + 1];
            ExternalReference extRef = (ExternalReference)this.arguments[x + 2];
            String cveId = (String)this.arguments[x + 3];
            TierImpl tier = this.transcription.getTierWithId(tiername);
            Annotation ann = tier.getAnnotationAtTime(this.begin);
            if (ann == null) {
                if (firstTier == null) {
                    firstTier = tier;
                }
                if (tier.isTimeAlignable()) {
                    ann = tier.createAnnotation(this.begin, this.end);
                } else {
                    long time = (this.begin + this.end) / 2L;
                    ann = tier.createAnnotation(time, time);
                }
                this.prevTexts.add(null);
                this.prevExtRefs.add(null);
                this.prevCveIds.add(null);
            } else {
                this.prevTexts.add(ann.getValue());
                ExternalReference oldExtRef = null;
                try {
                    AbstractAnnotation aa = (AbstractAnnotation)ann;
                    oldExtRef = aa.getExtRef();
                    if (oldExtRef != null) {
                        oldExtRef = oldExtRef.clone();
                    }
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                this.prevExtRefs.add(oldExtRef);
                this.prevCveIds.add(ann.getCVEntryId());
            }
            ann.setCVEntryId(cveId);
            ann.setValue(newAnnotationText);
            ModifyAnnotationCommand.replaceExternalReference((AbstractAnnotation)ann, extRef);
        }
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }
}

