/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.PasteAnnotationTreeCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.MonitoringLogger;
import mpi.eudico.client.annotator.util.TierNameCompare;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class MoveAnnotationToTierCommand
extends PasteAnnotationTreeCommand {
    private DefaultMutableTreeNode movedNode = null;
    private String origTierName = null;
    private boolean origAnnotationDeleted = false;

    public MoveAnnotationToTierCommand(String name) {
        super(name);
    }

    @Override
    public void redo() {
        if (this.transcription != null) {
            TierImpl t;
            this.setWaitCursor(true);
            this.transcription.setNotifying(false);
            this.newAnnotation();
            AbstractAnnotation aa = null;
            if (this.record != null && this.origTierName != null && this.origAnnotationDeleted && (t = this.transcription.getTierWithId(this.origTierName)) != null && (aa = (AbstractAnnotation)t.getAnnotationAtTime((this.record.getBeginTime() + this.record.getEndTime()) / 2L)) != null) {
                t.removeAnnotation(aa);
            }
            this.transcription.setNotifying(true);
            this.setWaitCursor(false);
        }
    }

    @Override
    public void undo() {
        boolean setNotifyingOff = false;
        if (this.tier != null && this.newAnnotation != null) {
            this.setWaitCursor(true);
            Annotation aa = this.tier.getAnnotationAtTime((this.newAnnBegin + this.newAnnEnd) / 2L);
            if (aa != null) {
                this.tier.removeAnnotation(aa);
                if (MonitoringLogger.isInitiated()) {
                    MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.UNDO, MonitoringLogger.NEW_ANNOTATION);
                }
            }
            if (this.tier.isTimeAlignable()) {
                this.transcription.setNotifying(false);
                setNotifyingOff = true;
                this.restoreInUndo();
            }
            if (this.movedNode != null && this.origAnnotationDeleted) {
                if (this.timePropMode != 0) {
                    this.transcription.setTimeChangePropagationMode(0);
                }
                AnnotationRecreator.createAnnotationFromTree(this.transcription, this.movedNode, true);
                if (this.timePropMode != 0) {
                    this.transcription.setTimeChangePropagationMode(this.timePropMode);
                }
            } else if (this.record != null && this.origAnnotationDeleted) {
                TierImpl t;
                AbstractAnnotation oa;
                if (this.timePropMode != 0) {
                    this.transcription.setTimeChangePropagationMode(0);
                }
                if ((oa = (AbstractAnnotation)(t = this.transcription.getTierWithId(this.origTierName)).createAnnotation(this.record.getBeginTime(), this.record.getEndTime())) != null) {
                    AnnotationRecreator.restoreValueEtc(oa, this.record, false);
                }
                if (this.timePropMode != 0) {
                    this.transcription.setTimeChangePropagationMode(this.timePropMode);
                }
            }
            if (setNotifyingOff) {
                this.transcription.setNotifying(true);
            }
            this.setWaitCursor(false);
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.tier = (TierImpl)receiver;
        this.destTierName = this.tier.getName();
        this.transcription = this.tier.getTranscription();
        this.changedAnnotations = new ArrayList();
        this.removedAnnotations = new ArrayList();
        AbstractAnnotation aa = (AbstractAnnotation)arguments[0];
        TierImpl srcTier = (TierImpl)aa.getTier();
        this.origTierName = srcTier.getName();
        if (this.tier == null || srcTier == null || this.tier.getParentTier() != null) {
            return;
        }
        int numDescendants = 0;
        if (aa.getParentListeners().size() == 0) {
            this.record = new AnnotationDataRecord(aa);
        } else {
            this.node = AnnotationRecreator.createTreeForAnnotation(aa);
            this.record = (AnnotationDataRecord)this.node.getUserObject();
            numDescendants = this.getDescendantCount(this.node);
        }
        this.timePropMode = this.transcription.getTimeChangePropagationMode();
        this.begin = aa.getBeginTimeBoundary();
        this.end = aa.getEndTimeBoundary();
        if (arguments.length > 2) {
            this.begin = (Long)arguments[1];
            this.end = (Long)arguments[2];
        }
        this.newAnnBegin = this.begin;
        this.newAnnEnd = this.end;
        if (this.node != null) {
            this.adjustTierNames(this.node, this.tier.getName());
        } else if (this.record != null) {
            this.record.setTierName(this.tier.getName());
        }
        this.storeForUndo();
        this.newAnnotation();
        if (this.newAnnotation != null) {
            this.movedNode = AnnotationRecreator.createTreeForAnnotation(aa);
            if (numDescendants > 0) {
                DefaultMutableTreeNode checkNode = AnnotationRecreator.createTreeForAnnotation((AbstractAnnotation)this.newAnnotation);
                if (checkNode != null) {
                    int numMovedDescendants = this.getDescendantCount(checkNode);
                    if (numDescendants == numMovedDescendants) {
                        ((TierImpl)aa.getTier()).removeAnnotation(aa);
                        this.origAnnotationDeleted = true;
                    } else {
                        ClientLogger.LOG.warning("Not all descendent annotations could be moved, therefore the original annotation is copied not moved.");
                    }
                }
            } else {
                ((TierImpl)aa.getTier()).removeAnnotation(aa);
                this.origAnnotationDeleted = true;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ELANCommandFactory.getRootFrame(MoveAnnotationToTierCommand.this.transcription).requestFocus();
            }
        });
    }

    @Override
    protected void adjustTimes() {
    }

    protected void adjustTierNames(DefaultMutableTreeNode inNode, String destTierName) {
        AnnotationDataRecord aRecord;
        TierNameCompare tnc;
        int[] indices;
        if (inNode != null && destTierName != null && (indices = (tnc = new TierNameCompare()).findCorrespondingAffix((aRecord = (AnnotationDataRecord)inNode.getUserObject()).getTierName(), destTierName)) != null && indices[0] > -1) {
            char del = aRecord.getTierName().charAt(indices[0]);
            String affix = "";
            if (indices[1] <= -1) {
                int di = destTierName.lastIndexOf(del);
                if (di > -1) {
                    affix = destTierName.substring(di);
                }
            } else {
                int di = destTierName.indexOf(del);
                if (di > -1) {
                    affix = destTierName.substring(0, di);
                }
            }
            tnc.adjustTierNames(inNode, affix, del, indices[1]);
        }
    }

    @Override
    public String getName() {
        return super.getName();
    }

    private int getDescendantCount(TreeNode node) {
        int count = 0;
        if (node != null && (count = node.getChildCount()) > 0) {
            TreeNode tn = null;
            for (int i = 0; i < node.getChildCount(); ++i) {
                tn = node.getChildAt(i);
                count += this.getDescendantCount(tn);
            }
        }
        return count;
    }
}

