/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.List;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.NewAnnotationFromTimeIntervalDialog;
import mpi.eudico.client.annotator.util.WindowLocationAndSizeManager;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;

public class NewAnnotationFromBeginEndTimeDlgCommand
implements Command {
    private String commandName;
    private long beginTime;
    private long endTime;
    private String annotationValue;
    private ViewerManager2 vm;
    private Object[] args;
    Boolean isCreateDependingAnnotations = Preferences.getBool("CreateDependingAnnotations", null);

    public NewAnnotationFromBeginEndTimeDlgCommand(String commandName) {
        this.commandName = commandName;
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.vm = (ViewerManager2)receiver;
        TranscriptionImpl transcription = (TranscriptionImpl)this.vm.getTranscription();
        NewAnnotationFromTimeIntervalDialog dialog = new NewAnnotationFromTimeIntervalDialog(this.vm, ELANCommandFactory.getRootFrame(this.vm.getTranscription()), true);
        dialog.setBeginTime(this.vm.getMediaPlayerController().getMediaTime());
        dialog.setEndTime(dialog.getBeginTime() + 1000L);
        dialog.setLimits(0L, this.vm.getMasterMediaPlayer().getMediaDuration());
        WindowLocationAndSizeManager.postInit(dialog, "NewAnnotationFromTimeIntervalDialog");
        dialog.setVisible(true);
        this.beginTime = dialog.getBeginTime();
        this.endTime = dialog.getEndTime();
        this.annotationValue = dialog.getAnnotationValue();
        List<String> listOfTiers = dialog.getTiers();
        if (!dialog.isActionApplied().booleanValue() || this.beginTime < 0L || this.beginTime >= this.endTime) {
            return;
        }
        boolean activeTierPresent = false;
        if (listOfTiers.isEmpty()) {
            boolean bl = activeTierPresent = this.vm.getMultiTierControlPanel() != null && this.vm.getMultiTierControlPanel().getActiveTier() != null;
            if (activeTierPresent) {
                TierImpl tier = (TierImpl)this.vm.getMultiTierControlPanel().getActiveTier();
                this.newCommand(tier);
            }
        } else {
            for (String selectedTier : listOfTiers) {
                TierImpl tier = transcription.getTierWithId(selectedTier);
                if (tier == null) continue;
                this.newCommand(tier);
            }
        }
    }

    private void newCommand(TierImpl tier) {
        Command command = null;
        this.args = new Object[]{this.beginTime, this.endTime, this.annotationValue};
        if (this.checkTierConstraints(tier)) {
            command = this.isCreateDependingAnnotations != null ? (this.isCreateDependingAnnotations.booleanValue() ? ELANCommandFactory.createCommand(this.vm.getTranscription(), "Menu.Annotation.NewAnnotationRecursive") : ELANCommandFactory.createCommand(this.vm.getTranscription(), "Menu.Annotation.NewAnnotation")) : ELANCommandFactory.createCommand(this.vm.getTranscription(), "Menu.Annotation.NewAnnotation");
            command.execute(tier, this.args);
        }
    }

    protected boolean checkTierConstraints(TierImpl tier) {
        if (tier.isTimeAlignable()) {
            return true;
        }
        Constraint c = null;
        if (tier.getLinguisticType() != null) {
            c = tier.getLinguisticType().getConstraints();
        }
        if (tier.getParentTier() != null && c != null && (c.getStereoType() == 4 || c.getStereoType() == 3)) {
            long time = (this.beginTime + this.endTime) / 2L;
            Annotation refA = tier.getParentTier().getAnnotationAtTime(time);
            Annotation curA = tier.getAnnotationAtTime(time);
            if (refA != null && curA == null) {
                this.args = new Object[]{time, time, this.annotationValue};
                return true;
            }
            if (refA != null) {
                if (this.isCreateDependingAnnotations != null && this.isCreateDependingAnnotations.booleanValue()) {
                    return false;
                }
                JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(this.vm.getTranscription()), ElanLocale.getString("Message.ExistingAnnotation"), ElanLocale.getString("Message.Warning"), 2);
            } else {
                JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(this.vm.getTranscription()), ElanLocale.getString("Message.NoParent"), ElanLocale.getString("Message.Warning"), 2);
            }
        }
        return false;
    }
}

