/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.List;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class NewAnnotationsInGap
implements UndoableCommand {
    private String commandName;
    Transcription transcription;
    TierImpl tier;
    long beginTime;
    long endTime;
    long splitTime;
    String[] splitText;
    AnnotationDataRecord annRecord1;
    AnnotationDataRecord annRecord2;

    public NewAnnotationsInGap(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        String inputText;
        this.tier = (TierImpl)receiver;
        if (this.tier.hasParentTier()) {
            ClientLogger.LOG.warning("This operation is not (yet) supported on dependent tiers.");
            return;
        }
        this.transcription = this.tier.getTranscription();
        this.beginTime = (Long)arguments[0];
        this.endTime = (Long)arguments[1];
        List<Annotation> overlapping = this.tier.getOverlappingAnnotations(this.beginTime, this.endTime);
        if (!overlapping.isEmpty()) {
            ClientLogger.LOG.warning("This operation is only allowed in sections where there is a gap (no annotations yet).");
            return;
        }
        this.splitTime = (Long)arguments[2];
        if (this.splitTime <= this.beginTime || this.splitTime >= this.endTime) {
            this.splitTime = -1L;
        }
        if ((inputText = (String)arguments[3]) == null) {
            inputText = "";
        }
        int splitPos = (Integer)arguments[4];
        if (this.splitTime == -1L) {
            splitPos = Integer.MAX_VALUE;
        }
        this.splitText = this.splitTextInTwo(inputText, splitPos);
        this.createAnnotations();
    }

    String[] splitTextInTwo(String inputText, int splitIndex) {
        String[] split = new String[2];
        if (splitIndex <= 0) {
            split[0] = "";
            split[1] = inputText;
        } else if (splitIndex >= inputText.length()) {
            split[0] = inputText;
            split[1] = "";
        } else {
            split[0] = inputText.substring(0, splitIndex);
            split[1] = inputText.substring(splitIndex);
        }
        return split;
    }

    protected void createAnnotations() {
        Annotation secAnn;
        long et;
        Annotation nextAnn;
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        if ((nextAnn = this.tier.createAnnotation(this.beginTime, et = this.splitTime != -1L ? this.splitTime : this.endTime)) != null) {
            nextAnn.setValue(this.splitText[0]);
            this.annRecord1 = new AnnotationDataRecord(nextAnn);
        }
        if (this.splitTime > -1L && this.splitText[1].length() > 0 && (secAnn = this.tier.createAnnotation(this.splitTime, this.endTime)) != null) {
            secAnn.setValue(this.splitText[1]);
            this.annRecord2 = new AnnotationDataRecord(secAnn);
        }
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    @Override
    public void undo() {
        if (this.annRecord1 != null) {
            TierImpl topTier;
            int curPropMode = 0;
            curPropMode = this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                this.transcription.setTimeChangePropagationMode(0);
            }
            if ((topTier = (TierImpl)this.transcription.getTierWithId(this.annRecord1.getTierName())) != null) {
                long mid2;
                Annotation remAnn2;
                long mid = (this.annRecord1.getBeginTime() + this.annRecord1.getEndTime()) / 2L;
                Annotation remAnn = topTier.getAnnotationAtTime(mid);
                if (remAnn != null) {
                    topTier.removeAnnotation(remAnn);
                }
                if (this.annRecord2 != null && (remAnn2 = topTier.getAnnotationAtTime(mid2 = (this.annRecord2.getBeginTime() + this.annRecord2.getEndTime()) / 2L)) != null) {
                    topTier.removeAnnotation(remAnn2);
                }
            }
            this.transcription.setTimeChangePropagationMode(curPropMode);
        }
    }

    @Override
    public void redo() {
        if (this.annRecord1 != null) {
            TierImpl topTier;
            int curPropMode = 0;
            curPropMode = this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                this.transcription.setTimeChangePropagationMode(0);
            }
            if ((topTier = (TierImpl)this.transcription.getTierWithId(this.annRecord1.getTierName())) != null) {
                Annotation secAnn;
                Annotation nextAnn = this.tier.createAnnotation(this.annRecord1.getBeginTime(), this.annRecord1.getEndTime());
                if (nextAnn != null) {
                    nextAnn.setValue(this.annRecord1.getValue());
                }
                if (this.annRecord2 != null && (secAnn = this.tier.createAnnotation(this.annRecord2.getBeginTime(), this.annRecord2.getEndTime())) != null) {
                    secAnn.setValue(this.annRecord2.getValue());
                }
            }
            this.transcription.setTimeChangePropagationMode(curPropMode);
        }
    }
}

