/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.ngramstats.NgramStatsResult;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.client.annotator.util.SquelchOutput;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.util.ProcessReport;
import mpi.eudico.server.corpora.util.SimpleReport;

public class NgramStatsCommand
implements Command {
    private String commandName;
    private ProgressListener listener;
    private List<String> selectedFiles;
    private NgramStatsResult ngramsResult;
    private NgramsThread ngramsThread;
    private SimpleReport report = new SimpleReport(ElanLocale.getString("ProcessReport"));

    public NgramStatsCommand(String commandName) {
        this.commandName = commandName;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.selectedFiles = (List)arguments[0];
        this.ngramsResult = (NgramStatsResult)arguments[1];
        this.ngramsThread = new NgramsThread(this.commandName);
        try {
            this.ngramsThread.start();
        }
        catch (Exception ex) {
            this.report.append("Error in executing analysis: " + ex.getMessage());
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    public synchronized void addProgressListener(ProgressListener pl) {
        this.listener = pl;
    }

    public synchronized void removeProgressListener(ProgressListener pl) {
        this.listener = null;
    }

    private void progressUpdate(int percent, String message) {
        if (this.listener != null) {
            this.listener.progressUpdated(this, percent, message);
        }
    }

    private void progressComplete(String message) {
        if (this.listener != null) {
            this.listener.progressCompleted(this, message);
        }
    }

    public ProcessReport getProcessReport() {
        return this.report;
    }

    private class NgramsThread
    extends Thread {
        public NgramsThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            float perFileProg = 100.0f / (float)NgramStatsCommand.this.selectedFiles.size();
            int numFailed = 0;
            SquelchOutput squelcher = new SquelchOutput();
            try {
                squelcher.squelchOutput();
            }
            catch (Exception e) {
                NgramStatsCommand.this.report.append("Error squelching parser: " + e.getMessage());
                NgramStatsCommand.this.progressComplete("ERROR");
                return;
            }
            for (int i = 0; i < NgramStatsCommand.this.selectedFiles.size(); ++i) {
                try {
                    TranscriptionImpl trans = new TranscriptionImpl((String)NgramStatsCommand.this.selectedFiles.get(i));
                    TierImpl tier = trans.getTierWithId(NgramStatsCommand.this.ngramsResult.getTier());
                    if (tier != null) {
                        List<AbstractAnnotation> annotations = tier.getAnnotations();
                        if (annotations.size() > 0) {
                            NgramStatsCommand.this.ngramsResult.startFile((String)NgramStatsCommand.this.selectedFiles.get(i));
                            for (int ann = 0; ann < annotations.size(); ++ann) {
                                NgramStatsCommand.this.ngramsResult.addAnnotation(annotations.get(ann));
                            }
                            NgramStatsCommand.this.ngramsResult.endFile();
                        }
                    } else {
                        NgramStatsCommand.this.report.append("Selected tier(" + NgramStatsCommand.this.ngramsResult.getTier() + ") not present in file: " + (String)NgramStatsCommand.this.selectedFiles.get(i));
                    }
                    NgramStatsCommand.this.progressUpdate((int)((float)(i + 1) * perFileProg - 1.0f), "Processed file: " + (String)NgramStatsCommand.this.selectedFiles.get(i));
                    continue;
                }
                catch (Exception ex) {
                    NgramStatsCommand.this.report.append("Error parsing file(" + (String)NgramStatsCommand.this.selectedFiles.get(i) + "): " + ex.getMessage());
                    ++numFailed;
                    NgramStatsCommand.this.progressUpdate((int)((float)(i + 1) * perFileProg - 1.0f), "Unable to load file(" + (String)NgramStatsCommand.this.selectedFiles.get(i) + "): " + ex.getMessage());
                }
            }
            try {
                squelcher.restoreOutput();
            }
            catch (Exception e) {
                NgramStatsCommand.this.report.append("Error unsquelching parser: " + e.getMessage());
                NgramStatsCommand.this.progressComplete("ERROR");
                return;
            }
            NgramStatsCommand.this.progressUpdate(99, "Calculating Statistics...");
            try {
                NgramStatsCommand.this.ngramsResult.calculateStatistics();
            }
            catch (Exception ex) {
                NgramStatsCommand.this.report.append("Error calculating statistics: " + ex.getMessage());
                StringWriter rv = new StringWriter();
                PrintWriter rvWriter = new PrintWriter(rv);
                ex.printStackTrace(rvWriter);
                NgramStatsCommand.this.report.append("Stack Trace: " + ((Object)rv).toString());
                NgramStatsCommand.this.progressComplete("ERROR");
                return;
            }
            NgramStatsCommand.this.report.prepend("----------\n Parsing run done in " + NgramStatsCommand.this.ngramsResult.getSearchTime() + " secs\n Selected Domain: " + NgramStatsCommand.this.ngramsResult.getDomain() + "\n Selected Tier: " + NgramStatsCommand.this.ngramsResult.getTier() + "\n N-gram Size: " + NgramStatsCommand.this.ngramsResult.getNgramSize() + "\n Files Inspected: " + NgramStatsCommand.this.ngramsResult.getNumFiles() + "\n Files Failed: " + numFailed + "\n Total Annotations: " + NgramStatsCommand.this.ngramsResult.getNumAnnotations() + "\n Total N-grams: " + NgramStatsCommand.this.ngramsResult.getNumNgrams() + "\n Collated N-grams: " + NgramStatsCommand.this.ngramsResult.getNumCollectedNgrams() + "\n----------\n");
            NgramStatsCommand.this.progressComplete("Statistics completed.");
        }
    }
}

