/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.Timer;
import java.util.TimerTask;
import mpi.eudico.client.annotator.ElanMediaPlayerController;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;

public class PlaySelectionCommand
implements Command {
    private String commandName;
    private ElanMediaPlayer player;
    private Selection s;
    private ElanMediaPlayerController mediaPlayerController;
    private long beginTime;
    private long endTime;

    public PlaySelectionCommand(String theName) {
        this.commandName = theName;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.player = (ElanMediaPlayer)receiver;
        Float selRate = null;
        if (arguments.length == 4) {
            selRate = (Float)arguments[3];
        }
        this.s = (Selection)arguments[0];
        this.mediaPlayerController = (ElanMediaPlayerController)arguments[1];
        int playAroundSelectionValue = (Integer)arguments[2];
        if (this.player == null) {
            return;
        }
        if (this.player.isPlaying()) {
            this.player.stop();
            this.mediaPlayerController.stopLoop();
            this.mediaPlayerController.setPlaySelectionMode(false);
            this.player.setStopTime(this.player.getMediaDuration());
            return;
        }
        long mediaTime = this.player.getMediaTime();
        this.beginTime = this.s.getBeginTime();
        this.endTime = this.s.getEndTime();
        if (this.beginTime == this.endTime) {
            return;
        }
        if (playAroundSelectionValue > 0) {
            this.beginTime -= (long)playAroundSelectionValue;
            if (this.beginTime < 0L) {
                this.beginTime = 0L;
            }
            this.endTime += (long)playAroundSelectionValue;
            if (this.endTime > this.player.getMediaDuration()) {
                this.endTime = this.player.getMediaDuration();
            }
        }
        if (!this.player.isPlaying() && mediaTime >= this.beginTime && mediaTime < this.endTime - 5L) {
            if (!this.mediaPlayerController.isBeginBoundaryActive()) {
                this.mediaPlayerController.toggleActiveSelectionBoundary();
            }
            this.mediaPlayerController.setPlaySelectionMode(true);
            if (selRate == null) {
                this.playInterval(mediaTime, this.endTime);
            } else {
                this.playIntervalWithRate(mediaTime, this.endTime, selRate.floatValue());
            }
            if (this.mediaPlayerController.getLoopMode()) {
                this.delayedStartLoop();
            }
            return;
        }
        if (this.mediaPlayerController.getLoopMode()) {
            this.mediaPlayerController.setPlaySelectionMode(true);
            this.doStartLoop();
        } else {
            this.mediaPlayerController.setPlaySelectionMode(true);
            if (selRate == null) {
                this.playInterval(this.beginTime, this.endTime);
            } else {
                this.playIntervalWithRate(this.beginTime, this.endTime, selRate.floatValue());
            }
        }
    }

    private void playInterval(long begin, long end) {
        this.player.playInterval(begin, end);
    }

    private void playIntervalWithRate(long begin, long end, float tmpRate) {
        final float oldRate = this.player.getRate();
        this.player.setRate(tmpRate);
        this.player.playInterval(begin, end);
        if (tmpRate != oldRate) {
            final Timer timer = new Timer();
            timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    if (!PlaySelectionCommand.this.player.isPlaying() || !PlaySelectionCommand.this.mediaPlayerController.isPlaySelectionMode()) {
                        PlaySelectionCommand.this.player.setRate(oldRate);
                        timer.cancel();
                    }
                }
            }, 0L, 100L);
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    public void doStartLoop() {
        this.mediaPlayerController.startLoop(this.beginTime, this.endTime);
    }

    private void delayedStartLoop() {
        LoopThread loopthread = new LoopThread();
        loopthread.start();
    }

    private class LoopThread
    extends Thread {
        private LoopThread() {
        }

        @Override
        public void run() {
            if (PlaySelectionCommand.this.mediaPlayerController.isPlaySelectionMode() && PlaySelectionCommand.this.mediaPlayerController.getLoopMode()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                while (PlaySelectionCommand.this.player.isPlaying()) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (PlaySelectionCommand.this.mediaPlayerController.isPlaySelectionMode()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    PlaySelectionCommand.this.mediaPlayerController.startLoop(PlaySelectionCommand.this.beginTime, PlaySelectionCommand.this.endTime);
                }
            }
        }
    }
}

