/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.AnnotationValuesRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class RemoveAnnotationsOrValuesCommand
implements UndoableCommand {
    private String commandName;
    private TranscriptionImpl transcription;
    List<String> tierNames;
    boolean annotations;
    boolean annotationValues;
    boolean allAnnotations;
    boolean annotationWithVal;
    String value;
    private ArrayList<AnnotationValuesRecord> records;
    private HashMap<String, List<DefaultMutableTreeNode>> delAnnRecordsMap;

    public RemoveAnnotationsOrValuesCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        this.setWaitCursor(true);
        this.transcription.setNotifying(false);
        if (this.annotationValues) {
            String name = null;
            TierImpl tier = null;
            if (this.tierNames != null) {
                if (this.records != null) {
                    AbstractAnnotation ann = null;
                    AnnotationValuesRecord record = null;
                    for (int i = 0; i < this.records.size(); ++i) {
                        record = this.records.get(i);
                        name = record.getTierName();
                        if (tier == null || !tier.getName().equals(name)) {
                            tier = this.transcription.getTierWithId(name);
                        }
                        if (tier != null) {
                            ann = (AbstractAnnotation)tier.getAnnotationAtTime(record.getBeginTime());
                            if (ann != null && ann.getEndTimeBoundary() == record.getEndTime()) {
                                this.restoreValueAndRefs(ann, record);
                                continue;
                            }
                            ClientLogger.LOG.warning("The annotation could not be found for undo");
                            continue;
                        }
                        ClientLogger.LOG.warning("The tier could not be found: " + name);
                    }
                } else {
                    ClientLogger.LOG.info("No annotation records have been stored for undo.");
                }
            } else {
                ClientLogger.LOG.warning("No tier names have been stored.");
            }
        } else if (this.annotations && this.transcription != null && this.delAnnRecordsMap != null) {
            List<Object> delAnnRecords = new ArrayList();
            String name = null;
            for (int i = 0; i < this.tierNames.size(); ++i) {
                name = this.tierNames.get(i);
                delAnnRecords = this.delAnnRecordsMap.get(name);
                if (delAnnRecords == null || name == null) continue;
                TierImpl tier = this.transcription.getTierWithId(name);
                if (tier == null) {
                    ClientLogger.LOG.warning("The tier could not be found: " + name);
                    return;
                }
                int curPropMode = 0;
                curPropMode = this.transcription.getTimeChangePropagationMode();
                if (curPropMode != 0) {
                    this.transcription.setTimeChangePropagationMode(0);
                }
                this.transcription.setNotifying(false);
                this.setWaitCursor(true);
                if (this.allAnnotations) {
                    if (!tier.hasParentTier()) {
                        for (DefaultMutableTreeNode defaultMutableTreeNode : delAnnRecords) {
                            AnnotationRecreator.createAnnotationFromTree(this.transcription, defaultMutableTreeNode, true);
                        }
                    } else if (!this.tierNames.contains(tier.getParentTier().getName())) {
                        AnnotationRecreator.createAnnotationsSequentially(this.transcription, delAnnRecords, true);
                    }
                } else if (this.annotationWithVal) {
                    for (DefaultMutableTreeNode defaultMutableTreeNode : delAnnRecords) {
                        AnnotationRecreator.createAnnotationFromTree(this.transcription, defaultMutableTreeNode, true);
                    }
                }
                this.transcription.setTimeChangePropagationMode(curPropMode);
            }
        }
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
    }

    @Override
    public void redo() {
        this.setWaitCursor(true);
        this.transcription.setNotifying(false);
        if (this.annotationValues) {
            String name = null;
            TierImpl tier = null;
            if (this.tierNames != null) {
                if (this.records != null) {
                    AbstractAnnotation ann = null;
                    AnnotationValuesRecord record = null;
                    for (int i = 0; i < this.records.size(); ++i) {
                        record = this.records.get(i);
                        name = record.getTierName();
                        if (tier == null || !tier.getName().equals(name)) {
                            tier = this.transcription.getTierWithId(name);
                        }
                        if (tier != null) {
                            ann = (AbstractAnnotation)tier.getAnnotationAtTime(record.getBeginTime());
                            if (ann != null && ann.getEndTimeBoundary() == record.getEndTime()) {
                                this.removeValueAndRefs(ann);
                                continue;
                            }
                            ClientLogger.LOG.warning("The annotation could not be found for redo");
                            continue;
                        }
                        ClientLogger.LOG.warning("Could not find tier for redo: " + name);
                    }
                } else {
                    ClientLogger.LOG.info("No annotation records have been stored for undo.");
                }
            } else {
                ClientLogger.LOG.warning("No tier names have been stored.");
            }
        } else if (this.annotations) {
            this.deleteAnnotations();
        }
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.tierNames = (List)arguments[0];
        this.annotations = (Boolean)arguments[1];
        this.annotationValues = (Boolean)arguments[2];
        this.allAnnotations = (Boolean)arguments[3];
        this.annotationWithVal = (Boolean)arguments[4];
        this.value = (String)arguments[5];
        if (this.tierNames == null || this.tierNames.size() == 0) {
            ClientLogger.LOG.warning("No tier selected.");
            this.transcription.setNotifying(true);
            this.setWaitCursor(false);
            return;
        }
        if (this.annotationWithVal && (this.value == null || this.value.length() == 0 && this.annotationValues)) {
            ClientLogger.LOG.warning("Search value is empty.");
            this.transcription.setNotifying(true);
            this.setWaitCursor(false);
            return;
        }
        if (this.annotations) {
            this.deleteAnnotations();
        } else if (this.annotationValues) {
            this.deleteAnnotationValues();
        }
    }

    private HashMap<String, List<AbstractAnnotation>> getAnnotationsToBeDeleted() {
        String name;
        ArrayList<AbstractAnnotation> anns;
        int i;
        TierImpl tier = null;
        HashMap<String, List<AbstractAnnotation>> annsMap = new HashMap<String, List<AbstractAnnotation>>();
        if (this.allAnnotations) {
            for (i = 0; i < this.tierNames.size(); ++i) {
                anns = new ArrayList<AbstractAnnotation>();
                name = this.tierNames.get(i);
                tier = this.transcription.getTierWithId(name);
                if (tier != null) {
                    anns.addAll(tier.getAnnotations());
                } else {
                    ClientLogger.LOG.warning("The tier " + name + " does not exist.");
                }
                annsMap.put(name, anns);
            }
        }
        if (this.annotationWithVal) {
            tier = null;
            name = null;
            for (i = 0; i < this.tierNames.size(); ++i) {
                anns = new ArrayList();
                name = this.tierNames.get(i);
                tier = this.transcription.getTierWithId(name);
                if (tier != null) {
                    List<AbstractAnnotation> annotations = tier.getAnnotations();
                    for (AbstractAnnotation annotation : annotations) {
                        if (annotation.getValue().compareToIgnoreCase(this.value) != 0) continue;
                        anns.add(annotation);
                    }
                } else {
                    ClientLogger.LOG.warning("The tier " + name + " does not exist.");
                }
                annsMap.put(name, anns);
            }
        }
        return annsMap;
    }

    private void deleteAnnotations() {
        this.setWaitCursor(true);
        this.transcription.setNotifying(false);
        this.delAnnRecordsMap = new HashMap();
        List<Object> anns = new ArrayList();
        ArrayList<DefaultMutableTreeNode> delAnnRecords = new ArrayList<DefaultMutableTreeNode>();
        HashMap<String, List<AbstractAnnotation>> annsMap = this.getAnnotationsToBeDeleted();
        String name = null;
        AnnotationValuesRecord record = null;
        if (this.allAnnotations) {
            for (int i = 0; i < this.tierNames.size(); ++i) {
                name = this.tierNames.get(i);
                anns = annsMap.get(name);
                TierImpl tier = this.transcription.getTierWithId(name);
                if (tier.hasParentTier() && !this.tierNames.contains(tier.getParentTier().getName())) {
                    tier = this.transcription.getTierWithId(name);
                    List<AbstractAnnotation> annotations = tier.getParentTier().getAnnotations();
                    for (AbstractAnnotation aa : annotations) {
                        delAnnRecords.add(AnnotationRecreator.createTreeForAnnotation(aa));
                    }
                }
                if (anns == null || anns.size() <= 0) continue;
                for (AbstractAnnotation abstractAnnotation : anns) {
                    tier = (TierImpl)abstractAnnotation.getTier();
                    AbstractAnnotation abstractAnnotation2 = (AbstractAnnotation)tier.getAnnotationAtTime(((record = new AnnotationValuesRecord(abstractAnnotation)).getBeginTime() + record.getEndTime()) / 2L);
                    if (abstractAnnotation2 == null) continue;
                    if (!tier.hasParentTier()) {
                        delAnnRecords.add(AnnotationRecreator.createTreeForAnnotation(abstractAnnotation2));
                    }
                    tier.removeAnnotation(abstractAnnotation2);
                }
                this.delAnnRecordsMap.put(name, delAnnRecords);
            }
        } else if (this.annotationWithVal) {
            for (int i = 0; i < this.tierNames.size(); ++i) {
                name = this.tierNames.get(i);
                anns = annsMap.get(name);
                TierImpl tier = this.transcription.getTierWithId(name);
                if (anns == null || anns.size() <= 0) continue;
                for (AbstractAnnotation abstractAnnotation : anns) {
                    tier = (TierImpl)abstractAnnotation.getTier();
                    AbstractAnnotation abstractAnnotation3 = (AbstractAnnotation)tier.getAnnotationAtTime(((record = new AnnotationValuesRecord(abstractAnnotation)).getBeginTime() + record.getEndTime()) / 2L);
                    if (abstractAnnotation3 == null) continue;
                    delAnnRecords.add(AnnotationRecreator.createTreeForAnnotation(abstractAnnotation3));
                    tier.removeAnnotation(abstractAnnotation3);
                }
                this.delAnnRecordsMap.put(name, delAnnRecords);
            }
        }
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
    }

    private void deleteAnnotationValues() {
        String name;
        int i;
        this.setWaitCursor(true);
        this.transcription.setNotifying(false);
        TierImpl tier = null;
        ArrayList<AbstractAnnotation> anns = new ArrayList<AbstractAnnotation>();
        if (this.allAnnotations) {
            for (i = 0; i < this.tierNames.size(); ++i) {
                name = this.tierNames.get(i);
                tier = this.transcription.getTierWithId(name);
                if (tier != null) {
                    anns.addAll(tier.getAnnotations());
                    continue;
                }
                ClientLogger.LOG.warning("The tier " + name + " does not exist.");
            }
        } else if (this.annotationWithVal) {
            for (i = 0; i < this.tierNames.size(); ++i) {
                name = this.tierNames.get(i);
                tier = this.transcription.getTierWithId(name);
                if (tier != null) {
                    List<AbstractAnnotation> annotations = tier.getAnnotations();
                    for (AbstractAnnotation annotation : annotations) {
                        if (annotation.getValue().compareToIgnoreCase(this.value) != 0) continue;
                        anns.add(annotation);
                    }
                    continue;
                }
                ClientLogger.LOG.warning("The tier " + name + " does not exist.");
            }
        }
        this.records = new ArrayList(anns.size());
        AbstractAnnotation ann = null;
        AnnotationValuesRecord record = null;
        for (int i2 = 0; i2 < anns.size(); ++i2) {
            ann = (AbstractAnnotation)anns.get(i2);
            record = new AnnotationValuesRecord(ann);
            this.records.add(record);
            this.removeValueAndRefs(ann);
        }
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
    }

    private void removeValueAndRefs(AbstractAnnotation ann) {
        ann.setCVEntryId(null);
        ann.setExtRef(null);
        ann.setValue("");
    }

    private void restoreValueAndRefs(AbstractAnnotation ann, AnnotationDataRecord record) {
        ann.setCVEntryId(record.getCvEntryId());
        ann.setExtRef(record.getExtRef());
        ann.setValue(record.getValue());
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

