/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.List;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.util.ControlledVocabulary;

public class ReplaceCVCommand
implements UndoableCommand {
    private String commandName;
    private TranscriptionImpl transcription;
    private ControlledVocabulary conVoc;
    private ControlledVocabulary newConVoc;

    public ReplaceCVCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        if (this.transcription != null) {
            List<LinguisticType> typesWithThisCV = this.transcription.getLinguisticTypesWithCV(this.newConVoc.getName());
            this.transcription.removeControlledVocabulary(this.newConVoc);
            this.transcription.addControlledVocabulary(this.conVoc);
            if (typesWithThisCV != null && !typesWithThisCV.isEmpty()) {
                for (int i = 0; i < typesWithThisCV.size(); ++i) {
                    LinguisticType lt = typesWithThisCV.get(i);
                    lt.setControlledVocabularyName(this.conVoc.getName());
                }
            }
        }
    }

    @Override
    public void redo() {
        if (this.transcription != null) {
            List<LinguisticType> typesWithThisCV = this.transcription.getLinguisticTypesWithCV(this.conVoc.getName());
            this.transcription.removeControlledVocabulary(this.conVoc);
            this.transcription.addControlledVocabulary(this.newConVoc);
            if (typesWithThisCV != null && !typesWithThisCV.isEmpty()) {
                for (int i = 0; i < typesWithThisCV.size(); ++i) {
                    LinguisticType lt = typesWithThisCV.get(i);
                    lt.setControlledVocabularyName(this.newConVoc.getName());
                }
            }
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.conVoc = (ControlledVocabulary)arguments[0];
        this.newConVoc = (ControlledVocabulary)arguments[1];
        if (this.transcription.getControlledVocabulary(this.conVoc.getName()) != null && this.newConVoc != null) {
            List<LinguisticType> typesWithThisCV = this.transcription.getLinguisticTypesWithCV(this.conVoc.getName());
            this.transcription.removeControlledVocabulary(this.conVoc);
            this.transcription.addControlledVocabulary(this.newConVoc);
            if (typesWithThisCV != null && !typesWithThisCV.isEmpty()) {
                for (int i = 0; i < typesWithThisCV.size(); ++i) {
                    LinguisticType lt = typesWithThisCV.get(i);
                    lt.setControlledVocabularyName(this.newConVoc.getName());
                }
            }
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

