/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.List;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.LicenseRecord;

public class SetDocumentPropertiesCommand
implements UndoableCommand {
    private Transcription transcription = null;
    private String name;
    private String oldAuthor;
    private String nextAuthor;
    private List<LicenseRecord> oldRecords;
    private List<LicenseRecord> nextRecords;

    public SetDocumentPropertiesCommand(String name) {
        this.name = name;
    }

    @Override
    public void redo() {
        if (this.transcription != null) {
            if (this.nextAuthor != null) {
                this.transcription.setAuthor(this.nextAuthor);
            }
            if (this.nextRecords != null) {
                this.transcription.setLicenses(this.nextRecords);
            }
        }
    }

    @Override
    public void undo() {
        if (this.transcription != null) {
            if (this.oldAuthor != null) {
                this.transcription.setAuthor(this.oldAuthor);
            }
            this.transcription.setLicenses(this.oldRecords);
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        List l;
        if (receiver instanceof Transcription) {
            this.transcription = (Transcription)receiver;
        }
        if (this.transcription == null) {
            return;
        }
        if (arguments[0] instanceof String) {
            this.nextAuthor = (String)arguments[0];
        }
        if (arguments[1] instanceof List && (l = (List)arguments[1]).size() > 0 && l.get(0) instanceof LicenseRecord) {
            this.nextRecords = l;
        }
        this.checkAndApplyChanges();
    }

    private void checkAndApplyChanges() {
        if (this.transcription != null) {
            this.oldAuthor = this.transcription.getAuthor();
            if (this.nextAuthor != null && !this.nextAuthor.equals(this.oldAuthor)) {
                this.transcription.setAuthor(this.nextAuthor);
                this.transcription.setChanged();
            }
            this.oldRecords = this.transcription.getLicenses();
            if (this.nextRecords != null) {
                if (this.oldRecords.size() != this.nextRecords.size()) {
                    this.transcription.setLicenses(this.nextRecords);
                    this.transcription.setChanged();
                } else {
                    boolean different = false;
                    for (int i = 0; i < this.nextRecords.size(); ++i) {
                        LicenseRecord lr = this.nextRecords.get(i);
                        LicenseRecord olr = this.oldRecords.get(i);
                        if (lr.getUrl() == null && olr.getUrl() != null || lr.getUrl() != null && !lr.getUrl().equals(olr)) {
                            different = true;
                            break;
                        }
                        if (lr.getText().equals(olr.getText())) continue;
                        different = true;
                        break;
                    }
                    if (different) {
                        this.transcription.setLicenses(this.nextRecords);
                        this.transcription.setChanged();
                    }
                }
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }
}

