/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.commands.ShiftAnnotationsCommand;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.TimeInterval;

public class ShiftAnnotationsLROfCommand
extends ShiftAnnotationsCommand {
    Map<String, TimeInterval> spacePerRootTier;

    public ShiftAnnotationsLROfCommand(String name) {
        super(name);
        this.availBT = 0L;
        this.availET = Long.MAX_VALUE;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        if (arguments != null) {
            TierImpl tier;
            int i;
            this.spacePerRootTier = new HashMap<String, TimeInterval>();
            this.bt = (Long)arguments[0];
            this.et = (Long)arguments[1];
            this.shiftValue = (Long)arguments[2];
            this.transcription.setNotifying(false);
            int numShifted = 0;
            List<TierImpl> rootTiers = this.transcription.getTopTiers();
            for (i = 0; i < rootTiers.size(); ++i) {
                tier = rootTiers.get(i);
                this.spacePerRootTier.put(tier.getName(), new TimeInterval(this.getBoundaryBefore(tier, this.bt), this.getBoundaryAfter(tier, this.et)));
            }
            for (i = 0; i < rootTiers.size(); ++i) {
                tier = rootTiers.get(i);
                if (tier == null || !tier.isTimeAlignable()) continue;
                numShifted += this.shift(tier, this.shiftValue, this.bt, this.et);
            }
            if (numShifted > 0) {
                this.transcription.handleModification(this.transcription, 14, this.transcription);
            }
            this.transcription.setNotifying(true);
        }
    }

    @Override
    public void redo() {
        if (this.transcription != null) {
            this.transcription.setNotifying(false);
            int numShifted = 0;
            List<TierImpl> rootTiers = this.transcription.getTopTiers();
            for (int i = 0; i < rootTiers.size(); ++i) {
                TierImpl tier = rootTiers.get(i);
                if (tier == null || !tier.isTimeAlignable()) continue;
                numShifted += this.shift(tier, this.shiftValue, this.bt, this.et);
            }
            if (numShifted > 0) {
                this.transcription.handleModification(this.transcription, 14, this.transcription);
            }
            this.transcription.setNotifying(true);
        }
    }

    @Override
    public void undo() {
        if (this.transcription != null) {
            this.transcription.setNotifying(false);
            int numShifted = 0;
            List<TierImpl> rootTiers = this.transcription.getTopTiers();
            for (int i = 0; i < rootTiers.size(); ++i) {
                TimeInterval ti;
                TierImpl tier = rootTiers.get(i);
                if (tier == null || !tier.isTimeAlignable() || (ti = this.spacePerRootTier.get(tier.getName())) == null || ti.getBeginTime() == ti.getEndTime()) continue;
                numShifted += this.shift(tier, -this.shiftValue.longValue(), ti.getBeginTime(), ti.getEndTime());
            }
            if (numShifted > 0) {
                this.transcription.handleModification(this.transcription, 14, this.transcription);
            }
            this.transcription.setNotifying(true);
        }
    }

    @Override
    long getBoundaryBefore(TierImpl tier, long bt) {
        if (bt == 0L) {
            return bt;
        }
        Annotation a = tier.getAnnotationAtTime(bt);
        if (a != null && a.getBeginTimeBoundary() != bt) {
            return a.getEndTimeBoundary();
        }
        a = tier.getAnnotationBefore(bt);
        if (a != null) {
            return a.getEndTimeBoundary();
        }
        return 0L;
    }

    @Override
    long getBoundaryAfter(TierImpl tier, long et) {
        if (et == Long.MAX_VALUE) {
            return et;
        }
        Annotation a = tier.getAnnotationAtTime(et);
        if (a != null) {
            return a.getBeginTimeBoundary();
        }
        a = tier.getAnnotationAfter(et);
        if (a != null) {
            return a.getBeginTimeBoundary();
        }
        return Long.MAX_VALUE;
    }
}

