/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ELAN;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.SIMPLELAN;
import mpi.eudico.client.annotator.prefs.PreferencesReader;
import mpi.eudico.client.annotator.prefs.PreferencesWriter;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.SystemReporting;

public class ShortcutsUtil {
    private static ShortcutsUtil shortcutsUtil;
    public static final String ANN_EDIT_CAT = "Frame.ShortcutFrame.Sub.AnnotationEdit";
    public static final String ANN_NAVIGATION_CAT = "Frame.ShortcutFrame.Sub.AnnotationNavigation";
    public static final String TIER_TYPE_CAT = "Frame.ShortcutFrame.Sub.TierType";
    public static final String SELECTION_CAT = "Frame.ShortcutFrame.Sub.Selection";
    public static final String MEDIA_CAT = "Frame.ShortcutFrame.Sub.MediaNavigation";
    public static final String DOCUMENT_CAT = "Frame.ShortcutFrame.Sub.Document";
    public static final String MISC_CAT = "Frame.ShortcutFrame.Sub.Misc";
    public static final String PREF_FILEPATH;
    public static final String NEW_PREF_FILEPATH;
    private Map<String, Map<String, List<String>>> shortcuttableActionsMap = new LinkedHashMap<String, Map<String, List<String>>>(8);
    private Map<String, Map<String, KeyStroke>> shortcutKeyStrokesMap = new LinkedHashMap<String, Map<String, KeyStroke>>(80);
    private boolean shortcutClash = false;

    private ShortcutsUtil() {
        this.fillActionsMap();
        this.fillShortcutMap();
    }

    public static ShortcutsUtil getInstance() {
        if (shortcutsUtil == null) {
            shortcutsUtil = new ShortcutsUtil();
        }
        return shortcutsUtil;
    }

    private void fillActionsMap() {
        this.shortcuttableActionsMap.put("Shortcuts.Common", this.getCommonShortcuttableActionsMap());
        this.shortcuttableActionsMap.put("Menu.Options.AnnotationMode", this.getAnnotationModeShortcuttableActionsMap());
        this.shortcuttableActionsMap.put("Menu.Options.SyncMode", this.getSyncModeShortcuttableActionsMap());
        this.shortcuttableActionsMap.put("Menu.Options.TranscriptionMode", this.getTranscModeShortcuttableActionsMap());
        this.shortcuttableActionsMap.put("Menu.Options.SegmentationMode", this.getSegmentModeShortcuttableActionsMap());
        this.shortcuttableActionsMap.put("Menu.Options.TurnsAndSceneMode", this.getTurnsAndSceneModeShortcuttableActionsMap());
        this.shortcuttableActionsMap.put("Menu.Options.InterlinearizationMode", this.getInterlinearModeShortcuttableActionsMap());
    }

    private void fillShortcutMap() {
        if (!this.readCurrentShortcuts()) {
            this.loadDefaultShortcuts();
        }
    }

    private void loadDefaultShortcuts() {
        this.shortcutKeyStrokesMap.put("Shortcuts.Common", this.getCommonDefaultShortcutsMap());
        this.shortcutKeyStrokesMap.put("Menu.Options.AnnotationMode", this.getAnnotationModeDefaultShortcutsMap());
        this.shortcutKeyStrokesMap.put("Menu.Options.SyncMode", this.getSyncModeDefaultShortcutsMap());
        this.shortcutKeyStrokesMap.put("Menu.Options.TranscriptionMode", this.getTranscModeDefaultShortcutsMap());
        this.shortcutKeyStrokesMap.put("Menu.Options.SegmentationMode", this.getSegmentModeDefaultShortcutsMap());
        this.shortcutKeyStrokesMap.put("Menu.Options.TurnsAndSceneMode", this.getTurnsAndSceneModeDefaultShortcutsMap());
        this.shortcutKeyStrokesMap.put("Menu.Options.InterlinearizationMode", this.getInterlinearModeDefaultShortcutsMap());
        this.addActionsWithoutShortcut();
    }

    private Map<String, List<String>> getAnnotationModeShortcuttableActionsMap() {
        Map<String, List<String>> shortcuttableActions = this.shortcuttableActionsMap.get("Menu.Options.AnnotationMode");
        if (shortcuttableActions != null) {
            return shortcuttableActions;
        }
        shortcuttableActions = new LinkedHashMap<String, List<String>>(8);
        ArrayList<String> editActions = new ArrayList<String>();
        editActions.add("Menu.Annotation.NewAnnotation");
        editActions.add("Menu.Annotation.NewAnnotationBefore");
        editActions.add("Menu.Annotation.NewAnnotationAfter");
        editActions.add("Menu.Annotation.NewAnnotationFromBeginEndTimeDialog");
        editActions.add("CommandActions.KeyCreateAnnotation");
        editActions.add("Menu.Annotation.CopyAnnotation");
        editActions.add("Menu.Annotation.CopyAnnotationTree");
        editActions.add("Menu.Annotation.PasteAnnotation");
        editActions.add("Menu.Annotation.PasteAnnotationHere");
        editActions.add("Menu.Annotation.PasteAnnotationTree");
        editActions.add("Menu.Annotation.PasteAnnotationTreeHere");
        editActions.add("Menu.Annotation.DuplicateAnnotation");
        editActions.add("CommandActions.CopyToNextAnnotation");
        editActions.add("Menu.Annotation.ModifyAnnotation");
        editActions.add("CommandActions.ModifyAnnotationTime");
        editActions.add("Menu.Annotation.ModifyAnnotationTimeDialog");
        editActions.add("Menu.Annotation.ModifyAnnotationDatCat");
        editActions.add("CommandActions.Annotation_LBound_Left");
        editActions.add("CommandActions.Annotation_LBound_Right");
        editActions.add("CommandActions.Annotation_RBound_Left");
        editActions.add("CommandActions.Annotation_RBound_Right");
        editActions.add("Menu.Annotation.RemoveAnnotationValue");
        editActions.add("Menu.Annotation.DeleteAnnotation");
        editActions.add("Menu.Annotation.ShiftActiveAnnotation");
        editActions.add("CommandActions.OpenInlineEditBox");
        editActions.add("Menu.Annotation.MergeWithNext");
        editActions.add("Menu.Annotation.MergeWithBefore");
        editActions.add("Menu.Tier.RegularAnnotation");
        editActions.add("Menu.Annotation.DeleteAnnotationsInSelection");
        editActions.add("Menu.Annotation.DeleteAnnotationsLeftOf");
        editActions.add("Menu.Annotation.DeleteAnnotationsRightOf");
        editActions.add("Menu.Annotation.DeleteAllLeftOf");
        editActions.add("Menu.Annotation.DeleteAllRightOf");
        editActions.add("Menu.Annotation.ShiftAll");
        editActions.add("Menu.Annotation.ShiftAllLeftOf");
        editActions.add("Menu.Annotation.ShiftAllRightOf");
        editActions.add("Menu.Annotation.ShiftAnnotationsInSelection");
        editActions.add("Menu.Annotation.ShiftAnnotationsLeftOf");
        editActions.add("Menu.Annotation.ShiftAnnotationsRightOf");
        editActions.add("Menu.Annotation.SplitAnnotation");
        shortcuttableActions.put(ANN_EDIT_CAT, editActions);
        ArrayList<String> navActions = new ArrayList<String>();
        navActions.add("CommandActions.PreviousAnnotation");
        navActions.add("CommandActions.PreviousAnnotationEdit");
        navActions.add("CommandActions.NextAnnotation");
        navActions.add("CommandActions.NextAnnotationEdit");
        navActions.add("CommandActions.AnnotationUp");
        navActions.add("CommandActions.AnnotationDown");
        shortcuttableActions.put(ANN_NAVIGATION_CAT, navActions);
        ArrayList<String> tierActions = new ArrayList<String>();
        tierActions.add("CommandActions.PreviousActiveTier");
        tierActions.add("CommandActions.NextActiveTier");
        shortcuttableActions.put(TIER_TYPE_CAT, tierActions);
        ArrayList<String> selActions = new ArrayList<String>();
        selActions.add("Menu.Play.ClearSelection");
        selActions.add("Menu.Play.ClearSelectionAndMode");
        selActions.add("Menu.Play.ToggleCrosshairInSelection");
        selActions.add("Menu.Play.MoveCrosshairToCenterOfSelection");
        selActions.add("CommandActions.SelectionMode");
        selActions.add("TimeLineViewer.CenterSelection");
        shortcuttableActions.put(SELECTION_CAT, selActions);
        ArrayList<String> medNavActions = new ArrayList<String>();
        medNavActions.add("Menu.Play.PlayPause");
        medNavActions.add("Menu.Play.PlaySelection");
        medNavActions.add("CommandActions.PlaySelectionNormalSpeed");
        medNavActions.add("CommandActions.PlaySelectionSlow");
        medNavActions.add("CommandActions.PlayAroundSelection");
        medNavActions.add("Menu.Play.PlayStepAndRepeat");
        medNavActions.add("Menu.Play.1PixelLeft");
        medNavActions.add("Menu.Play.1PixelRight");
        medNavActions.add("Menu.Play.Previous");
        medNavActions.add("Menu.Play.Next");
        medNavActions.add("Menu.Play.1SecLeft");
        medNavActions.add("Menu.Play.1SecRight");
        medNavActions.add("Menu.Play.GoToPreviousScrollview");
        medNavActions.add("Menu.Play.GoToNextScrollview");
        medNavActions.add("Menu.Play.GoToBegin");
        medNavActions.add("Menu.Play.GoToEnd");
        medNavActions.add("Menu.Search.GoTo");
        medNavActions.add("CommandActions.LoopMode");
        medNavActions.add("Menu.Options.PlaybackToggleDialog");
        shortcuttableActions.put(MEDIA_CAT, medNavActions);
        ArrayList<String> miscActions = new ArrayList<String>();
        miscActions.add("CommandActions.PlaybackRateToggle");
        miscActions.add("CommandActions.PlaybackVolumeToggle");
        miscActions.add("MultiTierViewer.ShiftToolTip");
        miscActions.add("Menu.View.ZoomIn");
        miscActions.add("Menu.View.ZoomOut");
        miscActions.add("Menu.View.ZoomDefault");
        miscActions.add("CommandActions.CycleTierSets");
        shortcuttableActions.put(MISC_CAT, miscActions);
        return shortcuttableActions;
    }

    private Map<String, KeyStroke> getAnnotationModeDefaultShortcutsMap() {
        LinkedHashMap<String, KeyStroke> shortcutKeyStrokes = new LinkedHashMap<String, KeyStroke>(80);
        int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        shortcutKeyStrokes.put("Menu.Annotation.NewAnnotation", KeyStroke.getKeyStroke(78, menuShortcutKeyMask + 8));
        shortcutKeyStrokes.put("Menu.Annotation.NewAnnotationBefore", KeyStroke.getKeyStroke(78, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.Annotation.NewAnnotationAfter", KeyStroke.getKeyStroke(78, 9));
        shortcutKeyStrokes.put("Menu.Annotation.NewAnnotationFromBeginEndTimeDialog", KeyStroke.getKeyStroke(78, menuShortcutKeyMask + 1 + 8));
        shortcutKeyStrokes.put("CommandActions.KeyCreateAnnotation", KeyStroke.getKeyStroke(10, 1));
        shortcutKeyStrokes.put("Menu.Annotation.CopyAnnotation", KeyStroke.getKeyStroke(67, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Annotation.CopyAnnotationTree", KeyStroke.getKeyStroke(67, menuShortcutKeyMask + 8));
        shortcutKeyStrokes.put("Menu.Annotation.PasteAnnotation", KeyStroke.getKeyStroke(86, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Annotation.PasteAnnotationHere", KeyStroke.getKeyStroke(86, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.Annotation.PasteAnnotationTree", KeyStroke.getKeyStroke(86, menuShortcutKeyMask + 8));
        shortcutKeyStrokes.put("Menu.Annotation.PasteAnnotationTreeHere", KeyStroke.getKeyStroke(86, menuShortcutKeyMask + 8 + 1));
        shortcutKeyStrokes.put("Menu.Annotation.DuplicateAnnotation", KeyStroke.getKeyStroke(68, menuShortcutKeyMask));
        shortcutKeyStrokes.put("CommandActions.CopyToNextAnnotation", KeyStroke.getKeyStroke(68, 3));
        shortcutKeyStrokes.put("Menu.Annotation.ModifyAnnotation", KeyStroke.getKeyStroke(77, menuShortcutKeyMask + 8));
        shortcutKeyStrokes.put("CommandActions.ModifyAnnotationTime", KeyStroke.getKeyStroke(10, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Annotation.ModifyAnnotationDatCat", KeyStroke.getKeyStroke(77, 9));
        shortcutKeyStrokes.put("Menu.Annotation.ModifyAnnotationTimeDialog", KeyStroke.getKeyStroke(77, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("CommandActions.Annotation_LBound_Left", KeyStroke.getKeyStroke(74, 2));
        shortcutKeyStrokes.put("CommandActions.Annotation_LBound_Right", KeyStroke.getKeyStroke(85, 2));
        shortcutKeyStrokes.put("CommandActions.Annotation_RBound_Left", KeyStroke.getKeyStroke(74, 3));
        shortcutKeyStrokes.put("CommandActions.Annotation_RBound_Right", KeyStroke.getKeyStroke(85, 3));
        shortcutKeyStrokes.put("Menu.Annotation.RemoveAnnotationValue", KeyStroke.getKeyStroke(127, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Annotation.DeleteAnnotation", KeyStroke.getKeyStroke(68, menuShortcutKeyMask + 8));
        shortcutKeyStrokes.put("Menu.Annotation.ShiftActiveAnnotation", KeyStroke.getKeyStroke(10, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("CommandActions.OpenInlineEditBox", KeyStroke.getKeyStroke(69, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("CommandActions.PreviousAnnotation", KeyStroke.getKeyStroke(37, 8));
        shortcutKeyStrokes.put("CommandActions.PreviousAnnotationEdit", KeyStroke.getKeyStroke(37, menuShortcutKeyMask + 8));
        shortcutKeyStrokes.put("CommandActions.NextAnnotation", KeyStroke.getKeyStroke(39, 8));
        shortcutKeyStrokes.put("CommandActions.NextAnnotationEdit", KeyStroke.getKeyStroke(39, menuShortcutKeyMask + 8));
        shortcutKeyStrokes.put("CommandActions.AnnotationUp", KeyStroke.getKeyStroke(38, 8));
        shortcutKeyStrokes.put("CommandActions.AnnotationDown", KeyStroke.getKeyStroke(40, 8));
        shortcutKeyStrokes.put("CommandActions.PreviousActiveTier", KeyStroke.getKeyStroke(38, menuShortcutKeyMask));
        shortcutKeyStrokes.put("CommandActions.NextActiveTier", KeyStroke.getKeyStroke(40, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.ClearSelection", KeyStroke.getKeyStroke(67, 9));
        shortcutKeyStrokes.put("Menu.Play.ClearSelectionAndMode", KeyStroke.getKeyStroke(90, 3));
        shortcutKeyStrokes.put("Menu.Play.ToggleCrosshairInSelection", KeyStroke.getKeyStroke(47, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.MoveCrosshairToCenterOfSelection", KeyStroke.getKeyStroke(47, menuShortcutKeyMask + 8));
        shortcutKeyStrokes.put("CommandActions.SelectionMode", KeyStroke.getKeyStroke(75, menuShortcutKeyMask));
        shortcutKeyStrokes.put("TimeLineViewer.CenterSelection", KeyStroke.getKeyStroke(65, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.Play.PlayPause", KeyStroke.getKeyStroke(32, 2));
        shortcutKeyStrokes.put("Menu.Play.PlaySelection", KeyStroke.getKeyStroke(32, 1));
        shortcutKeyStrokes.put("CommandActions.PlayAroundSelection", KeyStroke.getKeyStroke(32, 3));
        shortcutKeyStrokes.put("CommandActions.PlaySelectionSlow", KeyStroke.getKeyStroke(53, 2));
        shortcutKeyStrokes.put("CommandActions.PlaySelectionNormalSpeed", KeyStroke.getKeyStroke(48, 2));
        shortcutKeyStrokes.put("Menu.Play.PlayStepAndRepeat", KeyStroke.getKeyStroke(32, 10));
        shortcutKeyStrokes.put("Menu.Play.1PixelLeft", KeyStroke.getKeyStroke(37, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.Play.1PixelRight", KeyStroke.getKeyStroke(39, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.Play.Previous", KeyStroke.getKeyStroke(37, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.Next", KeyStroke.getKeyStroke(39, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.1SecLeft", KeyStroke.getKeyStroke(37, 1));
        shortcutKeyStrokes.put("Menu.Play.1SecRight", KeyStroke.getKeyStroke(39, 1));
        shortcutKeyStrokes.put("Menu.Play.GoToPreviousScrollview", KeyStroke.getKeyStroke(33, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.GoToNextScrollview", KeyStroke.getKeyStroke(34, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.GoToBegin", KeyStroke.getKeyStroke(66, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.GoToEnd", KeyStroke.getKeyStroke(69, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Search.GoTo", KeyStroke.getKeyStroke(71, menuShortcutKeyMask));
        shortcutKeyStrokes.put("CommandActions.LoopMode", KeyStroke.getKeyStroke(76, menuShortcutKeyMask));
        shortcutKeyStrokes.put("CommandActions.PlaybackRateToggle", KeyStroke.getKeyStroke(82, menuShortcutKeyMask + 8));
        shortcutKeyStrokes.put("CommandActions.PlaybackVolumeToggle", KeyStroke.getKeyStroke(82, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.View.ZoomIn", KeyStroke.getKeyStroke(61, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.View.ZoomOut", KeyStroke.getKeyStroke(45, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.View.ZoomDefault", KeyStroke.getKeyStroke(48, menuShortcutKeyMask));
        shortcutKeyStrokes.put("CommandActions.CycleTierSets", KeyStroke.getKeyStroke(84, 9));
        return shortcutKeyStrokes;
    }

    private Map<String, List<String>> getTranscModeShortcuttableActionsMap() {
        Map<String, List<String>> shortcuttableActions = this.shortcuttableActionsMap.get("Menu.Options.TranscriptionMode");
        if (shortcuttableActions != null) {
            return shortcuttableActions;
        }
        shortcuttableActions = new LinkedHashMap<String, List<String>>(8);
        ArrayList<String> editActions = new ArrayList<String>();
        editActions.add("TranscriptionMode.Actions.CommitChanges");
        editActions.add("TranscriptionMode.Actions.CancelChanges");
        editActions.add("Menu.Annotation.DeleteAnnotation");
        editActions.add("Menu.Annotation.MergeWithNext");
        editActions.add("Menu.Annotation.MergeWithBefore");
        shortcuttableActions.put(ANN_EDIT_CAT, editActions);
        ArrayList<String> navActions = new ArrayList<String>();
        navActions.add("TranscriptionMode.Actions.MoveUp");
        navActions.add("TranscriptionMode.Actions.MoveDown");
        navActions.add("TranscriptionMode.Actions.MoveLeft");
        navActions.add("TranscriptionMode.Actions.MoveRight");
        shortcuttableActions.put(ANN_NAVIGATION_CAT, navActions);
        ArrayList<String> selActions = new ArrayList<String>();
        selActions.add("Menu.Play.ClearSelection");
        selActions.add("Menu.Play.ToggleCrosshairInSelection");
        selActions.add("Menu.Play.MoveCrosshairToCenterOfSelection");
        shortcuttableActions.put(SELECTION_CAT, selActions);
        ArrayList<String> medNavActions = new ArrayList<String>();
        medNavActions.add("Menu.Play.PlayPause");
        medNavActions.add("TranscriptionMode.Actions.PlayFromStart");
        medNavActions.add("Menu.Play.PlaySelection");
        medNavActions.add("CommandActions.PlayAroundSelection");
        medNavActions.add("Menu.Play.1PixelLeft");
        medNavActions.add("Menu.Play.1PixelRight");
        medNavActions.add("Menu.Play.Previous");
        medNavActions.add("Menu.Play.Next");
        medNavActions.add("Menu.Play.1SecLeft");
        medNavActions.add("Menu.Play.1SecRight");
        medNavActions.add("CommandActions.LoopMode");
        shortcuttableActions.put(MEDIA_CAT, medNavActions);
        ArrayList<String> miscActions = new ArrayList<String>();
        miscActions.add("TranscriptionTableEditBox.EditInAnnotationMode");
        miscActions.add("TranscriptionMode.Actions.FreezeTier");
        miscActions.add("TranscriptionTable.Label.HideLinkedTiers");
        miscActions.add("Menu.View.ZoomIn");
        miscActions.add("Menu.View.ZoomOut");
        miscActions.add("Menu.View.ZoomDefault");
        shortcuttableActions.put(MISC_CAT, miscActions);
        return shortcuttableActions;
    }

    private Map<String, KeyStroke> getTranscModeDefaultShortcutsMap() {
        LinkedHashMap<String, KeyStroke> shortcutKeyStrokes = new LinkedHashMap<String, KeyStroke>(80);
        int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        shortcutKeyStrokes.put("TranscriptionMode.Actions.CommitChanges", KeyStroke.getKeyStroke(10, 0));
        shortcutKeyStrokes.put("TranscriptionMode.Actions.CancelChanges", KeyStroke.getKeyStroke(27, 0));
        shortcutKeyStrokes.put("Menu.Annotation.DeleteAnnotation", KeyStroke.getKeyStroke(127, 1));
        shortcutKeyStrokes.put("Menu.Annotation.MergeWithNext", KeyStroke.getKeyStroke(65, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.Annotation.MergeWithBefore", KeyStroke.getKeyStroke(66, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("TranscriptionMode.Actions.MoveUp", KeyStroke.getKeyStroke(38, 8));
        shortcutKeyStrokes.put("TranscriptionMode.Actions.MoveDown", KeyStroke.getKeyStroke(40, 8));
        shortcutKeyStrokes.put("TranscriptionMode.Actions.MoveLeft", KeyStroke.getKeyStroke(37, 8));
        shortcutKeyStrokes.put("TranscriptionMode.Actions.MoveRight", KeyStroke.getKeyStroke(39, 8));
        shortcutKeyStrokes.put("Menu.Play.ClearSelection", KeyStroke.getKeyStroke(67, 9));
        shortcutKeyStrokes.put("Menu.Play.ToggleCrosshairInSelection", KeyStroke.getKeyStroke(47, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.MoveCrosshairToCenterOfSelection", KeyStroke.getKeyStroke(47, menuShortcutKeyMask + 8));
        shortcutKeyStrokes.put("Menu.Play.PlayPause", KeyStroke.getKeyStroke(9, 0));
        shortcutKeyStrokes.put("TranscriptionMode.Actions.PlayFromStart", KeyStroke.getKeyStroke(9, 1));
        shortcutKeyStrokes.put("Menu.Play.PlaySelection", KeyStroke.getKeyStroke(32, 1));
        shortcutKeyStrokes.put("CommandActions.PlayAroundSelection", KeyStroke.getKeyStroke(32, 3));
        shortcutKeyStrokes.put("Menu.Play.1PixelLeft", KeyStroke.getKeyStroke(37, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.Play.1PixelRight", KeyStroke.getKeyStroke(39, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.Play.Previous", KeyStroke.getKeyStroke(37, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.Next", KeyStroke.getKeyStroke(39, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.1SecLeft", KeyStroke.getKeyStroke(37, 1));
        shortcutKeyStrokes.put("Menu.Play.1SecRight", KeyStroke.getKeyStroke(39, 1));
        shortcutKeyStrokes.put("CommandActions.LoopMode", KeyStroke.getKeyStroke(76, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.View.ZoomIn", KeyStroke.getKeyStroke(61, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.View.ZoomOut", KeyStroke.getKeyStroke(45, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.View.ZoomDefault", KeyStroke.getKeyStroke(48, menuShortcutKeyMask));
        return shortcutKeyStrokes;
    }

    private Map<String, List<String>> getSegmentModeShortcuttableActionsMap() {
        Map<String, List<String>> shortcuttableActions = this.shortcuttableActionsMap.get("Menu.Options.SegmentationMode");
        if (shortcuttableActions != null) {
            return shortcuttableActions;
        }
        shortcuttableActions = new LinkedHashMap<String, List<String>>(8);
        ArrayList<String> editActions = new ArrayList<String>();
        editActions.add("Menu.Annotation.DeleteAnnotation");
        editActions.add("SegmentationMode.Actions.Segment");
        editActions.add("Menu.Annotation.MergeWithNext");
        editActions.add("Menu.Annotation.MergeWithBefore");
        editActions.add("Menu.Annotation.ModifyAnnotationTimeDialog");
        editActions.add("Menu.Annotation.SplitAnnotation");
        shortcuttableActions.put(ANN_EDIT_CAT, editActions);
        ArrayList<String> tierActions = new ArrayList<String>();
        tierActions.add("CommandActions.PreviousActiveTier");
        tierActions.add("CommandActions.NextActiveTier");
        shortcuttableActions.put(TIER_TYPE_CAT, tierActions);
        ArrayList<String> selActions = new ArrayList<String>();
        selActions.add("Menu.Play.ClearSelection");
        selActions.add("Menu.Play.ToggleCrosshairInSelection");
        selActions.add("Menu.Play.MoveCrosshairToCenterOfSelection");
        shortcuttableActions.put(SELECTION_CAT, selActions);
        ArrayList<String> medNavActions = new ArrayList<String>();
        medNavActions.add("Menu.Play.PlayPause");
        medNavActions.add("Menu.Play.PlaySelection");
        medNavActions.add("CommandActions.PlayAroundSelection");
        medNavActions.add("Menu.Play.PlayStepAndRepeat");
        medNavActions.add("Menu.Play.1PixelLeft");
        medNavActions.add("Menu.Play.1PixelRight");
        medNavActions.add("Menu.Play.Previous");
        medNavActions.add("Menu.Play.Next");
        medNavActions.add("Menu.Play.GoToPreviousScrollview");
        medNavActions.add("Menu.Play.GoToNextScrollview");
        medNavActions.add("Menu.Play.1SecLeft");
        medNavActions.add("Menu.Play.1SecRight");
        medNavActions.add("Menu.Play.GoToBegin");
        medNavActions.add("Menu.Play.GoToEnd");
        medNavActions.add("Menu.Search.GoTo");
        medNavActions.add("Menu.Options.PlayAroundSelectionDialog");
        medNavActions.add("Menu.Options.PlaybackToggleDialog");
        shortcuttableActions.put(MEDIA_CAT, medNavActions);
        ArrayList<String> miscActions = new ArrayList<String>();
        miscActions.add("CommandActions.PlaybackRateToggle");
        miscActions.add("CommandActions.PlaybackVolumeToggle");
        miscActions.add("Menu.Options.BulldozerMode");
        miscActions.add("Menu.Options.NormalPropagationMode");
        miscActions.add("Menu.Options.ShiftMode");
        miscActions.add("Menu.View.ZoomIn");
        miscActions.add("Menu.View.ZoomOut");
        miscActions.add("Menu.View.ZoomDefault");
        shortcuttableActions.put(MISC_CAT, miscActions);
        return shortcuttableActions;
    }

    private Map<String, KeyStroke> getSegmentModeDefaultShortcutsMap() {
        LinkedHashMap<String, KeyStroke> shortcutKeyStrokes = new LinkedHashMap<String, KeyStroke>(80);
        int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        shortcutKeyStrokes.put("Menu.Annotation.DeleteAnnotation", KeyStroke.getKeyStroke(8, 0));
        shortcutKeyStrokes.put("SegmentationMode.Actions.Segment", KeyStroke.getKeyStroke(10, 0));
        shortcutKeyStrokes.put("Menu.Annotation.MergeWithNext", KeyStroke.getKeyStroke(65, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.Annotation.MergeWithBefore", KeyStroke.getKeyStroke(66, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.Annotation.ModifyAnnotationTimeDialog", KeyStroke.getKeyStroke(77, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("CommandActions.PreviousActiveTier", KeyStroke.getKeyStroke(38, 0));
        shortcutKeyStrokes.put("CommandActions.NextActiveTier", KeyStroke.getKeyStroke(40, 0));
        shortcutKeyStrokes.put("Menu.Play.ClearSelection", KeyStroke.getKeyStroke(67, 9));
        shortcutKeyStrokes.put("Menu.Play.ToggleCrosshairInSelection", KeyStroke.getKeyStroke(47, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.MoveCrosshairToCenterOfSelection", KeyStroke.getKeyStroke(47, menuShortcutKeyMask + 8));
        shortcutKeyStrokes.put("Menu.Play.PlayPause", KeyStroke.getKeyStroke(32, 2));
        shortcutKeyStrokes.put("Menu.Play.PlaySelection", KeyStroke.getKeyStroke(32, 1));
        shortcutKeyStrokes.put("CommandActions.PlayAroundSelection", KeyStroke.getKeyStroke(32, 3));
        shortcutKeyStrokes.put("Menu.Play.PlayStepAndRepeat", KeyStroke.getKeyStroke(32, 10));
        shortcutKeyStrokes.put("Menu.Play.1PixelLeft", KeyStroke.getKeyStroke(37, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.Play.1PixelRight", KeyStroke.getKeyStroke(39, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.Play.Previous", KeyStroke.getKeyStroke(37, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.Next", KeyStroke.getKeyStroke(39, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.1SecLeft", KeyStroke.getKeyStroke(37, 1));
        shortcutKeyStrokes.put("Menu.Play.1SecRight", KeyStroke.getKeyStroke(39, 1));
        shortcutKeyStrokes.put("Menu.Play.GoToPreviousScrollview", KeyStroke.getKeyStroke(33, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.GoToNextScrollview", KeyStroke.getKeyStroke(34, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.GoToBegin", KeyStroke.getKeyStroke(66, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.GoToEnd", KeyStroke.getKeyStroke(69, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Search.GoTo", KeyStroke.getKeyStroke(71, menuShortcutKeyMask));
        shortcutKeyStrokes.put("CommandActions.PlaybackRateToggle", KeyStroke.getKeyStroke(82, menuShortcutKeyMask + 8));
        shortcutKeyStrokes.put("CommandActions.PlaybackVolumeToggle", KeyStroke.getKeyStroke(82, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.View.ZoomIn", KeyStroke.getKeyStroke(61, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.View.ZoomOut", KeyStroke.getKeyStroke(45, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.View.ZoomDefault", KeyStroke.getKeyStroke(48, menuShortcutKeyMask));
        return shortcutKeyStrokes;
    }

    private Map<String, List<String>> getSyncModeShortcuttableActionsMap() {
        Map<String, List<String>> shortcuttableActions = this.shortcuttableActionsMap.get("Menu.Options.SyncMode");
        if (shortcuttableActions != null) {
            return shortcuttableActions;
        }
        shortcuttableActions = new LinkedHashMap<String, List<String>>(8);
        ArrayList<String> medNavActions = new ArrayList<String>();
        medNavActions.add("Menu.Play.PlayPause");
        medNavActions.add("Menu.Play.1PixelLeft");
        medNavActions.add("Menu.Play.1PixelRight");
        medNavActions.add("Menu.Play.Previous");
        medNavActions.add("Menu.Play.Next");
        medNavActions.add("Menu.Play.1SecLeft");
        medNavActions.add("Menu.Play.1SecRight");
        medNavActions.add("Menu.Play.GoToBegin");
        medNavActions.add("Menu.Play.GoToEnd");
        medNavActions.add("Menu.Search.GoTo");
        medNavActions.add("Menu.Options.PlaybackToggleDialog");
        shortcuttableActions.put(MEDIA_CAT, medNavActions);
        return shortcuttableActions;
    }

    private Map<String, KeyStroke> getSyncModeDefaultShortcutsMap() {
        LinkedHashMap<String, KeyStroke> shortcutKeyStrokes = new LinkedHashMap<String, KeyStroke>(80);
        int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        shortcutKeyStrokes.put("Menu.Play.PlayPause", KeyStroke.getKeyStroke(32, 2));
        shortcutKeyStrokes.put("Menu.Play.1PixelLeft", KeyStroke.getKeyStroke(37, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.Play.1PixelRight", KeyStroke.getKeyStroke(39, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.Play.Previous", KeyStroke.getKeyStroke(37, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.Next", KeyStroke.getKeyStroke(39, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.1SecLeft", KeyStroke.getKeyStroke(37, 1));
        shortcutKeyStrokes.put("Menu.Play.1SecRight", KeyStroke.getKeyStroke(39, 1));
        shortcutKeyStrokes.put("Menu.Play.GoToBegin", KeyStroke.getKeyStroke(66, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.GoToEnd", KeyStroke.getKeyStroke(69, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Search.GoTo", KeyStroke.getKeyStroke(71, menuShortcutKeyMask));
        return shortcutKeyStrokes;
    }

    private Map<String, List<String>> getTurnsAndSceneModeShortcuttableActionsMap() {
        Map<String, List<String>> shortcuttableActions = this.shortcuttableActionsMap.get("Menu.Options.TurnsAndSceneMode");
        if (shortcuttableActions != null) {
            return shortcuttableActions;
        }
        shortcuttableActions = new LinkedHashMap<String, List<String>>(8);
        ArrayList<String> editActions = new ArrayList<String>();
        editActions.add("Menu.Annotation.SplitAnnotation");
        editActions.add("Menu.Annotation.RemoveAnnotationValue");
        editActions.add("Menu.Annotation.DeleteAnnotation");
        editActions.add("Menu.Annotation.MergeWithNext");
        editActions.add("Menu.Annotation.MergeWithBefore");
        editActions.add("CommandActions.ModifyAnnotationTime");
        shortcuttableActions.put(ANN_EDIT_CAT, editActions);
        ArrayList<String> navActions = new ArrayList<String>();
        navActions.add("CommandActions.PreviousAnnotation");
        navActions.add("CommandActions.NextAnnotation");
        navActions.add("CommandActions.AnnotationAtCurrentTime");
        navActions.add("CommandActions.CancelAnnotationEdit");
        shortcuttableActions.put(ANN_NAVIGATION_CAT, navActions);
        ArrayList<String> selActions = new ArrayList<String>();
        selActions.add("Menu.Play.ClearSelection");
        selActions.add("Menu.Play.ToggleCrosshairInSelection");
        selActions.add("Menu.Play.MoveCrosshairToCenterOfSelection");
        selActions.add("Menu.Play.MoveCrosshairToBeginOfSelection");
        selActions.add("Menu.Play.MoveCrosshairToEndOfSelection");
        shortcuttableActions.put(SELECTION_CAT, selActions);
        ArrayList<String> medNavActions = new ArrayList<String>();
        medNavActions.add("Menu.Play.PlayPause");
        medNavActions.add("Menu.Play.PlaySelection");
        medNavActions.add("CommandActions.PlayAroundSelection");
        medNavActions.add("Menu.Play.1PixelLeft");
        medNavActions.add("Menu.Play.1PixelRight");
        medNavActions.add("Menu.Play.Previous");
        medNavActions.add("Menu.Play.Next");
        medNavActions.add("Menu.Play.1SecLeft");
        medNavActions.add("Menu.Play.1SecRight");
        medNavActions.add("Menu.Play.GoToPreviousScrollview");
        medNavActions.add("Menu.Play.GoToNextScrollview");
        medNavActions.add("Menu.Play.GoToBegin");
        medNavActions.add("Menu.Play.GoToEnd");
        medNavActions.add("Menu.Search.GoTo");
        medNavActions.add("CommandActions.LoopMode");
        medNavActions.add("CommandActions.ContinuousPlaybackMode");
        shortcuttableActions.put(MEDIA_CAT, medNavActions);
        ArrayList<String> miscActions = new ArrayList<String>();
        miscActions.add("Menu.View.ZoomIn");
        miscActions.add("Menu.View.ZoomOut");
        miscActions.add("Menu.View.ZoomDefault");
        shortcuttableActions.put(MISC_CAT, miscActions);
        return shortcuttableActions;
    }

    private Map<String, KeyStroke> getTurnsAndSceneModeDefaultShortcutsMap() {
        LinkedHashMap<String, KeyStroke> shortcutKeyStrokes = new LinkedHashMap<String, KeyStroke>(80);
        int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        shortcutKeyStrokes.put("Menu.Annotation.SplitAnnotation", KeyStroke.getKeyStroke(10, 0));
        shortcutKeyStrokes.put("Menu.Annotation.RemoveAnnotationValue", KeyStroke.getKeyStroke(127, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Annotation.DeleteAnnotation", KeyStroke.getKeyStroke(68, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.Annotation.MergeWithBefore", KeyStroke.getKeyStroke(38, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.Annotation.MergeWithNext", KeyStroke.getKeyStroke(40, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("CommandActions.ModifyAnnotationTime", KeyStroke.getKeyStroke(10, menuShortcutKeyMask));
        shortcutKeyStrokes.put("CommandActions.PreviousAnnotation", KeyStroke.getKeyStroke(37, 8));
        shortcutKeyStrokes.put("CommandActions.AnnotationUp", KeyStroke.getKeyStroke(38, menuShortcutKeyMask));
        shortcutKeyStrokes.put("CommandActions.NextAnnotation", KeyStroke.getKeyStroke(39, 8));
        shortcutKeyStrokes.put("CommandActions.AnnotationDown", KeyStroke.getKeyStroke(40, menuShortcutKeyMask));
        shortcutKeyStrokes.put("CommandActions.AnnotationAtCurrentTime", KeyStroke.getKeyStroke(47, menuShortcutKeyMask));
        shortcutKeyStrokes.put("CommandActions.CancelAnnotationEdit", KeyStroke.getKeyStroke(27, 0));
        shortcutKeyStrokes.put("Menu.Play.ClearSelection", KeyStroke.getKeyStroke(67, 9));
        shortcutKeyStrokes.put("Menu.Play.MoveCrosshairToBeginOfSelection", KeyStroke.getKeyStroke(91, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.MoveCrosshairToEndOfSelection", KeyStroke.getKeyStroke(93, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.MoveCrosshairToCenterOfSelection", KeyStroke.getKeyStroke(47, menuShortcutKeyMask + 8));
        shortcutKeyStrokes.put("Menu.Play.PlayPause", KeyStroke.getKeyStroke(32, 2));
        shortcutKeyStrokes.put("Menu.Play.PlaySelection", KeyStroke.getKeyStroke(32, 1));
        shortcutKeyStrokes.put("CommandActions.PlayAroundSelection", KeyStroke.getKeyStroke(32, 3));
        shortcutKeyStrokes.put("Menu.Play.1PixelLeft", KeyStroke.getKeyStroke(37, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.Play.1PixelRight", KeyStroke.getKeyStroke(39, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.Play.Previous", KeyStroke.getKeyStroke(37, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.Next", KeyStroke.getKeyStroke(39, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.1SecLeft", KeyStroke.getKeyStroke(37, 1));
        shortcutKeyStrokes.put("Menu.Play.1SecRight", KeyStroke.getKeyStroke(39, 1));
        shortcutKeyStrokes.put("Menu.Play.GoToPreviousScrollview", KeyStroke.getKeyStroke(33, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.GoToNextScrollview", KeyStroke.getKeyStroke(34, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.GoToBegin", KeyStroke.getKeyStroke(66, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Play.GoToEnd", KeyStroke.getKeyStroke(69, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Search.GoTo", KeyStroke.getKeyStroke(71, menuShortcutKeyMask));
        shortcutKeyStrokes.put("CommandActions.LoopMode", KeyStroke.getKeyStroke(76, menuShortcutKeyMask));
        shortcutKeyStrokes.put("CommandActions.ContinuousPlaybackMode", KeyStroke.getKeyStroke(75, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.View.ZoomIn", KeyStroke.getKeyStroke(61, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.View.ZoomOut", KeyStroke.getKeyStroke(45, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.View.ZoomDefault", KeyStroke.getKeyStroke(48, menuShortcutKeyMask));
        return shortcutKeyStrokes;
    }

    private Map<String, List<String>> getInterlinearModeShortcuttableActionsMap() {
        Map<String, List<String>> shortcuttableActions = this.shortcuttableActionsMap.get("Menu.Options.InterlinearizationMode");
        if (shortcuttableActions != null) {
            return shortcuttableActions;
        }
        shortcuttableActions = new LinkedHashMap<String, List<String>>(8);
        ArrayList<String> editActions = new ArrayList<String>();
        editActions.add("Menu.Annotation.NewAnnotationBefore");
        editActions.add("Menu.Annotation.NewAnnotationAfter");
        editActions.add("Menu.Annotation.DeleteAnnotation");
        editActions.add("CommandActions.OpenInlineEditBox");
        editActions.add("Menu.Annotation.SplitAnnotation");
        editActions.add("Menu.Annotation.CreateDependingAnnotations");
        editActions.add("Menu.Annotation.Analyze");
        editActions.add("Menu.Annotation.AddToLexicon");
        shortcuttableActions.put(ANN_EDIT_CAT, editActions);
        ArrayList<String> navActions = new ArrayList<String>();
        navActions.add("CommandActions.PreviousAnnotation");
        navActions.add("CommandActions.NextAnnotation");
        navActions.add("CommandActions.AnnotationUp");
        navActions.add("CommandActions.AnnotationDown");
        shortcuttableActions.put(ANN_NAVIGATION_CAT, navActions);
        ArrayList tierActions = new ArrayList();
        shortcuttableActions.put(TIER_TYPE_CAT, tierActions);
        ArrayList selActions = new ArrayList();
        shortcuttableActions.put(SELECTION_CAT, selActions);
        ArrayList<String> medNavActions = new ArrayList<String>();
        medNavActions.add("Menu.Play.PlayPause");
        medNavActions.add("Menu.Play.PlaySelection");
        medNavActions.add("CommandActions.PlayAroundSelection");
        medNavActions.add("Menu.Search.GoTo");
        medNavActions.add("CommandActions.LoopMode");
        shortcuttableActions.put(MEDIA_CAT, medNavActions);
        ArrayList<String> miscActions = new ArrayList<String>();
        miscActions.add("Menu.View.ZoomIn");
        miscActions.add("Menu.View.ZoomOut");
        miscActions.add("Menu.View.ZoomDefault");
        shortcuttableActions.put(MISC_CAT, miscActions);
        return shortcuttableActions;
    }

    private Map<String, KeyStroke> getInterlinearModeDefaultShortcutsMap() {
        LinkedHashMap<String, KeyStroke> shortcutKeyStrokes = new LinkedHashMap<String, KeyStroke>(10);
        int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        shortcutKeyStrokes.put("Menu.Annotation.DeleteAnnotation", KeyStroke.getKeyStroke(68, menuShortcutKeyMask + 8));
        shortcutKeyStrokes.put("Menu.Annotation.CreateDependingAnnotations", KeyStroke.getKeyStroke(68, menuShortcutKeyMask + 1 + 8));
        shortcutKeyStrokes.put("Menu.Annotation.NewAnnotationBefore", KeyStroke.getKeyStroke(78, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.Annotation.NewAnnotationAfter", KeyStroke.getKeyStroke(78, 9));
        shortcutKeyStrokes.put("Menu.Annotation.SplitAnnotation", KeyStroke.getKeyStroke(74, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Annotation.Analyze", KeyStroke.getKeyStroke(73, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Annotation.AddToLexicon", KeyStroke.getKeyStroke(76, menuShortcutKeyMask));
        shortcutKeyStrokes.put("CommandActions.OpenInlineEditBox", KeyStroke.getKeyStroke(69, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("CommandActions.PreviousAnnotation", KeyStroke.getKeyStroke(37, 8));
        shortcutKeyStrokes.put("CommandActions.NextAnnotation", KeyStroke.getKeyStroke(39, 8));
        shortcutKeyStrokes.put("CommandActions.AnnotationUp", KeyStroke.getKeyStroke(38, 8));
        shortcutKeyStrokes.put("CommandActions.AnnotationDown", KeyStroke.getKeyStroke(40, 8));
        shortcutKeyStrokes.put("Menu.Play.PlaySelection", KeyStroke.getKeyStroke(32, 1));
        shortcutKeyStrokes.put("Menu.Search.GoTo", KeyStroke.getKeyStroke(71, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.View.ZoomIn", KeyStroke.getKeyStroke(61, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.View.ZoomOut", KeyStroke.getKeyStroke(45, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.View.ZoomDefault", KeyStroke.getKeyStroke(48, menuShortcutKeyMask));
        return shortcutKeyStrokes;
    }

    private Map<String, List<String>> getCommonShortcuttableActionsMap() {
        Map<String, List<String>> shortcuttableActions = this.shortcuttableActionsMap.get("Shortcuts.Common");
        if (shortcuttableActions != null) {
            return shortcuttableActions;
        }
        shortcuttableActions = new LinkedHashMap<String, List<String>>(8);
        ArrayList<String> tierActions = new ArrayList<String>();
        tierActions.add("Menu.Tier.AddNewTier");
        tierActions.add("Menu.Tier.DeleteTier");
        tierActions.add("Menu.Type.AddNewType");
        tierActions.add("Menu.Tier.ChangeTier");
        tierActions.add("Menu.Tier.ReparentTier");
        tierActions.add("Menu.Tier.Tokenize");
        tierActions.add("Menu.Tier.FilterTierDlg");
        tierActions.add("Menu.Tier.CopyTierDialog");
        tierActions.add("Menu.Tier.AnnotationsFromOverlaps");
        tierActions.add("Menu.Tier.MergeTiers");
        tierActions.add("Menu.Tier.AnnotationsFromGaps");
        tierActions.add("Menu.Tier.ChangeCase");
        tierActions.add("Menu.File.MultipleFileCompareAnnotators");
        tierActions.add("Menu.Tier.RemoveAnnotationsOrValues");
        tierActions.add("Menu.Tier.AnnotationsOnDependentTiers");
        tierActions.add("Menu.Tier.LabelAndNumber");
        tierActions.add("Menu.View.Dependencies");
        tierActions.add("Menu.Type.ChangeType");
        tierActions.add("Menu.Type.DeleteType");
        tierActions.add("Menu.Tier.AddParticipant");
        tierActions.add("Menu.Tier.AnnotationValuesToTiers");
        tierActions.add("Menu.Tier.AnnotationsFromOverlapsClas");
        tierActions.add("Menu.Tier.AnnotationsFromSubtraction");
        tierActions.add("Menu.Tier.MergeTiersClassic");
        tierActions.add("Menu.Tier.MergeTierGroup");
        tierActions.add("Menu.Annotation.CreateDependingAnnotations");
        tierActions.add("Menu.Annotation.NewAnnotationRecursive");
        shortcuttableActions.put(TIER_TYPE_CAT, tierActions);
        ArrayList<String> docActions = new ArrayList<String>();
        docActions.add("Menu.File.New");
        docActions.add("Menu.File.Open");
        docActions.add("Menu.File.Save");
        docActions.add("Menu.File.SaveAs");
        docActions.add("Menu.File.SaveAsTemplate");
        docActions.add("Menu.File.Print");
        docActions.add("Menu.File.PrintPreview");
        docActions.add("Menu.File.PageSetup");
        docActions.add("Menu.Window.Next");
        docActions.add("Menu.Window.Previous");
        docActions.add("Menu.File.Close");
        docActions.add("Menu.File.Exit");
        docActions.add("Menu.File.OpenRemote");
        docActions.add("Menu.File.SaveSelectionAsEAF");
        docActions.add("Menu.File.Validate");
        docActions.add("Menu.File.MergeTranscriptions");
        docActions.add("Menu.File.Import.Shoebox");
        docActions.add("Menu.File.Import.Toolbox");
        docActions.add("Menu.File.Import.FLEx");
        docActions.add("Menu.File.Import.CHAT");
        docActions.add("Menu.File.Import.Transcriber");
        docActions.add("Menu.File.Import.Delimited");
        docActions.add("Menu.File.Import.Subtitle");
        docActions.add("Menu.File.Import.PraatTiers");
        docActions.add("Menu.Edit.Preferences.Import");
        docActions.add("Menu.Tier.ImportTiers");
        docActions.add("Menu.Type.ImportTypes");
        docActions.add("Menu.File.MultipleImport.FLEx");
        docActions.add("Menu.File.MultipleImport.PraatTiers");
        docActions.add("Menu.File.MultipleImport.Toolbox");
        docActions.add("Menu.File.MultipleExport.Toolbox");
        docActions.add("Menu.File.MultipleExport.Flex");
        docActions.add("Menu.File.MultipleExport.Tab");
        docActions.add("Menu.File.MultipleExport.Praat");
        docActions.add("Menu.File.Export.AnnotationListMulti");
        docActions.add("Menu.File.MultipleExport.WordList");
        docActions.add("Menu.File.Export.Tiers");
        docActions.add("Menu.File.Export.OverlapsMulti");
        docActions.add("Menu.File.Export.FilmStrip");
        docActions.add("Menu.File.Export.HTML");
        docActions.add("Menu.File.Export.ImageFromWindow");
        docActions.add("Menu.File.Export.Interlinear");
        docActions.add("Menu.File.Export.MediaWithScript");
        docActions.add("Menu.File.Export.Praat");
        docActions.add("Menu.Edit.Preferences.Export");
        docActions.add("Menu.File.Export.QtSub");
        docActions.add("Menu.File.Export.Shoebox");
        docActions.add("Menu.File.Export.Smil.RealPlayer");
        docActions.add("Menu.File.Export.Smil.QuickTime");
        docActions.add("Menu.File.Export.Subtitles");
        docActions.add("Menu.File.Export.Tab");
        docActions.add("Menu.File.Export.RecognizerTiers");
        docActions.add("Menu.File.Export.Tiger");
        docActions.add("Menu.File.Export.Toolbox");
        docActions.add("Menu.File.Export.Flex");
        docActions.add("Menu.File.Export.TraditionalTranscript");
        docActions.add("Menu.File.Export.WordList");
        docActions.add("Menu.File.Export.CHAT");
        docActions.add("Menu.File.Export.EAF2.7");
        docActions.add("Menu.File.Export.TeX");
        docActions.add("Menu.File.Export.JSON");
        docActions.add("CommandActions.Backup");
        docActions.add("Menu.File.Backup.Never");
        docActions.add("Menu.File.Backup.1");
        docActions.add("Menu.File.Backup.5");
        docActions.add("Menu.File.Backup.10");
        docActions.add("Menu.File.Backup.20");
        docActions.add("Menu.File.Backup.30");
        docActions.add("Menu.Options.FrameLength.PAL");
        docActions.add("Menu.Options.FrameLength.NTSC");
        docActions.add("Menu.File.Import.RecognizerTiers");
        shortcuttableActions.put(DOCUMENT_CAT, docActions);
        ArrayList<String> miscActions = new ArrayList<String>();
        miscActions.add("Menu.Edit.Undo");
        miscActions.add("Menu.Edit.Redo");
        miscActions.add("Menu.Search.Find");
        miscActions.add("Menu.Search.Multiple");
        miscActions.add("Menu.Search.StructuredMultiple");
        miscActions.add("Menu.Edit.LinkedFiles");
        miscActions.add("Menu.Edit.EditCV");
        miscActions.add("Menu.Help.Contents");
        miscActions.add("CommandActions.CopyCurrentTime");
        miscActions.add("Menu.Search.FindReplaceMulti");
        miscActions.add("Menu.Edit.LanguagesList");
        miscActions.add("Menu.Edit.TierSet");
        miscActions.add("Menu.Edit.EditLexSrvc");
        miscActions.add("Menu.Edit.Preferences.Edit");
        miscActions.add("Menu.Edit.Preferences.Shortcut");
        miscActions.add("Menu.Edit.Author");
        miscActions.add("Menu.View.FontBrowser");
        miscActions.add("Menu.View.Shortcuts");
        miscActions.add("Menu.View.SpreadSheet");
        miscActions.add("Menu.View.Statistics");
        miscActions.add("Menu.Help.About");
        miscActions.add("Menu.View.ShowInterlinear");
        miscActions.add("Menu.View.ShowTimeline");
        miscActions.add("WebServicesDialog.WebService.TypeCraft");
        miscActions.add("WebServicesDialog.WebService.WebLicht");
        miscActions.add("Menu.Options.AnnotationMode");
        miscActions.add("Menu.Options.SyncMode");
        miscActions.add("Menu.Options.TranscriptionMode");
        miscActions.add("Menu.Options.SegmentationMode");
        miscActions.add("Menu.Options.InterlinearizationMode");
        shortcuttableActions.put(MISC_CAT, miscActions);
        return shortcuttableActions;
    }

    private Map<String, KeyStroke> getCommonDefaultShortcutsMap() {
        LinkedHashMap<String, KeyStroke> shortcutKeyStrokes = new LinkedHashMap<String, KeyStroke>(80);
        int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        shortcutKeyStrokes.put("Menu.Tier.AddNewTier", KeyStroke.getKeyStroke(84, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Tier.DeleteTier", KeyStroke.getKeyStroke(84, menuShortcutKeyMask + 8));
        shortcutKeyStrokes.put("Menu.Type.AddNewType", KeyStroke.getKeyStroke(84, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.File.New", KeyStroke.getKeyStroke(78, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.File.Open", KeyStroke.getKeyStroke(79, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.File.Save", KeyStroke.getKeyStroke(83, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.File.SaveAs", KeyStroke.getKeyStroke(83, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.File.SaveAsTemplate", KeyStroke.getKeyStroke(83, menuShortcutKeyMask + 1 + 8));
        shortcutKeyStrokes.put("Menu.File.Print", KeyStroke.getKeyStroke(80, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.File.PrintPreview", KeyStroke.getKeyStroke(80, menuShortcutKeyMask + 8));
        shortcutKeyStrokes.put("Menu.File.PageSetup", KeyStroke.getKeyStroke(80, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.Window.Next", KeyStroke.getKeyStroke(40, 1));
        shortcutKeyStrokes.put("Menu.Window.Previous", KeyStroke.getKeyStroke(38, 1));
        shortcutKeyStrokes.put("Menu.File.Close", KeyStroke.getKeyStroke(87, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.File.Exit", KeyStroke.getKeyStroke(81, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Edit.Undo", KeyStroke.getKeyStroke(90, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Edit.Redo", KeyStroke.getKeyStroke(89, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Search.Find", KeyStroke.getKeyStroke(70, menuShortcutKeyMask));
        shortcutKeyStrokes.put("Menu.Search.Multiple", KeyStroke.getKeyStroke(70, menuShortcutKeyMask + 1));
        shortcutKeyStrokes.put("Menu.Search.StructuredMultiple", KeyStroke.getKeyStroke(70, menuShortcutKeyMask + 1 + 8));
        shortcutKeyStrokes.put("Menu.Edit.LinkedFiles", KeyStroke.getKeyStroke(76, menuShortcutKeyMask + 8));
        shortcutKeyStrokes.put("Menu.Edit.EditCV", KeyStroke.getKeyStroke(67, menuShortcutKeyMask + 1));
        if (!SystemReporting.isMacOS()) {
            shortcutKeyStrokes.put("Menu.Help.Contents", KeyStroke.getKeyStroke(72, menuShortcutKeyMask));
        } else {
            shortcutKeyStrokes.put("Menu.Help.Contents", KeyStroke.getKeyStroke(72, menuShortcutKeyMask + 8));
        }
        shortcutKeyStrokes.put("CommandActions.CopyCurrentTime", KeyStroke.getKeyStroke(71, menuShortcutKeyMask + 8));
        return shortcutKeyStrokes;
    }

    private void addActionsWithoutShortcut() {
        for (Map.Entry<String, Map<String, List<String>>> mode : this.shortcuttableActionsMap.entrySet()) {
            String modeName = mode.getKey();
            Map<String, KeyStroke> shortcutKeyStrokes = this.shortcutKeyStrokesMap.get(modeName);
            if (shortcutKeyStrokes == null) {
                shortcutKeyStrokes = new HashMap<String, KeyStroke>();
                this.shortcutKeyStrokesMap.put(modeName, shortcutKeyStrokes);
            }
            for (Map.Entry<String, List<String>> kvpair : mode.getValue().entrySet()) {
                List<String> actionList = kvpair.getValue();
                for (String action : actionList) {
                    if (shortcutKeyStrokes.containsKey(action)) continue;
                    shortcutKeyStrokes.put(action, null);
                }
            }
        }
    }

    public KeyStroke getKeyStrokeForAction(String actionID, String modeName) {
        KeyStroke ks = null;
        if (actionID != null) {
            if (modeName == null) {
                if (this.shortcutKeyStrokesMap.get("Shortcuts.Common").containsKey(actionID)) {
                    ks = this.shortcutKeyStrokesMap.get("Shortcuts.Common").get(actionID);
                }
            } else if (this.shortcutKeyStrokesMap.get(modeName).containsKey(actionID)) {
                ks = this.shortcutKeyStrokesMap.get(modeName).get(actionID);
            } else if (this.shortcutKeyStrokesMap.get("Shortcuts.Common").containsKey(actionID)) {
                ks = this.shortcutKeyStrokesMap.get("Shortcuts.Common").get(actionID);
            }
        }
        return ks;
    }

    public Map<String, KeyStroke> getCurrentShortcuts(String modeName) {
        HashMap<String, KeyStroke> currentShortcutKeyStrokes = new HashMap<String, KeyStroke>();
        currentShortcutKeyStrokes.putAll(this.shortcutKeyStrokesMap.get("Shortcuts.Common"));
        if (modeName != null) {
            currentShortcutKeyStrokes.putAll(this.shortcutKeyStrokesMap.get(modeName));
        }
        return currentShortcutKeyStrokes;
    }

    public Map<String, List<String>> getShortcuttableActions(String modeName) {
        if (modeName == null) {
            return this.shortcuttableActionsMap.get("Shortcuts.Common");
        }
        return this.shortcuttableActionsMap.get(modeName);
    }

    public Map<String, KeyStroke> getShortcutKeysOnlyIn(String modeName) {
        if (modeName == null) {
            return this.shortcutKeyStrokesMap.get("Shortcuts.Common");
        }
        return this.shortcutKeyStrokesMap.get(modeName);
    }

    public String getDescriptionForAction(String actionID) {
        if (actionID == null) {
            return "";
        }
        String desc = ElanLocale.getString(actionID + "ToolTip");
        if (desc == null || desc.isEmpty()) {
            desc = ElanLocale.getString(actionID);
        }
        return desc;
    }

    public String getCategoryForAction(String modeName, String actionID) {
        if (actionID == null) {
            return "";
        }
        Iterator<Map.Entry<String, List<String>>> it = modeName == null ? this.shortcuttableActionsMap.get("Shortcuts.Common").entrySet().iterator() : this.shortcuttableActionsMap.get(modeName).entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, List<String>> pairs = it.next();
            String cat = pairs.getKey();
            List<String> actionList = pairs.getValue();
            if (!actionList.contains(actionID)) continue;
            return cat;
        }
        return "";
    }

    public String getDescriptionForKeyStroke(KeyStroke ks) {
        if (ks == null) {
            return "";
        }
        Object nwAcc = "";
        if (SystemReporting.isMacOS()) {
            int modifier = ks.getModifiers();
            if ((modifier & 2) != 0) {
                nwAcc = (String)nwAcc + "\u2303";
            }
            if ((modifier & 1) != 0) {
                nwAcc = (String)nwAcc + "\u21e7";
            }
            if ((modifier & 8) != 0) {
                nwAcc = (String)nwAcc + "\u2325";
            }
            if ((modifier & 4) != 0) {
                nwAcc = (String)nwAcc + "\u2318";
            }
            nwAcc = ks.getKeyChar() == '\uffff' ? (ks.getKeyCode() == 127 ? (String)nwAcc + "Delete" : (ks.getKeyCode() == 33 ? (String)nwAcc + "PageUp" : (ks.getKeyCode() == 34 ? (String)nwAcc + "PageDown" : (ks.getKeyCode() == 32 ? (String)nwAcc + "Space" : (String)nwAcc + KeyEvent.getKeyText(ks.getKeyCode()))))) : (String)nwAcc + String.valueOf(ks.getKeyChar());
        } else {
            int modifier = ks.getModifiers();
            if ((modifier & 2) != 0) {
                nwAcc = (String)nwAcc + "Ctrl+";
            }
            if ((modifier & 8) != 0) {
                nwAcc = (String)nwAcc + "Alt+";
            }
            if ((modifier & 1) != 0) {
                nwAcc = (String)nwAcc + "Shift+";
            }
            nwAcc = ks.getKeyChar() == '\uffff' ? (String)nwAcc + KeyEvent.getKeyText(ks.getKeyCode()) : (String)nwAcc + String.valueOf(ks.getKeyChar());
        }
        return nwAcc;
    }

    public void restoreDefaultShortcutsForthisMode(String modeName) {
        if (modeName == null || modeName.equals("Shortcuts.Common")) {
            this.shortcutKeyStrokesMap.put("Shortcuts.Common", this.getCommonDefaultShortcutsMap());
        } else if (modeName.equals("Menu.Options.AnnotationMode")) {
            this.shortcutKeyStrokesMap.put(modeName, this.getAnnotationModeDefaultShortcutsMap());
        } else if (modeName.equals("Menu.Options.SyncMode")) {
            this.shortcutKeyStrokesMap.put(modeName, this.getSyncModeDefaultShortcutsMap());
        } else if (modeName.equals("Menu.Options.TranscriptionMode")) {
            this.shortcutKeyStrokesMap.put(modeName, this.getTranscModeDefaultShortcutsMap());
        } else if (modeName.equals("Menu.Options.SegmentationMode")) {
            this.shortcutKeyStrokesMap.put(modeName, this.getSegmentModeDefaultShortcutsMap());
        } else if (modeName.equals("Menu.Options.TurnsAndSceneMode")) {
            this.shortcutKeyStrokesMap.put(modeName, this.getTurnsAndSceneModeDefaultShortcutsMap());
        } else if (modeName.equals("Menu.Options.InterlinearizationMode")) {
            this.shortcutKeyStrokesMap.put(modeName, this.getInterlinearModeDefaultShortcutsMap());
        }
        JOptionPane.showMessageDialog(null, ElanLocale.getString("Shortcuts.Message.Restored") + " " + ElanLocale.getString(modeName));
    }

    public void restoreAll() {
        this.shortcutKeyStrokesMap.put("Shortcuts.Common", this.getCommonDefaultShortcutsMap());
        this.shortcutKeyStrokesMap.put("Menu.Options.AnnotationMode", this.getAnnotationModeDefaultShortcutsMap());
        this.shortcutKeyStrokesMap.put("Menu.Options.SyncMode", this.getSyncModeDefaultShortcutsMap());
        this.shortcutKeyStrokesMap.put("Menu.Options.TranscriptionMode", this.getTranscModeDefaultShortcutsMap());
        this.shortcutKeyStrokesMap.put("Menu.Options.SegmentationMode", this.getSegmentModeDefaultShortcutsMap());
        this.shortcutKeyStrokesMap.put("Menu.Options.TurnsAndSceneMode", this.getTurnsAndSceneModeDefaultShortcutsMap());
        this.shortcutKeyStrokesMap.put("Menu.Options.InterlinearizationMode", this.getInterlinearModeDefaultShortcutsMap());
        JOptionPane.showMessageDialog(null, ElanLocale.getString("Shortcuts.Message.RestoredAll"));
    }

    public boolean readCurrentShortcuts() {
        PreferencesReader xmlPrefsReader = new PreferencesReader();
        HashMap<String, Map<String, KeyStroke>> shortcutKeyMap = new HashMap<String, Map<String, KeyStroke>>();
        Map shortcutMapRaw = null;
        try {
            File file = new File(NEW_PREF_FILEPATH);
            shortcutMapRaw = file.exists() ? xmlPrefsReader.parse(NEW_PREF_FILEPATH) : xmlPrefsReader.parse(PREF_FILEPATH);
            if (!xmlPrefsReader.isParsingSuccessful()) {
                ClientLogger.LOG.info("Could not load the keyboard shortcut preferences file. The file does not exist or is not valid.");
                return false;
            }
        }
        catch (Exception ex) {
            ClientLogger.LOG.warning("Could not load the keyboard shortcut preferences file.");
        }
        if (shortcutMapRaw != null && !shortcutMapRaw.isEmpty()) {
            if (shortcutMapRaw.values().iterator().hasNext()) {
                Object val = shortcutMapRaw.values().iterator().next();
                if (val instanceof ArrayList) {
                    Iterator it = shortcutMapRaw.entrySet().iterator();
                    HashMap<String, KeyStroke> shortcutMap = new HashMap<String, KeyStroke>();
                    while (it.hasNext()) {
                        Map.Entry pair = it.next();
                        String actionName = (String)pair.getKey();
                        val = pair.getValue();
                        if (!(val instanceof ArrayList)) continue;
                        ArrayList codes = (ArrayList)val;
                        if (codes.size() != 2) {
                            shortcutMap.put(actionName, null);
                            continue;
                        }
                        try {
                            int keycode = Integer.parseInt((String)codes.get(0));
                            int modcode = Integer.parseInt((String)codes.get(1));
                            KeyStroke aks = KeyStroke.getKeyStroke(keycode, modcode);
                            shortcutMap.put(actionName, aks);
                        }
                        catch (NumberFormatException e) {
                            shortcutMap.put(actionName, null);
                        }
                    }
                    shortcutKeyMap.putAll(this.convertToNewShortCutMap(shortcutMap));
                } else if (val instanceof Map) {
                    for (Map.Entry pair2 : shortcutMapRaw.entrySet()) {
                        String modeName = (String)pair2.getKey();
                        val = pair2.getValue();
                        HashMap<String, KeyStroke> shortcutMap = null;
                        if (val instanceof Map) {
                            shortcutMap = new HashMap<String, KeyStroke>();
                            for (Map.Entry pair2 : ((Map)val).entrySet()) {
                                String actionName = (String)pair2.getKey();
                                val = pair2.getValue();
                                if (!(val instanceof ArrayList)) continue;
                                ArrayList codes = (ArrayList)val;
                                if (codes.size() != 2) {
                                    shortcutMap.put(actionName, null);
                                    continue;
                                }
                                try {
                                    int keycode = Integer.parseInt((String)codes.get(0));
                                    int modcode = Integer.parseInt((String)codes.get(1));
                                    KeyStroke aks = KeyStroke.getKeyStroke(keycode, modcode);
                                    shortcutMap.put(actionName, aks);
                                }
                                catch (NumberFormatException e) {
                                    shortcutMap.put(actionName, null);
                                }
                            }
                        }
                        shortcutKeyMap.put(modeName, shortcutMap);
                    }
                }
                this.shortcutKeyStrokesMap.clear();
                this.shortcutKeyStrokesMap.putAll(shortcutKeyMap);
                this.ensureAllModesInKeyStrokesMap();
                if (this.checkForNewShortcuts()) {
                    PreferencesWriter xmlPrefsWriter = new PreferencesWriter();
                    try {
                        xmlPrefsWriter.encodeAndSave(this.getStorableShortcutMap(this.shortcutKeyStrokesMap), NEW_PREF_FILEPATH);
                    }
                    catch (Exception ex) {
                        ClientLogger.LOG.warning("Error while updating the shortcuts file. File not created.");
                    }
                }
            }
            this.addActionsWithoutShortcut();
            return true;
        }
        return false;
    }

    public Map<String, Map<String, List<String>>> getStorableShortcutMap(Map<String, Map<String, KeyStroke>> shortcutKeyStrokesMap) {
        HashMap<String, Map<String, List<String>>> shortcutModeMap = new HashMap<String, Map<String, List<String>>>();
        for (Map.Entry<String, Map<String, KeyStroke>> pair : shortcutKeyStrokesMap.entrySet()) {
            String modeName = pair.getKey();
            Map<String, KeyStroke> valMap = pair.getValue();
            Iterator<Map.Entry<String, KeyStroke>> it1 = valMap.entrySet().iterator();
            HashMap map = new HashMap();
            while (it1.hasNext()) {
                Map.Entry<String, KeyStroke> pair1 = it1.next();
                String actionName = pair1.getKey();
                KeyStroke ks = pair1.getValue();
                ArrayList<String> codes = new ArrayList<String>(2);
                if (ks != null) {
                    codes.add(String.valueOf(ks.getKeyCode()));
                    codes.add(String.valueOf(ks.getModifiers()));
                }
                map.put(actionName, codes);
            }
            shortcutModeMap.put(modeName, map);
        }
        return shortcutModeMap;
    }

    private HashMap<String, Map<String, KeyStroke>> convertToNewShortCutMap(HashMap<String, KeyStroke> shortcutMap) {
        int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        ArrayList generalActions = new ArrayList();
        ArrayList annModeActions = new ArrayList();
        ArrayList transModeActions = new ArrayList();
        ArrayList syncModeActions = new ArrayList();
        ArrayList segMentActions = new ArrayList();
        HashMap<String, KeyStroke> annModeMap = new HashMap<String, KeyStroke>();
        HashMap<String, KeyStroke> transModeMap = new HashMap<String, KeyStroke>();
        HashMap<String, KeyStroke> syncModeMap = new HashMap<String, KeyStroke>();
        HashMap<String, KeyStroke> segmentModeMap = new HashMap<String, KeyStroke>();
        HashMap<String, KeyStroke> commonModeMap = new HashMap<String, KeyStroke>();
        Iterator<List<String>> it = this.getCommonShortcuttableActionsMap().values().iterator();
        while (it.hasNext()) {
            generalActions.addAll(it.next());
        }
        it = this.getAnnotationModeShortcuttableActionsMap().values().iterator();
        while (it.hasNext()) {
            annModeActions.addAll(it.next());
        }
        it = this.getTranscModeShortcuttableActionsMap().values().iterator();
        while (it.hasNext()) {
            transModeActions.addAll(it.next());
        }
        it = this.getSyncModeShortcuttableActionsMap().values().iterator();
        while (it.hasNext()) {
            syncModeActions.addAll(it.next());
        }
        it = this.getSegmentModeShortcuttableActionsMap().values().iterator();
        while (it.hasNext()) {
            segMentActions.addAll(it.next());
        }
        for (Map.Entry<String, KeyStroke> pair : shortcutMap.entrySet()) {
            String actionName = pair.getKey();
            KeyStroke val = pair.getValue();
            if (generalActions.contains(actionName) && val != null) {
                commonModeMap.put(actionName, val);
                continue;
            }
            if (annModeActions.contains(actionName) && val != null) {
                annModeMap.put(actionName, val);
            }
            if (transModeActions.contains(actionName) && val != null) {
                transModeMap.put(actionName, val);
            }
            if (syncModeActions.contains(actionName) && val != null) {
                syncModeMap.put(actionName, val);
            }
            if (!segMentActions.contains(actionName) || val == null) continue;
            segmentModeMap.put(actionName, val);
        }
        KeyStroke ks = KeyStroke.getKeyStroke(10, 0);
        if (transModeMap.containsValue(ks) || commonModeMap.containsValue(ks)) {
            this.shortcutClash = true;
        }
        transModeMap.put("TranscriptionMode.Actions.CommitChanges", ks);
        ks = KeyStroke.getKeyStroke(27, 0);
        if (transModeMap.containsValue(ks) || commonModeMap.containsValue(ks)) {
            this.shortcutClash = true;
        }
        transModeMap.put("TranscriptionMode.Actions.CancelChanges", ks);
        ks = KeyStroke.getKeyStroke(127, 1);
        if (transModeMap.containsValue(ks) || commonModeMap.containsValue(ks)) {
            this.shortcutClash = true;
        }
        transModeMap.put("Menu.Annotation.DeleteAnnotation", ks);
        ks = KeyStroke.getKeyStroke(65, menuShortcutKeyMask + 1);
        if (transModeMap.containsValue(ks) || commonModeMap.containsValue(ks)) {
            this.shortcutClash = true;
        }
        transModeMap.put("Menu.Annotation.MergeWithNext", ks);
        ks = KeyStroke.getKeyStroke(66, menuShortcutKeyMask + 1);
        if (transModeMap.containsValue(ks) || commonModeMap.containsValue(ks)) {
            this.shortcutClash = true;
        }
        transModeMap.put("Menu.Annotation.MergeWithBefore", ks);
        ks = KeyStroke.getKeyStroke(38, 8);
        if (transModeMap.containsValue(ks) || commonModeMap.containsValue(ks)) {
            this.shortcutClash = true;
        }
        transModeMap.put("TranscriptionMode.Actions.MoveUp", ks);
        ks = KeyStroke.getKeyStroke(40, 8);
        if (transModeMap.containsValue(ks) || commonModeMap.containsValue(ks)) {
            this.shortcutClash = true;
        }
        transModeMap.put("TranscriptionMode.Actions.MoveDown", ks);
        ks = KeyStroke.getKeyStroke(37, 8);
        if (transModeMap.containsValue(ks) || commonModeMap.containsValue(ks)) {
            this.shortcutClash = true;
        }
        transModeMap.put("TranscriptionMode.Actions.MoveLeft", ks);
        ks = KeyStroke.getKeyStroke(39, 8);
        if (transModeMap.containsValue(ks) || commonModeMap.containsValue(ks)) {
            this.shortcutClash = true;
        }
        transModeMap.put("TranscriptionMode.Actions.MoveRight", ks);
        ks = KeyStroke.getKeyStroke(9, 0);
        if (transModeMap.containsValue(ks) || commonModeMap.containsValue(ks)) {
            this.shortcutClash = true;
        }
        transModeMap.put("Menu.Play.PlayPause", ks);
        ks = KeyStroke.getKeyStroke(9, 1);
        if (transModeMap.containsValue(ks) || commonModeMap.containsValue(ks)) {
            this.shortcutClash = true;
        }
        transModeMap.put("TranscriptionMode.Actions.PlayFromStart", ks);
        ks = KeyStroke.getKeyStroke(8, 0);
        if (segmentModeMap.containsValue(ks) || commonModeMap.containsValue(ks)) {
            this.shortcutClash = true;
        }
        segmentModeMap.put("Menu.Annotation.DeleteAnnotation", ks);
        ks = KeyStroke.getKeyStroke(10, 0);
        if (segmentModeMap.containsValue(ks) || commonModeMap.containsValue(ks)) {
            this.shortcutClash = true;
        }
        segmentModeMap.put("SegmentationMode.Actions.Segment", ks);
        ks = KeyStroke.getKeyStroke(65, 2);
        if (segmentModeMap.containsValue(ks) || commonModeMap.containsValue(ks)) {
            this.shortcutClash = true;
        }
        segmentModeMap.put("Menu.Annotation.MergeWithNext", ks);
        ks = KeyStroke.getKeyStroke(66, 2);
        if (segmentModeMap.containsValue(ks) || commonModeMap.containsValue(ks)) {
            this.shortcutClash = true;
        }
        segmentModeMap.put("Menu.Annotation.MergeWithBefore", ks);
        ks = KeyStroke.getKeyStroke(38, 0);
        if (segmentModeMap.containsValue(ks) || commonModeMap.containsValue(ks)) {
            this.shortcutClash = true;
        }
        segmentModeMap.put("CommandActions.PreviousActiveTier", ks);
        ks = KeyStroke.getKeyStroke(40, 0);
        if (segmentModeMap.containsValue(ks) || commonModeMap.containsValue(ks)) {
            this.shortcutClash = true;
        }
        segmentModeMap.put("CommandActions.NextActiveTier", ks);
        HashMap<String, Map<String, KeyStroke>> shortcutKeysMap = new HashMap<String, Map<String, KeyStroke>>();
        shortcutKeysMap.put("Shortcuts.Common", commonModeMap);
        shortcutKeysMap.put("Menu.Options.AnnotationMode", annModeMap);
        shortcutKeysMap.put("Menu.Options.SyncMode", syncModeMap);
        shortcutKeysMap.put("Menu.Options.TranscriptionMode", transModeMap);
        shortcutKeysMap.put("Menu.Options.SegmentationMode", segmentModeMap);
        shortcutKeysMap.put("Menu.Options.InterlinearizationMode", new HashMap(0));
        shortcutKeysMap.put("Menu.Options.TurnsAndSceneMode", new HashMap(0));
        return shortcutKeysMap;
    }

    private boolean checkForNewShortcuts() {
        String version;
        String val;
        String appName = System.getProperty("ELANApplicationMain");
        boolean shortcutsCkecked = false;
        if (appName == null || appName.equals(ELAN.class.getName())) {
            val = Preferences.getString("ShortcutKeyUpdateVersion", null);
            version = ELAN.getVersionString();
            if (val == null || !val.equals(version)) {
                this.addNewShortcuts("Shortcuts.Common", this.getCommonDefaultShortcutsMap());
                this.addNewShortcuts("Menu.Options.AnnotationMode", this.getAnnotationModeDefaultShortcutsMap());
                this.addNewShortcuts("Menu.Options.TranscriptionMode", this.getTranscModeDefaultShortcutsMap());
                this.addNewShortcuts("Menu.Options.SyncMode", this.getSyncModeDefaultShortcutsMap());
                this.addNewShortcuts("Menu.Options.SegmentationMode", this.getSegmentModeDefaultShortcutsMap());
                this.addNewShortcuts("Menu.Options.TurnsAndSceneMode", this.getTurnsAndSceneModeDefaultShortcutsMap());
                this.addNewShortcuts("Menu.Options.InterlinearizationMode", this.getInterlinearModeDefaultShortcutsMap());
                Preferences.set("ShortcutKeyUpdateVersion", version, null);
                if (this.shortcutClash) {
                    String message = ElanLocale.getString("Shortcuts.Warning.Clashes") + System.getProperty("line.separator") + ElanLocale.getString("Shortcuts.Warning.Edit");
                    JOptionPane.showMessageDialog(null, message, ElanLocale.getString("Message.Warning"), 2);
                }
                shortcutsCkecked = true;
            }
        }
        if (appName != null && appName.equals(SIMPLELAN.class.getName())) {
            val = Preferences.getString("SimpleELAN.ShortcutKeyUpdateVersion", null);
            version = SIMPLELAN.getVersionString();
            if (val == null || !val.equals(version)) {
                this.addNewShortcuts("Menu.Options.TurnsAndSceneMode", this.getTurnsAndSceneModeDefaultShortcutsMap());
                Preferences.set("SimpleELAN.ShortcutKeyUpdateVersion", version, null);
                shortcutsCkecked = true;
            }
        }
        return shortcutsCkecked;
    }

    private void addNewShortcuts(String modeName, Map<String, KeyStroke> defaultShortcutMap) {
        Map<String, KeyStroke> currentShortcutMapForThisMode = this.shortcutKeyStrokesMap.get(modeName);
        HashMap<String, KeyStroke> currentlyUsedShortcutMap = new HashMap<String, KeyStroke>();
        if (currentShortcutMapForThisMode != null) {
            currentlyUsedShortcutMap.putAll(currentShortcutMapForThisMode);
        }
        if (!modeName.equals("Shortcuts.Common")) {
            currentlyUsedShortcutMap.putAll(this.shortcutKeyStrokesMap.get("Shortcuts.Common"));
        }
        for (Map.Entry<String, KeyStroke> pair : defaultShortcutMap.entrySet()) {
            String actionName = pair.getKey();
            if (currentShortcutMapForThisMode.containsKey(actionName)) continue;
            KeyStroke ks = pair.getValue();
            currentShortcutMapForThisMode.put(actionName, ks);
            if (currentlyUsedShortcutMap.containsValue(ks)) {
                this.shortcutClash = true;
            }
            currentlyUsedShortcutMap.put(actionName, ks);
        }
        this.shortcutKeyStrokesMap.put(modeName, currentShortcutMapForThisMode);
    }

    private void ensureAllModesInKeyStrokesMap() {
        if (this.shortcutKeyStrokesMap.get("Shortcuts.Common") == null) {
            this.shortcutKeyStrokesMap.put("Shortcuts.Common", this.getCommonDefaultShortcutsMap());
        }
        if (this.shortcutKeyStrokesMap.get("Menu.Options.AnnotationMode") == null) {
            this.shortcutKeyStrokesMap.put("Menu.Options.AnnotationMode", this.getAnnotationModeDefaultShortcutsMap());
        }
        if (this.shortcutKeyStrokesMap.get("Menu.Options.SyncMode") == null) {
            this.shortcutKeyStrokesMap.put("Menu.Options.SyncMode", this.getSyncModeDefaultShortcutsMap());
        }
        if (this.shortcutKeyStrokesMap.get("Menu.Options.TranscriptionMode") == null) {
            this.shortcutKeyStrokesMap.put("Menu.Options.TranscriptionMode", this.getTranscModeDefaultShortcutsMap());
        }
        if (this.shortcutKeyStrokesMap.get("Menu.Options.SegmentationMode") == null) {
            this.shortcutKeyStrokesMap.put("Menu.Options.SegmentationMode", this.getSegmentModeDefaultShortcutsMap());
        }
        if (this.shortcutKeyStrokesMap.get("Menu.Options.TurnsAndSceneMode") == null) {
            this.shortcutKeyStrokesMap.put("Menu.Options.TurnsAndSceneMode", this.getTurnsAndSceneModeDefaultShortcutsMap());
        }
        if (this.shortcutKeyStrokesMap.get("Menu.Options.InterlinearizationMode") == null) {
            this.shortcutKeyStrokesMap.put("Menu.Options.InterlinearizationMode", this.getInterlinearModeDefaultShortcutsMap());
        }
    }

    public void saveCurrentShortcuts(Map<String, Map<String, List<String>>> shortcutMap) {
        PreferencesWriter xmlPrefsWriter = new PreferencesWriter();
        try {
            xmlPrefsWriter.encodeAndSave(shortcutMap, NEW_PREF_FILEPATH);
            JOptionPane.showMessageDialog(null, ElanLocale.getString("Shortcuts.Message.Saved"));
        }
        catch (Exception ex) {
            ClientLogger.LOG.warning("Could not save the keyboard shortcut preferences file");
            JOptionPane.showMessageDialog(null, ElanLocale.getString("Shortcuts.Message.NotSaved"));
        }
    }

    static {
        PREF_FILEPATH = Constants.ELAN_DATA_DIR + System.getProperty("file.separator") + "shortcuts.pfsx";
        NEW_PREF_FILEPATH = Constants.ELAN_DATA_DIR + System.getProperty("file.separator") + "shortcuts1.pfsx";
    }
}

