/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import java.util.List;
import mpi.eudico.client.annotator.ActiveAnnotationListener;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.CommandAction;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class SplitAnnotationCA
extends CommandAction
implements ActiveAnnotationListener {
    private Annotation activeAnnotation;

    public SplitAnnotationCA(ViewerManager2 viewerManager) {
        super(viewerManager, "Menu.Annotation.SplitAnnotation");
        viewerManager.connectListener(this);
        this.activeAnnotation = viewerManager.getActiveAnnotation().getAnnotation();
        this.setEnabled(false);
    }

    @Override
    protected void newCommand() {
        this.command = ELANCommandFactory.createCommand(this.vm.getTranscription(), "Menu.Annotation.SplitAnnotation");
    }

    @Override
    protected Object getReceiver() {
        return this.vm.getTranscription();
    }

    @Override
    protected Object[] getArguments() {
        Object[] arg = new Object[]{this.activeAnnotation};
        return arg;
    }

    @Override
    public void updateActiveAnnotation() {
        this.activeAnnotation = this.vm.getActiveAnnotation().getAnnotation();
        this.checkState();
    }

    private List<Annotation> getDependingAnnotation(TierImpl tier) {
        List<TierImpl> dependentTiers = tier.getDependentTiers();
        ArrayList<Annotation> dependingAnnotations = new ArrayList<Annotation>();
        for (int i = 0; i < dependentTiers.size(); ++i) {
            if (dependentTiers.get(i).getLinguisticType().getConstraints().getStereoType() == 4) continue;
            dependingAnnotations.addAll(this.activeAnnotation.getChildrenOnTier(dependentTiers.get(i)));
        }
        return dependingAnnotations;
    }

    protected void checkState() {
        List<TierImpl> childTiers;
        TierImpl tier;
        this.setEnabled(false);
        if (this.activeAnnotation != null && (tier = (TierImpl)this.activeAnnotation.getTier()).isTimeAlignable() && !tier.hasParentTier() && (childTiers = tier.getChildTiers()) != null) {
            TierImpl childTier;
            boolean valid = false;
            for (int i = 0; i < childTiers.size() && (childTier = childTiers.get(i)).getLinguisticType().getConstraints().getStereoType() == 4; ++i) {
                valid = true;
            }
            this.setEnabled(valid);
            if (!valid && this.getDependingAnnotation(tier).size() == 0) {
                this.setEnabled(true);
            }
        }
    }
}

