/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class SpreadSheetCommand
implements Command {
    private String commandName;
    private JFrame sheetFrame;
    private TranscriptionImpl transcription;
    private List<TierImpl> rootTiers;

    public SpreadSheetCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.extractRootTiers();
        this.showFrame();
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    private void showFrame() {
        this.createSheetFrame();
        if (this.sheetFrame != null) {
            this.sheetFrame.setVisible(true);
            this.sheetFrame.toFront();
        }
    }

    private void createSheetFrame() {
        try {
            this.sheetFrame = new JFrame();
            this.sheetFrame.getContentPane().setLayout(new BorderLayout());
            DefaultTableModel annTableModel = this.getAnnotationsTable();
            JTable annTable = new JTable();
            if (annTableModel != null) {
                annTable.setModel(annTableModel);
            }
            annTable.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            annTable.setPreferredScrollableViewportSize(new Dimension(500, 500));
            annTable.setEnabled(false);
            JScrollPane annTableScrollPane = new JScrollPane(annTable);
            JPanel annTablePanel = new JPanel(new BorderLayout());
            annTablePanel.add((Component)annTableScrollPane, "Center");
            this.sheetFrame.getContentPane().add((Component)annTablePanel, "Center");
            this.updateLocale();
            this.sheetFrame.pack();
            this.sheetFrame.setResizable(true);
        }
        catch (Exception ex) {
            System.out.println("Couldn't create Sheet Frame.");
            ex.printStackTrace();
        }
    }

    public void updateLocale() {
        if (this.sheetFrame != null) {
            this.sheetFrame.setTitle(ElanLocale.getString("Menu.View.SpreadSheet"));
            this.sheetFrame.repaint();
        }
    }

    private DefaultTableModel getAnnotationsTable() {
        DefaultTableModel annTableModel = null;
        if (this.rootTiers != null) {
            Iterator<TierImpl> tierIt = this.rootTiers.iterator();
            int maxAnnos = 0;
            while (tierIt.hasNext()) {
                TierImpl tier = tierIt.next();
                maxAnnos = Math.max(tier.getAnnotations().size(), maxAnnos);
            }
            Object[][] tableVal = new String[maxAnnos][this.rootTiers.size()];
            Object[] tierNames = new String[this.rootTiers.size()];
            tierIt = this.rootTiers.iterator();
            int j = 0;
            while (tierIt.hasNext()) {
                TierImpl tier = tierIt.next();
                tierNames[j] = tier.getName();
                List<AbstractAnnotation> annotations = tier.getAnnotations();
                if (annotations != null) {
                    Collections.sort(annotations);
                    for (int i = 0; i < maxAnnos; ++i) {
                        if (i < annotations.size()) {
                            Annotation ann = annotations.get(i);
                            tableVal[i][j] = ann.getValue();
                            continue;
                        }
                        tableVal[i][j] = "";
                    }
                }
                ++j;
            }
            annTableModel = new DefaultTableModel(tableVal, tierNames);
        }
        return annTableModel;
    }

    private List<TierImpl> extractRootTiers() {
        this.rootTiers = null;
        if (this.transcription != null) {
            List<TierImpl> tiers = this.transcription.getTiers();
            this.rootTiers = new ArrayList<TierImpl>();
            if (tiers != null) {
                Iterator<TierImpl> tierIt = tiers.iterator();
                TierImpl tier = null;
                while (tierIt.hasNext()) {
                    tier = tierIt.next();
                    if (tier.getLinguisticType().getConstraints() != null) continue;
                    this.rootTiers.add(tier);
                }
            }
        }
        return this.rootTiers;
    }
}

