/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.imports.MergeUtil;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.clomimpl.abstr.LicenseRecord;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.type.ConstraintImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.clomimpl.util.TranscriptionCompare;
import mpi.eudico.server.corpora.util.ProcessReport;
import mpi.eudico.server.corpora.util.ProcessReporter;
import mpi.eudico.util.BasicControlledVocabulary;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;

public class UpdateTranscriptionsWithTemplateCommand
implements ProcessReporter,
Command {
    private String name;
    private ProgressListener listener;
    private ProcessReport reporter;
    private List<File> fileList;
    private TranscriptionImpl templateTrans;
    private Map<String, Object> templatePrefs;
    private Boolean dryRunFlag;
    private Boolean forceCVReplacement = false;
    private UpdateThread updateThread;
    private boolean cancelled = false;

    public UpdateTranscriptionsWithTemplateCommand(String name) {
        this.name = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        if (arguments[0] instanceof List) {
            this.fileList = (List)arguments[0];
        }
        if (this.fileList == null || this.fileList.isEmpty()) {
            this.report("The list of files to update is null or empty");
            this.processCancelled("The list of files to update is null or empty");
            return;
        }
        if (arguments[1] instanceof TranscriptionImpl) {
            this.templateTrans = (TranscriptionImpl)arguments[1];
        } else if (arguments[1] instanceof File) {
            File tf = (File)arguments[1];
            try {
                this.templateTrans = new TranscriptionImpl(tf.getAbsolutePath());
            }
            catch (Throwable t) {
                this.report(String.format("Unable to load the template: %s", t.getMessage()));
                this.processCancelled(String.format("Unable to load the template: %s", t.getMessage()));
                return;
            }
        }
        if (this.templateTrans == null) {
            this.report("The template is null, could not be loaded");
            return;
        }
        if (arguments.length >= 3 && arguments[2] instanceof Boolean) {
            this.dryRunFlag = (Boolean)arguments[2];
        }
        if (arguments.length >= 4 && arguments[3] instanceof Boolean) {
            this.forceCVReplacement = (Boolean)arguments[3];
        }
        this.templatePrefs = Preferences.loadPreferencesForFile(this.templateTrans.getFullPath());
        this.updateThread = new UpdateThread();
        this.updateThread.start();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setProcessReport(ProcessReport report) {
        this.reporter = report;
    }

    @Override
    public ProcessReport getProcessReport() {
        return this.reporter;
    }

    @Override
    public void report(String message) {
        if (this.reporter != null) {
            this.reporter.append(message);
        }
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public void setProgressListener(ProgressListener listener) {
        this.listener = listener;
    }

    private void setProgress(float percentage, String message) {
        if (this.listener != null) {
            if (percentage == 100.0f) {
                this.listener.progressCompleted(this, message);
            } else {
                this.listener.progressUpdated(this, (int)percentage, message);
            }
        }
    }

    private void processCancelled(String message) {
        if (this.listener != null) {
            this.listener.progressInterrupted(this, message);
        }
    }

    private class UpdateThread
    extends Thread {
        private MergeUtil mergeUtil;
        private final String NEW_TIERS = "nw_tiers";
        private final String CH_TIERS = "cg_tiers";
        private final String NEW_TYPES = "nw_types";
        private final String CH_TYPES = "ch_types";
        private final String NEW_CVS = "nw_cvs";
        private final String CH_CVS = "ch_cvs";
        private Map<String, List<String>> changeMap = new HashMap<String, List<String>>(8);

        private UpdateThread() {
        }

        @Override
        public void run() {
            float curProg = 0.0f;
            float perFilePercentage = 1.0f;
            if (UpdateTranscriptionsWithTemplateCommand.this.fileList.size() > 0) {
                perFilePercentage = 100.0f / (float)UpdateTranscriptionsWithTemplateCommand.this.fileList.size();
            }
            for (File f : UpdateTranscriptionsWithTemplateCommand.this.fileList) {
                UpdateTranscriptionsWithTemplateCommand.this.report("\nFILE:  " + f.getAbsolutePath());
                TranscriptionImpl trans = null;
                try {
                    trans = new TranscriptionImpl(f.getAbsolutePath());
                    trans.setNotifying(false);
                    trans.setUnchanged();
                }
                catch (Throwable t) {
                    UpdateTranscriptionsWithTemplateCommand.this.report("Unable to load: " + t.getMessage());
                    UpdateTranscriptionsWithTemplateCommand.this.setProgress(curProg += perFilePercentage, "Error - skipping file: " + f.getName());
                    continue;
                }
                this.changeMap.clear();
                this.reportDifferences(UpdateTranscriptionsWithTemplateCommand.this.templateTrans, trans);
                if (UpdateTranscriptionsWithTemplateCommand.this.dryRunFlag != null && UpdateTranscriptionsWithTemplateCommand.this.dryRunFlag.booleanValue()) {
                    UpdateTranscriptionsWithTemplateCommand.this.setProgress(Math.min(99.0f, curProg += perFilePercentage), "Processed file: " + f.getName());
                    if (!UpdateTranscriptionsWithTemplateCommand.this.cancelled) continue;
                    UpdateTranscriptionsWithTemplateCommand.this.report(String.format("The process was cancelled after %f%% of the files was processed", Float.valueOf(curProg)));
                    break;
                }
                if (this.mergeUtil == null) {
                    this.mergeUtil = new MergeUtil();
                }
                UpdateTranscriptionsWithTemplateCommand.this.report("Updating file:");
                this.updateDifferences(UpdateTranscriptionsWithTemplateCommand.this.templateTrans, trans, this.mergeUtil);
                if (trans.isChanged()) {
                    try {
                        ACMTranscriptionStore.getCurrentTranscriptionStore().storeTranscription(trans, null, null, 0);
                        this.mergeUtil.updatePreferences(trans, UpdateTranscriptionsWithTemplateCommand.this.templatePrefs, "CV.ML.Prefs", "TierColors", "TierHighlightColors", "TierFonts", "MultiTierViewer.TierOrder", "MultiTierViewer.TierSortingMode", "MultiTierViewer.HiddenTiers");
                    }
                    catch (IOException ioe) {
                        UpdateTranscriptionsWithTemplateCommand.this.report(String.format("Could not save the file: %s, cause: %s", f.getName(), ioe.getMessage()));
                    }
                    catch (Throwable t) {
                        UpdateTranscriptionsWithTemplateCommand.this.report(String.format("Could not save the file: %s, cause: %s", f.getName(), t.getMessage()));
                    }
                }
                UpdateTranscriptionsWithTemplateCommand.this.setProgress(Math.min(99.0f, curProg += perFilePercentage), "Processed file: " + f.getName());
                if (!UpdateTranscriptionsWithTemplateCommand.this.cancelled) continue;
                UpdateTranscriptionsWithTemplateCommand.this.report(String.format("The process was cancelled after %f%% of the files was processed", Float.valueOf(curProg)));
                break;
            }
            if (UpdateTranscriptionsWithTemplateCommand.this.cancelled) {
                UpdateTranscriptionsWithTemplateCommand.this.processCancelled("Process cancelled");
            } else {
                UpdateTranscriptionsWithTemplateCommand.this.setProgress(100.0f, "Processed all files");
            }
        }

        private void reportDifferences(TranscriptionImpl templTrans, TranscriptionImpl trans) {
            TranscriptionCompare trComp = new TranscriptionCompare();
            UpdateTranscriptionsWithTemplateCommand.this.report("Comparing transcription (T1) with template (T2):");
            List<String> dfList = trComp.getTierNamesOnlyInFirst(trans, templTrans);
            this.reportList(String.format("Number of tiers only in T1: %d", dfList.size()), dfList);
            dfList = trComp.getTierNamesOnlyInFirst(templTrans, trans);
            this.reportList(String.format("Number of tiers only in T2: %d", dfList.size()), dfList);
            this.changeMap.put("nw_tiers", dfList);
            dfList = trComp.getTierNamesInBoth(trans, templTrans);
            this.reportTierDifferences(String.format("Number of tiers both in T1 and T2: %d", dfList.size()), dfList, trComp, trans, templTrans);
            this.changeMap.put("cg_tiers", dfList);
            dfList = trComp.getTypeNamesOnlyInFirst(trans, templTrans);
            this.reportList(String.format("Number of types only in T1: %d", dfList.size()), dfList);
            dfList = trComp.getTypeNamesOnlyInFirst(templTrans, trans);
            this.reportList(String.format("Number of types only in T2: %d", dfList.size()), dfList);
            this.changeMap.put("nw_types", dfList);
            dfList = trComp.getTypeNamesInBoth(trans, templTrans);
            this.reportTypeDifferences(String.format("Number of types both in T1 and T2: %d", dfList.size()), dfList, trComp, trans, templTrans);
            this.changeMap.put("ch_types", dfList);
            dfList = trComp.getCVNamesOnlyInFirst(trans, templTrans);
            this.reportList(String.format("Number of CV's only in T1: %d", dfList.size()), dfList);
            dfList = trComp.getCVNamesOnlyInFirst(templTrans, trans);
            this.reportList(String.format("Number of CV's only in T2: %d", dfList.size()), dfList);
            this.changeMap.put("nw_cvs", dfList);
            dfList = trComp.getCVNamesInBoth(trans, templTrans);
            this.reportCVDifferences(String.format("Number of CV's both in T1 and T2: %d", dfList.size()), dfList, trComp, trans, templTrans);
            this.changeMap.put("ch_cvs", dfList);
            dfList = trComp.getLanguagesOnlyInFirst(trans, templTrans);
            this.reportList(String.format("Number of content languages only in T1: %d", dfList.size()), dfList);
            dfList = trComp.getLanguagesOnlyInFirst(templTrans, trans);
            this.reportList(String.format("Number of content languages only in T2: %d", dfList.size()), dfList);
            dfList = trComp.getLanguagesInBoth(trans, templTrans);
            this.reportList(String.format("Number of content languages both in T1 and T2: %d", dfList.size()), dfList);
            this.reportLicenseDifferences(trComp, trans, templTrans);
            this.reportAuthorDifferences(trans, templTrans);
        }

        private void reportTierDifferences(String heading, List<String> dfList, TranscriptionCompare trComp, TranscriptionImpl tr1, TranscriptionImpl tr2) {
            UpdateTranscriptionsWithTemplateCommand.this.report(heading);
            if (dfList.size() == 0) {
                return;
            }
            String dTab = "\t\t";
            int numTiersWithDiffs = 0;
            int numPropDifferences = 0;
            TierImpl.ValueGetter[] propGetters = new TierImpl.ValueGetter[]{new TierImpl.ParentTierNameGetter(), new TierImpl.LinguisticTypeNameGetter(), new TierImpl.ParticipantGetter(), new TierImpl.AnnotatorGetter(), new TierImpl.LanguageGetter(), new TierImpl.LocaleGetter()};
            for (String s : dfList) {
                int i;
                TierImpl t1 = tr1.getTierWithId(s);
                TierImpl t2 = tr2.getTierWithId(s);
                boolean anyDiff = false;
                boolean[] propDiffs = new boolean[propGetters.length];
                for (i = 0; i < propDiffs.length; ++i) {
                    boolean bl = propDiffs[i] = !trComp.sameTierProperty(t1, t2, propGetters[i]);
                    if (!propDiffs[i]) continue;
                    anyDiff = true;
                }
                if (!anyDiff) continue;
                ++numTiersWithDiffs;
                UpdateTranscriptionsWithTemplateCommand.this.report(String.format("\tDifference in: \"%s\"", s));
                block10: for (i = 0; i < propDiffs.length; ++i) {
                    if (!propDiffs[i]) continue;
                    ++numPropDifferences;
                    String p1 = propGetters[i].getSortValue(t1);
                    String p2 = propGetters[i].getSortValue(t2);
                    switch (i) {
                        case 0: {
                            UpdateTranscriptionsWithTemplateCommand.this.report(String.format("%sParent tier T1: \"%s\", T2: \"%s\"", "\t\t", p1.isEmpty() ? "-" : p1, p2.isEmpty() ? "-" : p2));
                            continue block10;
                        }
                        case 1: {
                            UpdateTranscriptionsWithTemplateCommand.this.report(String.format("%sTier type T1: \"%s\", T2: \"%s\"", "\t\t", p1, p2));
                            continue block10;
                        }
                        case 2: {
                            UpdateTranscriptionsWithTemplateCommand.this.report(String.format("%sParticipant T1: \"%s\", T2: \"%s\"", "\t\t", p1, p2));
                            continue block10;
                        }
                        case 3: {
                            UpdateTranscriptionsWithTemplateCommand.this.report(String.format("%sAnnotator T1: \"%s\", T2: \"%s\"", "\t\t", p1, p2));
                            continue block10;
                        }
                        case 4: {
                            UpdateTranscriptionsWithTemplateCommand.this.report(String.format("%sContent language T1: \"%s\", T2: \"%s\"", "\t\t", p1, p2));
                            continue block10;
                        }
                        case 5: {
                            UpdateTranscriptionsWithTemplateCommand.this.report(String.format("%sLocale (Input Method) T1: \"%s\", T2: \"%s\"", "\t\t", p1, p2));
                        }
                    }
                }
            }
            if (numTiersWithDiffs > 0) {
                UpdateTranscriptionsWithTemplateCommand.this.report(String.format("Found %d differences in %d of the %d tiers in T1 and T2.", numPropDifferences, numTiersWithDiffs, dfList.size()));
            } else {
                UpdateTranscriptionsWithTemplateCommand.this.report(String.format("Found no differences in the %d tiers both in T1 and T2.", dfList.size()));
            }
        }

        private void reportTypeDifferences(String heading, List<String> dfList, TranscriptionCompare trComp, TranscriptionImpl tr1, TranscriptionImpl tr2) {
            UpdateTranscriptionsWithTemplateCommand.this.report(heading);
            if (dfList.size() == 0) {
                return;
            }
            String dTab = "\t\t";
            int numTypesWithDiffs = 0;
            int numPropDifferences = 0;
            LinguisticType.PropKey[] propKeys = new LinguisticType.PropKey[]{LinguisticType.PropKey.CONSTRAINT, LinguisticType.PropKey.CV_NAME, LinguisticType.PropKey.DC, LinguisticType.PropKey.LEX_BUNDLE};
            for (String s : dfList) {
                int i;
                LinguisticType lt1 = tr1.getLinguisticTypeByName(s);
                LinguisticType lt2 = tr2.getLinguisticTypeByName(s);
                boolean anyDiff = false;
                boolean[] propDiffs = new boolean[propKeys.length];
                for (i = 0; i < propDiffs.length; ++i) {
                    boolean bl = propDiffs[i] = !trComp.sameTypeProperty(lt1, lt2, propKeys[i]);
                    if (!propDiffs[i]) continue;
                    anyDiff = true;
                }
                if (!anyDiff) continue;
                ++numTypesWithDiffs;
                UpdateTranscriptionsWithTemplateCommand.this.report(String.format("\tDifference in: \"%s\"", s));
                block9: for (i = 0; i < propDiffs.length; ++i) {
                    if (!propDiffs[i]) continue;
                    ++numPropDifferences;
                    switch (propKeys[i]) {
                        case NAME: 
                        case ID: {
                            continue block9;
                        }
                        case CONSTRAINT: {
                            UpdateTranscriptionsWithTemplateCommand.this.report(String.format("%sStereotype in T1: \"%s\", T2: \"%s\"", "\t\t", ConstraintImpl.getStereoTypeName(lt1.getConstraints() == null ? -1 : lt1.getConstraints().getStereoType()), ConstraintImpl.getStereoTypeName(lt2.getConstraints() == null ? -1 : lt2.getConstraints().getStereoType())));
                            continue block9;
                        }
                        case CV_NAME: {
                            String cvn1 = lt1.getControlledVocabularyName();
                            String cvn2 = lt2.getControlledVocabularyName();
                            UpdateTranscriptionsWithTemplateCommand.this.report(String.format("%sControlled Vocabulary in T1: \"%s\", T2: \"%s\"", "\t\t", cvn1 != null ? cvn1 : "-", cvn2 != null ? cvn2 : "-"));
                            continue block9;
                        }
                        case DC: {
                            String dcRef = lt1.getDataCategory();
                            String dcRef2 = lt2.getDataCategory();
                            UpdateTranscriptionsWithTemplateCommand.this.report(String.format("%sData Category in T1: \"%s\", T2: \"%s\"", "\t\t", dcRef != null ? dcRef : "-", dcRef2 != null ? dcRef2 : "-"));
                            continue block9;
                        }
                        case LEX_BUNDLE: {
                            String ll1 = null;
                            String ll2 = null;
                            if (lt1.getLexiconQueryBundle() != null) {
                                ll1 = String.format("%s:%s", lt1.getLexiconQueryBundle().getLink() != null ? lt1.getLexiconQueryBundle().getLink().getName() : "-", lt1.getLexiconQueryBundle().getFldId() != null ? lt1.getLexiconQueryBundle().getFldId().getName() : "-");
                            }
                            if (lt2.getLexiconQueryBundle() != null) {
                                ll2 = String.format("%s:%s", lt2.getLexiconQueryBundle().getLink() != null ? lt2.getLexiconQueryBundle().getLink().getName() : "-", lt2.getLexiconQueryBundle().getFldId() != null ? lt2.getLexiconQueryBundle().getFldId().getName() : "-");
                            }
                            UpdateTranscriptionsWithTemplateCommand.this.report(String.format("%sLexicon reference in T1: \"%s\", T2: \"%s\"", "\t\t", ll1 != null ? ll1 : "-", ll2 != null ? ll2 : "-"));
                            continue block9;
                        }
                    }
                }
            }
            if (numTypesWithDiffs > 0) {
                UpdateTranscriptionsWithTemplateCommand.this.report(String.format("Found %d differences in %d of the %d tier types in T1 and T2.", numPropDifferences, numTypesWithDiffs, dfList.size()));
            } else {
                UpdateTranscriptionsWithTemplateCommand.this.report(String.format("Found no differences in the %d tier types both in T1 and T2.", dfList.size()));
            }
        }

        private void reportCVDifferences(String heading, List<String> dfList, TranscriptionCompare trComp, TranscriptionImpl tr1, TranscriptionImpl tr2) {
            UpdateTranscriptionsWithTemplateCommand.this.report(heading);
            if (dfList.size() == 0) {
                return;
            }
            String dTab = "\t\t";
            int numCVsWithDiffs = 0;
            int numPropDifferences = 0;
            BasicControlledVocabulary.PropKey[] propKeys = new BasicControlledVocabulary.PropKey[]{BasicControlledVocabulary.PropKey.DESCRIPTION, BasicControlledVocabulary.PropKey.NUM_ENTRIES, BasicControlledVocabulary.PropKey.NUM_LANGUAGES, BasicControlledVocabulary.PropKey.EXTERNAL_REF};
            for (String s : dfList) {
                int i;
                ControlledVocabulary cv1 = tr1.getControlledVocabulary(s);
                ControlledVocabulary cv2 = tr2.getControlledVocabulary(s);
                boolean anyDiff = false;
                boolean[] propDiffs = new boolean[propKeys.length];
                for (i = 0; i < propDiffs.length; ++i) {
                    boolean bl = propDiffs[i] = !trComp.sameCVProperty(cv1, cv2, propKeys[i]);
                    if (!propDiffs[i]) continue;
                    anyDiff = true;
                }
                if (!anyDiff) continue;
                ++numCVsWithDiffs;
                UpdateTranscriptionsWithTemplateCommand.this.report(String.format("\tDifference in: \"%s\"", s));
                block9: for (i = 0; i < propDiffs.length; ++i) {
                    if (!propDiffs[i]) continue;
                    ++numPropDifferences;
                    switch (propKeys[i]) {
                        case NAME: {
                            continue block9;
                        }
                        case DESCRIPTION: {
                            UpdateTranscriptionsWithTemplateCommand.this.report(String.format("%sDifference in Description(s) in T1 and T2", "\t\t"));
                            continue block9;
                        }
                        case NUM_ENTRIES: {
                            UpdateTranscriptionsWithTemplateCommand.this.report(String.format("%sNumber of entries in T1: %d, T2: %d", "\t\t", cv1.size(), cv2.size()));
                            continue block9;
                        }
                        case NUM_LANGUAGES: {
                            int k;
                            Object ls1 = "";
                            Object ls2 = "";
                            for (k = 0; k < cv1.getNumberOfLanguages(); ++k) {
                                ls1 = (String)ls1 + cv1.getLanguageId(k) + " ";
                            }
                            for (k = 0; k < cv2.getNumberOfLanguages(); ++k) {
                                ls2 = (String)ls2 + cv2.getLanguageId(k) + " ";
                            }
                            UpdateTranscriptionsWithTemplateCommand.this.report(String.format("%sNumber of languages in T1: %d (\"%s\"), T2: %d (\"%s\")", "\t\t", cv1.getNumberOfLanguages(), ls1, cv2.getNumberOfLanguages(), ls2));
                            continue block9;
                        }
                        case EXTERNAL_REF: {
                            String extRef1 = null;
                            if (cv1 instanceof ExternalCV) {
                                extRef1 = ((ExternalCV)cv1).getExternalRef().getValue();
                            }
                            String extRef2 = null;
                            if (cv2 instanceof ExternalCV) {
                                extRef2 = ((ExternalCV)cv2).getExternalRef().getValue();
                            }
                            UpdateTranscriptionsWithTemplateCommand.this.report(String.format("%sCV in T1: \"%s\", in T2: \"%s\"", "\t\t", extRef1 == null ? "internal" : "external:" + extRef1, extRef2 == null ? "internal" : "external:" + extRef2));
                        }
                    }
                }
            }
            if (numCVsWithDiffs > 0) {
                UpdateTranscriptionsWithTemplateCommand.this.report(String.format("Found %d differences in %d of the %d CV's in T1 and T2.", numPropDifferences, numCVsWithDiffs, dfList.size()));
            } else {
                UpdateTranscriptionsWithTemplateCommand.this.report(String.format("Found no differences (ignoring CV entry contents) in the %d CV's both in T1 and T2.", dfList.size()));
            }
        }

        private void reportLicenseDifferences(TranscriptionCompare trComp, TranscriptionImpl tr1, TranscriptionImpl tr2) {
            List<LicenseRecord> lr2;
            List<LicenseRecord> lr1 = tr1.getLicenses();
            if (lr1 == null) {
                lr1 = new ArrayList<LicenseRecord>(0);
            }
            if ((lr2 = tr2.getLicenses()) == null) {
                lr2 = new ArrayList<LicenseRecord>(0);
            }
            if (lr1.isEmpty() && lr2.isEmpty()) {
                UpdateTranscriptionsWithTemplateCommand.this.report("No License information in either T1 or T2");
            } else {
                boolean found;
                int numLr1 = lr1.size();
                int numLr2 = lr2.size();
                int numLr1Only = 0;
                int numLr2Only = 0;
                for (LicenseRecord rec1 : lr1) {
                    found = false;
                    for (LicenseRecord rec2 : lr2) {
                        if (!trComp.sameLicense(rec1, rec2)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    ++numLr1Only;
                }
                for (LicenseRecord rec2 : lr2) {
                    found = false;
                    for (LicenseRecord rec1 : lr1) {
                        if (!trComp.sameLicense(rec2, rec1)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    ++numLr2Only;
                }
                if (numLr1Only == 0 && numLr2Only == 0) {
                    UpdateTranscriptionsWithTemplateCommand.this.report(String.format("Found %d identical License Records in T1 and T2", numLr1));
                } else {
                    UpdateTranscriptionsWithTemplateCommand.this.report(String.format("Found %d License Records in T1 (%d unique), %d in T2 (%d unique)", numLr1, numLr1Only, numLr2, numLr2Only));
                }
            }
        }

        private void reportAuthorDifferences(TranscriptionImpl tr1, TranscriptionImpl tr2) {
            String au2;
            String au1 = tr1.getAuthor() == null ? "" : tr1.getAuthor();
            String string = au2 = tr2.getAuthor() == null ? "" : tr2.getAuthor();
            if (au1.equals(au2)) {
                if (au1.isEmpty()) {
                    UpdateTranscriptionsWithTemplateCommand.this.report("No Author information in either T1 or T2");
                } else {
                    UpdateTranscriptionsWithTemplateCommand.this.report(String.format("Same Author in T1 and T2: \"%s\"", au1));
                }
            } else {
                UpdateTranscriptionsWithTemplateCommand.this.report(String.format("Different Author in T1 (\"%s\") and T2 (\"%s\")", au1, au2));
            }
        }

        private void reportList(String heading, List<String> dfList) {
            UpdateTranscriptionsWithTemplateCommand.this.report(heading);
            for (String s : dfList) {
                if (s == null || s.isEmpty()) continue;
                UpdateTranscriptionsWithTemplateCommand.this.report("\t" + s);
            }
        }

        private void updateDifferences(TranscriptionImpl templTrans, TranscriptionImpl trans, MergeUtil mergeUtil) {
            this.updateAuthor(templTrans, trans);
            this.updateLicense(templTrans, trans);
            this.updateCVDifferences(mergeUtil, templTrans, trans);
            this.updateTypeDifferences(mergeUtil, templTrans, trans);
            this.updateTierDifferences(mergeUtil, templTrans, trans);
        }

        private void updateAuthor(TranscriptionImpl srcTrans, TranscriptionImpl targetTrans) {
            if (srcTrans.getAuthor() != null && !srcTrans.getAuthor().isEmpty() && !srcTrans.getAuthor().equals(targetTrans.getAuthor())) {
                targetTrans.setAuthor(srcTrans.getAuthor());
                targetTrans.setChanged();
                UpdateTranscriptionsWithTemplateCommand.this.report(String.format("Updated Author of T1 to \"%s\"", srcTrans.getAuthor()));
            }
        }

        private void updateLicense(TranscriptionImpl srcTrans, TranscriptionImpl targetTrans) {
            if (srcTrans.getLicenses() != null && !srcTrans.getLicenses().isEmpty()) {
                if (targetTrans.getLicenses() == null || targetTrans.getLicenses().isEmpty()) {
                    targetTrans.setLicenses(srcTrans.getLicenses());
                    targetTrans.setChanged();
                    UpdateTranscriptionsWithTemplateCommand.this.report(String.format("\tAdded %d License Records to T1", targetTrans.getLicenses().size()));
                } else if (targetTrans.getLicenses().size() == 1 && srcTrans.getLicenses().size() == 1) {
                    targetTrans.getLicenses().set(0, srcTrans.getLicenses().get(0));
                    targetTrans.setChanged();
                    UpdateTranscriptionsWithTemplateCommand.this.report("\tUpdated the single License Record of T1");
                }
            }
        }

        private void updateCVDifferences(MergeUtil mergeUtil, TranscriptionImpl srcTrans, TranscriptionImpl targetTrans) {
            List<String> newCVNames;
            List<String> changedCVNames = this.changeMap.get("ch_cvs");
            if (changedCVNames != null && !changedCVNames.isEmpty()) {
                for (String s : changedCVNames) {
                    mergeUtil.updateControlledVocabulary(srcTrans, targetTrans, s, UpdateTranscriptionsWithTemplateCommand.this.forceCVReplacement, UpdateTranscriptionsWithTemplateCommand.this.reporter);
                }
            }
            if ((newCVNames = this.changeMap.get("nw_cvs")) != null && !newCVNames.isEmpty()) {
                for (String s : newCVNames) {
                    mergeUtil.updateControlledVocabulary(srcTrans, targetTrans, s, UpdateTranscriptionsWithTemplateCommand.this.forceCVReplacement, UpdateTranscriptionsWithTemplateCommand.this.reporter);
                }
            }
        }

        private void updateTypeDifferences(MergeUtil mergeUtil, TranscriptionImpl srcTrans, TranscriptionImpl targetTrans) {
            List<String> changedTypesNames;
            List<String> newTypesNames = this.changeMap.get("nw_types");
            if (newTypesNames != null && !newTypesNames.isEmpty()) {
                for (String s : newTypesNames) {
                    mergeUtil.updateTierType(srcTrans, targetTrans, s, UpdateTranscriptionsWithTemplateCommand.this.reporter);
                }
            }
            if ((changedTypesNames = this.changeMap.get("ch_types")) != null && !changedTypesNames.isEmpty()) {
                for (String s : changedTypesNames) {
                    mergeUtil.updateTierType(srcTrans, targetTrans, s, UpdateTranscriptionsWithTemplateCommand.this.reporter);
                }
            }
        }

        private void updateTierDifferences(MergeUtil mergeUtil, TranscriptionImpl srcTrans, TranscriptionImpl targetTrans) {
            List<String> newTiersNames;
            List<String> changedTiersNames = this.changeMap.get("cg_tiers");
            if (changedTiersNames != null && !changedTiersNames.isEmpty()) {
                for (String s : changedTiersNames) {
                    mergeUtil.updateTier(srcTrans, targetTrans, s, UpdateTranscriptionsWithTemplateCommand.this.reporter);
                }
            }
            if ((newTiersNames = this.changeMap.get("nw_tiers")) != null && !newTiersNames.isEmpty()) {
                mergeUtil.updateWithNewTiers(srcTrans, targetTrans, newTiersNames, UpdateTranscriptionsWithTemplateCommand.this.reporter);
            }
        }
    }
}

