/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands.global;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.commands.global.FrameMenuAction;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import nl.mpi.util.FileExtension;

public class ImportCHATMA
extends FrameMenuAction {
    public ImportCHATMA(String name, ElanFrame2 frame) {
        super(name, frame);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        JOptionPane.showMessageDialog(this.frame, ElanLocale.getString("ExportCHATDialog.Message.CLANutility"), "ELAN", 1);
        FileChooser chooser = new FileChooser(this.frame);
        chooser.createAndShowFileDialog(ElanLocale.getString("Frame.ElanFrame.OpenDialog.Title"), 0, FileExtension.CHAT_EXT, "LastUsedCHATDir");
        File fileTemp = chooser.getSelectedFile();
        if (fileTemp != null) {
            try {
                int answer;
                String path = fileTemp.getAbsolutePath();
                path = path.replace('\\', '/');
                TranscriptionImpl transcription = new TranscriptionImpl(new File(path).getAbsolutePath());
                transcription.setChanged();
                int lastSlash = path.lastIndexOf(47);
                String chatPath = path.substring(0, lastSlash);
                boolean validMedia = true;
                if (this.frame != null) {
                    validMedia = this.frame.checkMedia(transcription, chatPath);
                }
                if (!validMedia && (answer = JOptionPane.showConfirmDialog(this.frame, ElanLocale.getString("Frame.ElanFrame.IncompleteMediaQuestion"), ElanLocale.getString("Frame.ElanFrame.IncompleteMediaAvailable"), 0)) != 0) {
                    return;
                }
                FrameManager.getInstance().createFrame(transcription);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

