/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands.global;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.logging.Level;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.commands.global.FrameMenuAction;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.json.JSONWADecoderInfo;
import nl.mpi.util.FileExtension;

public class ImportJSONMA
extends FrameMenuAction {
    public ImportJSONMA(String name, ElanFrame2 frame) {
        super(name, frame);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block4: {
            FileChooser chooser = new FileChooser(this.frame);
            chooser.createAndShowFileAndEncodingDialog(ElanLocale.getString("Frame.ElanFrame.OpenDialog.Title"), 0, FileExtension.JSON_EXT, "LastUsedJSONDir", "UTF-8");
            File fileTemp = chooser.getSelectedFile();
            if (fileTemp == null) {
                return;
            }
            try {
                String encoding = chooser.getSelectedEncoding();
                String filePath = fileTemp.getAbsolutePath().replace('\\', '/');
                JSONWADecoderInfo decoderInfo = new JSONWADecoderInfo(filePath);
                decoderInfo.setCharsetName(encoding);
                TranscriptionImpl transcription = new TranscriptionImpl(filePath, decoderInfo);
                transcription.setChanged();
                int dotIndex = filePath.lastIndexOf(46);
                int slashIndex = filePath.lastIndexOf(47);
                if (slashIndex > -1 && dotIndex > slashIndex + 1) {
                    transcription.setName(filePath.substring(slashIndex + 1, dotIndex));
                }
                FrameManager.getInstance().createFrame(transcription);
            }
            catch (Throwable t) {
                if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block4;
                ClientLogger.LOG.log(Level.WARNING, "Could not convert the JSON file: " + t.getMessage());
                t.printStackTrace();
            }
        }
    }
}

