/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.comments;

import java.awt.AWTPermission;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.event.ListDataEvent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.AddCommentCommand;
import mpi.eudico.client.annotator.commands.ChangeCommentCommand;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.comments.CommentEnvelope;
import mpi.eudico.client.annotator.comments.CommentEnvelopesParser;
import mpi.eudico.client.annotator.comments.CommentWebClient;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.viewer.CommentViewer;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.IoUtil;
import mpi.eudico.util.Pair;
import nl.mpi.util.FileUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

public class CommentManager {
    public static final boolean DEBUG = false;
    static final String SHARED_DIRECTORY_LOCATION = "CommentViewer.SharedDirectoryLocation";
    static final String USE_SHARED_DIRECTORY = "CommentViewer.UseSharedDirectory";
    static final String SEARCH_EAF_DIRECTORY = "CommentViewer.SearchDirectory.EAF";
    static final String SEARCH_COMMENTS_DIRECTORY = "CommentViewer.SearchDirectory.Comments";
    public static final String UPDATE_CHECK_TIME = "CommentViewer.UpdateCheckTime";
    static final String SENDER_EMAIL_ADDRESS = "CommentViewer.Sender";
    static final String RECIPIENT_EMAIL_ADDRESS = "CommentViewer.Recipient";
    static final String INITIALS = "CommentViewer.Initials";
    static final String THREAD_ID = "CommentViewer.ThreadID";
    static final String SERVER_URL = "CommentViewer.Server.URL";
    static final String SERVER_URL_DEFAULT = "https://corpus1.mpi.nl/ds/webannotator-basic";
    static final String SERVER_LOGIN_NAME = "CommentViewer.Server.Loginname";
    static final String COMMENT_ENVELOPES_NAMESPACE = "http://mpi.nl/tools/coltime";
    static final String COMMENT_ENVELOPES_SCHEMA_URL = "http://www.mpi.nl/tools/coltime/schema.xsd";
    static final String COMMENT_ENVELOPES_SCHEMA_URL_OLD = "http://www.mpi.nl/tools/elan/comments.xsd";
    static final String COMMENT_FILENAME_SUFFIX = ".eafcomment";
    public static final int RELOAD_FROM_FILE = 0;
    public static final int RELOAD_FROM_SERVER = 1;
    private TranscriptionImpl transcription;
    private List<CommentEnvelope> comments;
    private List<CommentEnvelope> readOnlyComments;
    private CommentViewer viewer;
    private CommentWebClient webClient;
    private boolean toBeSavedToFile = false;
    private long nextCheckForModificationOfSaveFile;
    private long saveFileLastModified;
    private long saveFileLastLookedAt;
    private static String cachedSenderPreference = "";
    private static Pattern matchPattern;

    public CommentManager(TranscriptionImpl transcription, CommentViewer viewer) {
        this.transcription = transcription;
        this.comments = new ArrayList<CommentEnvelope>();
        this.readOnlyComments = Collections.unmodifiableList(this.comments);
        this.load();
        this.viewer = viewer;
    }

    public boolean webClientIsLoggedIn() {
        return this.webClient != null && this.webClient.isLoggedIn();
    }

    public boolean loginWebClient() {
        if (this.webClient == null) {
            this.webClient = CommentWebClient.getCommentWebClient(this.transcription);
        }
        String serviceURL = SERVER_URL_DEFAULT;
        String username = "";
        String servicePref = Preferences.getString(SERVER_URL, null);
        if (servicePref != null) {
            serviceURL = servicePref;
        }
        if (serviceURL.isEmpty()) {
            ClientLogger.LOG.severe("Can't even try to login: Service URL is empty.");
            return false;
        }
        String usernamePref = Preferences.getString(SERVER_LOGIN_NAME, null);
        if (usernamePref != null) {
            username = usernamePref;
        }
        if (username.isEmpty()) {
            ClientLogger.LOG.severe("Can't even try to login: User name is empty.");
            return false;
        }
        boolean loggedIn = this.webClient.login(serviceURL, username);
        if (loggedIn) {
            ClientLogger.LOG.warning("Logged in successfully.");
            this.reloadFromServer(true);
        } else {
            ClientLogger.LOG.warning("Did not manage to log in.");
            this.logoutWebClient();
        }
        return this.webClientIsLoggedIn();
    }

    public void logoutWebClient() {
        this.webClient.logout();
        this.webClient.close();
        this.webClient = null;
    }

    public CommentEnvelope createComment(String text, long start, long end) {
        CommentEnvelope m = new CommentEnvelope();
        m.setMessage(text);
        m.setStartEndTime(start, end);
        m.setMessageID();
        m.setCreationDate();
        m.setModificationDate();
        m.setAnnotationFile(this.transcription.getURN().toASCIIString());
        m.setAnnotationFileURL("");
        m.setAnnotationFileType("EAF");
        String stringPref = Preferences.getString(SENDER_EMAIL_ADDRESS, null);
        if (stringPref != null) {
            m.setSender(stringPref);
        }
        if ((stringPref = Preferences.getString(RECIPIENT_EMAIL_ADDRESS, null)) != null) {
            m.setRecipient(stringPref);
        }
        if ((stringPref = Preferences.getString(INITIALS, null)) != null) {
            m.setInitials(stringPref);
        }
        if ((stringPref = Preferences.getString(THREAD_ID, null)) != null) {
            m.setThreadID(stringPref);
        }
        m.setToBeSaved(true);
        return m;
    }

    private void notifyOfInsert(int where) {
        if (this.viewer != null) {
            this.viewer.intervalAdded(new ListDataEvent(this, 1, where, where));
        }
    }

    private void notifyOfRemoval(int where) {
        if (this.viewer != null) {
            this.viewer.intervalRemoved(new ListDataEvent(this, 2, where, where));
        }
    }

    private void notifyOfChange(int lwb, int upb) {
        if (this.viewer != null) {
            this.viewer.contentsChanged(new ListDataEvent(this, 0, lwb, upb));
        }
    }

    public int undoableInsert(CommentEnvelope m) {
        AddCommentCommand cmd = (AddCommentCommand)ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.AddComment");
        Object[] args = new Object[]{m};
        cmd.execute(this, args);
        return cmd.getInsertPosition();
    }

    public void undoableRemove(int i) {
        Command cmd = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.DeleteComment");
        Object[] args = new Object[]{i};
        cmd.execute(this, args);
    }

    public int undoableReplace(int index, CommentEnvelope ce) {
        ChangeCommentCommand cmd = (ChangeCommentCommand)ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.ChangeComment");
        Object[] args = new Object[]{index, ce};
        cmd.execute(this, args);
        return cmd.getInsertPosition();
    }

    public int insert(CommentEnvelope m) {
        int where = 0;
        this.toBeSavedToFile = true;
        m.setToBeSaved(true);
        if (this.comments.isEmpty()) {
            this.comments.add(m);
        } else {
            ListIterator<CommentEnvelope> i = this.comments.listIterator();
            CommentEnvelope next = null;
            while (i.hasNext()) {
                ++where;
                next = i.next();
                if (m.compareTo(next) > 0) continue;
                i.previous();
                i.add(m);
                this.notifyOfInsert(--where);
                this.saveToServer(m);
                return where;
            }
            i.add(m);
        }
        this.notifyOfInsert(where);
        this.saveToServer(m);
        return where;
    }

    public void remove(int index) {
        this.toBeSavedToFile = true;
        CommentEnvelope ce = this.comments.get(index);
        this.deleteFromServer(ce);
        this.notifyOfRemoval(index);
        this.comments.remove(index);
    }

    public int replace(int index, CommentEnvelope newCE) {
        this.toBeSavedToFile = true;
        this.comments.remove(index);
        this.notifyOfRemoval(index);
        return this.insert(newCE);
    }

    public ListIterator<CommentEnvelope> firstCommentAfterTime(long time) {
        ListIterator<CommentEnvelope> it = this.readOnlyComments.listIterator();
        if (time > 0L) {
            while (it.hasNext()) {
                CommentEnvelope comment = it.next();
                if (comment.getStartTime() < time) continue;
                it.previous();
                return it;
            }
        }
        return it;
    }

    public CommentEnvelope get(int index) {
        return this.comments.get(index);
    }

    public void release(int index, CommentEnvelope ce) {
        this.toBeSavedToFile = true;
        ce.setToBeSaved(true);
        this.saveToServer(ce);
        this.notifyOfChange(index, index);
    }

    public CommentEnvelope undoableGet(int index) {
        CommentEnvelope original = this.get(index);
        return original.clone();
    }

    public int undoableRelease(int index, CommentEnvelope ce) {
        return this.undoableReplace(index, ce);
    }

    private void saveToServer(CommentEnvelope ce) {
        if (this.webClientIsLoggedIn()) {
            this.webClient.putCommentEnvelope(ce);
        }
    }

    private void deleteFromServer(CommentEnvelope ce) {
        if (this.webClientIsLoggedIn()) {
            this.webClient.deleteCommentEnvelope(ce);
            ce.setMessageURL("");
        }
    }

    public List<CommentEnvelope> getList() {
        return this.readOnlyComments;
    }

    public ListIterator<CommentEnvelope> listIterator() {
        return this.readOnlyComments.listIterator();
    }

    public int findCommentById(String messageID) {
        int i = 0;
        for (CommentEnvelope c : this.comments) {
            if (messageID.equals(c.getMessageID())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void isClosing() {
        this.save();
        if (this.webClient != null) {
            this.webClient.close();
            this.webClient = null;
        }
    }

    private String privatePathName() {
        TranscriptionImpl ti;
        Object pathName;
        if (this.transcription instanceof TranscriptionImpl && (pathName = (ti = this.transcription).getPathName()) != null && !((String)pathName).equals("aishug294879ryshfda9763afo8947a5gf")) {
            int dot = ((String)pathName).lastIndexOf(46);
            if (dot >= 0) {
                pathName = ((String)pathName).substring(0, dot);
            }
            pathName = (String)pathName + COMMENT_FILENAME_SUFFIX;
            return pathName;
        }
        return null;
    }

    private String sharedDirectoryName() {
        String sharedPathName;
        String stringPref;
        Boolean boolPref = Preferences.getBool(USE_SHARED_DIRECTORY, this.transcription);
        if (boolPref != null && boolPref.booleanValue() && (stringPref = Preferences.getString(SHARED_DIRECTORY_LOCATION, null)) != null && !(sharedPathName = FileUtility.urlToAbsPath(stringPref)).isEmpty() && FileUtility.fileExists(sharedPathName)) {
            return sharedPathName + "/";
        }
        return null;
    }

    private String effectivePathName() {
        String pathName = this.privatePathName();
        if (pathName != null) {
            String sharedDirName = this.sharedDirectoryName();
            if (sharedDirName != null) {
                String sharedFileName = sharedDirName + FileUtility.fileNameFromPath(pathName);
                return sharedFileName;
            }
            return pathName;
        }
        return null;
    }

    public void save() {
        String pathName = this.effectivePathName();
        if (pathName != null) {
            File f = new File(pathName);
            long lastModified = f.lastModified();
            if (lastModified > this.saveFileLastModified) {
                this.checkForFileModifications(true);
            }
            this.save(pathName);
            this.saveFileLastLookedAt = this.saveFileLastModified = f.lastModified();
            this.clearToBeSavedToFile();
        }
    }

    private void clearToBeSavedToFile() {
        this.toBeSavedToFile = false;
        for (CommentEnvelope ce : this.comments) {
            ce.setToBeSavedToFile(false);
            if (!ce.getToBeSavedToServer()) continue;
            this.saveToServer(ce);
        }
    }

    private void save(String pathName) {
        if (this.comments.isEmpty()) {
            File f = new File(pathName);
            if (f.exists()) {
                f.delete();
            }
        } else {
            try {
                this.save(pathName, this.getElement());
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
        }
    }

    private void save(String pathName, Element e) {
        try {
            IoUtil.writeEncodedFile("UTF-8", pathName, e);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private Element getElement() throws ParserConfigurationException {
        return this.getElement(this.comments);
    }

    private Element getElement(Collection<CommentEnvelope> comments) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        Element list = doc.createElementNS(COMMENT_ENVELOPES_NAMESPACE, "ColTimeList");
        doc.appendChild(list);
        for (CommentEnvelope cm : comments) {
            Element elem = cm.getElement(COMMENT_ENVELOPES_NAMESPACE, doc);
            list.appendChild(elem);
        }
        Element docElement = CommentManager.addSchemaLocation(doc);
        return docElement;
    }

    public static Element getElement(CommentEnvelope cm) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        Element elem = cm.getElement(COMMENT_ENVELOPES_NAMESPACE, doc);
        doc.appendChild(elem);
        Element docElement = CommentManager.addSchemaLocation(doc);
        return docElement;
    }

    private static Element addSchemaLocation(Document doc) {
        Element docElement = doc.getDocumentElement();
        docElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "http://mpi.nl/tools/coltime http://www.mpi.nl/tools/coltime/schema.xsd");
        return docElement;
    }

    private void load() {
        String pathName = this.effectivePathName();
        if (pathName != null && FileUtility.fileExists(pathName)) {
            Predicate<CommentEnvelope> filter = new Predicate<CommentEnvelope>(){

                @Override
                public boolean test(CommentEnvelope obj) {
                    if (obj.getAnnotationFileURL().isEmpty()) {
                        obj.setToBeSavedToServer(true);
                        CommentManager.this.saveToServer(obj);
                    }
                    return true;
                }
            };
            this.load(pathName, filter);
        }
        this.reloadFromServer(false);
    }

    private boolean load(String pathName, Predicate<CommentEnvelope> filter) {
        this.saveFileLastLookedAt = System.currentTimeMillis();
        List<CommentEnvelope> comments = CommentManager.read(pathName, filter);
        if (comments != null && !comments.isEmpty()) {
            Collections.sort(comments);
            this.comments.clear();
            this.comments.addAll(comments);
            this.notifyOfChange(0, this.comments.size() - 1);
            return true;
        }
        return false;
    }

    static List<CommentEnvelope> read(String pathName, Predicate<CommentEnvelope> filter) {
        CommentEnvelopesParser parser = new CommentEnvelopesParser();
        List<CommentEnvelope> readComments = parser.parse(pathName, filter);
        CommentManager.assignReadOnlyStatus(readComments, false);
        return readComments;
    }

    private static String getSenderEmailAddress() {
        String pref = Preferences.getString(SENDER_EMAIL_ADDRESS, null);
        String me = pref != null ? pref : "";
        return me;
    }

    private static void assignReadOnlyStatus(List<CommentEnvelope> comments, boolean forceRW) {
        String me = CommentManager.getSenderEmailAddress();
        CommentManager.assignReadOnlyStatus(comments, me, forceRW);
    }

    private static void assignReadOnlyStatus(List<CommentEnvelope> comments, String me, boolean forceRW) {
        if (me.isEmpty()) {
            if (forceRW) {
                for (CommentEnvelope c : comments) {
                    c.setReadOnly(false);
                }
            }
        } else {
            Iterator<CommentEnvelope> iterator = comments.iterator();
            while (iterator.hasNext()) {
                CommentEnvelope c;
                String sender = (c = iterator.next()).getSender();
                c.setReadOnly(!sender.isEmpty() && !me.equals(sender));
            }
        }
        cachedSenderPreference = me;
    }

    private void reAssignReadOnlyStatus() {
        String me;
        if (!this.webClientIsLoggedIn() && !cachedSenderPreference.equals(me = CommentManager.getSenderEmailAddress())) {
            CommentManager.assignReadOnlyStatus(this.comments, me, true);
        }
    }

    public void preferencesChanged() {
        this.reAssignReadOnlyStatus();
    }

    public static TranscriptionImpl findTranscriptionFromURN(URI urn, Predicate<TranscriptionImpl> pred) {
        List<Transcription> ts = FrameManager.getInstance().getOpenTranscriptions();
        for (Transcription t : ts) {
            if (!t.getURN().equals(urn)) continue;
            TranscriptionImpl ti = (TranscriptionImpl)t;
            if (pred != null && !pred.test(ti)) continue;
            return ti;
        }
        List<File> candidates = CommentManager.findCandidateEafFiles(urn);
        return CommentManager.findTranscriptionFromURN(urn, pred, candidates);
    }

    static TranscriptionImpl findTranscriptionFromURN(URI urn, Predicate<TranscriptionImpl> pred, List<File> candidates) {
        for (File file : candidates) {
            TranscriptionImpl t = new TranscriptionImpl(file.getAbsolutePath());
            if (!t.getURN().equals(urn) || pred != null && !pred.test(t)) continue;
            return t;
        }
        return null;
    }

    private static List<File> findCandidateEafFiles(URI urn) {
        TreeSet<File> dirs = new TreeSet<File>();
        String stringPref = Preferences.getString(SEARCH_EAF_DIRECTORY, null);
        if (stringPref != null) {
            String searchPathName = FileUtility.urlToAbsPath(stringPref);
            CommentManager.addCandidateDirectory(dirs, new File(searchPathName));
        }
        for (String r : FrameManager.getInstance().getRecentFiles()) {
            CommentManager.addCandidateDirectory(dirs, new File(FileUtility.directoryFromPath(r)));
        }
        stringPref = Preferences.getString(SHARED_DIRECTORY_LOCATION, null);
        if (stringPref != null) {
            String sharedPathName = FileUtility.urlToAbsPath(stringPref);
            CommentManager.addCandidateDirectory(dirs, new File(sharedPathName));
        }
        ArrayList<File> res = new ArrayList<File>();
        for (File dir : dirs) {
            CommentManager.findCandidateEafFiles(res, urn, dir);
        }
        return res;
    }

    private static List<File> findCandidateEafFiles(URI urn, File startdir) {
        ArrayList<File> res = new ArrayList<File>();
        CommentManager.findCandidateEafFiles(res, urn, startdir);
        return res;
    }

    private static void addCandidateDirectory(Set<File> dirs, File newdir) {
        try {
            newdir = newdir.getCanonicalFile();
        }
        catch (IOException e) {
            return;
        }
        if (dirs.contains(newdir)) {
            return;
        }
        Iterator<File> iter = dirs.iterator();
        while (iter.hasNext()) {
            File olddir = iter.next();
            if (CommentManager.isParentOf(olddir, newdir)) {
                return;
            }
            if (!CommentManager.isParentOf(newdir, olddir)) continue;
            iter.remove();
        }
        dirs.add(newdir);
    }

    private static boolean isParentOf(File parent, File child) {
        String c;
        String p = parent.getPath();
        if (p.equals(c = child.getPath())) {
            return true;
        }
        int p_length = p.length();
        int c_length = c.length();
        return c_length > p_length && c.startsWith(p) && c.substring(p_length, p_length + 1).equals(File.separator);
    }

    private static void findCandidateEafFiles(List<File> res, URI urn, File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                String name;
                if (f.isDirectory()) {
                    CommentManager.findCandidateEafFiles(res, urn, f);
                    continue;
                }
                if (!f.canRead() || !(name = f.getName()).endsWith(".eaf") || !CommentManager.scanForURN(urn, f)) continue;
                res.add(f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean scanForURN(URI urn, File file) {
        if (matchPattern == null) {
            matchPattern = Pattern.compile("<PROPERTY\\s+NAME\\s*=\\s*\"URN\">\\s*(.*)\\s*</PROPERTY>");
        }
        String urnAsString = urn.toString();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = null;
            Matcher m = matchPattern.matcher("");
            for (int lineNr = 0; lineNr < 25; ++lineNr) {
                String urnInFile;
                line = reader.readLine();
                if (line == null) {
                    break;
                }
                if (!(m = m.reset(line)).find() || !urnAsString.equals(urnInFile = m.group(1))) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public static boolean canAccessSystemClipboard() {
        if (System.getSecurityManager() != null) {
            try {
                System.getSecurityManager().checkPermission(new AWTPermission("accessClipboard"));
                return true;
            }
            catch (SecurityException se) {
                se.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void commentsToClipboard(int[] selected) {
        try {
            if (CommentManager.canAccessSystemClipboard()) {
                ArrayList<CommentEnvelope> coll = new ArrayList<CommentEnvelope>();
                for (int s : selected) {
                    coll.add(this.comments.get(s));
                }
                Element e = this.getElement(coll);
                String s = CommentManager.serialize(e);
                StringSelection ssVal = new StringSelection(s);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ssVal, null);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public static String serialize(Element e) {
        Document document = e.getOwnerDocument();
        DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer serializer = domImplLS.createLSSerializer();
        serializer.getDomConfig().setParameter("format-pretty-print", true);
        String str = serializer.writeToString(e);
        return str;
    }

    public static void commentsFromClipboard() {
        if (CommentManager.canAccessSystemClipboard()) {
            List<CommentEnvelope> coll;
            try {
                Transferable trans = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                if (!trans.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    return;
                }
                String s = (String)trans.getTransferData(DataFlavor.stringFlavor);
                CommentEnvelopesParser cep = new CommentEnvelopesParser();
                coll = cep.parse(new InputSource(new StringReader(s)), null);
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            if (coll.isEmpty()) {
                JOptionPane.showMessageDialog(null, ElanLocale.getString("CommentManager.NoCommentsOnClipboard"), ElanLocale.getString("Message.Warning"), 0);
            }
            for (CommentEnvelope ce : coll) {
                URI uri = ce.getAnnotationURIBase();
                TranscriptionImpl t = CommentManager.findTranscriptionFromURNwithDialog(uri, null);
                Pair<ElanFrame2, Boolean> pair = CommentManager.getOrOpenFrameFor(t);
                ElanFrame2 frame = pair.getFirst();
                if (frame != null) {
                    ce.setToBeSaved(true);
                    frame.getViewerManager().getCommentViewer().addComment(ce);
                    continue;
                }
                System.err.printf("Can't find frame for pathname '%s' with URN %s\n", t.getPathName(), uri.toASCIIString());
            }
        }
    }

    public static TranscriptionImpl findTranscriptionFromURNwithDialog(URI uri, Predicate<TranscriptionImpl> pred) {
        TranscriptionImpl t = CommentManager.findTranscriptionFromURN(uri, pred);
        while (t == null) {
            System.err.printf("Can't find open transcription for URN %s\n", uri.toASCIIString());
            JOptionPane.showMessageDialog(null, ElanLocale.getString("CommentManager.CantFindOpenTranscription"), ElanLocale.getString("Message.Warning"), 0);
            FileChooser chooser = new FileChooser(null);
            String title = ElanLocale.getString("CommentManager.SelectDirectory");
            chooser.createAndShowFileDialog(title, 0, null, null, null, true, "LastUsedEAFDir", 1, null);
            File file = chooser.getSelectedFile();
            if (file == null) break;
            t = CommentManager.findTranscriptionFromURN(uri, pred, CommentManager.findCandidateEafFiles(uri, file));
        }
        return t;
    }

    public static Pair<ElanFrame2, Boolean> getOrOpenFrameFor(TranscriptionImpl t) {
        if (t != null) {
            ElanFrame2 frame = FrameManager.getInstance().getFrameFor(t);
            if (frame == null) {
                frame = FrameManager.getInstance().createFrame(t);
                return Pair.makePair(frame, true);
            }
            return Pair.makePair(frame, false);
        }
        return Pair.makePair(null, false);
    }

    public void commentsToMail(int[] selected) {
        try {
            ArrayList<CommentEnvelope> coll = new ArrayList<CommentEnvelope>();
            for (int s : selected) {
                coll.add(this.comments.get(s));
            }
            Element e = this.getElement(coll);
            String s = CommentManager.serialize(e);
            String to = ((CommentEnvelope)coll.get(0)).getRecipient();
            String uriString = String.format("mailto:%s?subject=%s&body=%s", this.mailtoURIEncode(to), this.mailtoURIEncode("ColTime comment"), this.mailtoURIEncode(s));
            Desktop.getDesktop().mail(new URI(uriString));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    String mailtoURIEncode(String s) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, "UTF-8").replace("+", "%20");
    }

    public int undoableAddComment(CommentEnvelope ce) {
        int c = this.findCommentById(ce.getMessageID());
        if (c >= 0) {
            return c;
        }
        this.undoableInsert(ce);
        return -1;
    }

    public void updateAsNewComment(CommentEnvelope ce, boolean removeFromServerFirst) {
        if (removeFromServerFirst) {
            this.deleteFromServer(ce);
        }
        ce.setMessageID();
        ce.setMessageURL("");
    }

    public void checkForFileModifications(boolean force) {
        long now = System.currentTimeMillis();
        if (!force && now < this.nextCheckForModificationOfSaveFile) {
            return;
        }
        this.nextCheckForModificationOfSaveFile = now + 30000L;
        String filename = this.effectivePathName();
        if (filename == null) {
            return;
        }
        File f = new File(filename);
        long time = f.lastModified();
        if (time > this.saveFileLastModified) {
            this.saveFileLastModified = time;
            this.reload(filename, null);
        }
        this.reloadFromServer(false);
        if (this.toBeSavedToFile) {
            this.save();
        }
        now = System.currentTimeMillis();
        this.nextCheckForModificationOfSaveFile = now + 30000L;
    }

    public boolean reload(String pathName, Predicate<CommentEnvelope> filter) {
        List<CommentEnvelope> comments = CommentManager.read(pathName, filter);
        if (comments != null && !comments.isEmpty()) {
            this.reload(comments, null, 0);
            return true;
        }
        return false;
    }

    public void reloadFromServer(boolean force) {
        if (this.webClientIsLoggedIn()) {
            LinkedList<CommentEnvelope> notChanged = new LinkedList<CommentEnvelope>();
            List<CommentEnvelope> extra = this.webClient.getCommentEnvelopes(this.transcription.getURN(), force ? null : this.getList(), notChanged);
            if (extra != null) {
                this.reload(extra, notChanged, 1);
            }
        }
    }

    public void reload(List<CommentEnvelope> reloadedComments, List<CommentEnvelope> notChanged, int reloadedFromWhere) {
        Collections.sort(reloadedComments);
        HashSet<String> unseen = new HashSet<String>();
        for (CommentEnvelope ce : this.comments) {
            unseen.add(ce.getMessageID());
        }
        if (notChanged != null) {
            for (CommentEnvelope ce : notChanged) {
                unseen.remove(ce.getMessageID());
            }
        }
        for (CommentEnvelope ce : reloadedComments) {
            String id = ce.getMessageID();
            int existingIndex = this.findCommentById(id);
            if (existingIndex < 0) {
                this.insert(ce);
                continue;
            }
            CommentEnvelope existing = this.get(existingIndex);
            unseen.remove(id);
            if (ce == existing) continue;
            if (ce.interestingValueEquals(existing)) {
                existing.setUninterestingFields(ce);
                if (reloadedFromWhere != 1) continue;
                existing.setServerModifiableFields(ce);
                continue;
            }
            if (ce.isReadOnly()) {
                this.undoableReplace(existingIndex, ce);
                continue;
            }
            if (reloadedFromWhere == 0 && existing.getToBeSavedToFile() && existing.isNewerThan(ce) && ce.getModificationDate().getTime() < this.saveFileLastLookedAt - 5000L || this.viewer == null) continue;
            this.viewer.modifyComment(existingIndex, ce, reloadedFromWhere);
        }
        if (!unseen.isEmpty()) {
            for (String removed : unseen) {
                int existingIndex = this.findCommentById(removed);
                if (existingIndex < 0) continue;
                CommentEnvelope ce = this.get(existingIndex);
                ce.setMessageURL("");
                ce = this.undoableGet(existingIndex);
                if (ce.getToBeSavedToServer()) {
                    this.undoableRelease(existingIndex, ce);
                    continue;
                }
                if (ce.isReadOnly()) {
                    this.undoableRemove(existingIndex);
                    continue;
                }
                if (this.viewer == null) continue;
                this.viewer.maybeRemoveComment(existingIndex, ce, reloadedFromWhere);
            }
        }
        if (this.toBeSavedToFile) {
            this.save();
        }
    }
}

