/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.comments;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.comments.CommentEnvelope;
import mpi.eudico.client.annotator.comments.CommentManager;
import mpi.eudico.client.annotator.comments.CommentTable;
import mpi.eudico.client.annotator.comments.DefaultCommentTableModel;
import mpi.eudico.client.annotator.comments.TableModelExtender;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.viewer.CommentViewer;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.Pair;
import nl.mpi.util.FileUtility;

public class CommentSearchDialog
extends ClosableDialog
implements ActionListener,
MouseListener,
PropertyChangeListener {
    private JLabel searchLabel;
    private JTextField searchTextField;
    private String searchString;
    private JLabel caseLabel;
    private JCheckBox caseCheckBox;
    private boolean caseSensitive;
    private JButton searchButton;
    private JButton closeButton;
    private DefaultCommentTableModel tableModel;
    private TableModelExtender<String> tableModelEx;
    private CommentTable commentTable;
    private List<CommentEnvelope> searchResults;
    private List<String> resultFiles;
    private JComboBox columnComboBox;
    private JLabel columnLabel;
    private int searchColumn;
    private JProgressBar progressBar;
    private SwingWorker<Void, Void> searchTask;

    public CommentSearchDialog(String initialFilter, boolean caseSensitive) {
        super((Frame)null, false);
        this.searchString = initialFilter;
        this.caseSensitive = caseSensitive;
        this.searchResults = Collections.emptyList();
        this.initComponents();
        this.postInit();
    }

    private void initComponents() {
        String title = ElanLocale.getString("CommentSearchDialog.Title");
        this.setTitle(title);
        this.setLayout(new GridBagLayout());
        JPanel settingsPanel = new JPanel(new GridBagLayout());
        settingsPanel.setBorder(BorderFactory.createTitledBorder(title));
        GridBagConstraints settingsgbc = new GridBagConstraints();
        settingsgbc.insets = new Insets(10, 10, 10, 10);
        settingsgbc.fill = 2;
        settingsgbc.weightx = 1.0;
        settingsgbc.gridx = 0;
        settingsgbc.gridy = 0;
        JPanel textfieldsPanel = new JPanel(new GridBagLayout());
        this.searchLabel = new JLabel(ElanLocale.getString("CommentSearchDialog.SearchForRegex"));
        this.searchTextField = new JTextField(this.searchString, 30);
        this.searchTextField.addActionListener(this);
        this.columnLabel = new JLabel(ElanLocale.getString("CommentSearchDialog.SearchInColumn"));
        this.columnComboBox = new JComboBox();
        this.columnComboBox.addItem(ElanLocale.getString("CommentSearchDialog.AllColumns"));
        this.tableModel = new DefaultCommentTableModel(null);
        int ncols = this.tableModel.getColumnCount();
        for (int i = 0; i < ncols; ++i) {
            this.columnComboBox.addItem(this.tableModel.getColumnName(i));
        }
        this.columnComboBox.addActionListener(this);
        this.searchColumn = -1;
        this.caseLabel = new JLabel(ElanLocale.getString("CommentSearchDialog.CaseSensitive"));
        this.caseCheckBox = new JCheckBox("", this.caseSensitive);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.gridx = 0;
        gbc.gridy = 0;
        textfieldsPanel.add((Component)this.searchLabel, gbc);
        ++gbc.gridy;
        textfieldsPanel.add((Component)this.columnLabel, gbc);
        ++gbc.gridy;
        textfieldsPanel.add((Component)this.caseLabel, gbc);
        ++gbc.gridy;
        ++gbc.gridx;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        textfieldsPanel.add((Component)this.searchTextField, gbc);
        ++gbc.gridy;
        textfieldsPanel.add((Component)this.columnComboBox, gbc);
        ++gbc.gridy;
        textfieldsPanel.add((Component)this.caseCheckBox, gbc);
        ++gbc.gridy;
        ++settingsgbc.gridy;
        settingsPanel.add((Component)textfieldsPanel, settingsgbc);
        this.tableModel.setComments(this.searchResults);
        this.tableModelEx = new TableModelExtender<String>(this.tableModel, ElanLocale.getString("CommentSearchDialog.File"), String.class);
        this.commentTable = new CommentTable(this.tableModelEx);
        JScrollPane scrollCommentList = new JScrollPane(this.commentTable);
        this.commentTable.setScrollPane(scrollCommentList);
        this.commentTable.addListeners(this);
        ++settingsgbc.gridy;
        settingsgbc.weighty = 1.0;
        settingsgbc.fill = 1;
        settingsPanel.add((Component)scrollCommentList, settingsgbc);
        this.progressBar = new JProgressBar(0, 1);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("");
        ++settingsgbc.gridy;
        settingsgbc.weighty = 0.0;
        settingsgbc.fill = 2;
        settingsPanel.add((Component)this.progressBar, settingsgbc);
        GridBagConstraints maingbc = new GridBagConstraints();
        maingbc.gridx = 0;
        maingbc.weightx = 1.0;
        maingbc.weighty = 1.0;
        maingbc.fill = 1;
        maingbc.insets = new Insets(20, 20, 10, 20);
        this.add((Component)settingsPanel, maingbc);
        JPanel searchClosePanel = new JPanel(new GridBagLayout());
        this.searchButton = new JButton(ElanLocale.getString("CommentSearchDialog.Search"));
        this.searchButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        searchClosePanel.add((Component)this.searchButton, gbc);
        this.closeButton = new JButton(ElanLocale.getString("CommentSearchDialog.Close"));
        this.closeButton.addActionListener(this);
        searchClosePanel.add((Component)this.closeButton, gbc);
        maingbc.weighty = 0.0;
        maingbc.fill = 2;
        maingbc.insets = new Insets(0, 20, 20, 20);
        this.add((Component)searchClosePanel, maingbc);
    }

    private void postInit() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setPreferences();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.searchButton || source == this.searchTextField) {
            String match = this.searchTextField.getText();
            if (!match.isEmpty()) {
                Pattern p;
                boolean caseSensitive = this.caseCheckBox.isSelected();
                int flags = caseSensitive ? 0 : 2;
                try {
                    p = Pattern.compile(match, flags);
                }
                catch (PatternSyntaxException ex) {
                    try {
                        p = Pattern.compile(match, flags | 0x10);
                    }
                    catch (PatternSyntaxException ex2) {
                        p = null;
                    }
                }
                if (p != null) {
                    this.doSearch(p);
                }
            }
        } else if (source == this.columnComboBox) {
            this.searchColumn = this.columnComboBox.getSelectedIndex() - 1;
        } else if (source == this.closeButton) {
            if (this.searchTask != null && !this.searchTask.isDone()) {
                this.searchTask.cancel(false);
            } else {
                this.savePreferences();
                this.dispose();
            }
        }
    }

    private void doSearch(Pattern p) {
        String pref = Preferences.getString("CommentViewer.SearchDirectory.Comments", null);
        String dir = pref != null ? FileUtility.urlToAbsPath(pref) : Constants.USERHOME;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.searchButton.setEnabled(false);
        this.progressBar.setIndeterminate(true);
        this.resultFiles = new ArrayList<String>();
        this.resultFiles = Collections.synchronizedList(this.resultFiles);
        this.tableModelEx.setColumn(this.resultFiles);
        this.searchResults = new ArrayList<CommentEnvelope>();
        this.searchResults = Collections.synchronizedList(this.searchResults);
        this.tableModel.setComments(this.searchResults);
        this.doSearchTask(p, new File(dir));
    }

    private void doSearchTask(final Pattern p, final File dir) {
        this.searchTask = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                CommentSearchDialog.this.doSearch(p, dir);
                return null;
            }

            @Override
            public void done() {
                CommentSearchDialog.this.progressBar.setIndeterminate(false);
                CommentSearchDialog.this.progressBar.setValue(CommentSearchDialog.this.progressBar.getMaximum());
                CommentSearchDialog.this.progressBar.setString(ElanLocale.getString("CommentSearchDialog.Done"));
                CommentSearchDialog.this.setCursor(null);
                CommentSearchDialog.this.searchButton.setEnabled(true);
            }
        };
        this.searchTask.addPropertyChangeListener(this);
        this.searchTask.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("results".equals(propertyName)) {
            List<Object> list = this.resultFiles;
            synchronized (list) {
                this.tableModelEx.setColumn(this.resultFiles);
            }
            list = this.searchResults;
            synchronized (list) {
                this.tableModel.setComments(this.searchResults);
            }
        }
        if ("directory".equals(propertyName)) {
            this.progressBar.setString((String)evt.getNewValue());
        }
    }

    private boolean doSearch(Pattern p, File dir) {
        this.searchTask.firePropertyChange("directory", null, dir.toString());
        if (this.searchTask.isCancelled()) {
            return true;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    if (this.doSearch(p, f)) {
                        return true;
                    }
                    this.searchTask.firePropertyChange("directory", null, dir.toString());
                    continue;
                }
                if (!f.canRead()) continue;
                if (this.searchTask.isCancelled()) {
                    return true;
                }
                String name = f.getName();
                if (!name.endsWith(".eafcomment")) continue;
                this.scanForComment(p, f);
            }
        }
        return false;
    }

    private void scanForComment(Pattern p, File f) {
        final Matcher m = p.matcher("");
        Predicate<CommentEnvelope> filter = this.searchColumn < 0 ? new Predicate<CommentEnvelope>(){

            @Override
            public boolean test(CommentEnvelope ce) {
                int ncols = CommentSearchDialog.this.tableModel.getColumnCount();
                for (int i = 0; i < ncols; ++i) {
                    m.reset(DefaultCommentTableModel.getValueAtColumn(ce, i));
                    if (!m.find()) continue;
                    return true;
                }
                return false;
            }
        } : new Predicate<CommentEnvelope>(){

            @Override
            public boolean test(CommentEnvelope ce) {
                m.reset(DefaultCommentTableModel.getValueAtColumn(ce, CommentSearchDialog.this.searchColumn));
                return m.find();
            }
        };
        String fileName = f.getAbsolutePath();
        List<CommentEnvelope> list = CommentManager.read(fileName, filter);
        if (!list.isEmpty()) {
            fileName = FileUtility.dropExtension(fileName);
            for (int i = list.size(); i > 0; --i) {
                this.resultFiles.add(fileName);
            }
            this.searchResults.addAll(list);
            this.searchTask.firePropertyChange("results", null, null);
        }
    }

    private void activateComment() {
        int index = this.commentTable.getSelectionModel().getLeadSelectionIndex();
        if (index >= 0) {
            index = this.commentTable.convertRowIndexToModel(index);
            CommentEnvelope ce = this.searchResults.get(index);
            Object commentFileName = this.resultFiles.get(index);
            commentFileName = FileUtility.dropExtension((String)commentFileName) + ".eaf";
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.activateComment(ce, (String)commentFileName);
            this.setCursor(null);
        }
    }

    private void activateComment(CommentEnvelope ce, String suggestedFileName) {
        final String searchString = ce.getMessageID();
        Predicate<TranscriptionImpl> pred = new Predicate<TranscriptionImpl>(){

            @Override
            public boolean test(TranscriptionImpl t) {
                Pair<ElanFrame2, Boolean> pair = CommentManager.getOrOpenFrameFor(t);
                ElanFrame2 frame = pair.getFirst();
                boolean opened = pair.getSecond();
                if (frame != null) {
                    CommentManager cm;
                    int index;
                    CommentViewer cv = frame.getViewerManager().getCommentViewer();
                    if (cv != null && (index = (cm = cv.getCommentManager()).findCommentById(searchString)) >= 0) {
                        cv.activateComment(index);
                        cv.showTableRow(index);
                        frame.toFront();
                        return true;
                    }
                    if (opened) {
                        frame.doClose(true);
                    }
                }
                return false;
            }
        };
        URI uri = ce.getAnnotationURIBase();
        File f = new File(suggestedFileName);
        if (f.canRead()) {
            ArrayList<File> candidate = new ArrayList<File>(1);
            candidate.add(f);
            TranscriptionImpl t = CommentManager.findTranscriptionFromURN(uri, pred, candidate);
            if (t != null) {
                return;
            }
        }
        CommentManager.findTranscriptionFromURNwithDialog(uri, pred);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.activateComment();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void setPreferences() {
        this.commentTable.applyPreferences("CommentSearchDlg", null);
    }

    private void savePreferences() {
        this.commentTable.savePreferences("CommentSearchDlg", null);
    }
}

