/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.comments;

import eu.dasish.annotation.schema.Access;
import eu.dasish.annotation.schema.Action;
import eu.dasish.annotation.schema.ActionList;
import eu.dasish.annotation.schema.Annotation;
import eu.dasish.annotation.schema.AnnotationBody;
import eu.dasish.annotation.schema.AnnotationInfo;
import eu.dasish.annotation.schema.AnnotationInfoList;
import eu.dasish.annotation.schema.CachedRepresentationInfo;
import eu.dasish.annotation.schema.ObjectFactory;
import eu.dasish.annotation.schema.Permission;
import eu.dasish.annotation.schema.PermissionList;
import eu.dasish.annotation.schema.Principal;
import eu.dasish.annotation.schema.ReferenceList;
import eu.dasish.annotation.schema.ResponseBody;
import eu.dasish.annotation.schema.TargetInfo;
import eu.dasish.annotation.schema.TargetInfoList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.net.ssl.SSLException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.ParserConfigurationException;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.comments.CommentEnvelope;
import mpi.eudico.client.annotator.comments.CommentManager;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Element;

public class CommentWebClient {
    static final boolean DEBUG = false;
    private static final boolean CREATE_CACHED_REPRESENTATION = false;
    private static final boolean ALWAYS_CREATE_CACHED_REPRESENTATION = false;
    private JAXBContext jc;
    private Unmarshaller unmarshaller;
    URI serviceURL;
    URI serviceURL_api_annotations;
    URI resolveBaseURL;
    private String serviceUrlPath;
    private CloseableHttpClient httpclient;
    private Marshaller marshaller;
    private Map<String, String> urnToTargetURL = new HashMap<String, String>();
    private HttpClientContext context;
    private CookieStore cookieStore;
    private String userName;
    private String loggedInPincipalURIString;
    private boolean isLoggedIn;
    private ObjectFactory objectFactory;
    private DatatypeFactory datatypeFactory;
    private StatusLine lastStatusLine;
    private TranscriptionImpl transcription;
    static final int HTTP_OK = 200;
    static final int HTTP_CLIENT_ERROR = 400;
    static final int HTTP_UNAUTHORIZED = 401;
    static final int HTTP_FORBIDDEN = 403;
    static final int HTTP_NOT_FOUND = 404;
    private static final String TEMP_TARGET_REF = "__TEMP_TARGET_REF__";
    private static final String TEMP_ANNOTATION_REF = "__TEMP_ANNOTATION_REF__";
    static final String crlf = "\r\n";
    static final String boundary = CommentWebClient.generateBoundary();
    static final String boundary_line = "--" + boundary + "\r\n";
    static final String boundary_end = "--" + boundary + "--\r\n\r\n";
    static final String latin1 = "ISO-8859-1";

    public static CommentWebClient getCommentWebClient(TranscriptionImpl t) {
        return new CommentWebClient(t);
    }

    private CommentWebClient(TranscriptionImpl t) {
        this.transcription = t;
        try {
            this.jc = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            this.unmarshaller = this.jc.createUnmarshaller();
            this.marshaller = this.jc.createMarshaller();
            this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            this.marshaller.setProperty("jaxb.schemaLocation", (Object)"http://lux17.mpi.nl/ds/webannotator-basic/SCHEMA/DASISH-schema.xsd");
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        this.objectFactory = new ObjectFactory();
        try {
            this.datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        this.cookieStore = new BasicCookieStore();
        this.httpclient = HttpClients.custom().setDefaultCookieStore(this.cookieStore).build();
        this.context = HttpClientContext.create();
        this.isLoggedIn = false;
    }

    public void logout() {
        this.loggedInPincipalURIString = "";
        this.cookieStore.clear();
        this.isLoggedIn = false;
    }

    public void close() {
        this.logout();
        try {
            this.httpclient.close();
            this.httpclient = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean login(String serviceURL, String user) {
        if (!((String)serviceURL).endsWith("/")) {
            serviceURL = (String)serviceURL + "/";
        }
        try {
            this.resolveBaseURL = this.serviceURL = new URI((String)serviceURL);
        }
        catch (URISyntaxException e) {
            ClientLogger.LOG.severe("Service URL is bad: URISyntaxException");
            return false;
        }
        try {
            this.marshaller.setProperty("jaxb.schemaLocation", (Object)(this.resolveBaseURL + "SCHEMA/DASISH-schema.xsd"));
        }
        catch (PropertyException e) {
            e.printStackTrace();
        }
        this.userName = user;
        this.serviceURL_api_annotations = this.serviceURL.resolve("api/annotations");
        this.serviceUrlPath = this.serviceURL.getPath() + "api/";
        return this.reLogin();
    }

    public boolean reLogin() {
        boolean success = false;
        while (!success) {
            char[] password = this.getPassword(this.serviceURL, this.userName);
            if (password == null) {
                ClientLogger.LOG.warning("password == null, user probably hit CANCEL in getPassword() dialog");
                return false;
            }
            success = this.reLogin(this.userName, password);
            if (success) continue;
            ClientLogger.LOG.severe("reLogin(userName, password) failed; password is probably incorrect");
        }
        return success;
    }

    private char[] getPassword(URI serviceURL, String username) {
        String prompt = String.format(ElanLocale.getString("CommentViewer.EnterPassword"), username);
        JPanel panel = new JPanel();
        JLabel label = new JLabel(prompt);
        JPasswordField pass = new JPasswordField(16);
        panel.add(label);
        panel.add(pass);
        Object[] options = new String[]{ElanLocale.getString("Button.OK"), ElanLocale.getString("Button.Cancel")};
        int option = JOptionPane.showOptionDialog(null, panel, serviceURL.toString(), 1, -1, null, options, options[0]);
        if (option == 0) {
            return pass.getPassword();
        }
        return null;
    }

    public boolean reLogin(String user, char[] password) {
        boolean loggedIn = this.loginByPOST("api/authentication/login", user, new String(password));
        this.isLoggedIn = loggedIn = loggedIn && this.getPrincipalURI();
        return loggedIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loginByPOST(String loginPage, String user, String password) {
        URI startPage = this.serviceURL.resolve(loginPage);
        URI redirectedPage = null;
        String postToPage = "j_spring_security_check";
        boolean loggedIn = true;
        try {
            HttpGet httpget = new HttpGet(startPage);
            try (CloseableHttpResponse response1 = this.httpclient.execute((HttpUriRequest)httpget, (HttpContext)this.context);){
                HttpEntity entity = response1.getEntity();
                EntityUtils.consume((HttpEntity)entity);
                if (response1.getStatusLine().getStatusCode() >= 400) {
                    this.warnAboutLoginProblem(response1.getStatusLine().toString());
                    boolean bl = false;
                    return bl;
                }
                HttpHost target = this.context.getTargetHost();
                List redirectLocations = this.context.getRedirectLocations();
                redirectedPage = URIUtils.resolve((URI)httpget.getURI(), (HttpHost)target, (List)redirectLocations);
            }
            redirectedPage = this.serviceURL.resolve(postToPage);
            HttpUriRequest login = RequestBuilder.post().setUri(redirectedPage).addParameter("username", user).addParameter("password", password).addParameter("submit", "submit").build();
            try (CloseableHttpResponse response2 = this.httpclient.execute(login, (HttpContext)this.context);){
                HttpEntity entity = response2.getEntity();
                EntityUtils.consume((HttpEntity)entity);
                if (response2.getStatusLine().getStatusCode() < 400) return loggedIn;
                this.warnAboutLoginProblem(response1.getStatusLine().toString());
                loggedIn = false;
                return loggedIn;
            }
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            return false;
        }
        catch (SSLException sslex) {
            ClientLogger.LOG.severe("Logging in; got SSLException. Is 'sunjce_provider.jar' necessary?");
            sslex.printStackTrace();
            return loggedIn;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isLoggedIn() {
        return this.isLoggedIn;
    }

    public <T> T unmarshal(InputStream inputStream) throws JAXBException {
        JAXBElement doc = (JAXBElement)this.unmarshaller.unmarshal(inputStream);
        return (T)doc.getValue();
    }

    public <T> void marshal(JAXBElement<T> document, OutputStream os) throws JAXBException {
        this.marshaller.marshal(document, os);
    }

    public void doDELETE(URI uri) {
        try {
            HttpDelete req = new HttpDelete(uri);
            CloseableHttpResponse res = this.httpclient.execute((HttpUriRequest)req, (HttpContext)this.context);
            this.lastStatusLine = res.getStatusLine();
            boolean shouldWarn = false;
            if (this.lastStatusLine.getStatusCode() == 401) {
                this.isLoggedIn = false;
                shouldWarn = true;
            } else if (this.lastStatusLine.getStatusCode() == 403) {
                this.warnAboutForbidden(ElanLocale.getString("CommentViewer.WarnAboutForbiddenDelete"));
            } else if (this.lastStatusLine.getStatusCode() >= 400) {
                shouldWarn = true;
            }
            EntityUtils.consume((HttpEntity)res.getEntity());
            if (shouldWarn) {
                this.warnAboutServerResponse(ElanLocale.getString("CommentViewer.WarnAboutSR.Removing"), this.lastStatusLine.toString());
            }
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RES> RES doGET(URI uri) {
        block23: {
            RES RES;
            CloseableHttpResponse res = null;
            try {
                HttpGet req = new HttpGet(uri);
                res = this.httpclient.execute((HttpUriRequest)req, (HttpContext)this.context);
                RES result = null;
                this.lastStatusLine = res.getStatusLine();
                if (this.lastStatusLine.getStatusCode() < 400) {
                    InputStream inputStream = res.getEntity().getContent();
                    result = (RES)this.unmarshal(inputStream);
                } else {
                    if (this.lastStatusLine.getStatusCode() == 401) {
                        this.isLoggedIn = false;
                    }
                    this.warnAboutServerResponse(ElanLocale.getString("CommentViewer.WarnAboutSR.Getting"), this.lastStatusLine.toString());
                }
                RES = result;
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
                break block23;
            }
            catch (IOException e) {
                e.printStackTrace();
                break block23;
            }
            catch (JAXBException e) {
                e.printStackTrace();
                break block23;
            }
            finally {
                try {
                    if (res != null) {
                        EntityUtils.consume((HttpEntity)res.getEntity());
                    }
                }
                catch (IOException e) {}
            }
            return RES;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RES> RES doPOSTorPUTwithResult(HttpEntityEnclosingRequestBase req, HttpEntity reqEntity) {
        block27: {
            RES RES;
            CloseableHttpResponse res = null;
            try {
                req.setEntity(reqEntity);
                res = this.httpclient.execute((HttpUriRequest)req, (HttpContext)this.context);
                RES object = null;
                this.lastStatusLine = res.getStatusLine();
                boolean shouldWarn = false;
                if (this.lastStatusLine.getStatusCode() < 400) {
                    InputStream inputStream = res.getEntity().getContent();
                    object = (RES)this.unmarshal(inputStream);
                } else if (this.lastStatusLine.getStatusCode() == 401) {
                    this.isLoggedIn = false;
                    shouldWarn = true;
                } else if (this.lastStatusLine.getStatusCode() == 403) {
                    this.warnAboutForbidden(ElanLocale.getString("CommentViewer.WarnAboutForbiddenModify"));
                } else {
                    shouldWarn = true;
                }
                if (shouldWarn) {
                    this.warnAboutServerResponse(ElanLocale.getString("CommentViewer.WarnAboutSR.Putting"), this.lastStatusLine.toString());
                }
                RES = object;
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
                break block27;
            }
            catch (IOException e) {
                e.printStackTrace();
                break block27;
            }
            catch (JAXBException e) {
                e.printStackTrace();
                break block27;
            }
            finally {
                try {
                    if (res != null) {
                        EntityUtils.consume((HttpEntity)res.getEntity());
                    }
                }
                catch (IOException e) {}
            }
            return RES;
        }
        return null;
    }

    public <RES> RES doPOSTorPUTwithResult(HttpEntityEnclosingRequestBase req, String textPlain) {
        StringEntity reqEntity = new StringEntity(textPlain, ContentType.TEXT_PLAIN);
        return this.doPOSTorPUTwithResult(req, (HttpEntity)reqEntity);
    }

    public <ARG, RES> RES doPOSTorPUTwithResult(HttpEntityEnclosingRequestBase req, final JAXBElement<ARG> je) {
        ContentProducer producer = new ContentProducer(){

            public void writeTo(OutputStream outstream) throws IOException {
                try {
                    CommentWebClient.this.marshal(je, outstream);
                }
                catch (JAXBException e) {
                    e.printStackTrace();
                }
            }
        };
        EntityTemplate reqEntity = new EntityTemplate(producer);
        reqEntity.setContentType(ContentType.APPLICATION_XML.getMimeType());
        return this.doPOSTorPUTwithResult(req, (HttpEntity)reqEntity);
    }

    private <ARG, RES> RES doPOSTorPUTwithResult_OLD(HttpEntityEnclosingRequestBase req, JAXBElement<ARG> je) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.marshal(je, output);
            byte[] bytes = output.toByteArray();
            try {
                output.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            output = null;
            InputStreamEntity reqEntity = new InputStreamEntity((InputStream)new ByteArrayInputStream(bytes), (long)bytes.length, ContentType.APPLICATION_XML);
            bytes = null;
            return this.doPOSTorPUTwithResult(req, (HttpEntity)reqEntity);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <ARG, RES> RES doPOST(URI uri, JAXBElement<ARG> je) {
        HttpPost req = new HttpPost(uri);
        return this.doPOSTorPUTwithResult((HttpEntityEnclosingRequestBase)req, je);
    }

    public <ARG, RES> RES doPUT(URI uri, JAXBElement<ARG> je) {
        HttpPut req = new HttpPut(uri);
        return this.doPOSTorPUTwithResult((HttpEntityEnclosingRequestBase)req, je);
    }

    public <RES> RES doPUT(URI uri, String textPlain) {
        HttpPut req = new HttpPut(uri);
        return this.doPOSTorPUTwithResult((HttpEntityEnclosingRequestBase)req, textPlain);
    }

    public void warnAboutForbidden(String action) {
        String fmt = ElanLocale.getString("CommentViewer.WarnAboutForbidden");
        String msg = String.format(fmt, action);
        JOptionPane.showMessageDialog(null, msg, ElanLocale.getString("Message.Warning"), 0);
    }

    public void warnAboutServerResponse(String process, String message) {
        String fmt = ElanLocale.getString("CommentViewer.WarnAboutServerResponse");
        String msg = String.format(fmt, process) + message;
        ClientLogger.LOG.severe(msg);
        JOptionPane.showMessageDialog(null, msg, ElanLocale.getString("Message.Error"), 0);
    }

    public void warnAboutLoginProblem(String message) {
        this.warnAboutServerResponse(ElanLocale.getString("CommentViewer.WarnAboutSR.Login"), message);
    }

    private boolean getPrincipalURI() {
        URI uri = this.serviceURL.resolve("api/authentication/principal");
        Principal p = (Principal)this.doGET(uri);
        this.loggedInPincipalURIString = p != null ? p.getHref() : "";
        return !this.loggedInPincipalURIString.isEmpty();
    }

    public AnnotationInfoList getAnnotationInfoList(URI uri) {
        try {
            URIBuilder ub = new URIBuilder(this.serviceURL.toString() + "api/annotations");
            ub.addParameter("access", "read");
            ub.addParameter("link", uri.toString());
            ub.addParameter("matchMode", "exact");
            AnnotationInfoList ail = (AnnotationInfoList)this.doGET(ub.build());
            if (ail != null) {
                return ail;
            }
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    public Annotation getAnnotation(URI uri) {
        Annotation a = (Annotation)this.doGET(uri);
        return a;
    }

    private boolean isReadOnly(Annotation ann) {
        PermissionList pl = ann.getPermissions();
        Access ac = pl.getPublic();
        if (ac.value().equals("write")) {
            return false;
        }
        for (Permission p : pl.getPermission()) {
            if (!p.getPrincipalHref().equals(this.loggedInPincipalURIString)) continue;
            return !p.getLevel().value().equals("write");
        }
        return true;
    }

    private List<CommentEnvelope> getCommentEnvelopes(AnnotationInfoList ail, URI urn) {
        ArrayList<CommentEnvelope> lce = new ArrayList<CommentEnvelope>();
        String targetURI = null;
        HashSet<String> fetchedIDs = new HashSet<String>();
        for (AnnotationInfo ai : ail.getAnnotationInfo()) {
            Element e;
            CommentEnvelope ce;
            String id;
            AnnotationBody.XmlBody xb;
            AnnotationBody body;
            URI annoref;
            Annotation a;
            String firstTarget = this.getFirstTarget(ai);
            if (targetURI == null) {
                targetURI = firstTarget;
            } else if (!targetURI.equals(firstTarget)) {
                // empty if block
            }
            if ((a = this.getAnnotation(annoref = this.resolveBaseURL.resolve(ai.getHref()))) == null || (body = a.getBody()) == null || (xb = body.getXmlBody()) == null || fetchedIDs.contains(id = (ce = new CommentEnvelope(e = xb.getAny())).getMessageID())) continue;
            ce.setMessageURL(a.getHref());
            ce.setAnnotationFileURL(firstTarget);
            ce.setLastModifiedOnServer(a.getLastModified());
            ce.setReadOnly(this.isReadOnly(a));
            lce.add(ce);
            fetchedIDs.add(id);
        }
        if (targetURI != null) {
            this.urnToTargetURL.put(urn.toString(), targetURI);
        }
        return lce;
    }

    public List<CommentEnvelope> getCommentEnvelopes(URI urn, List<CommentEnvelope> existing, List<CommentEnvelope> hadThemAlready) {
        AnnotationInfoList ail = this.getAnnotationInfoList(urn);
        if (ail == null) {
            return null;
        }
        List lai = ail.getAnnotationInfo();
        if (lai == null || lai.isEmpty()) {
            return Collections.emptyList();
        }
        if (existing != null && !existing.isEmpty() && hadThemAlready != null) {
            HashMap<String, CommentEnvelope> map = new HashMap<String, CommentEnvelope>();
            for (CommentEnvelope ce : existing) {
                map.put(ce.getMessageURL(), ce);
            }
            Iterator iter = lai.iterator();
            while (iter.hasNext()) {
                XMLGregorianCalendar date;
                AnnotationInfo ai = (AnnotationInfo)iter.next();
                CommentEnvelope ce = (CommentEnvelope)map.get(ai.getHref());
                if (ce == null || (date = ce.getLastModifiedOnServer()) == null || !date.equals(ai.getLastModified())) continue;
                hadThemAlready.add(ce);
                iter.remove();
            }
        }
        List<CommentEnvelope> fetched = this.getCommentEnvelopes(ail, urn);
        return fetched;
    }

    private String getFirstTarget(AnnotationInfo ai) {
        ReferenceList list = ai.getTargets();
        List list2 = list.getHref();
        if (list2 != null && list2.size() >= 1) {
            return (String)list2.get(0);
        }
        return "";
    }

    private String getFirstTarget(Annotation replyA) {
        List lti;
        TargetInfoList replyTIL = replyA.getTargets();
        if (replyTIL != null && (lti = replyTIL.getTargetInfo()) != null && !lti.isEmpty()) {
            TargetInfo ti2 = (TargetInfo)lti.get(0);
            String ref = ti2.getHref();
            return ref;
        }
        return null;
    }

    private boolean annotationURLIsKnown(CommentEnvelope ce) {
        String ceURL = ce.getMessageURL();
        if (ceURL.startsWith("http")) {
            if (!ceURL.startsWith(this.serviceURL + "api/")) {
                return false;
            }
        } else {
            if (this.serviceURL == null || !this.serviceURL.isAbsolute()) {
                return false;
            }
            if (!ceURL.startsWith(this.serviceUrlPath)) {
                return false;
            }
        }
        return true;
    }

    public URI resolveEnvelopeURL(CommentEnvelope ce, String extra) {
        if (!this.annotationURLIsKnown(ce)) {
            return null;
        }
        try {
            URI uri = this.resolveBaseURL.resolve(ce.getMessageURL() + extra);
            return uri;
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    private static String lastPathPart(String url) {
        int slashPos = url.lastIndexOf(47);
        if (slashPos > 0) {
            return url.substring(slashPos + 1);
        }
        return url;
    }

    private Annotation createAnnotation(CommentEnvelope ce, AnnPostParams h) {
        Element e;
        CommentEnvelope cloneCE = ce.clone();
        h.sourceURL = ce.getAnnotationURIBase().toString();
        h.targetURL = this.urnToTargetURL.get(h.sourceURL);
        h.annotationURLIsKnown = this.annotationURLIsKnown(ce);
        boolean bl = h.targetIsKnown = h.targetURL != null && !h.targetURL.isEmpty();
        if (!h.annotationURLIsKnown) {
            cloneCE.setMessageURL(TEMP_ANNOTATION_REF);
        }
        if (!h.targetIsKnown) {
            cloneCE.setAnnotationFileURL(TEMP_TARGET_REF);
            h.targetURL = TEMP_TARGET_REF;
        } else {
            ce.setAnnotationFileURL(h.targetURL);
            cloneCE.setAnnotationFileURL(h.targetURL);
        }
        try {
            e = CommentManager.getElement(cloneCE);
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
            return null;
        }
        TargetInfo ti = new TargetInfo();
        ti.setHref(h.targetURL);
        ti.setLink(h.sourceURL);
        ti.setVersion("");
        Annotation a = new Annotation();
        a.setOwnerHref(this.loggedInPincipalURIString);
        a.setHref(cloneCE.getMessageURL());
        a.setId(CommentWebClient.lastPathPart(cloneCE.getMessageURL()));
        AnnotationBody aB = new AnnotationBody();
        AnnotationBody.XmlBody xB = new AnnotationBody.XmlBody();
        xB.setMimeType("text/xml");
        xB.setAny(e);
        aB.setXmlBody(xB);
        a.setBody(aB);
        String headline = cloneCE.getMessage();
        headline = headline.substring(0, Math.min(40, headline.length()));
        a.setHeadline(headline);
        a.setLastModified(this.datatypeFactory.newXMLGregorianCalendar(cloneCE.getCreationDateString()));
        TargetInfoList til = new TargetInfoList();
        til.getTargetInfo().add(ti);
        a.setTargets(til);
        PermissionList pl = new PermissionList();
        pl.setPublic(Access.READ);
        Permission p = new Permission();
        p.setPrincipalHref(this.loggedInPincipalURIString);
        p.setLevel(Access.WRITE);
        pl.getPermission().add(p);
        a.setPermissions(pl);
        return a;
    }

    private ResponseBody process(CommentEnvelope ce, ResponseBody rb) {
        if (rb != null) {
            Annotation replyA = rb.getAnnotation();
            if (replyA != null) {
                ce.setLastModifiedOnServer(replyA.getLastModified());
            }
        } else if (this.lastStatusLine.getStatusCode() == 404) {
            ce.setMessageURL("");
            return this.putCommentEnvelope(ce);
        }
        return rb;
    }

    private ResponseBody putAnnotation(CommentEnvelope ce, Annotation a, AnnPostParams h) {
        URI uri = this.resolveEnvelopeURL(ce, "");
        if (uri == null) {
            return null;
        }
        JAXBElement ja = this.objectFactory.createAnnotation(a);
        ResponseBody rb = (ResponseBody)this.doPUT(uri, ja);
        return this.process(ce, rb);
    }

    private ResponseBody putBody(CommentEnvelope ce, Annotation a, AnnPostParams h) {
        URI uri = this.resolveEnvelopeURL(ce, "/body");
        if (uri == null) {
            return null;
        }
        AnnotationBody aB = a.getBody();
        JAXBElement ja = this.objectFactory.createAnnotationBody(aB);
        ResponseBody rb = (ResponseBody)this.doPUT(uri, ja);
        return this.process(ce, rb);
    }

    private ResponseBody putHeadline(CommentEnvelope ce, String headline, AnnPostParams h) {
        URI uri = this.resolveEnvelopeURL(ce, "/headline");
        if (uri == null) {
            return null;
        }
        ResponseBody rb = (ResponseBody)this.doPUT(uri, headline);
        return this.process(ce, rb);
    }

    private ResponseBody putBodyAndHeadline(CommentEnvelope ce, Annotation a, AnnPostParams h) {
        Annotation replyA;
        String headline;
        ResponseBody rb = this.putBody(ce, a, h);
        if (rb != null && !(headline = a.getHeadline()).equals((replyA = rb.getAnnotation()).getHeadline())) {
            rb = this.putHeadline(ce, headline, h);
        }
        return rb;
    }

    private ResponseBody postAnnotation(CommentEnvelope ce, Annotation a, AnnPostParams h) {
        Annotation replyA;
        JAXBElement ja = this.objectFactory.createAnnotation(a);
        ResponseBody rb = (ResponseBody)this.doPOST(this.serviceURL_api_annotations, ja);
        if (rb != null && (replyA = rb.getAnnotation()) != null) {
            String replyTarget;
            ce.setMessageURL(replyA.getHref());
            ce.setLastModifiedOnServer(replyA.getLastModified());
            if (!h.targetIsKnown && (replyTarget = this.getFirstTarget(replyA)) != null) {
                this.urnToTargetURL.put(h.sourceURL, replyTarget);
                ce.setAnnotationFileURL(replyTarget);
            }
        }
        return rb;
    }

    public ResponseBody putCommentEnvelope(CommentEnvelope ce) {
        if (ce.isReadOnly()) {
            ClientLogger.LOG.warning("Cannot putCommentEnvelope: it is READ ONLY");
            ce.setToBeSavedToServer(false);
            return null;
        }
        AnnPostParams h = new AnnPostParams();
        Annotation a = this.createAnnotation(ce, h);
        ResponseBody rb = null;
        rb = h.annotationURLIsKnown ? this.putBodyAndHeadline(ce, a, h) : this.postAnnotation(ce, a, h);
        if (rb != null) {
            ce.setToBeSavedToServer(false);
            this.checkActionList(ce, rb);
        }
        return rb;
    }

    private void checkActionList(CommentEnvelope ce, ResponseBody rb) {
        ActionList actionList = rb.getActionList();
        if (actionList.getAction() != null) {
            for (Action action : actionList.getAction()) {
            }
        }
    }

    private void createCachedRepresentation(CommentEnvelope ce, String object) {
        String encFrag;
        URI targetURI = this.resolveBaseURL.resolve(object + "/");
        String frag = ce.getFragment();
        if (!frag.equals(encFrag = CommentEnvelope.fragmentEncode(frag))) {
            encFrag = CommentEnvelope.fragmentEncode(encFrag);
            encFrag = CommentEnvelope.fragmentEncode(encFrag);
        }
        URI cachedRepresentationURI = targetURI.resolve("fragment/" + encFrag + "/cached");
        this.createCachedRepresentation(ce, cachedRepresentationURI);
    }

    private void createCachedRepresentation(CommentEnvelope ce, URI cachedRepresentationURI) {
        CachedRepresentationInfo cri = new CachedRepresentationInfo();
        cri.setMimeType("application/xml");
        cri.setTool("ELAN");
        cri.setType("EAF");
        cri.setHref(ce.getAnnotationFileURL());
        cri.setId(CommentWebClient.lastPathPart(ce.getAnnotationFileURL()));
        JAXBElement jcri = this.objectFactory.createCachedRepresentationInfo(cri);
        HttpEntity entity = this.createMultipartEntity(jcri, new File(this.transcription.getPathName()));
        HttpPost req = new HttpPost(cachedRepresentationURI);
        System.out.println("POST: " + cachedRepresentationURI.toASCIIString());
        this.doPOSTorPUTwithResult((HttpEntityEnclosingRequestBase)req, entity);
    }

    private HttpEntity createMultipartEntity(final JAXBElement<?> part1, final File part2) {
        ContentProducer producer = new ContentProducer(){

            public void writeTo(OutputStream outstream) throws IOException {
                byte[] crlf_b = CommentWebClient.crlf.getBytes(CommentWebClient.latin1);
                byte[] boundary_b = boundary_line.getBytes(CommentWebClient.latin1);
                try {
                    int len;
                    outstream.write(boundary_b);
                    outstream.write("Content-Type: application/xml".getBytes(CommentWebClient.latin1));
                    outstream.write(crlf_b);
                    outstream.write(crlf_b);
                    CommentWebClient.this.marshal(part1, outstream);
                    outstream.write(crlf_b);
                    outstream.write(boundary_b);
                    outstream.write("Content-Type: application/octet-stream".getBytes(CommentWebClient.latin1));
                    outstream.write(crlf_b);
                    outstream.write(crlf_b);
                    FileInputStream in = new FileInputStream(part2);
                    byte[] buffer = new byte[4096];
                    while ((len = in.read(buffer)) != -1) {
                        outstream.write(buffer, 0, len);
                    }
                    in.close();
                    buffer = null;
                    outstream.write(crlf_b);
                    outstream.write(boundary_end.getBytes(CommentWebClient.latin1));
                }
                catch (JAXBException e) {
                    e.printStackTrace();
                }
            }
        };
        EntityTemplate reqEntity = new EntityTemplate(producer);
        reqEntity.setContentType("multipart/mixed; boundary=\"" + boundary + "\"");
        return reqEntity;
    }

    private static String generateBoundary() {
        char[] MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        StringBuilder buffer = new StringBuilder();
        Random rand = new Random();
        int count = rand.nextInt(11) + 30;
        for (int i = 0; i < count; ++i) {
            buffer.append(MULTIPART_CHARS[rand.nextInt(MULTIPART_CHARS.length)]);
        }
        return buffer.toString();
    }

    public void deleteCommentEnvelope(CommentEnvelope ce) {
        if (ce.isReadOnly()) {
            ClientLogger.LOG.warning("Cannot deleteCommentEnvelope: it is READ ONLY");
            ce.setToBeSavedToServer(false);
            return;
        }
        URI uri = this.resolveEnvelopeURL(ce, "");
        if (uri != null) {
            this.doDELETE(uri);
        } else {
            ClientLogger.LOG.warning("Can't DELETE (URL unknown/out of date) id " + ce.getMessageID());
        }
    }

    private <T> T unmarshal(Class<T> docClass, InputStream inputStream) throws JAXBException {
        String packageName = docClass.getPackage().getName();
        JAXBContext jc = JAXBContext.newInstance((String)packageName);
        Unmarshaller u = jc.createUnmarshaller();
        JAXBElement doc = (JAXBElement)u.unmarshal(inputStream);
        return (T)doc.getValue();
    }

    private static class AnnPostParams {
        String sourceURL;
        String targetURL;
        boolean annotationURLIsKnown;
        boolean targetIsKnown;

        private AnnPostParams() {
        }
    }
}

