/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.comments;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.server.corpora.clom.Transcription;
import nl.mpi.util.FileUtility;

public class CommentsSettingsDialog
extends ClosableDialog
implements ActionListener {
    private static final String NONE = "-";
    private String sharedDirectoryLocation = null;
    private Boolean useSharedDirectory = false;
    private String searchCommentsDirectory = null;
    private String searchEAFDirectory = null;
    private String threadID;
    private String senderEmailAddress;
    private String recipientEmailAddress;
    private String initials;
    private String serverURL;
    private String serverLoginName;
    private DirPanel sharedDirPanel;
    private JCheckBox useSharedDirBox;
    private DirPanel searchEAFPanel;
    private DirPanel searchCommentsPanel;
    private Transcription transcription;
    private JLabel senderLabel;
    private JTextField senderTextField;
    private JLabel recipientLabel;
    private JTextField recipientTextField;
    private JLabel initialsLabel;
    private JTextField initialsTextField;
    private JLabel threadIdLabel;
    private JTextField threadIdTextField;
    private JLabel serverURLLabel;
    private JTextField serverURLTextField;
    private JLabel serverLoginNameLabel;
    private JTextField serverLoginNameTextField;
    private JLabel updatetimeLabel;
    private JSlider updatetimeSlider;
    private int updatetimeValue = 10;
    private JButton applyButton;
    private JButton cancelButton;

    public CommentsSettingsDialog(Transcription transcription) {
        super((Frame)null, true);
        this.transcription = transcription;
        this.readPrefs();
        this.initComponents();
        this.postInit();
    }

    private void initComponents() {
        String title = ElanLocale.getString("CommentSettingsDialog.Title");
        this.setTitle(title);
        this.setLayout(new GridBagLayout());
        GridBagConstraints maingbc = new GridBagConstraints();
        maingbc.gridx = 0;
        maingbc.weightx = 1.0;
        maingbc.fill = 2;
        maingbc.insets = new Insets(20, 10, 20, 20);
        JPanel settingsPanel = new JPanel(new GridBagLayout());
        settingsPanel.setBorder(BorderFactory.createTitledBorder(title));
        GridBagConstraints settingsgbc = new GridBagConstraints();
        settingsgbc.insets = new Insets(10, 10, 0, 10);
        settingsgbc.fill = 2;
        settingsgbc.weightx = 1.0;
        settingsgbc.gridx = 0;
        settingsgbc.gridy = 0;
        this.sharedDirPanel = new DirPanel(ElanLocale.getString("CommentSettingsDialog.Sharedir.DefaultLoc"), this.sharedDirectoryLocation);
        settingsPanel.add((Component)this.sharedDirPanel, settingsgbc);
        this.useSharedDirBox = new JCheckBox(ElanLocale.getString("CommentSettingsDialog.Sharedir.UseShared"));
        this.useSharedDirBox.setSelected(this.useSharedDirectory);
        this.sharedDirectoryChanged(this.sharedDirectoryLocation);
        ++settingsgbc.gridy;
        settingsPanel.add((Component)this.useSharedDirBox, settingsgbc);
        ++settingsgbc.gridy;
        this.searchCommentsPanel = new DirPanel(ElanLocale.getString("CommentSettingsDialog.SearchComments.DefaultLoc"), this.searchCommentsDirectory);
        settingsPanel.add((Component)this.searchCommentsPanel, settingsgbc);
        ++settingsgbc.gridy;
        this.searchEAFPanel = new DirPanel(ElanLocale.getString("CommentSettingsDialog.SearchEAF.DefaultLoc"), this.searchEAFDirectory);
        settingsPanel.add((Component)this.searchEAFPanel, settingsgbc);
        JPanel commentValuesPanel = new JPanel(new GridBagLayout());
        commentValuesPanel.setBorder(BorderFactory.createTitledBorder(ElanLocale.getString("CommentSettingsDialog.DefaultFieldValues")));
        this.senderLabel = new JLabel(ElanLocale.getString("CommentSettingsDialog.Sender"));
        this.senderTextField = new JTextField(this.senderEmailAddress);
        this.recipientLabel = new JLabel(ElanLocale.getString("CommentSettingsDialog.Recipient"));
        this.recipientTextField = new JTextField(this.recipientEmailAddress);
        this.initialsLabel = new JLabel(ElanLocale.getString("CommentSettingsDialog.Initials"));
        this.initialsTextField = new JTextField(this.initials);
        this.threadIdLabel = new JLabel(ElanLocale.getString("CommentSettingsDialog.ThreadID"));
        this.threadIdTextField = new JTextField(this.threadID);
        this.serverURLLabel = new JLabel(ElanLocale.getString("CommentSettingsDialog.ServiceURL"));
        this.serverURLTextField = new JTextField(this.serverURL);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.gridx = 0;
        gbc.gridy = 0;
        commentValuesPanel.add((Component)this.senderLabel, gbc);
        ++gbc.gridy;
        commentValuesPanel.add((Component)this.recipientLabel, gbc);
        ++gbc.gridy;
        commentValuesPanel.add((Component)this.initialsLabel, gbc);
        ++gbc.gridy;
        commentValuesPanel.add((Component)this.threadIdLabel, gbc);
        ++gbc.gridx;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        commentValuesPanel.add((Component)this.senderTextField, gbc);
        ++gbc.gridy;
        commentValuesPanel.add((Component)this.recipientTextField, gbc);
        ++gbc.gridy;
        commentValuesPanel.add((Component)this.initialsTextField, gbc);
        ++gbc.gridy;
        commentValuesPanel.add((Component)this.threadIdTextField, gbc);
        ++settingsgbc.gridy;
        settingsPanel.add((Component)commentValuesPanel, settingsgbc);
        JPanel serverValuesPanel = new JPanel(new GridBagLayout());
        serverValuesPanel.setBorder(BorderFactory.createTitledBorder(ElanLocale.getString("CommentSettingsDialog.StoredComments")));
        this.serverLoginNameLabel = new JLabel(ElanLocale.getString("CommentSettingsDialog.ServerLoginName"));
        this.serverLoginNameTextField = new JTextField(this.serverLoginName);
        this.updatetimeLabel = new JLabel(ElanLocale.getString("CommentSettingsDialog.UpdateTime"));
        this.updatetimeSlider = new JSlider(2, 60, this.updatetimeValue);
        this.updatetimeSlider.setMajorTickSpacing(10);
        this.updatetimeSlider.setMinorTickSpacing(2);
        this.updatetimeSlider.setPaintTicks(true);
        this.updatetimeSlider.setPaintLabels(true);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        serverValuesPanel.add((Component)this.serverURLLabel, gbc);
        ++gbc.gridy;
        serverValuesPanel.add((Component)this.serverLoginNameLabel, gbc);
        ++gbc.gridy;
        serverValuesPanel.add((Component)this.updatetimeLabel, gbc);
        ++gbc.gridx;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        serverValuesPanel.add((Component)this.serverURLTextField, gbc);
        ++gbc.gridy;
        serverValuesPanel.add((Component)this.serverLoginNameTextField, gbc);
        ++gbc.gridy;
        serverValuesPanel.add((Component)this.updatetimeSlider, gbc);
        ++settingsgbc.gridy;
        settingsPanel.add((Component)serverValuesPanel, settingsgbc);
        this.add((Component)settingsPanel, maingbc);
        JPanel okCancelPanel = new JPanel(new GridBagLayout());
        this.applyButton = new JButton(ElanLocale.getString("CommentSettingsDialog.Apply"));
        this.applyButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        okCancelPanel.add((Component)this.applyButton, gbc);
        this.cancelButton = new JButton(ElanLocale.getString("CommentSettingsDialog.Cancel"));
        this.cancelButton.addActionListener(this);
        okCancelPanel.add((Component)this.cancelButton, gbc);
        maingbc.insets = new Insets(0, 10, 20, 20);
        this.add((Component)okCancelPanel, maingbc);
    }

    private void postInit() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.applyButton) {
            this.savePrefs();
            this.dispose();
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }

    public void sharedDirectoryChanged(String value) {
        if (value != null && !value.isEmpty()) {
            this.useSharedDirBox.setEnabled(true);
        } else {
            this.useSharedDirectory = false;
            this.useSharedDirBox.setSelected(false);
            this.useSharedDirBox.setEnabled(false);
        }
    }

    private void readPrefs() {
        Integer intPref;
        Boolean boolPref;
        String stringPref = Preferences.getString("CommentViewer.SharedDirectoryLocation", null);
        if (stringPref != null) {
            this.sharedDirectoryLocation = stringPref;
        }
        if ((boolPref = Preferences.getBool("CommentViewer.UseSharedDirectory", this.transcription)) != null) {
            this.useSharedDirectory = boolPref;
        }
        if ((stringPref = Preferences.getString("CommentViewer.SearchDirectory.EAF", null)) != null) {
            this.searchEAFDirectory = stringPref;
        }
        if ((stringPref = Preferences.getString("CommentViewer.SearchDirectory.Comments", null)) != null) {
            this.searchCommentsDirectory = stringPref;
        }
        if ((stringPref = Preferences.getString("CommentViewer.Sender", null)) != null) {
            this.senderEmailAddress = stringPref;
        }
        if ((stringPref = Preferences.getString("CommentViewer.Recipient", null)) != null) {
            this.recipientEmailAddress = stringPref;
        }
        if ((stringPref = Preferences.getString("CommentViewer.Initials", null)) != null) {
            this.initials = stringPref;
        }
        if ((stringPref = Preferences.getString("CommentViewer.ThreadID", null)) != null) {
            this.threadID = stringPref;
        }
        this.serverURL = (stringPref = Preferences.getString("CommentViewer.Server.URL", null)) != null ? stringPref : "https://corpus1.mpi.nl/ds/webannotator-basic";
        stringPref = Preferences.getString("CommentViewer.Server.Loginname", null);
        if (stringPref != null) {
            this.serverLoginName = stringPref;
        }
        if ((intPref = Preferences.getInt("CommentViewer.UpdateCheckTime", null)) != null) {
            this.updatetimeValue = intPref;
        }
    }

    private void savePrefs() {
        this.sharedDirectoryLocation = this.sharedDirPanel.getDirectory();
        Preferences.set("CommentViewer.SharedDirectoryLocation", this.sharedDirectoryLocation, null, false, false);
        this.useSharedDirectory = this.useSharedDirBox.isSelected();
        Preferences.set("CommentViewer.UseSharedDirectory", (boolean)this.useSharedDirectory, this.transcription, false, false);
        this.searchCommentsDirectory = this.searchCommentsPanel.getDirectory();
        Preferences.set("CommentViewer.SearchDirectory.Comments", this.searchCommentsDirectory, null, false, false);
        this.searchEAFDirectory = this.searchEAFPanel.getDirectory();
        Preferences.set("CommentViewer.SearchDirectory.EAF", this.searchEAFDirectory, null, false, false);
        this.senderEmailAddress = this.senderTextField.getText();
        Preferences.set("CommentViewer.Sender", this.senderEmailAddress, null, false, false);
        this.recipientEmailAddress = this.recipientTextField.getText();
        Preferences.set("CommentViewer.Recipient", this.recipientEmailAddress, null, false, false);
        this.initials = this.initialsTextField.getText();
        Preferences.set("CommentViewer.Initials", this.initials, null, false, false);
        this.threadID = this.threadIdTextField.getText();
        Preferences.set("CommentViewer.ThreadID", this.threadID, null, false, false);
        this.serverURL = this.serverURLTextField.getText();
        Preferences.set("CommentViewer.Server.URL", this.serverURL, null, false, false);
        this.serverLoginName = this.serverLoginNameTextField.getText();
        Preferences.set("CommentViewer.Server.Loginname", this.serverLoginName, null);
        this.updatetimeValue = this.updatetimeSlider.getValue();
        Preferences.set("CommentViewer.UpdateCheckTime", this.updatetimeValue, null, true, false);
    }

    private class DirPanel
    extends JPanel
    implements ActionListener {
        private String textlabel;
        private JLabel setDirLabel;
        private JLabel curDirLabel;
        private JButton defaultDirButton;
        private JButton resetDirButton;
        private Font plainFont;
        private String directoryLocation;

        DirPanel(String textlabel, String dirlabel) {
            super(new GridBagLayout());
            if (dirlabel == null || dirlabel.isEmpty()) {
                dirlabel = CommentsSettingsDialog.NONE;
            }
            this.textlabel = textlabel;
            this.directoryLocation = dirlabel;
            this.setDirLabel = new JLabel(textlabel);
            this.plainFont = this.setDirLabel.getFont().deriveFont(0);
            this.setDirLabel.setFont(this.plainFont);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.add((Component)this.setDirLabel, gbc);
            this.curDirLabel = new JLabel(this.directoryLocation);
            this.curDirLabel.setFont(Constants.deriveSmallFont(this.curDirLabel.getFont()));
            gbc.gridy = 1;
            this.add((Component)this.curDirLabel, gbc);
            this.defaultDirButton = new JButton(ElanLocale.getString("Button.Browse"));
            gbc.gridy = 0;
            gbc.gridx = 1;
            gbc.gridheight = 2;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            this.add((Component)this.defaultDirButton, gbc);
            this.defaultDirButton.addActionListener(this);
            this.resetDirButton = new JButton();
            ImageIcon resetIcon = null;
            try {
                resetIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Remove.gif"));
                this.resetDirButton.setIcon(resetIcon);
            }
            catch (Exception ex) {
                this.resetDirButton.setText("X");
            }
            this.resetDirButton.setToolTipText(ElanLocale.getString("PreferencesDialog.Reset"));
            this.resetDirButton.setPreferredSize(new Dimension(this.resetDirButton.getPreferredSize().width, this.defaultDirButton.getPreferredSize().height));
            gbc.gridx = 2;
            this.add((Component)this.resetDirButton, gbc);
            this.resetDirButton.addActionListener(this);
        }

        public String getDirectory() {
            if (CommentsSettingsDialog.NONE.equals(this.directoryLocation)) {
                return null;
            }
            return this.directoryLocation;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.defaultDirButton) {
                File dir;
                FileChooser chooser = new FileChooser(this);
                File startDir = new File(System.getProperty("user.home"));
                if (this.directoryLocation.length() > 0 && (dir = new File(FileUtility.urlToAbsPath(this.directoryLocation))).exists() && dir.isDirectory()) {
                    startDir = dir;
                }
                chooser.setCurrentDirectory(startDir.getAbsolutePath());
                chooser.createAndShowFileDialog(this.textlabel, 0, ElanLocale.getString("Button.Select"), null, null, true, null, 1, null);
                File selFile = chooser.getSelectedFile();
                if (selFile != null) {
                    this.directoryLocation = FileUtility.pathToURLString(selFile.getAbsolutePath());
                    this.curDirLabel.setText(this.directoryLocation);
                    CommentsSettingsDialog.this.sharedDirectoryChanged(this.directoryLocation);
                }
            } else if (source == this.resetDirButton) {
                this.directoryLocation = CommentsSettingsDialog.NONE;
                this.curDirLabel.setText(this.directoryLocation);
                CommentsSettingsDialog.this.sharedDirectoryChanged(null);
            }
        }
    }
}

