/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.dcr;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.border.TitledBorder;
import mpi.dcr.DCRConnectorException;
import mpi.dcr.DCSmall;
import mpi.dcr.ILATDCRConnector;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.dcr.ELANLocalDCRConnector;
import mpi.eudico.client.annotator.dcr.LocalDCSPanel;

public class AnnotationDCPanel2
extends LocalDCSPanel {
    protected JLabel tierKeyLabel;
    protected JTextArea tierValueArea;
    protected JLabel annKeyLabel;
    protected JTextArea annValueArea;
    protected JPanel tierPanel;
    protected JPanel dcrPanel;
    protected JLabel identifierKeyLabel;
    protected JTextArea identifierValueArea;
    protected JLabel idKeyLabel;
    protected JTextArea idValueArea;
    protected JLabel profileKeyLabel;
    protected JTextArea profileValueArea;
    protected JButton deleteButton;

    public AnnotationDCPanel2(ILATDCRConnector connector) {
        super(connector);
    }

    public AnnotationDCPanel2(ILATDCRConnector connector, ResourceBundle resBundle) {
        super(connector, resBundle);
    }

    public void setAnnotation(String tierName, String value, String dcId) {
        this.tierValueArea.setText(tierName);
        this.annValueArea.setText(value);
        DCSmall sm = ELANLocalDCRConnector.getInstance().getDCSmall(dcId);
        if (sm != null) {
            for (int i = 0; i < this.catTable.getRowCount(); ++i) {
                DCSmall dc = (DCSmall)this.catTable.getValueAt(i, 0);
                if (!dc.getId().equals(sm.getId())) continue;
                this.catTable.setRowSelectionInterval(i, i);
                break;
            }
        } else {
            this.updateDescriptionPanel(sm);
        }
        if (sm == null && dcId != null) {
            this.idValueArea.setText(dcId);
        }
    }

    public void scrollIfNeededAutomatically(int row) {
        JViewport viewport = (JViewport)this.catTable.getParent();
        Rectangle rect = this.catTable.getCellRect(row, 0, true);
        Rectangle viewRect = viewport.getViewRect();
        rect.setLocation(rect.x - viewRect.x, rect.y - viewRect.y);
        viewport.scrollRectToVisible(rect);
    }

    public String getAnnotationDCId() {
        if (this.idValueArea.getText() != null && this.idValueArea.getText().length() > 0) {
            return this.idValueArea.getText().trim();
        }
        return null;
    }

    @Override
    protected void initializeDescriptionPanel() {
        super.initializeDescriptionPanel();
        this.descPanel.removeAll();
        this.identifierKeyLabel = new JLabel();
        this.identifierValueArea = new JTextArea();
        this.identifierValueArea.setEditable(false);
        this.identifierValueArea.setLineWrap(true);
        this.identifierValueArea.setWrapStyleWord(true);
        this.idKeyLabel = new JLabel();
        this.idValueArea = new JTextArea();
        this.idValueArea.setEditable(false);
        this.idValueArea.setLineWrap(true);
        this.idValueArea.setWrapStyleWord(true);
        this.profileKeyLabel = new JLabel();
        this.profileValueArea = new JTextArea();
        this.profileValueArea.setEditable(false);
        this.profileValueArea.setLineWrap(true);
        this.profileValueArea.setWrapStyleWord(true);
        this.deleteButton = new JButton();
        this.deleteButton.addActionListener(this);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.globalInsets;
        this.descPanel.add((Component)this.langLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = this.spacerInsets;
        this.descPanel.add((Component)this.langCombo, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets = this.globalInsets;
        this.descPanel.add((Component)this.identifierKeyLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = this.spacerInsets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.descPanel.add((Component)this.identifierValueArea, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets = this.globalInsets;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.descPanel.add((Component)this.idKeyLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = this.spacerInsets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.descPanel.add((Component)this.idValueArea, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets = this.globalInsets;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.descPanel.add((Component)this.profileKeyLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = this.spacerInsets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.descPanel.add((Component)this.profileValueArea, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets = this.globalInsets;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.descPanel.add((Component)this.nameKeyLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = this.spacerInsets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.descPanel.add((Component)this.nameValueLabel, gbc);
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        ++gbc.gridy;
        gbc.insets = this.globalInsets;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.descPanel.add((Component)this.descLabel, gbc);
        ++gbc.gridy;
        gbc.insets = this.globalInsets;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.descPanel.add((Component)this.descScroll, gbc);
    }

    @Override
    protected void initComponents() {
        this.tierKeyLabel = new JLabel();
        this.tierValueArea = new JTextArea();
        this.tierValueArea.setEditable(false);
        this.annKeyLabel = new JLabel();
        this.annValueArea = new JTextArea();
        this.annValueArea.setEditable(false);
        this.annValueArea.setLineWrap(true);
        this.annValueArea.setWrapStyleWord(true);
        this.tierPanel = new JPanel(new GridBagLayout());
        this.dcrPanel = new JPanel(new GridBagLayout());
        super.initComponents();
        this.setSingleSelection(true);
        this.remove(this.catPanel);
        this.remove(this.descPanel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.globalInsets;
        gbc.fill = 0;
        gbc.anchor = 18;
        this.tierPanel.add((Component)this.tierKeyLabel, gbc);
        gbc.gridx = 1;
        this.tierPanel.add((Component)this.tierValueArea, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.tierPanel.add((Component)this.annKeyLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        this.tierPanel.add((Component)this.annValueArea, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.globalInsets;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        this.dcrPanel.add((Component)this.tierPanel, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.dcrPanel.add((Component)this.descPanel, gbc);
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.anchor = 10;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.dcrPanel.add((Component)this.deleteButton, gbc);
        this.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.insets = this.globalInsets;
        gbc.fill = 1;
        gbc.anchor = 18;
        this.add((Component)this.dcrPanel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.add((Component)this.catPanel, gbc);
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        String isocat = "ISO data category";
        String ident = "Identifier";
        String id = "Id";
        String profs = "Profiles";
        String tierName = "Tier Name";
        String ann = "Annotation";
        String remove = "Remove Reference";
        String remCat = "Remove Categories";
        if (this.resBundle != null) {
            try {
                isocat = this.resBundle.getString(ElanLocale.getString("DCR.Label.ISOCategory"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ident = this.resBundle.getString("DCR.Label.Identifier");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                id = this.resBundle.getString("DCR.Label.Id");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                profs = this.resBundle.getString("DCR.Label.Profiles");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                tierName = this.resBundle.getString("EditTierDialog.Label.TierName");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ann = this.resBundle.getString("Frame.GridFrame.ColumnAnnotation");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                remove = this.resBundle.getString("DCR.Label.RemoveReference");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                remCat = this.resBundle.getString("DCR.Label.RemoveCategory");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.identifierKeyLabel.setText(ident);
        this.idKeyLabel.setText(id);
        this.profileKeyLabel.setText(profs);
        this.dcrPanel.setBorder(new TitledBorder(isocat));
        this.tierKeyLabel.setText(tierName);
        this.annKeyLabel.setText(ann);
        this.deleteButton.setText(remove);
        this.removeCatsButton.setText(remCat);
    }

    @Override
    protected void updateDescriptionPanel(DCSmall dc) {
        super.updateDescriptionPanel(dc);
        if (dc != null) {
            this.identifierValueArea.setText(dc.getIdentifier());
            this.idValueArea.setText(dc.getId());
            if (dc.getProfiles().length == 1) {
                this.profileValueArea.setText(dc.getProfiles()[0].getName());
            } else {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < dc.getProfiles().length; ++i) {
                    buf.append(dc.getProfiles()[i].getName());
                    if (i == dc.getProfiles().length - 1) continue;
                    buf.append(", ");
                }
                this.profileValueArea.setText(buf.toString());
            }
            return;
        }
        this.identifierValueArea.setText("-");
        this.idValueArea.setText("-");
        this.profileValueArea.setText("-");
    }

    @Override
    protected void refreshCategory() {
        DCSmall dc = null;
        this.setCursor(this.BUSY_CURSOR);
        if (this.catTable.getSelectedRow() > -1) {
            super.refreshCategory();
        } else if (this.idValueArea.getText().trim().length() > 0) {
            try {
                dc = this.connector.getDataCategory(this.idValueArea.getText().trim());
            }
            catch (DCRConnectorException e1) {
                e1.printStackTrace();
            }
            if (dc == null && (dc = this.getDC(this.idValueArea.getText().trim())) != null) {
                ArrayList<DCSmall> list = new ArrayList<DCSmall>();
                list.add(dc);
                this.addCategories(list);
                this.catTable.setRowSelectionInterval(this.catTable.getRowCount() - 1, this.catTable.getRowCount() - 1);
            }
        }
        this.setCursor(this.DEFAULT_CURSOR);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.deleteButton) {
            this.updateDescriptionPanel(null);
        } else {
            super.actionPerformed(e);
        }
    }
}

