/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.dcr;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import mpi.dcr.DCRConnectorException;
import mpi.dcr.DCSmall;
import mpi.dcr.isocat.Profile;
import mpi.dcr.isocat.RestDCRConnector;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.util.IoUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DCRCacheReaderWriter {
    private final String struct = "struct";
    private final String feat = "feat";
    private final String dcs = "DCS";
    private final String dc = "DC";
    private final String ai = "AI";
    private final String ar = "AR";
    private final String desc = "Desc";
    private final String def = "definition";
    private final String ident = "identifier";
    private final String prof = "profile";
    private final String broad = "broaderConceptGeneric";
    private final String type = "type";
    private final String id = "id";
    private final String lang = "lang";
    private final String loaded = "loaded";
    private final String lastUpdated = "lastUpdated";
    private final String name = "name";
    private final String urlPref = "http://www.isocat.org/datcat/DC-";
    private DocumentBuilder db;
    private SAXParser parser;
    private String filePath;
    private boolean profileIdsNeeded = false;
    private boolean newVersion = false;

    public DCRCacheReaderWriter() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        this.db = dbf.newDocumentBuilder();
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            parserFactory.setNamespaceAware(true);
            parserFactory.setValidating(false);
            this.parser = parserFactory.newSAXParser();
        }
        catch (SAXException se) {
            ClientLogger.LOG.warning("Could not create a parser for the DCR cache: " + se.getMessage());
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.setFilePath(filePath, false);
    }

    public void setFilePath(String filePath, boolean newVersion) {
        this.filePath = filePath;
        this.newVersion = newVersion;
    }

    public synchronized void save(List<DCSmall> categories) throws IOException, ParserConfigurationException {
        if (this.filePath == null) {
            throw new IOException("No filepath specified.");
        }
        if (categories == null) {
            throw new NullPointerException("The list of categories is null");
        }
        if (this.db != null) {
            Document doc = this.db.newDocument();
            Element dcsElem = doc.createElement("struct");
            doc.appendChild(dcsElem);
            dcsElem.setAttribute("type", "DCS");
            DCSmall dcsmall = null;
            for (int i = 0; i < categories.size(); ++i) {
                dcsmall = categories.get(i);
                Element dcEl = doc.createElement("struct");
                dcEl.setAttribute("type", "DC");
                dcEl.setAttribute("id", dcsmall.getId());
                dcsElem.appendChild(dcEl);
                if (dcsmall.getIdentifier() != null && dcsmall.getIdentifier().length() > 0) {
                    Element aiEl = doc.createElement("struct");
                    aiEl.setAttribute("type", "AI");
                    dcEl.appendChild(aiEl);
                    Element arEl = doc.createElement("struct");
                    arEl.setAttribute("type", "AR");
                    aiEl.appendChild(arEl);
                    Element idEl = doc.createElement("feat");
                    idEl.setAttribute("type", "identifier");
                    idEl.appendChild(doc.createTextNode(dcsmall.getIdentifier()));
                    arEl.appendChild(idEl);
                }
                Element descEl = doc.createElement("struct");
                descEl.setAttribute("type", "Desc");
                dcEl.appendChild(descEl);
                if (dcsmall.getLanguages().size() > 0) {
                    for (int l = 0; l < dcsmall.getLanguages().size(); ++l) {
                        String language = dcsmall.getLanguages().get(l);
                        Element langEl = doc.createElement("struct");
                        langEl.setAttribute("type", "lang");
                        Element defEl = doc.createElement("feat");
                        defEl.setAttribute("type", "definition");
                        defEl.setAttribute("lang", language);
                        defEl.appendChild(doc.createTextNode(dcsmall.getDesc(language)));
                        langEl.appendChild(defEl);
                        Element nameEl = doc.createElement("feat");
                        nameEl.setAttribute("type", "name");
                        nameEl.setAttribute("lang", language);
                        nameEl.appendChild(doc.createTextNode(dcsmall.getName(language)));
                        langEl.appendChild(nameEl);
                        descEl.appendChild(langEl);
                    }
                }
                if (dcsmall.getProfiles() != null && dcsmall.getProfiles().length > 0) {
                    for (int j = 0; j < dcsmall.getProfiles().length; ++j) {
                        if (dcsmall.getProfiles()[j].getName().length() == 0) continue;
                        Element prEl = doc.createElement("struct");
                        prEl.setAttribute("type", "profile");
                        prEl.setAttribute("id", dcsmall.getProfiles()[j].getId());
                        Element nameEl = doc.createElement("feat");
                        nameEl.setAttribute("type", "name");
                        nameEl.appendChild(doc.createTextNode(dcsmall.getProfiles()[j].getName()));
                        prEl.appendChild(nameEl);
                        descEl.appendChild(prEl);
                    }
                }
                if (dcsmall.getBroaderDCId() != null && dcsmall.getBroaderDCId().length() > 0) {
                    Element brEl = doc.createElement("feat");
                    brEl.setAttribute("type", "broaderConceptGeneric");
                    brEl.appendChild(doc.createTextNode(dcsmall.getBroaderDCId()));
                    descEl.appendChild(brEl);
                }
                Element loadEl = doc.createElement("feat");
                loadEl.setAttribute("type", "loaded");
                loadEl.appendChild(doc.createTextNode(Boolean.toString(dcsmall.isLoaded())));
                descEl.appendChild(loadEl);
                if (!dcsmall.isLoaded()) continue;
                Element lastUpdateEl = doc.createElement("feat");
                lastUpdateEl.setAttribute("type", "lastUpdated");
                lastUpdateEl.appendChild(doc.createTextNode(new Timestamp(dcsmall.getLastUpdated()).toString()));
                dcEl.appendChild(lastUpdateEl);
            }
            try {
                IoUtil.writeEncodedFile("UTF-8", this.filePath, doc.getDocumentElement());
            }
            catch (Exception ioe) {
                throw new IOException(ioe.getMessage());
            }
        }
    }

    public synchronized List<DCSmall> read() throws IOException {
        if (this.parser != null) {
            try {
                DcrGmtAdapter adapter = this.newVersion ? new DcrGmtAdapter2() : new DcrGmtAdapter();
                this.parser.parse(this.filePath, (DefaultHandler)adapter);
                List<DCSmall> curDCList = adapter.getDCS();
                if (this.profileIdsNeeded) {
                    try {
                        RestDCRConnector rconn = new RestDCRConnector();
                        List<Profile> profs = rconn.getProfiles();
                        for (int i = 0; i < curDCList.size(); ++i) {
                            Profile[] curProfs;
                            DCSmall small1 = curDCList.get(i);
                            block5: for (Profile curProf : curProfs = small1.getProfiles()) {
                                if (curProf.getId().length() != 0) continue;
                                for (int k = 0; k < profs.size(); ++k) {
                                    Profile pr = profs.get(k);
                                    if (!pr.getName().equals(curProf.getName())) continue;
                                    curProf.setId(pr.getId());
                                    continue block5;
                                }
                            }
                        }
                    }
                    catch (DCRConnectorException dce) {
                        ClientLogger.LOG.warning("Could not retrieve additional information from ISOCat");
                    }
                }
                return curDCList;
            }
            catch (SAXException se) {
                ClientLogger.LOG.warning("Could not read the local data categories cache: " + se.getMessage());
            }
        }
        return new ArrayList<DCSmall>();
    }

    private class DcrGmtAdapter2
    extends DcrGmtAdapter {
        protected HashMap<String, String> descMap;
        protected HashMap<String, String> nameMap;
        private boolean inProfile;
        private boolean load;
        private long lastUpdate;
        private String language;

        public DcrGmtAdapter2() {
            this.lastUpdate = 0L;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inFeat) {
                this.content = new String(ch, start, length);
                if (this.curFeat == "identifier") {
                    this.identifierAttr = this.content;
                } else if (this.curFeat == "definition") {
                    this.descMap.put(this.language, this.content);
                } else if (this.curFeat == "broaderConceptGeneric") {
                    this.broaderDCIdAttr = this.content;
                } else if (this.curFeat == "profile") {
                    this.profiles.add(new Profile("", this.content));
                } else if (this.curFeat == "name") {
                    if (this.inProfile) {
                        this.profiles.add(new Profile(this.curProfId, this.content));
                    } else {
                        this.nameMap.put(this.language, this.content);
                    }
                } else if (this.curFeat == "loaded") {
                    this.load = Boolean.valueOf(this.content);
                } else if (this.curFeat == "lastUpdated") {
                    this.lastUpdate = Timestamp.valueOf(this.content).getTime();
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.inFeat = false;
            this.inProfile = false;
            if (localName.equals("struct")) {
                --this.structLevel;
            }
            if (this.structLevel == 1 && this.idAttr != null && this.profiles.size() > 0) {
                this.dcsmall = new DCSmall(null, this.idAttr, this.identifierAttr);
                this.dcsmall.setBroaderDCId(this.broaderDCIdAttr);
                this.dcsmall.setProfiles(this.profiles.toArray(new Profile[this.profiles.size()]));
                this.dcsmall.setLoaded(this.load);
                this.dcsmall.setDescMap(this.descMap);
                this.dcsmall.setNameMap(this.nameMap);
                this.dcsmall.setLastUpdate(this.lastUpdate);
                this.datcats.add(this.dcsmall);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (localName.equals("struct")) {
                ++this.structLevel;
                String ty = atts.getValue("type");
                if ("DC".equals(ty)) {
                    this.curStruct = "DC";
                    this.idAttr = atts.getValue("id");
                    if (this.idAttr.length() > 0) {
                        try {
                            Integer.parseInt(this.idAttr);
                            this.idAttr = "http://www.isocat.org/datcat/DC-" + this.idAttr;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    this.identifierAttr = null;
                    this.descAttr = null;
                    this.broaderDCIdAttr = null;
                    this.profiles.clear();
                    this.content = "";
                    this.descMap = new HashMap();
                    this.nameMap = new HashMap();
                    this.inProfile = false;
                    this.load = false;
                    this.language = "";
                } else if ("AR".equals(ty)) {
                    this.curStruct = "AR";
                } else if ("Desc".equals(ty)) {
                    this.curStruct = "Desc";
                } else if ("profile".equals(ty)) {
                    this.curStruct = "profile";
                    this.inProfile = true;
                    this.curProfId = atts.getValue("id");
                }
            } else if (localName.equals("feat")) {
                this.inFeat = true;
                String fty = atts.getValue("type");
                if ("identifier".equals(fty)) {
                    this.curFeat = "identifier";
                } else if ("definition".equals(fty)) {
                    this.curFeat = "definition";
                    this.language = atts.getValue("lang");
                } else if ("profile".equals(fty)) {
                    this.curFeat = "profile";
                    DCRCacheReaderWriter.this.profileIdsNeeded = true;
                } else if ("broaderConceptGeneric".equals(fty)) {
                    this.curFeat = "broaderConceptGeneric";
                } else if ("name".equals(fty)) {
                    this.curFeat = "name";
                    if (!this.inProfile) {
                        this.language = atts.getValue("lang");
                    }
                } else if ("loaded".equals(fty)) {
                    this.curFeat = "loaded";
                } else if ("lastUpdated".equals(fty)) {
                    this.curFeat = "lastUpdated";
                }
            }
        }
    }

    private class DcrGmtAdapter
    extends DefaultHandler {
        protected List<DCSmall> datcats = new ArrayList<DCSmall>();
        protected String idAttr;
        protected String identifierAttr;
        protected String descAttr;
        protected DCSmall dcsmall;
        protected String broaderDCIdAttr;
        protected List<Profile> profiles = new ArrayList<Profile>();
        protected String curProfId;
        protected String curStruct;
        protected String curFeat;
        protected String content = "";
        protected int structLevel = 0;
        boolean inFeat = false;

        public List<DCSmall> getDCS() {
            return this.datcats;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inFeat) {
                this.content = new String(ch, start, length);
                if (this.curFeat == "identifier") {
                    this.identifierAttr = this.content;
                } else if (this.curFeat == "definition") {
                    this.descAttr = this.content;
                } else if (this.curFeat == "broaderConceptGeneric") {
                    this.broaderDCIdAttr = this.content;
                } else if (this.curFeat == "profile") {
                    this.profiles.add(new Profile("", this.content));
                } else if (this.curFeat == "name") {
                    this.profiles.add(new Profile(this.curProfId, this.content));
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.inFeat = false;
            if (localName.equals("struct")) {
                --this.structLevel;
            }
            if (this.structLevel == 1 && this.idAttr != null && this.profiles.size() > 0) {
                this.dcsmall = new DCSmall(null, this.idAttr, this.identifierAttr);
                this.dcsmall.setBroaderDCId(this.broaderDCIdAttr);
                this.dcsmall.setProfiles(this.profiles.toArray(new Profile[this.profiles.size()]));
                this.dcsmall.setDesc(this.descAttr);
                this.dcsmall.setLoaded(false);
                this.datcats.add(this.dcsmall);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (localName.equals("struct")) {
                ++this.structLevel;
                String ty = atts.getValue("type");
                if ("DC".equals(ty)) {
                    this.curStruct = "DC";
                    this.idAttr = atts.getValue("id");
                    if (this.idAttr.length() > 0) {
                        try {
                            Integer.parseInt(this.idAttr);
                            this.idAttr = "http://www.isocat.org/datcat/DC-" + this.idAttr;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    this.identifierAttr = null;
                    this.descAttr = null;
                    this.broaderDCIdAttr = null;
                    this.profiles.clear();
                    this.content = "";
                } else if ("AR".equals(ty)) {
                    this.curStruct = "AR";
                } else if ("Desc".equals(ty)) {
                    this.curStruct = "Desc";
                } else if ("profile".equals(ty)) {
                    this.curStruct = "profile";
                    this.curProfId = atts.getValue("id");
                }
            } else if (localName.equals("feat")) {
                this.inFeat = true;
                String fty = atts.getValue("type");
                if ("identifier".equals(fty)) {
                    this.curFeat = "identifier";
                } else if ("definition".equals(fty)) {
                    this.curFeat = "definition";
                } else if ("profile".equals(fty)) {
                    this.curFeat = "profile";
                    DCRCacheReaderWriter.this.profileIdsNeeded = true;
                } else if ("broaderConceptGeneric".equals(fty)) {
                    this.curFeat = "broaderConceptGeneric";
                } else if ("name".equals(fty)) {
                    this.curFeat = "name";
                }
            }
        }
    }
}

