/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.flex.FlexEncoder;
import mpi.eudico.server.corpora.clomimpl.flex.FlexEncoderInfo;
import nl.mpi.util.FileExtension;

public class ExportFlexStep4
extends StepPane {
    private FlexEncoderInfo encoderInfo;
    private TranscriptionImpl transcription;
    private JTextField fileTextField;
    private JButton browseButton;

    public ExportFlexStep4(MultiStepPane multiPane, TranscriptionImpl trans) {
        super(multiPane);
        this.transcription = trans;
        this.initComponents();
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("ExportFlexStep4.Title");
    }

    @Override
    public void enterStepForward() {
        this.encoderInfo = (FlexEncoderInfo)this.multiPane.getStepProperty("EncoderInfo");
        this.updateButtonStates();
    }

    @Override
    public void enterStepBackward() {
        this.updateButtonStates();
    }

    public void updateButtonStates() {
        this.multiPane.setButtonEnabled(2, true);
        this.multiPane.setButtonEnabled(1, false);
        this.multiPane.setButtonEnabled(3, true);
        if (this.fileTextField.getText().trim().length() <= 0) {
            this.multiPane.setButtonEnabled(3, false);
            return;
        }
    }

    @Override
    protected void initComponents() {
        this.fileTextField = new JTextField();
        this.fileTextField.setEditable(false);
        this.browseButton = new JButton(ElanLocale.getString("Button.Browse"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportFlexStep4.this.selectFlexFile();
                ExportFlexStep4.this.updateButtonStates();
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(2, 4, 2, 4);
        this.add((Component)new JLabel(ElanLocale.getString("ExportFlexStep4.SelectDestination")), gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.fileTextField, gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.add((Component)this.browseButton, gbc);
    }

    private void selectFlexFile() {
        FileChooser chooser = new FileChooser(ELANCommandFactory.getRootFrame(this.transcription));
        chooser.createAndShowFileDialog(ElanLocale.getString("ExportFlexDialog.Title"), 1, FileExtension.FLEX_EXT, "LastUsedFlexDir");
        File f = chooser.getSelectedFile();
        if (f != null) {
            this.fileTextField.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    @Override
    public boolean doFinish() {
        this.encoderInfo.setFile(this.fileTextField.getText());
        if (this.encoderInfo != null) {
            FlexEncoder encoder = new FlexEncoder();
            encoder.setEncoderInfo(this.encoderInfo);
            encoder.encode(this.transcription);
        }
        return true;
    }
}

